/**
 * @license https://github.com/Intermesh/goui/blob/main/LICENSE MIT License
 * @copyright Copyright 2023 Intermesh BV
 * @author Michael de Hart <mdhart@intermesh.nl>
 */
/**
 * Short function to create a HTML element by tag name
 *
 * @category Utility
 * @param tag Tag name
 * @param items Elements to append to this new element
 * @constructor
 */
export function E(tag, ...items) {
    const el = document.createElement(tag);
    el.append(...items);
    return el;
}
/**
 * DOM Html Element
 * @class Element
 * @category Utitlity
 */
Object.assign(Element.prototype, {
    on(event, listener, options) {
        this.addEventListener(event, listener, options);
        return this;
    },
    un(event, listener, options) {
        this.removeEventListener(event, listener, options);
        return this;
    },
    cls(name, enable) {
        if (!name)
            return this;
        if (Array.isArray(name)) {
            name.map((n) => {
                this.cls(n, enable);
            });
            return this;
        }
        name = name;
        if (enable !== undefined) {
            name = (enable ? '+' : '-') + name;
        }
        switch (name.substring(0, 1)) {
            case '+':
                this.classList.add(name.substring(1));
                break;
            case '-':
                this.classList.remove(name.substring(1));
                break;
            case '!':
                this.classList.toggle(name.substring(1));
                break;
            default:
                this.className = name;
        }
        return this;
    },
    css(style) {
        Object.assign(this.style, style);
        return this;
    },
    attr(name, value) {
        if (value === undefined) {
            return this.getAttribute(name);
        }
        this.setAttribute(name, value);
        return this;
    },
    has(clsOrAttr) {
        if (clsOrAttr.substring(0, 1) === '.') {
            return this.classList.contains(clsOrAttr.substring(1));
        }
        return this.hasAttribute(clsOrAttr);
    },
    isA(tagName) {
        return this.tagName.toLowerCase() === tagName.toLowerCase();
    },
    up(expression, until) {
        if (!expression)
            return this.parentElement;
        let curr = this;
        do {
            if (curr === until)
                return null;
            // Return any node that matches the expression, if there is one.
            if (curr.matches(expression))
                return curr;
        } while (curr = curr.parentElement);
    },
    empty() {
        while (this.firstChild) {
            this.removeChild(this.firstChild);
        }
    },
    isScrolledIntoView(container) {
        container = container || document.body;
        const { top, bottom, height } = this.getBoundingClientRect();
        const holderRect = container.getBoundingClientRect();
        return top <= holderRect.top
            ? holderRect.top - top <= height
            : bottom - holderRect.bottom <= height;
    },
});
//# sourceMappingURL=Element.js.map