<?php
/**
 * Localized data
 *
 * @copyright Copyright (C) 2010-2024 Combodo SAS
 * @license    https://opensource.org/licenses/AGPL-3.0
 * 
 */
/**
 *
 */
Dict::Add('FR FR', 'French', 'Français', [
	'BooleanLabel:no' => 'non',
	'BooleanLabel:yes' => 'oui',
	'Calendar-FirstDayOfWeek' => '1',
	'Class:AuditCategory' => 'Catégorie d\'audit',
	'Class:AuditCategory+' => 'La catégorie d\'audit définit un ensemble d\'objets qui doivent être audité.
Elle regroupe toutes les régles qui s\'appliquent au même périmètre d\'objets',
	'Class:AuditCategory/Attribute:definition_set' => 'Périmètre',
	'Class:AuditCategory/Attribute:definition_set+' => 'Requête OQL retournant les objets qui sont dans le périmètre d\'application de cet audit',
	'Class:AuditCategory/Attribute:description' => 'Description',
	'Class:AuditCategory/Attribute:description+' => '',
	'Class:AuditCategory/Attribute:domains_list' => 'Domaines',
	'Class:AuditCategory/Attribute:domains_list+' => 'Domaines incluant cette catégorie d\'audit',
	'Class:AuditCategory/Attribute:name' => 'Nom',
	'Class:AuditCategory/Attribute:name+' => 'Identifie un ensemble d\'objets à auditer',
	'Class:AuditCategory/Attribute:ok_error_tolerance' => 'Seuil d\'alerte',
	'Class:AuditCategory/Attribute:ok_error_tolerance+' => 'Pourcentage d\'objets en erreur au dela duquel le résultat est à surveiller (orange)',
	'Class:AuditCategory/Attribute:rules_list' => 'Règles d\'audit',
	'Class:AuditCategory/Attribute:rules_list+' => 'Les règles d\'audit qui utilisent le périmètre de cette catégorie',
	'Class:AuditCategory/Attribute:warning_error_tolerance' => 'Seuil d\'erreur',
	'Class:AuditCategory/Attribute:warning_error_tolerance+' => 'Pourcentage d\'objets en erreur au dela duquel le résultat est en erreur (rouge)',
	'Class:AuditDomain' => 'Domaine d\'audit',
	'Class:AuditDomain+' => 'Un domaine permet de regrouper ensemble des catégories d\'audit.
Cela recouvre en général, un domaine d\'intérêt ou de responsabilité',
	'Class:AuditDomain/Attribute:categories_list' => 'Catégories',
	'Class:AuditDomain/Attribute:categories_list+' => 'Catégories d\'audit incluses dans ce domaine. Cette inclusion n\'est pas exclusive.
Lorsqu\'on execute l\'audit sur un domaine, toutes les catégories d\'audit incluses sont vérifiées en même temps et seulement celles là',
	'Class:AuditDomain/Attribute:description' => 'Description',
	'Class:AuditDomain/Attribute:description+' => '',
	'Class:AuditDomain/Attribute:icon' => 'Icône',
	'Class:AuditDomain/Attribute:icon+' => '',
	'Class:AuditDomain/Attribute:name' => 'Nom',
	'Class:AuditDomain/Attribute:name+' => 'C\'est un filtre sur les catégories d\'audit pour une population en charge de contrôler ou de fixer les erreurs',
	'Class:AuditRule' => 'Règle d\'audit',
	'Class:AuditRule+' => 'Une règle d\'audit correspond à une vérification particulière.
Elle s\'applique à tous les objets dans le périmètre de sa catégorie d\'audit',
	'Class:AuditRule/Attribute:category_id' => 'Catégorie',
	'Class:AuditRule/Attribute:category_id+' => '',
	'Class:AuditRule/Attribute:category_name' => 'Nom de la catégorie',
	'Class:AuditRule/Attribute:category_name+' => '',
	'Class:AuditRule/Attribute:description' => 'Description',
	'Class:AuditRule/Attribute:description+' => 'Qu\'est ce qu\'on vérifie ? Comment le corriger ? Qui doit le faire ? ...',
	'Class:AuditRule/Attribute:name' => 'Nom',
	'Class:AuditRule/Attribute:name+' => 'Une vérification particulière',
	'Class:AuditRule/Attribute:query' => 'Requête',
	'Class:AuditRule/Attribute:query+' => 'Requête OQL à executer. Les classes retournées doivent être cohérentes avec celles définies dans le périmètre de la catégorie',
	'Class:AuditRule/Attribute:valid_flag' => 'Objets retournés :',
	'Class:AuditRule/Attribute:valid_flag+' => 'Que retourne la requête ci-dessus ?
"les objets valides" : alors les objets en erreur sont tout ceux du périmètre qui ne sont pas dans la liste des valides.
"les objets invalides" : alors les objets en erreur sont les invalides qui font partie du périmètre.',
	'Class:AuditRule/Attribute:valid_flag/Value:false' => 'les objets invalides',
	'Class:AuditRule/Attribute:valid_flag/Value:false+' => 'Alors les objets en erreur sont les invalides qui font partie du périmètre',
	'Class:AuditRule/Attribute:valid_flag/Value:true' => 'les objets valides',
	'Class:AuditRule/Attribute:valid_flag/Value:true+' => 'Alors les objets en erreur sont tout ceux du périmètre qui ne sont pas dans la liste des objets valides',
	'Class:Query' => 'Requête',
	'Class:Query+' => 'Une requête définit un ensemble d\'information de manière dynamique',
	'Class:Query/Attribute:description' => 'Description',
	'Class:Query/Attribute:description+' => 'Description complète (finalité, utilisations, public)',
	'Class:Query/Attribute:export_count' => 'Nombre d\'exports',
	'Class:Query/Attribute:export_count+' => 'Compteur reflétant le nombre d\'éxécutions de cette requête',
	'Class:Query/Attribute:export_last_date' => 'Dernier export',
	'Class:Query/Attribute:export_last_date+' => 'Date et heure de la dernière éxécution',
	'Class:Query/Attribute:export_last_user_contact' => 'Contact',
	'Class:Query/Attribute:export_last_user_contact+' => 'Dernier contact ayant exécuté cette requête',
	'Class:Query/Attribute:export_last_user_id' => 'Utilisateur',
	'Class:Query/Attribute:export_last_user_id+' => 'Dernier utilisateur ayant exécuté cette requête',
	'Class:Query/Attribute:is_template' => 'Base pour champ OQL',
	'Class:Query/Attribute:is_template+' => 'Utilisable comme base pour les destinataires des Notifications',
	'Class:Query/Attribute:is_template/Value:no' => 'Non',
	'Class:Query/Attribute:is_template/Value:yes' => 'Oui',
	'Class:Query/Attribute:name' => 'Nom',
	'Class:Query/Attribute:name+' => 'Identification de la requête',
	'Class:QueryOQL' => 'Requête OQL',
	'Class:QueryOQL+' => 'Une requête écrite dans le langage "Object Query Language"',
	'Class:QueryOQL/Attribute:fields' => 'Champs',
	'Class:QueryOQL/Attribute:fields+' => 'Liste CSV des attributs (ou alias.attribut) à exporter',
	'Class:QueryOQL/Attribute:oql' => 'Expression',
	'Class:QueryOQL/Attribute:oql+' => 'Expression OQL',
	'Class:Shortcut' => 'Raccourci',
	'Class:Shortcut+' => '',
	'Class:Shortcut/Attribute:name' => 'Nom',
	'Class:Shortcut/Attribute:name+' => 'Label utilisé dans le menu et comme titre de la page',
	'Class:ShortcutOQL' => 'Raccourci vers une liste d\'objets',
	'Class:ShortcutOQL+' => '',
	'Class:ShortcutOQL/Attribute:auto_reload' => 'Réactualisation automatique',
	'Class:ShortcutOQL/Attribute:auto_reload/Value:custom' => 'Personnalisée',
	'Class:ShortcutOQL/Attribute:auto_reload/Value:none' => 'Désactivée',
	'Class:ShortcutOQL/Attribute:auto_reload_sec' => 'Réactualisation toutes les (secondes)',
	'Class:ShortcutOQL/Attribute:auto_reload_sec/tip' => 'Le minimum permis est de %1$d secondes',
	'Class:ShortcutOQL/Attribute:oql' => 'Requête',
	'Class:ShortcutOQL/Attribute:oql+' => 'Requête de définition de l\'ensemble des objets',
	'Class:URP_ActionGrant' => 'action_permission',
	'Class:URP_ActionGrant+' => 'permissions on classes',
	'Class:URP_ActionGrant/Attribute:action' => 'Action',
	'Class:URP_ActionGrant/Attribute:action+' => 'operations to perform on the given class',
	'Class:URP_ActionGrant/Attribute:class' => 'Class',
	'Class:URP_ActionGrant/Attribute:class+' => 'Target class',
	'Class:URP_ActionGrant/Attribute:permission' => 'Permission',
	'Class:URP_ActionGrant/Attribute:permission+' => 'allowed or not allowed?',
	'Class:URP_ActionGrant/Attribute:permission/Value:no' => 'non',
	'Class:URP_ActionGrant/Attribute:permission/Value:no+' => 'non',
	'Class:URP_ActionGrant/Attribute:permission/Value:yes' => 'oui',
	'Class:URP_ActionGrant/Attribute:permission/Value:yes+' => 'oui',
	'Class:URP_ActionGrant/Attribute:profile' => 'Profile',
	'Class:URP_ActionGrant/Attribute:profile+' => 'usage profile',
	'Class:URP_ActionGrant/Attribute:profileid' => 'Profile',
	'Class:URP_ActionGrant/Attribute:profileid+' => 'usage profile',
	'Class:URP_AttributeGrant' => 'attribute_permission',
	'Class:URP_AttributeGrant+' => 'permissions at the attributes level',
	'Class:URP_AttributeGrant/Attribute:actiongrantid' => 'Action grant',
	'Class:URP_AttributeGrant/Attribute:actiongrantid+' => 'action grant',
	'Class:URP_AttributeGrant/Attribute:attcode' => 'Attribute',
	'Class:URP_AttributeGrant/Attribute:attcode+' => 'attribute code',
	'Class:URP_ClassProjection' => 'class_projection',
	'Class:URP_ClassProjection+' => 'class projections',
	'Class:URP_ClassProjection/Attribute:attribute' => 'Attribute',
	'Class:URP_ClassProjection/Attribute:attribute+' => 'Target attribute code (optional)',
	'Class:URP_ClassProjection/Attribute:class' => 'Class',
	'Class:URP_ClassProjection/Attribute:class+' => 'Target class',
	'Class:URP_ClassProjection/Attribute:dimension' => 'Dimension',
	'Class:URP_ClassProjection/Attribute:dimension+' => 'application dimension',
	'Class:URP_ClassProjection/Attribute:dimensionid' => 'Dimension',
	'Class:URP_ClassProjection/Attribute:dimensionid+' => 'application dimension',
	'Class:URP_ClassProjection/Attribute:value' => 'Value expression',
	'Class:URP_ClassProjection/Attribute:value+' => 'OQL expression (using $this) | constant |  | +attribute code',
	'Class:URP_Dimensions' => 'Dimension',
	'Class:URP_Dimensions+' => 'Dimension applicative (défini des silos)',
	'Class:URP_Dimensions/Attribute:description' => 'Description',
	'Class:URP_Dimensions/Attribute:description+' => '',
	'Class:URP_Dimensions/Attribute:name' => 'Nom',
	'Class:URP_Dimensions/Attribute:name+' => '',
	'Class:URP_Dimensions/Attribute:type' => 'Type',
	'Class:URP_Dimensions/Attribute:type+' => 'Nom de classe ou type de données (unité de projection)',
	'Class:URP_ProfileProjection' => 'profile_projection',
	'Class:URP_ProfileProjection+' => 'profile projections',
	'Class:URP_ProfileProjection/Attribute:attribute' => 'Attribute',
	'Class:URP_ProfileProjection/Attribute:attribute+' => 'Target attribute code (optional)',
	'Class:URP_ProfileProjection/Attribute:dimension' => 'Dimension',
	'Class:URP_ProfileProjection/Attribute:dimension+' => 'application dimension',
	'Class:URP_ProfileProjection/Attribute:dimensionid' => 'Dimension',
	'Class:URP_ProfileProjection/Attribute:dimensionid+' => 'application dimension',
	'Class:URP_ProfileProjection/Attribute:profile' => 'Profile',
	'Class:URP_ProfileProjection/Attribute:profile+' => 'Profile name',
	'Class:URP_ProfileProjection/Attribute:profileid' => 'Profile',
	'Class:URP_ProfileProjection/Attribute:profileid+' => 'usage profile',
	'Class:URP_ProfileProjection/Attribute:value' => 'Value expression',
	'Class:URP_ProfileProjection/Attribute:value+' => 'OQL expression (using $user) | constant |  | +attribute code',
	'Class:URP_Profiles' => 'Profil',
	'Class:URP_Profiles+' => 'Profil utilisateur',
	'Class:URP_Profiles/Attribute:description' => 'Description',
	'Class:URP_Profiles/Attribute:description+' => '',
	'Class:URP_Profiles/Attribute:name' => 'Nom',
	'Class:URP_Profiles/Attribute:name+' => '',
	'Class:URP_Profiles/Attribute:user_list' => 'Utilisateurs',
	'Class:URP_Profiles/Attribute:user_list+' => 'Comptes utilisateur (logins) ayant ce profil',
	'Class:URP_StimulusGrant' => 'stimulus_permission',
	'Class:URP_StimulusGrant+' => 'permissions on stimilus in the life cycle of the object',
	'Class:URP_StimulusGrant/Attribute:class' => 'Class',
	'Class:URP_StimulusGrant/Attribute:class+' => 'Target class',
	'Class:URP_StimulusGrant/Attribute:permission' => 'Permission',
	'Class:URP_StimulusGrant/Attribute:permission+' => 'allowed or not allowed?',
	'Class:URP_StimulusGrant/Attribute:permission/Value:no' => 'no',
	'Class:URP_StimulusGrant/Attribute:permission/Value:no+' => 'no',
	'Class:URP_StimulusGrant/Attribute:permission/Value:yes' => 'yes',
	'Class:URP_StimulusGrant/Attribute:permission/Value:yes+' => 'yes',
	'Class:URP_StimulusGrant/Attribute:profile' => 'Profile',
	'Class:URP_StimulusGrant/Attribute:profile+' => 'usage profile',
	'Class:URP_StimulusGrant/Attribute:profileid' => 'Profile',
	'Class:URP_StimulusGrant/Attribute:profileid+' => 'usage profile',
	'Class:URP_StimulusGrant/Attribute:stimulus' => 'Stimulus',
	'Class:URP_StimulusGrant/Attribute:stimulus+' => 'stimulus code',
	'Class:URP_UserOrg' => 'Utilisateur/Organisation',
	'Class:URP_UserOrg+' => 'Organisations permises pour l\'utilisateur',
	'Class:URP_UserOrg/Attribute:allowed_org_id' => 'Organisation',
	'Class:URP_UserOrg/Attribute:allowed_org_id+' => '',
	'Class:URP_UserOrg/Attribute:allowed_org_name' => 'Organisation',
	'Class:URP_UserOrg/Attribute:allowed_org_name+' => '',
	'Class:URP_UserOrg/Attribute:reason' => 'Raison',
	'Class:URP_UserOrg/Attribute:reason+' => 'Justifie la permission de voir les données de cette organisation',
	'Class:URP_UserOrg/Attribute:userid' => 'Utilisateur',
	'Class:URP_UserOrg/Attribute:userid+' => '',
	'Class:URP_UserOrg/Attribute:userlogin' => 'Login',
	'Class:URP_UserOrg/Attribute:userlogin+' => '',
	'Class:URP_UserOrg/Name' => 'Lien entre %1$s et %2$s',
	'Class:URP_UserProfile' => 'Utilisateur/Profil',
	'Class:URP_UserProfile+' => '',
	'Class:URP_UserProfile/Attribute:profile' => 'Profil',
	'Class:URP_UserProfile/Attribute:profile+' => '',
	'Class:URP_UserProfile/Attribute:profileid' => 'Profil',
	'Class:URP_UserProfile/Attribute:profileid+' => '',
	'Class:URP_UserProfile/Attribute:reason' => 'Raison',
	'Class:URP_UserProfile/Attribute:reason+' => 'Justifie le rôle affecté à cet utilisateur',
	'Class:URP_UserProfile/Attribute:userid' => 'Utilisateur',
	'Class:URP_UserProfile/Attribute:userid+' => '',
	'Class:URP_UserProfile/Attribute:userlogin' => 'Login',
	'Class:URP_UserProfile/Attribute:userlogin+' => '',
	'Class:URP_UserProfile/Name' => 'Lien entre %1$s et %2$s',
	'Class:User' => 'Utilisateur',
	'Class:User+' => 'Compte utilisateur',
	'Class:User/Attribute:allowed_org_list' => 'Organisations permises',
	'Class:User/Attribute:allowed_org_list+' => 'L\'utilisateur a le droit de voir les données des organisations listées ici. Si aucune organisation n\'est spécifiée, alors aucune restriction ne s\'applique.',
	'Class:User/Attribute:contactid' => 'Personne',
	'Class:User/Attribute:contactid+' => 'Ce champ est obligatoire pour un utilisateur portail et très souhaitable hors comptes systèmes',
	'Class:User/Attribute:email' => 'Adresse mél',
	'Class:User/Attribute:email+' => 'Adresse mél de la personne associée',
	'Class:User/Attribute:finalclass' => 'Type de compte',
	'Class:User/Attribute:finalclass+' => 'Nom de la classe instanciable',
	'Class:User/Attribute:first_name' => 'Prénom',
	'Class:User/Attribute:first_name+' => 'Prénom de la personne associée',
	'Class:User/Attribute:language' => 'Langue',
	'Class:User/Attribute:language+' => 'Langue de défaut d\''.ITOP_APPLICATION_SHORT.' pour cet utilisateur, à choisir parmi les langues dans lequelles '.ITOP_APPLICATION_SHORT.' a été traduit.',
	'Class:User/Attribute:language/Value:EN US' => 'Anglais',
	'Class:User/Attribute:language/Value:EN US+' => 'Anglais (Etats-unis)',
	'Class:User/Attribute:language/Value:FR FR' => 'Français',
	'Class:User/Attribute:language/Value:FR FR+' => 'Français (France)',
	'Class:User/Attribute:last_name' => 'Nom',
	'Class:User/Attribute:last_name+' => 'Nom de la personne associée',
	'Class:User/Attribute:login' => 'Login',
	'Class:User/Attribute:login+' => 'Indentifiant de ce compte, doit être unique au sein d\''.ITOP_APPLICATION_SHORT,
	'Class:User/Attribute:org_id' => 'Organisation',
	'Class:User/Attribute:org_id+' => 'Organisation de la personne associée',
	'Class:User/Attribute:profile_list' => 'Profils',
	'Class:User/Attribute:profile_list+' => 'Rôles, ouvrants les droits d\'accès',
	'Class:User/Attribute:status' => 'Etat',
	'Class:User/Attribute:status+' => 'Est-ce que ce compte utilisateur est actif, ou non?',
	'Class:User/Attribute:status/Value:disabled' => 'Désactivé',
	'Class:User/Attribute:status/Value:enabled' => 'Actif',
	'Class:User/Error:AllowedOrgsMustContainUserOrg' => 'Les organisations permises doivent contenir l\'organisation de l\'utilisateur',
	'Class:User/Error:AtLeastOneOrganizationIsNeeded' => 'L\'utilisateur doit avoir au moins une organisation.',
	'Class:User/Error:AtLeastOneProfileIsNeeded' => 'L\'utilisateur doit avoir au moins un profil.',
	'Class:User/Error:CurrentProfilesHaveInsufficientRights' => 'Les profils existants ne permettent pas de modifier les utilisateurs',
	'Class:User/Error:LoginMustBeUnique' => 'Le login doit être unique - "%1s" est déjà utilisé.',
	'Class:User/Error:OrganizationNotAllowed' => 'Organisation non autorisée.',
	'Class:User/Error:PersonIsMandatory' => 'Le Contact est obligatoire.',
	'Class:User/Error:PortalPowerUserHasInsufficientRights' => 'Le profil Portal power user ne donne pas suffisamment de droits à l\'utilisateur (un autre profil doit être ajouté)',
	'Class:User/Error:ProfileNotAllowed' => 'Le profil "%1$s" ne peux pas être ajouté à son propre utilisateur, il interdit l\'accès à la console',
	'Class:User/Error:StatusChangeIsNotAllowed' => 'Impossible de changer l\'état de son propre utilisateur',
	'Class:User/Error:UserOrganizationNotAllowed' => 'L\'utilisateur n\'appartient pas à vos organisations.',
	'Class:User/Warning:NoContactHasImpact' => 'Attention: il n\'y a pas de Personne liée à cet utilisateur, il ne pourra pas se connecter à un portail, ni recevoir de News, ni changer sa langue.',
	'Class:User/Warning:NoOrganizationMeansFullAccess' => 'Aucune "Organisations permises" définie pour cet utilisateur, il aura accès à toutes les organisations sans restriction',
	'Class:UserDashboard' => 'Tableau de bord utilisateur',
	'Class:UserDashboard+' => '',
	'Class:UserDashboard/Attribute:contents' => 'Contenu',
	'Class:UserDashboard/Attribute:contents+' => '',
	'Class:UserDashboard/Attribute:menu_code' => 'Menu',
	'Class:UserDashboard/Attribute:menu_code+' => '',
	'Class:UserDashboard/Attribute:user_id' => 'Utilisateur',
	'Class:UserDashboard/Attribute:user_id+' => '',
	'Class:UserInternal' => 'Utilisateur interne',
	'Class:UserInternal+' => 'Utilisateur défini dans '.ITOP_APPLICATION_SHORT,
	'Class:lnkAuditCategoryToAuditDomain' => 'Link AuditCategory / AuditDomain',
	'Class:lnkAuditCategoryToAuditDomain+' => '',
	'Class:lnkAuditCategoryToAuditDomain/Attribute:category_id' => 'Catégorie',
	'Class:lnkAuditCategoryToAuditDomain/Attribute:category_id+' => 'Catégorie d\'audit',
	'Class:lnkAuditCategoryToAuditDomain/Attribute:category_name' => 'Nom de la catégorie',
	'Class:lnkAuditCategoryToAuditDomain/Attribute:category_name+' => 'Nom de la catégorie d\'audit',
	'Class:lnkAuditCategoryToAuditDomain/Attribute:domain_id' => 'Domaine',
	'Class:lnkAuditCategoryToAuditDomain/Attribute:domain_id+' => 'Domaine d\'audit',
	'Class:lnkAuditCategoryToAuditDomain/Attribute:domain_name' => 'Nom du domain',
	'Class:lnkAuditCategoryToAuditDomain/Attribute:domain_name+' => 'Nom du domain d\'audit',
	'DayOfWeek-Friday' => 'Vendredi',
	'DayOfWeek-Friday-Min' => 'Ve',
	'DayOfWeek-Monday' => 'Lundi',
	'DayOfWeek-Monday-Min' => 'Lu',
	'DayOfWeek-Saturday' => 'Samedi',
	'DayOfWeek-Saturday-Min' => 'Sa',
	'DayOfWeek-Sunday' => 'Dimanche',
	'DayOfWeek-Sunday-Min' => 'Di',
	'DayOfWeek-Thursday' => 'Jeudi',
	'DayOfWeek-Thursday-Min' => 'Je',
	'DayOfWeek-Tuesday' => 'Mardi',
	'DayOfWeek-Tuesday-Min' => 'Ma',
	'DayOfWeek-Wednesday' => 'Mercredi',
	'DayOfWeek-Wednesday-Min' => 'Me',
	'Enum:Undefined' => 'Non défini',
	'ExcelExport:AutoDownload' => 'Téléchargement automatique dès que le fichier est prêt',
	'ExcelExport:PreparingExport' => 'Préparation de l\'export...',
	'ExcelExport:Statistics' => 'Statistiques',
	'ExcelExporter:BuildingExcelFile' => 'Construction du fichier Excel...',
	'ExcelExporter:Done' => 'Terminé.',
	'ExcelExporter:DownloadButton' => 'Télécharger %1$s',
	'ExcelExporter:ExportButton' => 'Exporter',
	'ExcelExporter:ExportDialogTitle' => 'Export au format Excel',
	'ExcelExporter:ExportMenu' => 'Exporter pour Excel...',
	'ExcelExporter:RetrievingData' => 'Récupération des données...',
	'Expression:Operator:=' => ' : ',
	'Expression:Operator:AND' => ' ET ',
	'Expression:Operator:OR' => ' OU ',
	'Expression:Unit:Long:DAY' => 'jour(s)',
	'Expression:Unit:Long:HOUR' => 'heure(s)',
	'Expression:Unit:Long:MINUTE' => 'minute(s)',
	'Expression:Unit:Short:DAY' => 'j',
	'Expression:Unit:Short:MONTH' => 'm',
	'Expression:Unit:Short:WEEK' => 's',
	'Expression:Unit:Short:YEAR' => 'a',
	'Expression:Verb:ISNULL' => ' : non défini',
	'Expression:Verb:NOW' => 'maintenant',
	'Menu:AdminTools' => 'Administration',
	'Menu:AdminTools+' => 'Outils d\'administration',
	'Menu:AdminTools?' => 'Ces outils sont accessibles uniquement aux utilisateurs possédant le profil Administrateur.',
	'Menu:AuditCategories' => 'Configurer l\'audit',
	'Menu:AuditCategories+' => 'Définir des régles pour auditer la qualité des données',
	'Menu:AuditCategories:Title' => 'Configurer l\'audit',
	'Menu:CSVImportMenu' => 'Import CSV',
	'Menu:CSVImportMenu+' => 'Import ou mise à jour en masse',
	'Menu:ConfigurationTools' => 'Configuration',
	'Menu:ConfigEditor'       => 'Configuration générale',
	'Menu:ConfigEditor+'      => 'Édition du fichier de configuration',
	'Menu:Integrations' => 'Intégrations',
	'Menu:Integrations+'          => '',
	'Menu:DataAdministration' => 'Administration des données',
	'Menu:DataAdministration+' => 'Administration des données',
	'Menu:DataModelMenu' => 'Modèle de données',
	'Menu:DataModelMenu+' => 'Résumé du modèle de données',
	'Menu:DataSources' => 'Synchronisation',
	'Menu:DataSources+' => 'Configurations d\'import de données issues de sources externes',
	'Menu:ExportMenu' => 'Export',
	'Menu:ExportMenu+' => 'Export des résultats d\'une requête en HTML, CSV ou XML',
	'Menu:MyShortcuts' => 'Mes raccourcis',
	'Menu:Notifications:Title' => 'Catégories d\'audit',
	'Menu:NotificationsMenu' => 'Notifications',
	'Menu:NotificationsMenu+' => 'Configurer les Notifications',
	'Menu:ProfilesMenu' => 'Profils',
	'Menu:ProfilesMenu+' => 'Consulter les profils existants',
	'Menu:ProfilesMenu:Title' => 'Profils',
	'Menu:Queries' => 'Requêtes',
	'Menu:QueryMenu' => 'Livre des requêtes',
	'Menu:QueryMenu+' => 'Créer des requêtes réutilisables',
	'Menu:RunQueriesMenu' => 'Requêtes OQL',
	'Menu:RunQueriesMenu+' => 'Executer une requête OQL',
	'Menu:SystemTools' => 'Système',
	'Menu:TagAdminMenu' => 'Étiquettes',
	'Menu:TagAdminMenu+' => 'Gestion des étiquettes',
	'Menu:UniversalSearchMenu' => 'Recherche universelle',
	'Menu:UniversalSearchMenu+' => 'Rechercher n\'importe quel objet...',
	'Menu:UserAccountsMenu' => 'Comptes utilisateurs',
	'Menu:UserAccountsMenu+' => 'Gérer les comptes utilisateurs et leur droits',
	'Menu:UserAccountsMenu:Title' => 'Comptes utilisateurs',
	'Menu:UserManagement' => 'Utilisateurs',
	'Menu:UserManagementMenu' => 'Gestion des Utilisateurs',
	'Menu:UserManagementMenu+' => 'Qui peut se connecter à '.ITOP_APPLICATION_SHORT.' et y faire quoi ?',
	'Menu:WelcomeMenu' => 'Bienvenue',
	'Menu:WelcomeMenu+' => 'Bienvenue dans '.ITOP_APPLICATION_SHORT,
	'Menu:WelcomeMenuPage' => 'Bienvenue',
	'Menu:WelcomeMenuPage+' => 'Bienvenue dans '.ITOP_APPLICATION_SHORT,
	'Month-01' => 'Janvier',
	'Month-01-Short' => 'Jan',
	'Month-02' => 'Février',
	'Month-02-Short' => 'Fév',
	'Month-03' => 'Mars',
	'Month-03-Short' => 'Mar',
	'Month-04' => 'Avril',
	'Month-04-Short' => 'Avr',
	'Month-05' => 'Mai',
	'Month-05-Short' => 'Mai',
	'Month-06' => 'Juin',
	'Month-06-Short' => 'Juin',
	'Month-07' => 'Juillet',
	'Month-07-Short' => 'Juil',
	'Month-08' => 'Août',
	'Month-08-Short' => 'Août',
	'Month-09' => 'Septembre',
	'Month-09-Short' => 'Sept',
	'Month-10' => 'Octobre',
	'Month-10-Short' => 'Oct',
	'Month-11' => 'Novembre',
	'Month-11-Short' => 'Nov',
	'Month-12' => 'Décembre',
	'Month-12-Short' => 'Déc',
	'ObjectRef:Archived' => 'Archivé',
	'ObjectRef:Obsolete' => 'Obsolète',
	'Portal:AddAttachment' => ' Ajouter une pièce jointe ',
	'Portal:Attachment_No_To_Ticket_Name' => 'Pièce jointe #%1$d à %2$s (%3$s)',
	'Portal:Attachments' => 'Pièces jointes',
	'Portal:Back' => 'Retour',
	'Portal:Button:CloseTicket' => 'Clôre cette requête',
	'Portal:Button:ReopenTicket' => 'Réouvrir cette requête',
	'Portal:Button:UpdateRequest' => 'Mettre à jour la requête',
	'Portal:ChangeMyPassword' => 'Changer mon mot de passe',
	'Portal:ClosedRequests' => 'Mes requêtes fermées',
	'Portal:CreateNewIncidentItil' => 'Indiquer une panne',
	'Portal:CreateNewRequest' => 'Créer une nouvelle requête',
	'Portal:CreateNewRequestItil' => 'Créer une nouvelle requête',
	'Portal:DescriptionOfTheRequest' => 'Entrez la description de votre requête:',
	'Portal:Disconnect' => 'Déconnexion',
	'Portal:EnterYourCommentsOnTicket' => 'Vos commentaires à propos du traitement de cette requête:',
	'Portal:ErrorNoContactForThisUser' => 'Erreur: l\'utilisateur courant n\'est pas associé à une Personne/Contact. Contactez votre administrateur.',
	'Portal:NoClosedRequest' => 'Aucune requête.',
	'Portal:NoOpenRequest' => 'Aucune requête.',
	'Portal:NoRequestMgmt' => 'Chèr(e) %1$s, vous avez été redirigé(e) vers cette page car votre compte utilisateur est configuré avec le profil \'Utilisateur du Portail\'.Malheureusement, iTop n\'a pas été installé avec le module de \'Gestion des Demandes\'.Merci de contacter votre administrateur '.ITOP_APPLICATION_SHORT.'.',
	'Portal:OpenRequests' => 'Mes requêtes en cours',
	'Portal:PleaseSelectAServiceSubCategory' => 'Veuillez choisir une sous-catégorie',
	'Portal:PleaseSelectOneService' => 'Veuillez choisir un service',
	'Portal:Refresh' => 'Rafraîchir',
	'Portal:RemoveAttachment' => ' Enlever la pièce jointe ',
	'Portal:ResolvedRequests' => 'Mes requêtes résolues',
	'Portal:SelectRequestTemplate' => 'Sélectionnez un modèle de requête pour %1$s',
	'Portal:SelectService' => 'Choisissez un service dans le catalogue:',
	'Portal:SelectSubcategoryFrom_Service' => 'Choisissez une sous-catégorie du service %1$s:',
	'Portal:ShowClosed' => 'Requêtes fermées',
	'Portal:ShowOngoing' => 'Requêtes en cours',
	'Portal:Title' => 'Portail utilisateur '.ITOP_APPLICATION_SHORT,
	'Portal:TitleDetailsFor_Request' => 'Détail de la requête',
	'Portal:TitleRequestDetailsFor_Request' => 'Détails de votre requête %1$s:',
	'Portal:WelcomeUserOrg' => 'Bienvenue %1$s (%2$s)',
	'Query:baseinfo' => 'Informations générales',
	'Query:exportInfo' => 'Informations sur les exports',
	'Tag:Archived' => 'Archivé',
	'Tag:Archived+' => 'Accessible seulement dans le mode Archive',
	'Tag:Obsolete' => 'Obsolète',
	'Tag:Obsolete+' => 'Exclu de l\'analyse d\'impact et des résultats de recherche',
	'Tag:Synchronized' => 'Synchronisé',
	'UI-ChangeManagementMenu-ChangesByStatus' => 'Changements par état',
	'UI-ChangeManagementMenu-ChangesByType' => 'Changements par type',
	'UI-ChangeManagementMenu-ChangesNotYetAssigned' => 'Changements en attente d\'assignation',
	'UI-ChangeManagementOverview-ChangeByType' => 'Changes par type',
	'UI-ChangeManagementOverview-ChangeUnassigned' => 'Changes non affectés à un agent',
	'UI-ChangeManagementOverview-ChangeWithOutage' => 'Interruptions de service liées à un changement',
	'UI-ConfigMgmtMenuOverview-FunctionalCIByType' => 'Actifs par type',
	'UI-ConfigMgmtMenuOverview-FunctionalCIbyStatus' => 'Actifs par état',
	'UI-ConfigurationManagementMenu-InfraByStatus' => 'Nombre d\'éléments par état',
	'UI-ConfigurationManagementMenu-InfraByType' => 'Nombre d\'éléments par type',
	'UI-ContactsMenu-ContactsByLocation' => 'Contacts par emplacement',
	'UI-ContactsMenu-ContactsByStatus' => 'Contacts par état',
	'UI-ContactsMenu-ContactsByType' => 'Contacts par type',
	'UI-IncidentManagementOverview-IncidentByPriority' => 'Incidents par priorité',
	'UI-IncidentManagementOverview-IncidentByService' => 'Incidents par service',
	'UI-IncidentManagementOverview-IncidentUnassigned' => 'Incidents non affectés à un agent',
	'UI-RequestManagementOverview-RequestByPriority' => 'Demandes par priorité',
	'UI-RequestManagementOverview-RequestByService' => 'Demandes par service',
	'UI-RequestManagementOverview-RequestUnassigned' => 'Demandes non affectées à un agent',
	'UI-ServiceManagementOverview-CustomerContractToRenew' => 'Contrats clients à renouveler dans les 30 jours',
	'UI-ServiceManagementOverview-ProviderContractToRenew' => 'Contrats fournisseurs à renouveler dans les 30 jours',
	'UI:About:DataModel' => 'Modèle de données',
	'UI:About:Extension_Version' => 'Version: %1$s',
	'UI:About:InstallationOptions' => 'Options d\'installation',
	'UI:About:Licenses' => 'Licences',
	'UI:About:ManualExtensionSource' => 'Extension',
	'UI:About:RemoteExtensionSource' => 'Data',
	'UI:About:Support' => 'Informations pour le support',
	'UI:About:Title' => 'A propos d\''.ITOP_APPLICATION_SHORT,
	'UI:AboutBox' => 'A propos d\''.ITOP_APPLICATION_SHORT.'...',
	'UI:AccessRO-All' => ITOP_APPLICATION_SHORT.' est en lecture seule',
	'UI:AccessRO-Users' => ITOP_APPLICATION_SHORT.' est en lecture seule pour les utilisateurs finaux',
	'UI:ActionNotAllowed' => 'Vous n\'êtes pas autorisé à exécuter cette opération sur ces objets.',
	'UI:AddAnExisting_Class' => 'Ajouter des objets de type %1$s...',
	'UI:AddLinkedObjectsOf_Class' => 'Ajouter des %1$s',
	'UI:AddObjectsOf_Class_LinkedWith_Class' => 'Ajouter des objets de type %1$s à lier à cet objet de type %2$s',
	'UI:AddObjectsOf_Class_LinkedWith_Class_Instance' => 'Ajouter des objets de type %1$s liés à %3$s (%2$s)',
	'UI:AllOrganizations' => ' Toutes les Organisations ',
	'UI:ApplicationEnvironment' => 'Environnement applicatif: %1$s',
	'UI:Apply_Stimulus_On_Object_In_State_ToTarget_State' => '%1$s pour %2$s de l\'état %3$s vers l\'état %4$s.',
	'UI:ArchiveMode:Banner' => 'Mode Archive',
	'UI:ArchiveMode:Banner+' => 'Les objets archivés sont visibles, et aucune modification n\'est possible',
	'UI:ArchiveModeOff' => 'Désactiver le mode Archive',
	'UI:ArchiveModeOn' => 'Activer le mode Archive',
	'UI:Archive_User_OnBehalfOf_User' => '%1$s pour %2$s',
	'UI:AttemptingToChangeASlaveAttribute_Name' => 'Le champ %1$s ne peut pas être modifié car il est géré par une synchronisation avec une source de données. Valeur inchangée.',
	'UI:AttemptingToSetAReadOnlyAttribute_Name' => 'Tentative de modification du champ en lecture seule: %1$s',
	'UI:AttemptingToSetASlaveAttribute_Name' => 'Le champ %1$s (%2$s) ne peut pas être modifié car il est géré par une synchronisation avec une source de données. Valeur ignorée.',
	'UI:Audit:AuditCategory:Subtitle' => '%1$s en erreur sur %2$s - %3$s%% des objets sont valides',
	'UI:Audit:AuditErrors' => 'Audit Errors~~',
	'UI:Audit:Dashboard:ObjectsAudited' => 'Objets audités',
	'UI:Audit:Dashboard:ObjectsInError' => 'Objets en erreur',
	'UI:Audit:Dashboard:ObjectsValidated' => 'Objets valides',
	'UI:Audit:Error:ValueNA' => 'n/a',
	'UI:Audit:ErrorIn_Category' => 'Erreur dans la catégorie',
	'UI:Audit:ErrorIn_Category_Reason' => 'Erreur OQL dans la catégorie %1$s: %2$s.',
	'UI:Audit:ErrorIn_Rule' => 'Erreur dans le régle',
	'UI:Audit:ErrorIn_Rule_Reason' => 'Erreur OQL dans la règle %1$s: %2$s.',
	'UI:Audit:HeaderAuditRule' => 'Règle d\'audit',
	'UI:Audit:HeaderNbErrors' => 'Nb d\'Erreurs',
	'UI:Audit:HeaderNbObjects' => 'Nb d\'Objets',
	'UI:Audit:Interactive:All:BreadCrumb' => 'Audit complet',
	'UI:Audit:Interactive:All:BreadCrumb+' => 'Audit de toutes les régles',
	'UI:Audit:Interactive:All:SubTitle' => 'Audit complet, incluant toutes les régles, sans limitation de domaine ni de catégorie',
	'UI:Audit:Interactive:All:Title' => 'Résultats de tous les audits',
	'UI:Audit:Interactive:Button:Back' => 'Retour à l\'audit',
	'UI:Audit:Interactive:Button:Configuration' => 'Configurer l\'audit',
	'UI:Audit:Interactive:Categories:BreadCrumb' => 'Catégories',
	'UI:Audit:Interactive:Categories:BreadCrumb+' => 'Audit des catégories : %1$s',
	'UI:Audit:Interactive:Categories:SubTitle' => 'Audit de toutes les régles appartenant à ces %1$s catégories',
	'UI:Audit:Interactive:Categories:Title' => 'Résultats d\'audit des catégories : %1$s',
	'UI:Audit:Interactive:Domain:BreadCrumb' => '%1$s',
	'UI:Audit:Interactive:Domain:BreadCrumb+' => 'Audit du domaine : %1$s',
	'UI:Audit:Interactive:Domain:SubTitle' => 'Audit de toutes les régles dont la catégorie est reliée au domaine : %1$s',
	'UI:Audit:Interactive:Domain:Title' => 'Résultats d\'audit du domaine : %1$s',
	'UI:Audit:Interactive:Selection:BadgeAll' => 'Toutes les catégories',
	'UI:Audit:Interactive:Selection:BreadCrumb' => 'Sélection',
	'UI:Audit:Interactive:Selection:BreadCrumb+' => 'Choix d\'un Audit à exécuter',
	'UI:Audit:Interactive:Selection:SubTitle' => 'Choisir un domaine pour obtenir les résultats d\'audit limités à ce domaine ou "Toutes les catégories" (Peut prendre du temps, voir échouer s\'il y a trop d\'objets à auditer)',
	'UI:Audit:Interactive:Selection:Title' => 'Sélection d\'un audit',
	'UI:Audit:OqlError' => 'Erreur OQL',
	'UI:Audit:PercentageOk' => '% Ok',
	'UI:Audit:Title' => ITOP_APPLICATION_SHORT.' - Audit de la CMDB',
	'UI:Audit:ViewRules' => 'Vérifier les régles d\'audit',
	'UI:AutoApplyConfirmationMessage' => 'Des modifications n\'ont pas encore été prises en compte. Voulez-vous qu\'elles soient prises en compte automatiquement ?',
	'UI:AvailableInlineImagesLegend' => 'Images disponibles',
	'UI:BeforeAdding_Class_ObjectsSaveThisObject' => 'Enregistrez l\'objet courant avant de créer de nouveaux éléments de type %1$s.',
	'UI:BrowseInlineImages' => 'Parcourir les images...',
	'UI:BulkAction:NoObjectSelected' => 'Veuillez s\électionner au moins un objet pour cette opération.',
	'UI:BulkDeletePageTitle' => ITOP_APPLICATION_SHORT.' - Suppression massive',
	'UI:BulkDeleteTitle' => 'Sélectionnez les objets à supprimer:',
	'UI:BulkModify:N_MoreValues' => '%1$d valeurs supplémentaires...',
	'UI:BulkModify:Value_Exists_N_Times' => '%1$s, %2$d fois',
	'UI:BulkModifyErrors' => 'Erreur',
	'UI:BulkModifyErrors+' => '',
	'UI:BulkModifyStatus' => 'Opération',
	'UI:BulkModifyStatus+' => '',
	'UI:BulkModifyStatusError' => 'Erreur',
	'UI:BulkModifyStatusModified' => 'Modifié',
	'UI:BulkModifyStatusOk' => 'Ok',
	'UI:BulkModifyStatusSkipped' => 'Ignoré',
	'UI:BulkModify_Count_DistinctValues' => '%1$d valeurs distinctes:',
	'UI:Button:Add' => ' Ajouter ',
	'UI:Button:AddObject' => ' Ajouter... ',
	'UI:Button:AddToList' => ' << Ajouter ',
	'UI:Button:Apply' => 'Appliquer',
	'UI:Button:Back' => ' << Retour ',
	'UI:Button:BrowseObjects' => ' Naviguer... ',
	'UI:Button:Cancel' => 'Annuler',
	'UI:Button:ChangePassword' => ' Changer ! ',
	'UI:Button:Clear' => ' Clear ~~',
	'UI:Button:Close' => 'Fermer',
	'UI:Button:Confirm' => 'Confirmer',
	'UI:Button:Create' => ' Créer ',
	'UI:Button:Delete' => ' Supprimer ',
	'UI:Button:DoImport' => ' Lancer l\'import ! ',
	'UI:Button:Done' => ' Terminé ',
	'UI:Button:Evaluate' => ' Exécuter ',
	'UI:Button:Evaluate:Title' => ' Exécuter (Ctrl+Entrée)',
	'UI:Button:Export' => 'Exporter',
	'UI:Button:FilterList' => ' Filtrer... ',
	'UI:Button:Finish' => ' Terminer ',
	'UI:Button:GlobalSearch' => 'Rechercher',
	'UI:Button:GoPrint' => 'Imprimer...',
	'UI:Button:Insert' => 'Insérer',
	'UI:Button:Less' => 'Moins',
	'UI:Button:Login' => 'Entrer dans '.ITOP_APPLICATION_SHORT,
	'UI:Button:Logoff' => 'Déconnexion',
	'UI:Button:ModifyAll' => 'Modifier',
	'UI:Button:More' => 'Plus',
	'UI:Button:MoveDown' => 'Descendre',
	'UI:Button:MoveUp' => 'Monter',
	'UI:Button:Next' => ' Suite >> ',
	'UI:Button:Ok' => 'Ok',
	'UI:Button:PreviewModifications' => 'Aperçu des modifications >>',
	'UI:Button:Query' => ' Lancer la requête ',
	'UI:Button:Refresh' => 'Rafraîchir',
	'UI:Button:Remove' => 'Enlever',
	'UI:Button:RemoveDocument' => 'Supprimer le document',
	'UI:Button:RemoveFromList' => ' Enlever >> ',
	'UI:Button:RemoveImage' => 'Supprimer l\'image',
	'UI:Button:Rename' => ' Renommer... ',
	'UI:Button:ResetImage' => 'Récupérer l\'image initiale',
	'UI:Button:ResetPassword' => ' Ràz du mot de passe ',
	'UI:Button:Restart' => ' |<< Recommencer ',
	'UI:Button:Save' => 'Sauver',
	'UI:Button:SaveAnd' => 'Sauver et %1$s',
	'UI:Button:Search' => 'Rechercher',
	'UI:Button:SearchInHierarchy' => 'Rechercher dans la hiérarchie',
	'UI:Button:Send' => 'Envoyer',
	'UI:Button:SendAnd' => 'Envoyer et %1$s',
	'UI:Button:SimulateImport' => ' Simuler l\'import ',
	'UI:Button:Test' => 'Tester !',
	'UI:Button:UploadImage' => 'Upload an image from the disk~~',
	'UI:Button:Wait' => 'Patientez pendant la mise à jour des champs',
	'UI:CSVExport:AdvancedMode' => 'Mode expert',
	'UI:CSVExport:AdvancedMode+' => 'Dans le mode expert, des colonnes supplémentaires apparaissent: l\'identifiant de l\'objet, la valeur des clés externes et leurs attributs de reconciliation.',
	'UI:CSVExport:LostChars' => 'Problème d\'encodage',
	'UI:CSVExport:LostChars+' => 'Le fichier téléchargé sera encodé en %1$s. iTop a détecté des caractères incompatible avec ce format. Ces caractères seront soit remplacés par des caractères de substitution (par exemple: \'é\' transformé en \'e\'), soit perdus. Vous pouvez utiliser le copier/coller depuis votre navigateur web, ou bien contacter votre administrateur pour que l\'encodage corresponde mieux à votre besoin (Cf. paramètre \'csv_file_default_charset\').',
	'UI:CSVImport:AdvancedMode' => 'Mode expert',
	'UI:CSVImport:AdvancedMode+' => 'En mode expert, l\'"id" (clef primaire) des objets peut être utilisé pour renommer des objets.Cependant la colonne "id" (si elle est présente) ne peut être utilisée que comme clef de recherche et ne peut pas être combinée avec une autre clef de recherche.',
	'UI:CSVImport:AlertIncompleteMapping' => 'Veuillez choisir la correspondance pour chacun des champs.',
	'UI:CSVImport:AlertMultipleMapping' => 'Veuillez vous assurer que chaque champ cible est sélectionné une seule fois.',
	'UI:CSVImport:AlertNoSearchCriteria' => 'Veuillez choisir au moins une clef de recherche.',
	'UI:CSVImport:CSVDataPreview' => 'Aperçu des données CSV',
	'UI:CSVImport:ClassesSelectOne' => '-- choisir une valeur --',
	'UI:CSVImport:Column' => 'Colonne %1$s',
	'UI:CSVImport:CommentsAndHeader' => 'Commentaires et en-tête',
	'UI:CSVImport:CustomDateTimeFormat' => 'Format spécial: %1$s',
	'UI:CSVImport:CustomDateTimeFormatTooltip' => 'Codes de format:<table>
<tr><td>Y</td><td>année (sur 4 chiffres, ex. 2016)</td></tr>
<tr><td>y</td><td>année (sur 2 chiffres, ex. 16 pour 2016)</td></tr>
<tr><td>m</td><td>mois (sur 2 chiffres: 01..12)</td></tr>
<tr><td>n</td><td>month (sur 1 ou 2 chiffres sans le zero au début: 1..12)</td></tr>
<tr><td>d</td><td>jour (sur 2 chiffres: 01..31)</td></tr>
<tr><td>j</td><td>jour (sur 1 ou 2 chiffres sans le zero au début: 1..31)</td></tr>
<tr><td>H</td><td>heure (24 heures sur 2 chiffres: 00..23)</td></tr>
<tr><td>h</td><td>heure (12 heures sur 2 chiffres: 01..12)</td></tr>
<tr><td>G</td><td>heure (24 heures sur 1 ou 2 chiffres: 0..23)</td></tr>
<tr><td>g</td><td>heure (12 heures sur 1 ou 2 chiffres: 1..12)</td></tr>
<tr><td>a</td><td>am ou pm (en minuscules)</td></tr>
<tr><td>A</td><td>AM ou PM (en majuscules)</td></tr>
<tr><td>i</td><td>minutes (sur 2 chiffres: 00..59)</td></tr>
<tr><td>s</td><td>secondes (sur 2 chiffres: 00..59)</td></tr>
</table>',
	'UI:CSVImport:DataLine1' => 'Données Ligne 1',
	'UI:CSVImport:DataLine2' => 'Données Ligne  2',
	'UI:CSVImport:DateAndTimeFormats' => 'Format de date et heure',
	'UI:CSVImport:DefaultDateTimeFormat_Format_Example' => 'Format par défaut: %1$s (ex. %2$s)',
	'UI:CSVImport:Encoding' => 'Encodage des caractères',
	'UI:CSVImport:ErrorExtendedAttCode' => 'Erreur interne: "%1$s" n\'est pas une code correct car "%2$s" n\'est pas une clef externe de la classe "%3$s"',
	'UI:CSVImport:ErrorOnlyOneColumn' => 'Erreur: Les données semblent ne contenir qu\'une seule colonne. Avez-vous choisi le bon séparateur ?',
	'UI:CSVImport:FieldName' => 'Champ n°%1$d',
	'UI:CSVImport:HeaderFields' => 'Champs',
	'UI:CSVImport:HeaderMappings' => 'Correspondance',
	'UI:CSVImport:HeaderSearch' => 'Recherche ?',
	'UI:CSVImport:LinesNotImported' => 'Des lignes n\'ont pas été importées:',
	'UI:CSVImport:LinesNotImported+' => 'Les lignes suivantes n\'ont pas été importées car elles contenaient des erreurs.',
	'UI:CSVImport:MappingNotApplicable' => '-- ignorer ce champ --',
	'UI:CSVImport:MappingSelectOne' => '-- choisir une valeur --',
	'UI:CSVImport:NoData' => 'Aucune donnée... merci de fournir des données !',
	'UI:CSVImport:ObjectsHadErrors' => '%1$d ligne(s) contenaient des erreurs.',
	'UI:CSVImport:ObjectsRemainedUnchanged' => '%1$d objets(s) n\'ont pas changé.',
	'UI:CSVImport:ObjectsWereAdded' => '%1$d objets(s) ont été créés.',
	'UI:CSVImport:ObjectsWereModified' => '%1$d objets(s)ont été modifiés.',
	'UI:CSVImport:ObjectsWillBeAdded' => '%1$d objets(s) seront créés.',
	'UI:CSVImport:ObjectsWillBeModified' => '%1$d objets(s) seront modifiés.',
	'UI:CSVImport:ObjectsWillHaveErrors' => '%1$d objets(s) seront en erreur.',
	'UI:CSVImport:ObjectsWillStayUnchanged' => '%1$d objets(s) resteront inchangés.',
	'UI:CSVImport:PasteData' => 'Collez ici les données à importer:',
	'UI:CSVImport:PickClassForTemplate' => 'Choisissez un modèle à télécharger: ',
	'UI:CSVImport:QualifierDoubleQuote+' => '" (guillemet double)',
	'UI:CSVImport:QualifierOther' => 'autre :',
	'UI:CSVImport:QualifierSimpleQuote+' => '\' (guillemet simple / apostrophe)',
	'UI:CSVImport:SelectAClassFirst' => 'Pour configurer la correspondance, choississez d\'abord un type ci-dessus.',
	'UI:CSVImport:SelectClass' => 'Sélectionner le type d\'objets à importer:',
	'UI:CSVImport:SelectFile' => 'Sélectionnez le fichier à importer:',
	'UI:CSVImport:SeparatorCharacter' => 'Séparateur:',
	'UI:CSVImport:SeparatorComma+' => ', (virgule)',
	'UI:CSVImport:SeparatorOther' => 'autre :',
	'UI:CSVImport:SeparatorSemicolon+' => '; (point-virgule)',
	'UI:CSVImport:SeparatorTab+' => 'tab',
	'UI:CSVImport:Skip_N_LinesAtTheBeginning' => 'Ignorer les %1$s premières lignes du fichier',
	'UI:CSVImport:Tab:CopyPaste' => 'Copier/Coller de données',
	'UI:CSVImport:Tab:LoadFromFile' => 'Import depuis un fichier',
	'UI:CSVImport:Tab:Templates' => 'Modèles',
	'UI:CSVImport:TextQualifierCharacter' => 'Délimiteur de texte',
	'UI:CSVImport:TreatFirstLineAsHeader' => 'La première ligne est l\'en-tête (noms des colonnes)',
	'UI:CSVImport:ViewAllAmbiguousValues' => 'Voir toutes les valeurs ambigues',
	'UI:CSVImport:ViewAllPossibleValues' => 'Voir toutes les valeurs possibles',
	'UI:CSVImport:idField' => 'id (Clef primaire)',
	'UI:CSVImportConfirmMessage' => 'Etes-vous sûr(e) de vouloir faire cela ?',
	'UI:CSVImportConfirmTitle' => 'Veuillez confirmer cette opération',
	'UI:CSVImportCreated_items' => 'Créations: %1$d',
	'UI:CSVImportError_items' => 'Erreurs: %1$d',
	'UI:CSVImportModified_items' => 'Modifications: %1$d',
	'UI:CSVImportUnchanged_items' => 'Inchangés: %1$d',
	'UI:CSVReport-Icon-Created' => 'Créé',
	'UI:CSVReport-Icon-Error' => 'Erreur',
	'UI:CSVReport-Icon-Missing' => 'A disparu',
	'UI:CSVReport-Icon-Modified' => 'Modifié',
	'UI:CSVReport-Icon-Unchanged' => 'Non modifié',
	'UI:CSVReport-Object-Ambiguous' => 'Ambigüité: %1$s',
	'UI:CSVReport-Object-Created' => 'Objet créé',
	'UI:CSVReport-Object-Error' => 'Erreur: %1$s',
	'UI:CSVReport-Object-MissingToUpdate' => 'Objet disparu: sera modifié',
	'UI:CSVReport-Object-MissingUpdated' => 'Objet disparu: modifié',
	'UI:CSVReport-Object-ToCreate' => 'L\'objet sera créé',
	'UI:CSVReport-Row-Created' => 'créé',
	'UI:CSVReport-Row-Disappeared' => 'disparu, %1$d colonnes modifiées',
	'UI:CSVReport-Row-Issue' => 'Erreur: %1$s',
	'UI:CSVReport-Row-Issue-Ambiguous' => 'Réconciliation ambigüe',
	'UI:CSVReport-Row-Issue-Attribute' => 'Des attributs ont des valeurs incorrectes',
	'UI:CSVReport-Row-Issue-DateFormat' => 'Format de date incorrect',
	'UI:CSVReport-Row-Issue-ExpectedDateFormat' => 'Expected format: %1$s~~',
	'UI:CSVReport-Row-Issue-Inconsistent' => 'Incohérence entre attributs: %1$s',
	'UI:CSVReport-Row-Issue-Internal' => 'Erreur interne: %1$s, %2$s',
	'UI:CSVReport-Row-Issue-MissingExtKey' => 'Ne peut pas être créé car il manque des clés externes : %1$s',
	'UI:CSVReport-Row-Issue-Reconciliation' => 'Echec de réconciliation',
	'UI:CSVReport-Row-Unchanged' => 'inchangé',
	'UI:CSVReport-Row-Updated' => '%1$d colonnes modifiées',
	'UI:CSVReport-Stats-Created' => '%1$.0f %% des lignes chargées vont engendrer un nouvel objet.',
	'UI:CSVReport-Stats-Errors' => '%1$.0f %% des lignes chargées sont en erreur et seront ignorées.',
	'UI:CSVReport-Stats-Modified' => '%1$.0f %% des lignes chargées vont modifier un objet.',
	'UI:CSVReport-Value-Ambiguous' => 'Ambigüité: %1$d objets trouvés',
	'UI:CSVReport-Value-ChangeIssue' => 'Ne peut pas prendre la valeur \'%1$s\'',
	'UI:CSVReport-Value-Issue-AllowedValues' => 'Allowed \'%1$s\' value(s): %2$s~~',
	'UI:CSVReport-Value-Issue-Format' => 'Echec de traitement de la valeur: %1$s',
	'UI:CSVReport-Value-Issue-FoundMany' => 'Plusieurs objets trouvés (%1$d)',
	'UI:CSVReport-Value-Issue-NoMatch' => 'Valeur incorrecte pour \'%1$s\': pas de correspondance, veuillez vérifier la syntaxe',
	'UI:CSVReport-Value-Issue-NotFound' => 'Objet non trouvé',
	'UI:CSVReport-Value-Issue-Null' => 'Valeur obligatoire',
	'UI:CSVReport-Value-Issue-Readonly' => 'L\'attribut \'%1$s\' est en lecture seule (valeur courante: %2$s, valeur proposée: %3$s)',
	'UI:CSVReport-Value-Issue-Unknown' => 'Valeur incorrecte pour \'%1$s\': %2$s',
	'UI:CSVReport-Value-Missing' => 'Absence de valeur obligatoire',
	'UI:CSVReport-Value-Modified' => 'Modifié',
	'UI:CSVReport-Value-NoMatch' => 'Pas de correspondance avec \'%1$s\'',
	'UI:CSVReport-Value-NoMatch-NoObject' => 'Il n\'y a aucun objet \'%1$s\'',
	'UI:CSVReport-Value-NoMatch-NoObject-ForCurrentUser' => 'Il n\'y a aucun objet \'%1$s\' visible par votre utilisateur',
	'UI:CSVReport-Value-NoMatch-PossibleValues' => 'Valeur(s) possible(s) pour l\'objet \'%1$s\' : %2$s',
	'UI:CSVReport-Value-NoMatch-SomeObjectNotVisibleForCurrentUser' => 'Il existe des objet(s) \'%1$s\' non visible(s) par votre utilisateur',
	'UI:CSVReport-Value-SetIssue' => 'Valeur invalide',
	'UI:CancelConfirmationMessage' => 'Vous allez perdre vos modifications. Voulez-vous continuer ?',
	'UI:CaseLog:Header_Date_UserName' => '%1$s - %2$s:',
	'UI:CaseLog:InitialValue' => 'Valeur initiale:',
	'UI:CaseLogTypeYourTextHere' => 'Nouvelle entrée ici...',
	'UI:ChangeManagementMenu' => 'Gestion du Changement',
	'UI:ChangeManagementMenu+' => 'Gestion du Changement',
	'UI:ChangeManagementMenu:Title' => 'Résumé des changements',
	'UI:ChangeMgmtMenuOverview:Title' => 'Tableau de bord de la Gestion des Changements',
	'UI:ChangePwdMenu' => 'Changer de mot de passe...',
	'UI:ChangesLogTitle' => 'Liste de modifications (%1$d):',
	'UI:Class_Object_NotUpdated' => 'Aucun changement détecté, %1$s (type : %2$s) n\'a <strong>pas</strong> été modifié.',
	'UI:Class_Object_Updated' => '%1$s (%2$s) - informations mises à jour.',
	'UI:ClickToCreateNew' => 'Créer un(e) %1$s',
	'UI:ClonePageTitle_Object_Class' => ITOP_APPLICATION_SHORT.' - %2$s - Duplication de %1$s',
	'UI:CloneTitle_Class_Object' => ' %1$s - Duplication de <span class="hilite">%2$s</span>',
	'UI:CollapseList' => 'Refermer',
	'UI:ColumnsAndSortOrder' => 'Colonnes et ordre de tri:',
	'UI:Combo:SelectValue' => '--- choisissez une valeur ---',
	'UI:ConcurrentLockKilled' => 'Le verrouillage en édition de l\'objet courant a été supprimé.',
	'UI:ConfigMgmtMenuOverview:Title' => 'Tableau de bord de la Gestion de Configuration',
	'UI:ConfigurationManagementMenu' => 'Gestion de Configuration',
	'UI:ConfigurationManagementMenu+' => 'Gestion de Configuration',
	'UI:ConfigurationManagementMenu:Title' => 'Résumé de l\'Infrastructure',
	'UI:ConfigureThisList' => 'Configurer Cette Liste...',
	'UI:ContactsMenu' => 'Contacts',
	'UI:ContactsMenu+' => 'Contacts',
	'UI:ContactsMenu:Title' => 'Résumé des contacts',
	'UI:CountOfObjects' => '%1$d objets correspondants aux critères.',
	'UI:CountOfResults' => '%1$d objet(s)',
	'UI:Create_Class_InState' => 'Créer l\'objet %1$s dans l\'état: ',
	'UI:CreationPageTitle_Class' => ITOP_APPLICATION_SHORT.' - Création d\'un objet de type %1$s ',
	'UI:CreationTitle_Class' => 'Création d\'un objet de type %1$s',
	'UI:CurrentObjectIsLockedBy_User' => 'L\'objet est verrouillé car il est en train d\'être modifié par %1$s.',
	'UI:CurrentObjectIsLockedBy_User_Explanation' => 'L\'objet est en train d\'être modifié par %1$s. Vos modifications ne peuvent pas être acceptées car elles risquent d\'être écrasées.',
	'UI:CurrentObjectIsSoftLockedBy_User' => 'L\'objet est en train d\'être modifié par %1$s. Vous pourrez envoyer vos modifications quand il/elle aura fini.',
	'UI:CurrentObjectLockExpired' => 'Le verrouillage interdisant les modifications concurrentes a expiré.',
	'UI:CurrentObjectLockExpired_Explanation' => 'Le verrouillage interdisant les modifications concurrentes a expiré. Vos modifications ne peuvent pas être acceptées car d\'autres utilisateurs peuvent modifier cet objet.',
	'UI:Dashboard:Actions' => 'Actions du tableau de bord',
	'UI:Dashboard:CreateCustom' => 'Créer une version modifiée...',
	'UI:Dashboard:DeleteCustom' => 'Supprimer la version modifiée...',
	'UI:Dashboard:EditCustom' => 'Éditer la version modifiée...',
	'UI:Dashboard:NotUpToDateUntilContainerSaved' => 'Ce tableau de bord affiche des informations qui ne reflète pas les modifications en cours.',
	'UI:Dashboard:RevertConfirm' => 'Toutes modifications apportées à la version d\'origine seront perdues. Veuillez confirmer l\'opération.',
	'UI:DashboardEdit:Apply' => 'Appliquer',
	'UI:DashboardEdit:AutoReload' => 'Réactualisation automatique',
	'UI:DashboardEdit:AutoReloadSec' => 'Réactualisation toutes les (secondes)',
	'UI:DashboardEdit:AutoReloadSec+' => 'Le minimum permis est de %1$d secondes',
	'UI:DashboardEdit:DashboardTitle' => 'Titre',
	'UI:DashboardEdit:DashletProperties' => 'Propriétés de l\'Indicateur',
	'UI:DashboardEdit:Dashlets' => 'Indicateurs',
	'UI:DashboardEdit:Layout' => 'Mise en page',
	'UI:DashboardEdit:Properties' => 'Propriétés du tableau de bord',
	'UI:DashboardEdit:Revert' => 'Revenir à la valeur précédente',
	'UI:DashboardEdit:Title' => 'Éditeur de tableau de bord',
	'UI:DashletBadge:Description' => 'Icône représentant une classe d\'objets, ainsi que des liens pour créer/rechercher',
	'UI:DashletBadge:Label' => 'Badge',
	'UI:DashletBadge:Prop-Class' => 'Classe',
	'UI:DashletCreation:Dashboard' => 'Tableau de bord',
	'UI:DashletCreation:DashletType' => 'Type d\'Indicateur',
	'UI:DashletCreation:EditNow' => 'Modifier le tableau de bord',
	'UI:DashletCreation:Title' => 'Créer un Indicateur',
	'UI:DashletGroupBy:MissingGroupBy' => 'Veuillez sélectionner le champ sur lequel les objets seront groupés',
	'UI:DashletGroupBy:Order:asc' => 'Croissant',
	'UI:DashletGroupBy:Order:desc' => 'Décroissant',
	'UI:DashletGroupBy:Prop-Function' => 'Fonction d\'agrégation',
	'UI:DashletGroupBy:Prop-FunctionAttribute' => 'Attribut',
	'UI:DashletGroupBy:Prop-GroupBy' => 'Grouper par',
	'UI:DashletGroupBy:Prop-GroupBy:DayOfMonth' => 'Jour du mois pour %1$s',
	'UI:DashletGroupBy:Prop-GroupBy:DayOfWeek' => 'Jour de la semaine pour %1$s',
	'UI:DashletGroupBy:Prop-GroupBy:Hour' => 'Heure de %1$s (0-23)',
	'UI:DashletGroupBy:Prop-GroupBy:Month' => 'Mois de %1$s (1 - 12)',
	'UI:DashletGroupBy:Prop-GroupBy:Select-DayOfMonth' => '%1$s (jour du mois)',
	'UI:DashletGroupBy:Prop-GroupBy:Select-DayOfWeek' => '%1$s (jour de la semaine)',
	'UI:DashletGroupBy:Prop-GroupBy:Select-Hour' => '%1$s (heure)',
	'UI:DashletGroupBy:Prop-GroupBy:Select-Month' => '%1$s (mois)',
	'UI:DashletGroupBy:Prop-Limit' => 'Limite',
	'UI:DashletGroupBy:Prop-OrderDirection' => 'Type de tri',
	'UI:DashletGroupBy:Prop-OrderField' => 'Trié par',
	'UI:DashletGroupBy:Prop-Query' => 'Requête OQL',
	'UI:DashletGroupBy:Prop-Style' => 'Style',
	'UI:DashletGroupBy:Prop-Title' => 'Titre',
	'UI:DashletGroupByBars:Description' => 'Graphique en Barres',
	'UI:DashletGroupByBars:Label' => 'Barres',
	'UI:DashletGroupByPie:Description' => 'Graphique à secteur',
	'UI:DashletGroupByPie:Label' => 'Secteurs',
	'UI:DashletGroupByTable:Description' => 'Table',
	'UI:DashletGroupByTable:Label' => 'Table',
	'UI:DashletHeaderDynamic:Description' => 'En-tête avec statistiques (regroupements)',
	'UI:DashletHeaderDynamic:Label' => 'En-tête dynamique',
	'UI:DashletHeaderDynamic:Prop-GroupBy' => 'Grouper par',
	'UI:DashletHeaderDynamic:Prop-Icon' => 'Icône',
	'UI:DashletHeaderDynamic:Prop-Query' => 'Requête OQL',
	'UI:DashletHeaderDynamic:Prop-Subtitle' => 'Sous-titre',
	'UI:DashletHeaderDynamic:Prop-Subtitle:Default' => 'Contacts',
	'UI:DashletHeaderDynamic:Prop-Title' => 'Titre',
	'UI:DashletHeaderDynamic:Prop-Title:Default' => 'Contacts',
	'UI:DashletHeaderDynamic:Prop-Values' => 'Valeurs',
	'UI:DashletHeaderStatic:Description' => 'En-tête présenté comme une barre horizontale',
	'UI:DashletHeaderStatic:Label' => 'En-tête',
	'UI:DashletHeaderStatic:Prop-Icon' => 'Icône',
	'UI:DashletHeaderStatic:Prop-Title' => 'Titre',
	'UI:DashletHeaderStatic:Prop-Title:Default' => 'Contacts',
	'UI:DashletObjectList:Description' => 'Liste d\'objets',
	'UI:DashletObjectList:Label' => 'Liste d\'objets',
	'UI:DashletObjectList:Prop-Menu' => 'Menu',
	'UI:DashletObjectList:Prop-Query' => 'Requête OQL',
	'UI:DashletObjectList:Prop-Title' => 'Titre',
	'UI:DashletPlainText:Description' => 'Text pur (pas de mise en forme)',
	'UI:DashletPlainText:Label' => 'Texte',
	'UI:DashletPlainText:Prop-Text' => 'Texte',
	'UI:DashletPlainText:Prop-Text:Default' => 'Veuillez saisir votre texte ici...',
	'UI:DashletProxy:Description' => 'Proxy',
	'UI:DashletProxy:Label' => 'Proxy',
	'UI:DashletProxy:Prop-XMLConfiguration' => 'Configuration (XML)',
	'UI:DashletProxy:RenderNoDataText:Edit' => 'Impossible d\'effectuer le rendu de cet élément externe (classe "%1$s").',
	'UI:DashletUnknown:Description' => 'Element inconnu (est peut-être désinstallé)',
	'UI:DashletUnknown:Label' => 'Inconnu',
	'UI:DashletUnknown:Prop-XMLConfiguration' => 'Configuration (XML)',
	'UI:DashletUnknown:RenderNoDataText:Edit' => 'Impossible d\'effectuer le rendu de cet élément (classe "%1$s").',
	'UI:DashletUnknown:RenderText:Edit' => 'Impossible d\'effectuer le rendu de cet élément (classe "%1$s"). Vérifiez avec votre administrateur si il est toujours disponible.',
	'UI:DashletUnknown:RenderText:View' => 'Impossible d\'effectuer le rendu de cet élément.',
	'UI:DeadlineMissedBy_duration' => 'Passé de %1$s',
	'UI:Deadline_Days_Hours_Minutes' => '%1$dj %2$dh %3$dmin',
	'UI:Deadline_Hours_Minutes' => '%1$dh %2$dmin',
	'UI:Deadline_LessThan1Min' => '< 1 min',
	'UI:Deadline_Minutes' => '%1$d min',
	'UI:Delect:Confirm_Count_ObjectsOf_Class' => 'Confirmez que vous voulez bien supprimer les %1$d objets de type %2$s ci-dessous.',
	'UI:Delect:Confirm_Object' => 'Confirmez que vous voulez bien supprimer %1$s.',
	'UI:Delete:AutomaticResetOf_Fields' => 'mise à jour automatique des champ(s): %1$s',
	'UI:Delete:AutomaticallyDeleted' => 'supprimé automatiquement',
	'UI:Delete:CannotDeleteBecause' => 'Ne peut pas être supprimé: %1$s',
	'UI:Delete:CannotUpdateBecause_Issue' => 'Devrait être mis à jour automatiquement, mais: %1$s',
	'UI:Delete:CleaningUpRefencesTo_Object' => 'Suppression de toutes les références vers %1$s...',
	'UI:Delete:CleaningUpRefencesTo_Several_ObjectsOf_Class' => 'Suppression de toutes les références vers les %1$d objets de type %2$s...',
	'UI:Delete:ConfirmDeletionOf_Count_ObjectsOf_Class' => 'Suppression de %1$d objets de type %2$s',
	'UI:Delete:ConfirmDeletionOf_Name' => 'Suppression de %1$s',
	'UI:Delete:Consequence+' => 'Ce qui va être effectué',
	'UI:Delete:Count_Objects/LinksReferencingTheObjects' => '%1$d objets ou liens font référence à certain des objets à supprimer',
	'UI:Delete:Count_Objects/LinksReferencing_Object' => '%1$d objets ou liens font référence à %2$s',
	'UI:Delete:Deleted' => 'supprimé',
	'UI:Delete:Done+' => 'Ce qui a été effectué...',
	'UI:Delete:MustBeDeletedManually' => 'Doit être supprimé manuellement',
	'UI:Delete:MustBeDeletedManuallyButNotPossible' => 'Doit être supprimé manuellement, mais cela n\'est pas possible: %1$s',
	'UI:Delete:NotAllowedToDelete' => 'Vous n\'êtes pas autorisé à supprimer cet objet',
	'UI:Delete:NotAllowedToUpdate_Fields' => 'Vous n\'êtes pas autorisé à mettre à jour les champs suivants : %1$s',
	'UI:Delete:PleaseDoTheManualOperations' => 'Vous devez effectuer les opération manuelles listées ci-dessus avant de pourvoir supprimer cet objet.',
	'UI:Delete:ReferencesMustBeDeletedToEnsureIntegrity' => 'pour garantir l\'intégrité de la base de données, toutes les références doivent être supprimées.',
	'UI:Delete:ShouldBeDeletedAtomaticallyButNotPossible' => 'Devrait être supprimé automatiquement, mais cela n\'est pas possible: %1$s',
	'UI:Delete:SorryDeletionNotAllowed' => 'Désolé, vous n\'êtes pas autorisé à supprimer cette objet. Voir les explications détaillées ci-dessus.',
	'UI:Delete:WillAutomaticallyUpdate_Fields' => 'Va être mis à jour automatiquement (champs impactés : %1$s)',
	'UI:Delete:WillBeDeletedAutomatically' => 'Sera supprimé automatiquement',
	'UI:Delete:_Name_Class_Deleted' => ' %2$s %1$s supprimé.',
	'UI:Details+' => 'Détails',
	'UI:DetailsPageTitle' => ITOP_APPLICATION_SHORT.' - %2$s - Détails de %1$s',
	'UI:DisconnectedDlgMessage' => 'Vous êtes déconnecté(e). Vous devez vous identifier pour pouvoir continuer à utiliser l\'application.',
	'UI:DisconnectedDlgTitle' => 'Attention !',
	'UI:DisplayAll' => 'Tout afficher',
	'UI:DisplayThisMessageAtStartup' => 'Afficher ce message au démarrage',
	'UI:Display_X_ItemsPerPage_prefix' => 'Afficher',
	'UI:Display_X_ItemsPerPage_suffix' => 'éléments par page',
	'UI:Document:NoPreview' => 'L\'aperçu n\'est pas disponible pour ce type de documents',
	'UI:Document:OpenInNewWindow:Download' => 'Ouvrir dans un nouvelle fenêtre: %1$s, Télécharger: %2$s',
	'UI:Download-CSV' => 'Télécharger %1$s',
	'UI:DownloadDocument_' => 'Télécharger',
	'UI:DurationForm_Days_Hours_Minutes_Seconds' => '%1$s J %2$s H %3$s min %4$s s',
	'UI:Edit:SearchQuery' => 'Sélectionner une requête prédéfinie',
	'UI:Edit:TestQuery' => 'Tester la requête',
	'UI:ElementsDisplayed' => 'Filtrage',
	'UI:EmptyChangesLogTitle' => 'Aucune modification',
	'UI:Error:1ParametersMissing' => 'Erreur: Pour effectuer cette opération il manque le paramètre suivant: %1$s.',
	'UI:Error:2ParametersMissing' => 'Erreur: Pour effectuer cette opération il manque les paramètres suivants: %1$s and %2$s.',
	'UI:Error:3ParametersMissing' => 'Erreur: Pour effectuer cette opération il manque les paramètres suivants: %1$s, %2$s and %3$s.',
	'UI:Error:4ParametersMissing' => 'Erreur: Pour effectuer cette opération il manque les paramètres suivants: %1$s, %2$s, %3$s and %4$s.',
	'UI:Error:ActionNotAllowed' => 'Vous n\'êtes pas autorisé à effectuer cette action',
	'UI:Error:AnErrorOccuredWhileRunningTheQuery_Message' => 'Une erreur s\'est produite en exécutant la requête: %1$s',
	'UI:Error:BulkDeleteNotAllowedOn_Class' => 'Vous n\'êtes pas autorisé à faire une suppression massive sur les objets de type %1$s',
	'UI:Error:BulkModifyNotAllowedOn_Class' => 'Vous n\'êtes pas autorisé à faire une modification massive sur les objets de type %1$s',
	'UI:Error:CannotDeleteBecause' => 'Cet objet ne peut pas être effacé. Raison: %1$s',
	'UI:Error:CannotDeleteBecauseManualOpNeeded' => 'Des opération manuelles sont nécessaires avant de pouvoir effacer cet objet',
	'UI:Error:CannotDeleteBecauseOfDepencies' => 'Cet objet ne peut pas être supprimé, des opérations manuelles sont nécessaire avant sa suppression.',
	'UI:Error:CannotWriteToTmp_Dir' => 'Impossible d\'écrire le fichier temporaire sur disque. upload_tmp_dir = "%1$s".',
	'UI:Error:DeleteNotAllowedOn_Class' => 'Vous n\'êtes pas autorisé à supprimer des objets de type %1$s',
	'UI:Error:IncorrectLinkDefinition_LinkedClass_Class' => 'la définition du lien est incorrecte: la classe d\'objets à gérer: %1$s n\'est référencée par aucune clef externe de la classe %2$s',
	'UI:Error:IncorrectOQLQuery_Message' => 'Erreur: requête OQL incorrecte: %1$s',
	'UI:Error:InvalidDashboard' => 'Erreur: Le tableau de bord est invalide',
	'UI:Error:InvalidDashboardFile' => 'Erreur: Le fichier tableau de bord est invalide',
	'UI:Error:InvalidGroupByFields' => 'Liste des champs "group by" incorrecte: "%1$s".',
	'UI:Error:InvalidToken' => 'Erreur: l\'opération a déjà été effectuée (CSRF token not found)',
	'UI:Error:Invalid_Stimulus_On_Object_In_State' => '%2$s est actuellement dans l\'état "%3$s", l\'opération "%1$s" que vous avez demandée ne peut être appliquée.',
	'UI:Error:MaintenanceMode' => 'L\'application est en maintenance',
	'UI:Error:MaintenanceTitle' => 'Maintenance',
	'UI:Error:MandatoryTemplateParameter_group_by' => 'Le paramètre group_by est obligatoire. Vérifiez la définition du modèle.',
	'UI:Error:MandatoryTemplateParameter_object_id' => 'Le paramètre object_id est obligatoire quand link_attr est spécifié. Vérifiez la définition du modèle.',
	'UI:Error:MandatoryTemplateParameter_target_attr' => 'Le paramètre taarget_attr est obligatoire quand link_attr est spécifié. Vérifiez la définition du modèle.',
	'UI:Error:NoTmpDir' => 'Il n\'y a aucun répertoire temporaire de défini.',
	'UI:Error:NotEnoughRightsToDelete' => 'Cet objet ne peut pas être supprimé car l\'utilisateur courant n\'a pas les droits nécessaires.',
	'UI:Error:ObjectAlreadyCloned' => 'Erreur: l\'objet a déjà été dupliqué !',
	'UI:Error:ObjectAlreadyCreated' => 'Erreur: l\'objet a déjà été créé !',
	'UI:Error:ObjectAlreadyUpdated' => 'Erreur: l\'objet a déjà été mis à jour.',
	'UI:Error:ObjectCannotBeUpdated' => 'Erreur: l\'objet ne peut pas être mis à jour.',
	'UI:Error:Object_Class_Id_NotFound' => 'L\'objet: %1$s:%2$d est introuvable.',
	'UI:Error:ObjectsAlreadyDeleted' => 'Erreur: les objets ont déjà été supprimés !',
	'UI:Error:ReadNotAllowedOn_Class' => 'Vous n\'êtes pas autorisé à voir des objets de type %1$s',
	'UI:Error:SMTP:UnknownVendor' => 'Le provider SMTP OAuth 2.0 %1$s n\'existe pas',
	'UI:Error:SaveFailed' => 'L\'objet ne peut pas être sauvé : ',
	'UI:Error:UnsupportedStyleOfBlock' => 'Erreur: style de bloc("%1$s") inconnu.',
	'UI:Error:UploadFailedUnknownCause_Code' => 'Le téléchargement a échoué pour une raison inconnue. (Code d\'erreur = "%1$s").',
	'UI:Error:UploadStoppedByExtension_FileName' => 'Téléchargement arrêté à cause de l\'extension. (Nom du fichier original = "%1$s").',
	'UI:Error:UploadedFileTooBig' => 'Le fichier téléchargé est trop gros. (La taille maximale autorisée est %1$s). Pour modifier cette limite contactez votre administrateur '.ITOP_APPLICATION_SHORT.'. (Réglages upload_max_filesize et post_max_size dans la configuration PHP sur le serveur)',
	'UI:Error:UploadedFileTruncated.' => 'Le fichier téléchargé a été tronqué !',
	'UI:Error:WizardCircularReferenceInDependencies' => 'Erreur: Référence circulaire entre les dépendences entre champs, vérifiez le modèle de données.',
	'UI:ErrorPageTitle' => ITOP_APPLICATION_SHORT.' - Erreur',
	'UI:Error_Details' => 'Erreur: %1$s.',
	'UI:ExplainPrintable' => 'Cliquez sur les icones %1$s pour cacher des éléments lors de l\'impression.<br/>Utilisez la fonction "Aperçu avant impression" de votre navigateur pour prévisualiser avant d\'imprimer.<br/>Note: cet en-tête ainsi que les icones %1$s ne seront pas imprimés.',
	'UI:ExportDashBoard' => 'Exporter dans un fichier',
	'UI:ExtField_AsRemoteField' => '%1$s (%2$s)',
	'UI:ExtKey_AsFriendlyName' => '%1$s (Nom)',
	'UI:ExtKey_AsLink' => '%1$s (Lien)',
	'UI:FailedToApplyStimuli' => 'L\'action a échoué',
	'UI:FatalErrorMessage' => 'Erreur fatale, iTop ne peut pas continuer.',
	'UI:FavoriteLanguage' => 'Langue préférée',
	'UI:FavoriteOrganizations' => 'Organisations Favorites',
	'UI:FavoriteOrganizations+' => 'Cochez dans la liste ci-dessous les organisations que vous voulez voir listées dans le menu principal. Ceci n\'est pas un réglage de sécurité. Les objets de toutes les organisations sont toujours visibles en choisissant "Toutes les Organisations" dans le menu.',
	'UI:FavoriteOtherSettings' => 'Autres réglages',
	'UI:Favorites:Default_X_ItemsPerPage' => 'Longueur par défaut :  %1$s éléments par page',
	'UI:Favorites:SelectYourLanguage' => 'Choisissez votre langue préférée',
	'UI:Favorites:ShowObsoleteData' => 'Voir les données obsolètes',
	'UI:Favorites:ShowObsoleteData+' => 'Voir les données obsolètes dans les résultats de recherche et dans les listes de choix',
	'UI:FillAllMandatoryFields' => 'Veuillez remplir tous les champs obligatoires.',
	'UI:ForAllLists' => 'Défaut pour toutes les listes',
	'UI:Form:Property' => 'Propriété',
	'UI:Form:Value' => 'Valeur',
	'UI:FullTextSearchTitle_Text' => 'Résultats pour "%1$s" :',
	'UI:GroupBy:Count' => 'Nombre',
	'UI:GroupBy:Count+' => 'Nombre d\'éléments',
	'UI:GroupBy:avg' => 'Moyenne',
	'UI:GroupBy:avg+' => 'Moyenne des %1$s',
	'UI:GroupBy:count' => 'Nombre',
	'UI:GroupBy:count+' => 'Nombre d\'éléments',
	'UI:GroupBy:max' => 'Maximum',
	'UI:GroupBy:max+' => 'Maximum des %1$s',
	'UI:GroupBy:min' => 'Minimum',
	'UI:GroupBy:min+' => 'Minimum des %1$s',
	'UI:GroupBy:sum' => 'Somme',
	'UI:GroupBy:sum+' => 'Somme des %1$s',
	'UI:Help' => 'Aide',
	'UI:HierarchyOf_Class' => 'Hiérarchie de type %1$s',
	'UI:History:BulkImportDetails' => 'Changements résultant de l\'import CSV du %1$s (auteur: %2$s)',
	'UI:History:BulkImports' => 'Historique',
	'UI:History:BulkImports+' => 'Liste des imports CSV (le dernier est en haut de la liste)',
	'UI:History:Changes' => 'Changements',
	'UI:History:Changes+' => 'Changements sur cet objet',
	'UI:History:Date' => 'Date',
	'UI:History:Date+' => 'Date de modification',
	'UI:History:LastModified_On_By' => 'Dernière modification par %2$s le %1$s.',
	'UI:History:StatsCreations' => 'Créés',
	'UI:History:StatsCreations+' => 'Nombre d\'objets créés',
	'UI:History:StatsDeletes' => 'Effacés',
	'UI:History:StatsDeletes+' => 'Nombre d\'objets effacés',
	'UI:History:StatsModifs' => 'Modifiés',
	'UI:History:StatsModifs+' => 'Nombre d\'objets modifiés',
	'UI:History:User' => 'Utilisateur',
	'UI:History:User+' => 'Utilisateur qui a fait la modification',
	'UI:HistoryTab' => 'Historique',
	'UI:ImportDashBoard' => 'Importer depuis un fichier...',
	'UI:ImportDashboardText' => 'Choisissez un fichier de définition de tableau de bord :',
	'UI:ImportDashboardTitle' => 'Importation depuis un fichier',
	'UI:IncidentMgmtMenuOverview:Title' => 'Tableau de bord de la Gestion des Incidents',
	'UI:InputFile:NoFileSelected' => 'Aucun fichier sélectionné',
	'UI:InputFile:SelectFile' => 'Sélectionner un fichier',
	'UI:Label:AvailableObjects' => 'Objets disponibles: ',
	'UI:Label:SelectedObjects' => 'Objets sélectionnés: ',
	'UI:Link_Class_Attributes' => 'Attributs du type %1$s',
	'UI:LinksWidget:Autocomplete+' => 'Tapez les 3 premiers caractères...',
	'UI:ListConfigurationTitle' => 'Configuration de la liste',
	'UI:Loading' => 'Chargement...',
	'UI:LogOff:ClickHereToLoginAgain' => 'Cliquez ici pour vous reconnecter...',
	'UI:LogOff:ThankYou' => 'Merci d\'avoir utilisé '.ITOP_APPLICATION_SHORT,
	'UI:LogOffMenu' => 'Déconnexion',
	'UI:LoggedAsMessage' => 'Connecté(e) comme: %1$s (%2$s)',
	'UI:LoggedAsMessage+Admin' => 'Connecté(e) comme: %1$s (%2$s, Administrateur)',
	'UI:Login:About' => ITOP_APPLICATION.' Powered by Combodo~~',
	'UI:Login:ChangeYourPassword' => 'Changer de mot de passe',
	'UI:Login:Error:AccessAdmin' => 'Accès restreint aux utilisateurs possédant le profil Administrateur.',
	'UI:Login:Error:AccessRestricted' => 'L\'accès à cette page '.ITOP_APPLICATION_SHORT.' est soumis à autorisation. Merci de contacter votre administrateur '.ITOP_APPLICATION_SHORT.'.',
	'UI:Login:Error:MultipleContactsHaveSameEmail' => 'Email partagé par plusieurs contacts',
	'UI:Login:Error:NoValidProfiles' => 'Pas de profil valide',
	'UI:Login:Error:WrongOrganizationName' => 'Organisation inconnue',
	'UI:Login:ForgotPwd' => 'Mot de passe oublié ?',
	'UI:Login:ForgotPwdForm' => 'Mot de passe oublié',
	'UI:Login:ForgotPwdForm+' => 'Vous pouvez demander à saisir un nouveau mot de passe. Vous allez recevoir un email et vous pourrez suivre les instructions.',
	'UI:Login:IdentifyYourself' => 'Merci de vous identifier',
	'UI:Login:IncorrectLoginPassword' => 'Mot de passe ou identifiant incorrect.',
	'UI:Login:IncorrectOldPassword' => 'Erreur: l\'ancien mot de passe est incorrect',
	'UI:Login:NewPasswordPrompt' => 'Nouveau mot de passe',
	'UI:Login:OldPasswordPrompt' => 'Ancien mot de passe',
	'UI:Login:PasswordChanged' => 'Mot de passe mis à jour !',
	'UI:Login:PasswordNotChanged' => 'Erreur : le mot de passe est identique !',
	'UI:Login:PasswordPrompt' => 'Mot de passe',
	'UI:Login:ResetPassword' => 'Envoyer le message',
	'UI:Login:ResetPwdFailed' => 'Impossible de vous faire parvenir le message: %1$s',
	'UI:Login:RetypeNewPasswordPrompt' => 'Resaisir le nouveau mot de passe',
	'UI:Login:RetypePwdDoesNotMatch' => 'Les deux saisies du nouveau mot de passe ne sont pas identiques !',
	'UI:Login:SeparatorOr' => 'Ou',
	'UI:Login:Title' => ITOP_APPLICATION_SHORT.' login',
	'UI:Login:UserNamePrompt' => 'Identifiant',
	'UI:Login:Welcome' => 'Bienvenue dans '.ITOP_APPLICATION_SHORT.'!',
	'UI:LoginAgain' => 'S\'identifier',
	'UI:ManageObjectsOf_Class_LinkedWith_Class_Instance' => 'Gérer les objets de type %1$s liés à %3$s (%2$s)',
	'UI:Menu:Actions' => 'Actions',
	'UI:Menu:Add' => 'Ajouter...',
	'UI:Menu:AddToDashboard' => 'Ajouter au Tableau de Bord...',
	'UI:Menu:BulkDelete' => 'Supprimer...',
	'UI:Menu:BulkDelete_Class' => 'Supprimer ces %1$s...',
	'UI:Menu:BulkDelete_Link' => 'Supprimer ces %1$s...',
	'UI:Menu:BulkDelete_Remote' => 'Supprimer ces %1$s...',
	'UI:Menu:CSVExport' => 'Exporter en CSV...',
	'UI:Menu:Delete' => 'Supprimer...',
	'UI:Menu:EMail' => 'Envoyer par eMail',
	'UI:Menu:ExportPDF' => 'Exporter en PDF...',
	'UI:Menu:FilterList' => 'Afficher la liste et ses critères de recherche',
	'UI:Menu:KillConcurrentLock' => 'Supprimer le verrouillage !',
	'UI:Menu:Manage' => 'Gérer...',
	'UI:Menu:Modify' => 'Modifier...',
	'UI:Menu:ModifyAll' => 'Modifier...',
	'UI:Menu:ModifyAll_Class' => 'Modifier ces %1$s...',
	'UI:Menu:ModifyAll_Link' => 'Modifier ces %1$s...',
	'UI:Menu:ModifyAll_Remote' => 'Modifier ces %1$s...',
	'UI:Menu:New' => 'Créer...',
	'UI:Menu:OtherActions' => 'Autres actions',
	'UI:Menu:OtherTransitions' => 'Autres transitions',
	'UI:Menu:PrintableVersion' => 'Version imprimable',
	'UI:Menu:ShortcutList' => 'Créer un Raccourci...',
	'UI:Menu:Transitions' => 'Transitions',
	'UI:Menu:View' => 'Voir cet objet',
	'UI:Message:EmptyList:UseAdd' => 'La liste est vide, utilisez le bouton "Ajouter..." pour ajouter des objets.',
	'UI:Message:EmptyList:UseSearchForm' => 'Utilisez le formulaire de recherche ci-dessus pour trouver les objets à ajouter.',
	'UI:ModificationPageTitle_Object_Class' => ITOP_APPLICATION_SHORT.' - %2$s - Modification de %1$s',
	'UI:ModificationTitle_Class_Object' => '%1$s - Modification de <span class="hilite">%2$s</span>',
	'UI:ModifiedObject' => 'Objet Modifié',
	'UI:ModifyAllPageTitle' => 'Modification par lots',
	'UI:Modify_M_ObjectsOf_Class_OutOf_N' => 'Modification de %1$d (sur %3$d) objets de type %2$s',
	'UI:Modify_N_ObjectsOf_Class' => 'Modification de %1$d objet(s) de type %2$s',
	'UI:Modify_ObjectsOf_Class' => 'Modification d\'objet(s) de type %1$s',
	'UI:NavigateAwayConfirmationMessage' => 'Toute modification sera perdue.',
	'UI:Newsroom:ConfigurationLink' => 'Configuration',
	'UI:Newsroom:DisplayAtMost_X_Messages' => 'Afficher au plus %1$s messages dans le menu %2$s.',
	'UI:Newsroom:DisplayMessagesFor_Provider' => 'Afficher les messages de %1$s',
	'UI:Newsroom:MarkAllAsRead' => 'Marquer tous les messages comme lus',
	'UI:Newsroom:NoNewMessage' => 'Aucun nouveau message',
	'UI:Newsroom:Preferences' => 'Préférences du centre d\'information',
	'UI:Newsroom:Priority:1:Tooltip' => 'Critique',
	'UI:Newsroom:Priority:2:Tooltip' => 'Urgent',
	'UI:Newsroom:Priority:3:Tooltip' => 'Important',
	'UI:Newsroom:Priority:4:Tooltip' => 'Standard',
	'UI:Newsroom:ResetCache' => 'Ràz du cache',
	'UI:Newsroom:ResetCache:Success:Message' => 'Le cache de la newsroom a été réinitialisé avec succès',
	'UI:Newsroom:ViewAllMessages' => 'Voir tous les messages',
	'UI:Newsroom:XNewMessage' => '%1$s new message(s)~~',
	'UI:NoInlineImage' => 'Il n\'y a aucune image de disponible sur le serveur. Utilisez le bouton "Parcourir" (ci-dessus) pour sélectionner une image sur votre ordinateur et la télécharger sur le serveur.',
	'UI:NoObjectToDisplay' => 'Aucun objet à afficher.',
	'UI:NoObject_Class_ToDisplay' => 'Aucun objet %1$s à afficher',
	'UI:NotificationsMenu:Actions' => 'Actions',
	'UI:NotificationsMenu:Actions:Action' => 'Autres types d\'actions',
	'UI:NotificationsMenu:Actions:ActionEmail' => 'Actions de type mél',
	'UI:NotificationsMenu:Actions:ActionWebhook' => 'Actions de type webhook (intégrations sortantes)',
	'UI:NotificationsMenu:AvailableActions' => 'Actions existantes',
	'UI:NotificationsMenu:AvailableTriggers' => 'Déclencheurs existants',
	'UI:NotificationsMenu:Help' => 'Aide',
	'UI:NotificationsMenu:HelpContent' => '<p>Dans '.ITOP_APPLICATION_SHORT.' les notifications sont totalement configurables. Elles sont basées sur deux types d\'objets: <i>déclencheurs et actions</i>.</p>
<p><i><b>Les déclencheurs</b></i> définissent quand une notification sera exécutée. Il y a différents déclencheurs qui font partie du noyau d\'iTop, mais d\'autres peuvent être apportés par des extensions :
<ol>
	<li>Certains déclencheurs sont exécutés lorsqu\'un objet de la classe spécifiée est <b>créé</b>, <b>mis à jour</b> ou <b>supprimé</b>.</li>
	<li>Certains déclencheurs sont exécutés lorsqu\'un objet d\'une classe donnée <b>entre</b> ou <b>sort</b> d\'un <b>état</b> spécifié.</li>
	<li>Certains déclencheurs sont exécutés lorsqu\'un <b>seuil</b> sur <b>TTO</b> ou <b>TTR</b> a été <b>atteint</b>.</li>
</ol>
</p>
<p>
<i><b>Les actions</b></i> définissent ce qui doit être exécuté. Pour le moment il existe deux types d\'actions :
<ol>
    <li>L\'envoi de mél : Les actions de type mél définissent le modèle du message ainsi que les autres paramètres (destinataires, importance, etc.).<br />
    Une page spéciale : <a href="../setup/email.test.php" target="_blank">email.test.php</a> permet de tester votre configuration mail PHP.</li>
	<li>L\'envoi de message newsroom : Les actions de type newsroom permettent d\'afficher une news à l\'utilisateur directement dans l\'application à travers la newsroom (icône de cloche dans le menu de gauche)</li>
    <li>Les webhooks sortants : Les actions de type webhooks permettent l\'intégration avec une application tierce en transmettant des données structurées à une URL définie.</li>
</ol>
</p>
<p>Les actions doivent être associées à des déclencheurs pour pouvoir être exécutées.
Lors de l\'association à un déclencheur, on attribue à chaque action un numéro d\'ordre, qui définit la séquence des actions à exécuter.</p>',
	'UI:NotificationsMenu:OnCreate' => 'A la création d\'un objet',
	'UI:NotificationsMenu:OnStateEnter' => 'Quand un objet entre dans un état donné',
	'UI:NotificationsMenu:OnStateLeave' => 'Quand un objet quitte un état donné',
	'UI:NotificationsMenu:Title' => 'Configuration des notifications',
	'UI:NotificationsMenu:Triggers' => 'Déclencheurs',
	'UI:NotificationsTab' => 'Notifications',
	'UI:OQL:UnknownClassAndFix' => 'La classe "%1$s" est inconnue. Essayez plutôt "%2$s".',
	'UI:OQL:UnknownClassNoFix' => 'La classe "%1$s" est inconnue',
	'UI:OQLQueryBuilderTitle' => 'Constructeur de requêtes OQL',
	'UI:OQLQueryTab' => 'Requête OQL',
	'UI:ObjectArchived' => 'Cet objet a été archivé. Veuillez activer le mode Archive, ou contactez votre administrateur.',
	'UI:ObjectCouldNotBeWritten' => 'L\'objet ne peut pas être enregistré: %1$s',
	'UI:ObjectDoesNotExist' => 'Désolé cet objet n\'existe pas (ou vous n\'êtes pas autorisé à l\'afficher).',
	'UI:ObjectShortcutInsert' => 'Insérer un raccourcis vers un objet',
	'UI:OnlyForThisList' => 'Seulement pour cette liste',
	'UI:OpenDocumentInNewWindow_' => 'Ouvrir',
	'UI:OperationCancelled' => 'Opération Annulée',
	'UI:OrderByHint_Values' => 'Ordre de tri: %1$s',
	'UI:PageFormat_A3' => 'A3',
	'UI:PageFormat_A4' => 'A4',
	'UI:PageFormat_Letter' => 'Letter',
	'UI:PageOrientation_Landscape' => 'Paysage',
	'UI:PageOrientation_Portrait' => 'Portrait',
	'UI:PageTitle:FatalError' => ITOP_APPLICATION_SHORT.' - Erreur Fatale',
	'UI:PageTitle:ObjectCreated' => ITOP_APPLICATION_SHORT.' objet créé.',
	'UI:PageTitle:ProfileProjections' => ITOP_APPLICATION_SHORT.' gestion des utilisateurs - projections des profils',
	'UI:Pagination:All' => 'Tous',
	'UI:Pagination:HeaderNoSelection' => 'Total: %1$s éléments.',
	'UI:Pagination:HeaderSelection' => 'Total: %1$s éléments / %2$s éléments sélectionné(s).',
	'UI:Pagination:PageSize' => '%1$s éléments par page',
	'UI:Pagination:PagesLabel' => 'Pages:',
	'UI:PasswordConfirm' => 'Confirmer',
	'UI:Preferences' => 'Préférences...',
	'UI:PrintResolution:A4Landscape' => 'A4 Paysage',
	'UI:PrintResolution:A4Portrait' => 'A4 Portrait',
	'UI:PrintResolution:FullSize' => 'Pleine largeur',
	'UI:PrintResolution:LetterLandscape' => 'US Letter Paysage',
	'UI:PrintResolution:LetterPortrait' => 'US Letter Portrait',
	'UI:PropertiesTab' => 'Propriétés',
	'UI:Query:UrlForExcel' => 'Lien à copier-coller dans Excel, pour déclarer une source de données à partir du web',
	'UI:Query:UrlV1' => 'La liste des champs à exporter n\'a pas été spécifiée. La page <em>export-V2.php</em> ne peut pas fonctionner sans cette information. Par conséquent, le lien fourni ci-dessous pointe sur l\'ancienne page: <em>export.php</em>. Cette ancienne version de l\'export présente la limitation suivante : la liste des champs exportés varie en fonction du format de l\'export et du modèle de données. <br/>Si vous devez garantir la stabilité du format de l\'export (liste des colonnes) sur le long terme, alors vous devrez renseigner l\'attribut "Champs" et utiliser la page <em>export-V2.php</em>.',
	'UI:Relation:AdditionalContextInfo' => 'Infos complémentaires de contexte',
	'UI:Relation:AttachmentExportOptions_Name' => 'Options pour la Pièce Jointe à %1$s',
	'UI:Relation:Comments' => 'Commentaires',
	'UI:Relation:DrillDown' => 'Détails...',
	'UI:Relation:ExportAsAttachment' => 'Exporter comme une Pièce Jointe...',
	'UI:Relation:ExportAsPDF' => 'Exporter en PDF...',
	'UI:Relation:Key' => 'Légende',
	'UI:Relation:NoneSelected' => 'Aucune',
	'UI:Relation:PDFExportOptions' => 'Options de l\'export en PDF',
	'UI:Relation:PDFExportPageFormat' => 'Format de page',
	'UI:Relation:PDFExportPageOrientation' => 'Orientation de la page',
	'UI:Relation:Zoom' => 'Zoom',
	'UI:RelationGroupNumber_N' => 'Groupe n°%1$d',
	'UI:RelationGroups' => 'Groupes',
	'UI:RelationOption:Comments' => 'Commentaires',
	'UI:RelationOption:GroupingThreshold' => 'Seuil de groupage',
	'UI:RelationOption:IncludeList' => 'Inclure la liste des objets',
	'UI:RelationOption:Title' => 'Titre',
	'UI:RelationOption:Untitled' => 'Sans Titre',
	'UI:RelationTooltip:CriticalThreshold_N_of_M' => 'Seuil critique: %1$d / %2$d',
	'UI:RelationTooltip:ImpactedItems_N_of_M' => 'Nb éléments impactés: %1$d / %2$d',
	'UI:RelationTooltip:Redundancy' => 'Redondance',
	'UI:RelationshipGraph' => 'Vue graphique',
	'UI:RelationshipList' => 'Liste',
	'UI:RemoveLinkedObjectsOf_Class' => 'Enlever les objets sélectionnés',
	'UI:RequestMgmtMenuOverview:Title' => 'Tableau de bord de la Gestion des Demandes Utilisateurs',
	'UI:ResetPwd-EmailBody' => '<body><p>Vous avez demandé à changer votre mot de passe '.ITOP_APPLICATION_SHORT.' sans connaître le mot de passe précédent.</p><p>Veuillez suivre le lien suivant (usage unique) afin de pouvoir <a href="%1$s">saisir un nouveau mot de passe</a></p>.',
	'UI:ResetPwd-EmailSent' => 'Veuillez vérifier votre boîte de réception. Ensuite, suivez les instructions données dans l\'email. Si vous ne recevez pas d\'email, merci de vérifier le login saisi',
	'UI:ResetPwd-EmailSubject' => 'Changer votre mot de passe '.ITOP_APPLICATION_SHORT,
	'UI:ResetPwd-Error-EnterPassword' => 'Veuillez saisir le nouveau mot de passe pour \'%1$s\'.',
	'UI:ResetPwd-Error-FixedPwd' => 'ce mode de saisie du mot de passe n\'est pas autorisé pour ce compte.',
	'UI:ResetPwd-Error-InvalidToken' => 'Désolé, le mot de passe a déjà été modifié avec le lien que vous avez suivi, ou bien vous avez reçu plusieurs emails. Dans ce cas, veillez à utiliser le tout dernier lien reçu.',
	'UI:ResetPwd-Error-NoContact' => 'le comte n\'est pas associé à une Personne.',
	'UI:ResetPwd-Error-NoEmail' => 'il manque une adresse email sur la Personne associée à ce compte. Veuillez contacter l\'administrateur de l\'application.',
	'UI:ResetPwd-Error-NoEmailAtt' => 'il manque un attribut de type "email" sur la Personne associée à ce compte. Veuillez contacter l\'administrateur de l\'application.',
	'UI:ResetPwd-Error-NotPossible' => 'les comptes "externes" ne permettent pas la saisie d\'un mot de passe dans '.ITOP_APPLICATION_SHORT.'.',
	'UI:ResetPwd-Error-Send' => 'erreur technique lors de l\'envoi de l\'email. Veuillez contacter l\'administrateur de l\'application.',
	'UI:ResetPwd-Error-WrongLogin' => 'le compte \'%1$s\' est inconnu.',
	'UI:ResetPwd-Login' => 'Cliquez ici pour vous connecter...',
	'UI:ResetPwd-Ready' => 'Le mot de passe a bien été changé.',
	'UI:ResetPwd-Title' => 'Nouveau mot de passe',
	'UI:RunQuery:DevelopedOQL' => 'OQL développé',
	'UI:RunQuery:DevelopedOQLCount' => 'OQL développé pour le compte',
	'UI:RunQuery:DevelopedQuery' => 'Requête OQL décompilée : ',
	'UI:RunQuery:Error' => 'Une erreur s\'est produite durant l\'exécution de la requête',
	'UI:RunQuery:ExpressionToEvaluate' => 'Requête à exécuter : ',
	'UI:RunQuery:HeaderOQLExpression' => 'Requête OQL',
	'UI:RunQuery:HeaderOQLExpression+' => 'La requête en OQL',
	'UI:RunQuery:HeaderPurpose' => 'Objectif',
	'UI:RunQuery:HeaderPurpose+' => 'But de la requête',
	'UI:RunQuery:MoreInfo' => 'Plus d\'information sur la requête : ',
	'UI:RunQuery:QueryArguments' => 'Arguments de la requête',
	'UI:RunQuery:QueryExamples' => 'Exemples de requêtes',
	'UI:RunQuery:QueryResults' => 'Résultats de la requête',
	'UI:RunQuery:ResultSQL' => 'SQL généré',
	'UI:RunQuery:ResultSQLCount' => 'SQL généré pour le compte',
	'UI:RunQuery:SerializedFilter' => 'Version sérialisée : ',
	'UI:RunQuery:Title' => ITOP_APPLICATION_SHORT.' - Evaluation de requêtes OQL',
	'UI:Schema:AbstractClass' => 'Classe abstraite : les objets de cette classe ne peuvent pas être instanciés.',
	'UI:Schema:AllClasses' => 'Toutes les classes',
	'UI:Schema:AllowedValues' => 'Valeurs possibles',
	'UI:Schema:AllowedValues+' => 'Restrictions des valeurs possibles pour cet attribut',
	'UI:Schema:Attribute/Filter' => 'Filtre',
	'UI:Schema:AttributeCode' => 'Code',
	'UI:Schema:AttributeCode+' => 'Code interne de l\'attribut',
	'UI:Schema:Attributes' => 'Attributs',
	'UI:Schema:AvailOperators' => 'Opérateurs',
	'UI:Schema:AvailOperators+' => 'Opérateurs possibles pour ce critère de recherche',
	'UI:Schema:CategoryMenuItem' => 'Catégorie <b>%1$s</b>',
	'UI:Schema:ChildClasses' => 'Classes dérivées',
	'UI:Schema:ClassFilter' => 'Classe :',
	'UI:Schema:ClassHierarchyTitle' => 'Hiérachie des classes',
	'UI:Schema:Class_IsLinkedTo_Class_Via_ClassAndAttribute' => '%1$s est lié à la classe %2$s via %3$s::<em>%4$s</em>',
	'UI:Schema:Class_ReferencingClasses_From_By' => '%1$s est référencé par la classe %2$s via le champ %3$s',
	'UI:Schema:Columns_Description' => 'Colonnes : <em>%1$s</em>',
	'UI:Schema:DefaultNullValue' => 'Valeur null par défaut : "%1$s"',
	'UI:Schema:Default_Description' => 'Valeur par défaut: "%1$s"',
	'UI:Schema:Description' => 'Description',
	'UI:Schema:Description+' => 'Description de l\'attribut',
	'UI:Schema:DisplayLabel' => 'Affichage :',
	'UI:Schema:DisplaySelector/Code' => 'Code',
	'UI:Schema:DisplaySelector/Label' => 'Label',
	'UI:Schema:DisplaySelector/LabelAndCode' => 'Label et code',
	'UI:Schema:Events' => 'Événements',
	'UI:Schema:Events:Defined' => 'Événements',
	'UI:Schema:Events:Description' => 'Description',
	'UI:Schema:Events:Event' => 'Événement',
	'UI:Schema:Events:Listener' => 'Récepteur',
	'UI:Schema:Events:Listeners' => 'Récepteurs d\'événements',
	'UI:Schema:Events:Module' => 'Module',
	'UI:Schema:Events:NoEvent' => 'Aucun événement défini',
	'UI:Schema:Events:NoListener' => 'Aucun récepteur d\'événements',
	'UI:Schema:Events:Rank' => 'Rang',
	'UI:Schema:ExternalKey_To' => 'Clef externe vers %1$s',
	'UI:Schema:FilterCode' => 'Code',
	'UI:Schema:FilterCode+' => 'Code de ce critère de recherche',
	'UI:Schema:FilterDescription' => 'Description',
	'UI:Schema:FilterDescription+' => 'Description de ce critère de recherche',
	'UI:Schema:Label' => 'Label',
	'UI:Schema:Label+' => 'Label de l\'attribut',
	'UI:Schema:LifeCycle' => 'Cycle de vie',
	'UI:Schema:LifeCycleAttributeMustChange' => 'Doit changer',
	'UI:Schema:LifeCycleAttributeMustPrompt' => 'L\'utilisateur se verra proposer de changer la valeur',
	'UI:Schema:LifeCycleEmptyList' => 'liste vide',
	'UI:Schema:LifeCycleHiddenAttribute' => 'Caché',
	'UI:Schema:LifeCycleMandatoryAttribute' => 'Obligatoire',
	'UI:Schema:LifeCycleReadOnlyAttribute' => 'Lecture seule',
	'UI:Schema:LifeCycleTransitions' => 'États et Transitions',
	'UI:Schema:LifeCyleAttributeOptions' => 'Options des attributs',
	'UI:Schema:Links:1-n' => 'Classes pointant sur %1$s (liens 1:n) :',
	'UI:Schema:Links:All' => 'Graphe de toutes les classes liées',
	'UI:Schema:Links:n-n' => 'Classes liées à %1$s (liens n:n) :',
	'UI:Schema:MoreInfo' => 'Plus info',
	'UI:Schema:MoreInfo+' => 'Plus d\'information à propos de la définition de ce champ dans la base de données',
	'UI:Schema:NoLifeCyle' => 'Aucun cycle de vie n\'est défini pour cette classe.',
	'UI:Schema:NonAbstractClass' => 'Classe concrète : les objets de cette classe peuvent être instanciés.',
	'UI:Schema:NullAllowed' => 'Null autorisé',
	'UI:Schema:NullNotAllowed' => 'Null interdit',
	'UI:Schema:Origin' => 'Origine',
	'UI:Schema:Origin+' => 'La classe de base dans laquelle l\'attribut est défini',
	'UI:Schema:ReferencingClasses' => 'Classes faisant référence',
	'UI:Schema:RelatedClasses' => 'Classes reliées',
	'UI:Schema:RelationDoesNotPropagate' => '%1$s: ne se propage pas (%2$d niveaux), requête: %3$s',
	'UI:Schema:RelationDown_Description' => 'Sens descendant: %1$s',
	'UI:Schema:RelationPropagates' => '%1$s: se propage sur %2$d niveau(x), requête: %3$s',
	'UI:Schema:RelationUp_Description' => 'Sens montant: %1$s',
	'UI:Schema:Relation_Code_Description' => 'Relation <em>%1$s</em> (%2$s)',
	'UI:Schema:Relationships' => 'Relations',
	'UI:Schema:SearchCriteria' => 'Critères de recherche',
	'UI:Schema:Title' => 'Modèle de données '.ITOP_APPLICATION_SHORT,
	'UI:Schema:TitleForClass' => 'Modèle de données de %1$s',
	'UI:Schema:Triggers' => 'Déclencheurs',
	'UI:Schema:Type' => 'Type',
	'UI:Schema:Type+' => 'Type de données de l\'attribut',
	'UI:Search:AddCriteria:List:MostPopular:Title' => 'Populaires',
	'UI:Search:AddCriteria:List:Others:Title' => 'Autres',
	'UI:Search:AddCriteria:List:RecentlyUsed:Placeholder' => 'Aucun.',
	'UI:Search:AddCriteria:List:RecentlyUsed:Title' => 'Récents',
	'UI:Search:AutoSubmit:DisabledHint' => 'La soumission automatique a été desactivée pour cette classe',
	'UI:Search:Count_ObjectsOf_Class_Found' => 'Trouvé %1$d objet(s) de type %2$s.',
	'UI:Search:Criteria:DateTime:From' => 'Depuis',
	'UI:Search:Criteria:DateTime:FromTime' => 'Depuis',
	'UI:Search:Criteria:DateTime:PlaceholderFrom' => 'Indifférent',
	'UI:Search:Criteria:DateTime:PlaceholderFromTime' => 'Indifférent',
	'UI:Search:Criteria:DateTime:PlaceholderUntil' => 'Indifférent',
	'UI:Search:Criteria:DateTime:PlaceholderUntilTime' => 'Indifférent',
	'UI:Search:Criteria:DateTime:Until' => 'jusqu\'à',
	'UI:Search:Criteria:DateTime:UntilTime' => 'jusqu\'à',
	'UI:Search:Criteria:HierarchicalKey:ChildrenIncluded:Hint' => 'Children of the selected objects will be included.~~',
	'UI:Search:Criteria:Locked' => 'Verrouillé',
	'UI:Search:Criteria:Numeric:From' => 'De',
	'UI:Search:Criteria:Numeric:PlaceholderFrom' => 'Indifférent',
	'UI:Search:Criteria:Numeric:PlaceholderUntil' => 'Indifférent',
	'UI:Search:Criteria:Numeric:Until' => 'à',
	'UI:Search:Criteria:Operator:Default:Between' => 'Compris entre',
	'UI:Search:Criteria:Operator:Default:Empty' => 'Vide',
	'UI:Search:Criteria:Operator:Default:Equals' => 'Egal',
	'UI:Search:Criteria:Operator:Default:NotEmpty' => 'Non vide',
	'UI:Search:Criteria:Operator:Numeric:Different' => 'Différent',
	'UI:Search:Criteria:Operator:Numeric:Equals' => 'Egal',
	'UI:Search:Criteria:Operator:Numeric:GreaterThan' => 'Supérieur',
	'UI:Search:Criteria:Operator:Numeric:GreaterThanOrEquals' => 'Sup. / égal',
	'UI:Search:Criteria:Operator:Numeric:LessThan' => 'Inférieur',
	'UI:Search:Criteria:Operator:Numeric:LessThanOrEquals' => 'Inf. / égal',
	'UI:Search:Criteria:Operator:String:Contains' => 'Contient',
	'UI:Search:Criteria:Operator:String:EndsWith' => 'Fini par',
	'UI:Search:Criteria:Operator:String:RegExp' => 'Exp. rég.',
	'UI:Search:Criteria:Operator:String:StartsWith' => 'Commence par',
	'UI:Search:Criteria:Operator:TagSet:Matches' => 'Contient',
	'UI:Search:Criteria:Raw:Filtered' => 'Filtré',
	'UI:Search:Criteria:Raw:FilteredOn' => 'Filtré sur %1$s',
	'UI:Search:Criteria:Remove' => 'Retirer',
	'UI:Search:Criteria:Title:DateTime:Between' => '%2$s <= 1$s <= %3$s',
	'UI:Search:Criteria:Title:Default:Any' => '%1$s : Indifférent',
	'UI:Search:Criteria:Title:Default:Between' => '%1$s entre [%2$s]',
	'UI:Search:Criteria:Title:Default:Between:All' => '%1$s : Indifférent',
	'UI:Search:Criteria:Title:Default:Between:From' => '%1$s à partir de %2$s',
	'UI:Search:Criteria:Title:Default:Between:Until' => '%1$s jusqu\'à %2$s',
	'UI:Search:Criteria:Title:Default:BetweenDates' => '%1$s [%2$s]',
	'UI:Search:Criteria:Title:Default:BetweenDates:All' => '%1$s : Indifférent',
	'UI:Search:Criteria:Title:Default:BetweenDates:From' => '%1$s depuis %2$s',
	'UI:Search:Criteria:Title:Default:BetweenDates:Until' => '%1$s jusqu\'à %2$s',
	'UI:Search:Criteria:Title:Default:Contains' => '%1$s contient %2$s',
	'UI:Search:Criteria:Title:Default:Different' => '%1$s ≠ %2$s',
	'UI:Search:Criteria:Title:Default:Empty' => '%1$s vide',
	'UI:Search:Criteria:Title:Default:EndsWith' => '%1$s fini par %2$s',
	'UI:Search:Criteria:Title:Default:Equals' => '%1$s égal %2$s',
	'UI:Search:Criteria:Title:Default:GreaterThan' => '%1$s > %2$s',
	'UI:Search:Criteria:Title:Default:GreaterThanOrEquals' => '%1$s >= %2$s',
	'UI:Search:Criteria:Title:Default:LessThan' => '%1$s < %2$s',
	'UI:Search:Criteria:Title:Default:LessThanOrEquals' => '%1$s <= %2$s',
	'UI:Search:Criteria:Title:Default:NotEmpty' => '%1$s non vide',
	'UI:Search:Criteria:Title:Default:RegExp' => '%1$s correspond à %2$s',
	'UI:Search:Criteria:Title:Default:StartsWith' => '%1$s commence par %2$s',
	'UI:Search:Criteria:Title:Enum:In' => '%1$s : %2$s',
	'UI:Search:Criteria:Title:Enum:In:All' => '%1$s : Indifférent',
	'UI:Search:Criteria:Title:Enum:In:Many' => '%1$s : %2$s et %3$s autres',
	'UI:Search:Criteria:Title:ExternalKey:Empty' => '%1$s est renseigné',
	'UI:Search:Criteria:Title:ExternalKey:Equals' => '%1$s %2$s',
	'UI:Search:Criteria:Title:ExternalKey:In' => '%1$s : %2$s',
	'UI:Search:Criteria:Title:ExternalKey:In:All' => '%1$s : Indifférent',
	'UI:Search:Criteria:Title:ExternalKey:In:Many' => '%1$s : %2$s et %3$s autres',
	'UI:Search:Criteria:Title:ExternalKey:NotEmpty' => '%1$s n\'est pas renseigné',
	'UI:Search:Criteria:Title:HierarchicalKey:Empty' => '%1$s est renseigné',
	'UI:Search:Criteria:Title:HierarchicalKey:Equals' => '%1$s %2$s',
	'UI:Search:Criteria:Title:HierarchicalKey:In' => '%1$s : %2$s',
	'UI:Search:Criteria:Title:HierarchicalKey:In:All' => '%1$s : Indifférent',
	'UI:Search:Criteria:Title:HierarchicalKey:In:Many' => '%1$s : %2$s et %3$s autres',
	'UI:Search:Criteria:Title:HierarchicalKey:NotEmpty' => '%1$s n\'est pas renseigné',
	'UI:Search:Criteria:Title:TagSet:Matches' => '%1$s : %2$s',
	'UI:Search:Criteria:Toggle' => 'Réduire / Ouvrir',
	'UI:Search:Criterion:MoreMenu:AddCriteria' => 'Ajouter un critère',
	'UI:Search:Enlarge' => 'Elargir la recherche',
	'UI:Search:NeedleTooShort' => 'La clé de recherche "%1$s" est trop courte. Veuillez saisir au moins %2$d caractères.',
	'UI:Search:NoAutoSubmit:ExplainText' => 'Ajoutez des critères dans le formulaire de recherche ou cliquez sur le bouton rechercher pour voir les objets.',
	'UI:Search:NoObjectFound' => 'Aucun objet trouvé.',
	'UI:Search:NoSearch' => 'Rien à rechercher',
	'UI:Search:Obsolescence:DisabledHint' => 'Conformément à vos préférences utilisateur, vous ne voyez pas les données obsolètes',
	'UI:Search:Ongoing' => 'Recherche de "%1$s"',
	'UI:Search:Toggle' => 'Réduire / Ouvrir',
	'UI:Search:Value:Autocomplete:NoResult' => 'Aucun résultat.',
	'UI:Search:Value:Autocomplete:StartTyping' => 'Commencez à taper pour voir les valeurs possibles.',
	'UI:Search:Value:Autocomplete:Wait' => 'Patientez ...',
	'UI:Search:Value:Filter:Placeholder' => 'Filtrez...',
	'UI:Search:Value:Search:Placeholder' => 'Recherchez...',
	'UI:Search:Value:Toggler:CheckAllNone' => 'Cocher tout / aucun',
	'UI:Search:Value:Toggler:CheckAllNoneFiltered' => 'Cocher tout / aucun visibles',
	'UI:SearchFor_Class' => 'Rechercher des objets de type %1$s',
	'UI:SearchFor_Class_Objects' => 'Recherche d\'objets de type %1$s ',
	'UI:SearchResultsPageTitle' => ITOP_APPLICATION_SHORT.' - Résultats de la recherche',
	'UI:SearchResultsTitle' => 'Recherche globale',
	'UI:SearchResultsTitle+' => 'Résultat de recherche globale',
	'UI:SearchToggle' => 'Recherche',
	'UI:SearchValue:Any' => '* Indifférent *',
	'UI:SearchValue:CheckAll' => 'Cocher',
	'UI:SearchValue:Mixed' => '* Plusieurs *',
	'UI:SearchValue:NbSelected' => '# sélectionné(e)s',
	'UI:SearchValue:UncheckAll' => 'Décocher',
	'UI:SelectAllToggle+' => 'Tout sélectionner / Tout déselectionner',
	'UI:SelectInlineImageToUpload' => 'Sélectionnez l\'image à ajouter',
	'UI:SelectOne' => '-- choisir une valeur --',
	'UI:SelectTheTypeOf_Class_ToCreate' => 'Sélectionnez le type de %1$s à créer :',
	'UI:SelectionOf_Class' => 'Sélection d\'objets de type %1$s',
	'UI:ServiceMgmtMenuOverview:Title' => 'Tableau de bord de la Gestion des Services',
	'UI:ShortcutDelete:Confirm' => 'Veuillez confirmer la suppression du ou des raccourci(s)',
	'UI:ShortcutListDlg:Title' => 'Créer un raccourci pour la liste',
	'UI:ShortcutRenameDlg:Title' => 'Renommer le raccourci',
	'UI:SimpleSearchTab' => 'Recherche simple',
	'UI:SplitDateTime-Date' => 'date',
	'UI:SplitDateTime-Time' => 'heure',
	'UI:StateChanged' => 'Etat modifié',
	'UI:StayOnThePage' => 'Rester sur cette page',
	'UI:StimulusModify_N_ObjectsOf_Class' => '%1$s: Modification de %2$d objet(s) de type %3$s',
	'UI:SystemIntrusion' => 'Accès non autorisé. Vous êtes en train de d\'effectuer une opération qui ne vous est pas permise.',
	'UI:TagAdminMenu:NoTags' => 'Pas de champ étiquette configuré',
	'UI:TagAdminMenu:Title' => 'Gestion des étiquettes',
	'UI:TagSetFieldData:Error' => 'Erreur: %1$s',
	'UI:Title:BulkDeletionOf_Count_ObjectsOf_Class' => 'Suppression massive de %1$d objets de type %2$s',
	'UI:Title:BulkImport' => ITOP_APPLICATION_SHORT.' - Import massif',
	'UI:Title:BulkImport+' => 'Assistant d\'import CSV',
	'UI:Title:BulkSynchro_nbItem_ofClass_class' => 'Synchronisation de %1$d éléments de type %2$s',
	'UI:Title:CSVImportStep2' => 'Etape 2 sur 5: Options du format CSV',
	'UI:Title:CSVImportStep3' => 'Etape 3 sur 5: Correspondance des données',
	'UI:Title:CSVImportStep4' => 'Etape 4 sur 5: Simulation de l\'import',
	'UI:Title:CSVImportStep5' => 'Etape 5 sur 5: Import terminé',
	'UI:Title:DataPreview' => 'Aperçu des données',
	'UI:Title:DeletionOf_Object' => 'Suppression de %1$s',
	'UI:Title:Object_Of_Class_Created' => '%2$s - %1$s créé(e).',
	'UI:Toggle:SwitchToCustomDashboard' => 'Basculer sur le tableau de bord modifié',
	'UI:Toggle:SwitchToStandardDashboard' => 'Basculer sur le tableau de bord standard',
	'UI:ToggleFullScreen' => 'Agrandir / Minimiser',
	'UI:Treeview:CollapseAll' => 'Tout replier',
	'UI:Treeview:ExpandAll' => 'Tout déplier',
	'UI:TruncatedResults' => '%1$d objets affichés sur %2$d',
	'UI:UndefinedObject' => 'non défini',
	'UI:UniversalSearch:Error' => 'Erreur : %1$s',
	'UI:UniversalSearch:LabelSelectTheClass' => 'Sélectionnez le type d\'objets à rechercher : ',
	'UI:UniversalSearchTitle' => ITOP_APPLICATION_SHORT.' - Recherche universelle',
	'UI:UploadInlineImageLegend' => 'Ajouter une image',
	'UI:UploadNotSupportedInThisMode' => 'La modification d\'images ou de fichiers n\'est pas supportée dans ce mode.',
	'UI:UseDefaultSettings' => 'Utiliser les réglages par défaut',
	'UI:UseSavetheSettings' => 'Enregistrer ces réglages',
	'UI:UseSpecificSettings' => 'Utiliser les réglages suivants:',
	'UI:UserManagement:Action' => 'Action',
	'UI:UserManagement:Action+' => 'l\'action effectuée par l\'utilisateur',
	'UI:UserManagement:Action:BulkDelete' => 'Suppression en masse',
	'UI:UserManagement:Action:BulkDelete+' => 'Suppression de plusieurs objets',
	'UI:UserManagement:Action:BulkModify' => 'Modification en masse',
	'UI:UserManagement:Action:BulkModify+' => 'Création et modification de plusieurs objets (import CSV)',
	'UI:UserManagement:Action:BulkRead' => 'Lecture en masse (export)',
	'UI:UserManagement:Action:BulkRead+' => 'Export de liste d\'objets',
	'UI:UserManagement:Action:Delete' => 'Suppression',
	'UI:UserManagement:Action:Delete+' => 'Suppression d\'un objet',
	'UI:UserManagement:Action:Modify' => 'Modification',
	'UI:UserManagement:Action:Modify+' => 'Création et modification d\'un objet',
	'UI:UserManagement:Action:Read' => 'Lecture',
	'UI:UserManagement:Action:Read+' => 'Lecture et affichage d\'un objet',
	'UI:UserManagement:Action:Stimuli' => 'Stimuli',
	'UI:UserManagement:Action:Stimuli+' => 'Actions autorisées',
	'UI:UserManagement:ActionAllowed:No' => 'Non',
	'UI:UserManagement:ActionAllowed:Yes' => 'Oui',
	'UI:UserManagement:AdminProfile+' => 'Les administrateurs ont un accès total à tous les objets de la base de données.',
	'UI:UserManagement:AnyObject' => '* indifférent *',
	'UI:UserManagement:Attributes' => 'Champs',
	'UI:UserManagement:Class' => 'Type',
	'UI:UserManagement:Class+' => 'Type des objets',
	'UI:UserManagement:GrantMatrix' => 'Matrice des droits',
	'UI:UserManagement:NoLifeCycleApplicable' => 'N/A',
	'UI:UserManagement:NoLifeCycleApplicable+' => 'Aucun cycle de vie n\'est défini pour ce type d\'objets.',
	'UI:UserManagement:Permission' => 'Permission',
	'UI:UserManagement:Permission+' => 'Les droits de l\'utilisateur',
	'UI:UserManagement:ProjectedObject' => 'Objet',
	'UI:UserManagement:ProjectedObject+' => 'L\'objet projeté',
	'UI:UserManagement:TitleActions' => 'Actions',
	'UI:UserManagement:User' => 'Utilisateur',
	'UI:UserManagement:User+' => 'L\'utilisateur',
	'UI:UserPref:DoNotShowAgain' => 'Ne plus afficher ce message',
	'UI:ValueInvalidFormat' => 'Format invalide',
	'UI:ValueMustBeChanged' => 'Veuillez modifier la valeur de ce champ',
	'UI:ValueMustBeSet' => 'Veuillez spécifier une valeur pour ce champ',
	'UI:WelcomeMenu:AllConfigItems' => 'Actifs: %1$d',
	'UI:WelcomeMenu:AllOpenRequests' => 'Requêtes en cours: %1$d',
	'UI:WelcomeMenu:MyCalls' => 'Mes appels support',
	'UI:WelcomeMenu:MyIncidents' => 'Mes incidents',
	'UI:WelcomeMenu:OpenIncidents' => 'Incidents en cours: %1$d',
	'UI:WelcomeMenu:Text' => '<div>Félicitations, vous avez atterri sur '.ITOP_APPLICATION.' '.ITOP_VERSION_NAME.' !</div>

<div>Cette version présente un tout nouveau design moderne et accessible pour la console de support.</div>

<div>Nous avons conservé les fonctions de base d\''.ITOP_APPLICATION.' que vous aviez apprécié et les avons modernisées pour vous les faire adorer.
Nous espérons que vous aimerez cette version autant que nous avons eu du plaisir à l\'imaginer et à la créer.</div>

<div>Configurez vos préférences '.ITOP_APPLICATION.' pour une expérience personnalisée.</div>',
	'UI:WelcomeMenu:Title' => 'Bienvenue dans '.ITOP_APPLICATION_SHORT,
	'UI:WelcomeToITop' => 'Bienvenue dans '.ITOP_APPLICATION_SHORT,
	'UI:Wizard:FinalStepTitle' => 'Dernière étape: confirmation',
	'UI:YourSearch' => 'Votre recherche',
	'UI:iTopVersion:Long' => '%1$s version %2$s-%3$s du %4$s',
	'UI:iTopVersion:Short' => '%1$s version %2$s',
	'UI_CountOfObjectsShort' => '%1$d objets.',
	'portal:backoffice' => 'Console '.ITOP_APPLICATION_SHORT,
	'portal:legacy_portal' => 'Portail Utilisateurs',
]);
