<?php
/**
 * Localized data
 *
 * @copyright Copyright (C) 2010-2024 Combodo SAS
 * @license    https://opensource.org/licenses/AGPL-3.0
 * 
 */

/**
 * @author Thomas Casteleyn <thomas.casteleyn@super-visions.com>
 */
Dict::Add('NL NL', 'Dutch', 'Nederlands', [
	'BooleanLabel:no' => 'Nee',
	'BooleanLabel:yes' => 'Ja',
	'Calendar-FirstDayOfWeek' => '0',
	'Class:AuditCategory' => 'Auditcategorie',
	'Class:AuditCategory+' => 'Een onderdeel van de gehele audit',
	'Class:AuditCategory/Attribute:definition_set' => 'Definitieset',
	'Class:AuditCategory/Attribute:definition_set+' => 'OQL-expressie die de set van objecten naar audit definieert',
	'Class:AuditCategory/Attribute:description' => 'Audit categorie beschrijving',
	'Class:AuditCategory/Attribute:description+' => 'Uitgebreide beschrijving van deze Audit categorie',
	'Class:AuditCategory/Attribute:domains_list' => 'Domeinen',
	'Class:AuditCategory/Attribute:domains_list+' => 'Domains which includes this category~~',
	'Class:AuditCategory/Attribute:name' => 'Naam categorie',
	'Class:AuditCategory/Attribute:name+' => 'Afkorting van de naam van deze categorie',
	'Class:AuditCategory/Attribute:ok_error_tolerance' => 'Warning threshold~~',
	'Class:AuditCategory/Attribute:ok_error_tolerance+' => 'Percentage of invalid objects below which the result is a warning (orange)~~',
	'Class:AuditCategory/Attribute:rules_list' => 'Auditregels',
	'Class:AuditCategory/Attribute:rules_list+' => 'Auditregels voor deze categorie',
	'Class:AuditCategory/Attribute:warning_error_tolerance' => 'Error threshold~~',
	'Class:AuditCategory/Attribute:warning_error_tolerance+' => 'Percentage of invalid objects below which the result is in error (red)~~',
	'Class:AuditDomain' => 'Audit Domein',
	'Class:AuditDomain+' => 'Audit domeinen groeperen de audit categorieën.
Het domein komt meestal overeen met wie er verantwoordelijk is om de fouten te controleren en oplossen',
	'Class:AuditDomain/Attribute:categories_list' => 'Categorieën',
	'Class:AuditDomain/Attribute:categories_list+' => 'Related audit categories. When running the audit on a domain, all related audit categories are checked and only those.~~',
	'Class:AuditDomain/Attribute:description' => 'Beschrijving',
	'Class:AuditDomain/Attribute:description+' => '',
	'Class:AuditDomain/Attribute:icon' => 'Pictogram',
	'Class:AuditDomain/Attribute:icon+' => '',
	'Class:AuditDomain/Attribute:name' => 'Naam',
	'Class:AuditDomain/Attribute:name+' => 'Its a segmentation of the Audit by who is in charge of fixing it or just interested~~',
	'Class:AuditRule' => 'Auditregel',
	'Class:AuditRule+' => 'Een regel voor het controleren van een bepaalde Auditcategorie',
	'Class:AuditRule/Attribute:category_id' => 'Categorie',
	'Class:AuditRule/Attribute:category_id+' => 'De categorie voor deze regel',
	'Class:AuditRule/Attribute:category_name' => 'Categorie',
	'Class:AuditRule/Attribute:category_name+' => 'Naam van de categorie voor deze regel',
	'Class:AuditRule/Attribute:description' => 'Beschrijving',
	'Class:AuditRule/Attribute:description+' => 'Uitgebreide beschrijving van deze Auditregel',
	'Class:AuditRule/Attribute:name' => 'Naam regel',
	'Class:AuditRule/Attribute:name+' => 'Naam van de regel',
	'Class:AuditRule/Attribute:query' => 'Query om uit te voeren',
	'Class:AuditRule/Attribute:query+' => 'De OQL-expressie voor het uitvoeren',
	'Class:AuditRule/Attribute:valid_flag' => 'Geldige objecten?',
	'Class:AuditRule/Attribute:valid_flag+' => 'Waar als de regel de geldige objecten vindt, anders onwaar',
	'Class:AuditRule/Attribute:valid_flag/Value:false' => 'Onwaar',
	'Class:AuditRule/Attribute:valid_flag/Value:false+' => 'Onwaar',
	'Class:AuditRule/Attribute:valid_flag/Value:true' => 'Waar',
	'Class:AuditRule/Attribute:valid_flag/Value:true+' => 'Waar',
	'Class:Query' => 'Query',
	'Class:Query+' => 'Een query is een definie voor een dataset die op een dynamische manier wordt samengesteld',
	'Class:Query/Attribute:description' => 'Beschrijving',
	'Class:Query/Attribute:description+' => 'Uitgebreide beschrijving voor de query (doel, gebruik, enz.)',
	'Class:Query/Attribute:export_count' => 'Exports',
	'Class:Query/Attribute:export_count+' => 'Hoeveel keer deze query uitgevoerd is',
	'Class:Query/Attribute:export_last_date' => 'Laatste export',
	'Class:Query/Attribute:export_last_date+' => 'Date and time of the last export execution~~',
	'Class:Query/Attribute:export_last_user_contact' => 'Contact',
	'Class:Query/Attribute:export_last_user_contact+' => 'The contact who executed the last export~~',
	'Class:Query/Attribute:export_last_user_id' => 'Gebruiker',
	'Class:Query/Attribute:export_last_user_id+' => 'The user who executed the last export~~',
	'Class:Query/Attribute:is_template' => 'Sjabloon voor OQL-velden',
	'Class:Query/Attribute:is_template+' => 'Bruikbaar als bron voor bestemming OQL-notificaties',
	'Class:Query/Attribute:is_template/Value:no' => 'Nee',
	'Class:Query/Attribute:is_template/Value:yes' => 'Ja',
	'Class:Query/Attribute:name' => 'Naam',
	'Class:Query/Attribute:name+' => 'Identificeert de query',
	'Class:QueryOQL' => 'OQL-query',
	'Class:QueryOQL+' => 'Een query gebaseerd op de Object Query Language',
	'Class:QueryOQL/Attribute:fields' => 'Velden',
	'Class:QueryOQL/Attribute:fields+' => 'Kommagescheiden lijst van attributen (of alias.attribuut) om te exporteren',
	'Class:QueryOQL/Attribute:oql' => 'Expressie',
	'Class:QueryOQL/Attribute:oql+' => 'OQL-expressie',
	'Class:Shortcut' => 'Snelkoppelingen',
	'Class:Shortcut+' => '',
	'Class:Shortcut/Attribute:name' => 'Naam',
	'Class:Shortcut/Attribute:name+' => 'Label gebruikt in het menu en in de titel van de pagina',
	'Class:ShortcutOQL' => 'Zoekresultaat snelkoppeling',
	'Class:ShortcutOQL+' => '',
	'Class:ShortcutOQL/Attribute:auto_reload' => 'Automatisch vernieuwen',
	'Class:ShortcutOQL/Attribute:auto_reload/Value:custom' => 'Aangepast interval',
	'Class:ShortcutOQL/Attribute:auto_reload/Value:none' => 'Onbruikbaar',
	'Class:ShortcutOQL/Attribute:auto_reload_sec' => 'Interval van het automatisch vernieuwen (seconden)',
	'Class:ShortcutOQL/Attribute:auto_reload_sec/tip' => 'De minimale waarde is %1$d seconden',
	'Class:ShortcutOQL/Attribute:oql' => 'Query',
	'Class:ShortcutOQL/Attribute:oql+' => 'OQL die de lijst van objecten om naar te zoeken definieert',
	'Class:TagSetFieldData/Attribute:finalclass' => 'Tagklasse',
	'Class:TagSetFieldData/Attribute:obj_attcode' => 'Veldcode',
	'Class:TagSetFieldData/Attribute:obj_class' => 'Objectklasse',
	'Class:URP_ActionGrant' => 'action_permission',
	'Class:URP_ActionGrant+' => 'Toestemming aan klasses',
	'Class:URP_ActionGrant/Attribute:action' => 'Actie',
	'Class:URP_ActionGrant/Attribute:action+' => 'Actie om uit te voeren op een bepaalde klasse',
	'Class:URP_ActionGrant/Attribute:class' => 'Klasse',
	'Class:URP_ActionGrant/Attribute:class+' => 'Doelklasse',
	'Class:URP_ActionGrant/Attribute:permission' => 'Toestemming',
	'Class:URP_ActionGrant/Attribute:permission+' => 'Is dit toegestaan?',
	'Class:URP_ActionGrant/Attribute:permission/Value:no' => 'Nee',
	'Class:URP_ActionGrant/Attribute:permission/Value:no+' => 'Nee',
	'Class:URP_ActionGrant/Attribute:permission/Value:yes' => 'Ja',
	'Class:URP_ActionGrant/Attribute:permission/Value:yes+' => 'Ja',
	'Class:URP_ActionGrant/Attribute:profile' => 'Profiel',
	'Class:URP_ActionGrant/Attribute:profile+' => 'Gebruiksprofiel',
	'Class:URP_ActionGrant/Attribute:profileid' => 'Profiel',
	'Class:URP_ActionGrant/Attribute:profileid+' => 'Gebruiksprofiel',
	'Class:URP_AttributeGrant' => 'attribute_permission',
	'Class:URP_AttributeGrant+' => 'Toestemming op het niveau van de attributen',
	'Class:URP_AttributeGrant/Attribute:actiongrantid' => 'Actie verleen',
	'Class:URP_AttributeGrant/Attribute:actiongrantid+' => 'Actie verleen',
	'Class:URP_AttributeGrant/Attribute:attcode' => 'Attribuut',
	'Class:URP_AttributeGrant/Attribute:attcode+' => 'Code van attribuut',
	'Class:URP_ClassProjection' => 'class_projection',
	'Class:URP_ClassProjection+' => 'class projections',
	'Class:URP_ClassProjection/Attribute:attribute' => 'Attribuut',
	'Class:URP_ClassProjection/Attribute:attribute+' => 'Code van doelattribuut (optioneel)',
	'Class:URP_ClassProjection/Attribute:class' => 'Klasse',
	'Class:URP_ClassProjection/Attribute:class+' => 'Doelklasse',
	'Class:URP_ClassProjection/Attribute:dimension' => 'Dimensie',
	'Class:URP_ClassProjection/Attribute:dimension+' => 'Dimensie van de applicatie',
	'Class:URP_ClassProjection/Attribute:dimensionid' => 'Dimensie',
	'Class:URP_ClassProjection/Attribute:dimensionid+' => 'Dimensie van de applicatie',
	'Class:URP_ClassProjection/Attribute:value' => 'Waarde-expressie',
	'Class:URP_ClassProjection/Attribute:value+' => 'OQL-expressie (gebruikt $this) | constant |  | +attribute code',
	'Class:URP_Dimensions' => 'Dimensie',
	'Class:URP_Dimensions+' => 'Dimensie van de applicatie (definieert silo\'s)',
	'Class:URP_Dimensions/Attribute:description' => 'Beschrijving',
	'Class:URP_Dimensions/Attribute:description+' => 'Beschrijving van deze dimensie',
	'Class:URP_Dimensions/Attribute:name' => 'Naam',
	'Class:URP_Dimensions/Attribute:name+' => 'Naam van deze dimensie',
	'Class:URP_Dimensions/Attribute:type' => 'Type',
	'Class:URP_Dimensions/Attribute:type+' => 'Klassenaam of data type (projection unit)',
	'Class:URP_ProfileProjection' => 'profile_projection',
	'Class:URP_ProfileProjection+' => 'profile projections',
	'Class:URP_ProfileProjection/Attribute:attribute' => 'Attribuut',
	'Class:URP_ProfileProjection/Attribute:attribute+' => 'Code van doelattribuut (optioneel)',
	'Class:URP_ProfileProjection/Attribute:dimension' => 'Dimensie',
	'Class:URP_ProfileProjection/Attribute:dimension+' => 'Dimensie van de applicatie',
	'Class:URP_ProfileProjection/Attribute:dimensionid' => 'Dimensie',
	'Class:URP_ProfileProjection/Attribute:dimensionid+' => 'Dimensie van de applicatie',
	'Class:URP_ProfileProjection/Attribute:profile' => 'Profiel',
	'Class:URP_ProfileProjection/Attribute:profile+' => 'Naam van het profiel',
	'Class:URP_ProfileProjection/Attribute:profileid' => 'Profiel',
	'Class:URP_ProfileProjection/Attribute:profileid+' => 'Gebruiksprofiel',
	'Class:URP_ProfileProjection/Attribute:value' => 'Waarde-expressie',
	'Class:URP_ProfileProjection/Attribute:value+' => 'OQL-expressie (gebruikt $user) | constant |  | +attribute code',
	'Class:URP_Profiles' => 'Profiel',
	'Class:URP_Profiles+' => 'Gebruikersprofiel',
	'Class:URP_Profiles/Attribute:description' => 'Beschrijving',
	'Class:URP_Profiles/Attribute:description+' => 'Beschrijving van dit profiel',
	'Class:URP_Profiles/Attribute:name' => 'Naam',
	'Class:URP_Profiles/Attribute:name+' => 'Naam van dit gebruikersprofiel',
	'Class:URP_Profiles/Attribute:user_list' => 'Gebruikers',
	'Class:URP_Profiles/Attribute:user_list+' => 'Gebruikers met deze rol',
	'Class:URP_StimulusGrant' => 'stimulus_permission',
	'Class:URP_StimulusGrant+' => 'Toegestane stimulus in de levenscyclus van het object',
	'Class:URP_StimulusGrant/Attribute:class' => 'Klasse',
	'Class:URP_StimulusGrant/Attribute:class+' => 'Doelklasse',
	'Class:URP_StimulusGrant/Attribute:permission' => 'Toestemming',
	'Class:URP_StimulusGrant/Attribute:permission+' => 'Is dit toegestaan',
	'Class:URP_StimulusGrant/Attribute:permission/Value:no' => 'Nee',
	'Class:URP_StimulusGrant/Attribute:permission/Value:no+' => 'Nee',
	'Class:URP_StimulusGrant/Attribute:permission/Value:yes' => 'Ja',
	'Class:URP_StimulusGrant/Attribute:permission/Value:yes+' => 'Ja',
	'Class:URP_StimulusGrant/Attribute:profile' => 'Profiel',
	'Class:URP_StimulusGrant/Attribute:profile+' => 'Gebruiksprofiel',
	'Class:URP_StimulusGrant/Attribute:profileid' => 'Profiel',
	'Class:URP_StimulusGrant/Attribute:profileid+' => 'Gebruiksprofiel',
	'Class:URP_StimulusGrant/Attribute:stimulus' => 'Stimulus',
	'Class:URP_StimulusGrant/Attribute:stimulus+' => 'Code van stimulus',
	'Class:URP_UserOrg' => 'Gebruiker / Organisatie',
	'Class:URP_UserOrg+' => 'Koppeling tussen gebruikers en organisaties',
	'Class:URP_UserOrg/Attribute:allowed_org_id' => 'Organisatie',
	'Class:URP_UserOrg/Attribute:allowed_org_id+' => 'Mijn organisatie',
	'Class:URP_UserOrg/Attribute:allowed_org_name' => 'Mijn organisatie',
	'Class:URP_UserOrg/Attribute:allowed_org_name+' => 'Mijn organisatie',
	'Class:URP_UserOrg/Attribute:reason' => 'Reden',
	'Class:URP_UserOrg/Attribute:reason+' => 'Leg uit waarom deze persoon de data van deze organisatie mag inzien',
	'Class:URP_UserOrg/Attribute:userid' => 'Gebruiker',
	'Class:URP_UserOrg/Attribute:userid+' => 'Account van de gebruiker',
	'Class:URP_UserOrg/Attribute:userlogin' => 'Login',
	'Class:URP_UserOrg/Attribute:userlogin+' => 'Login van de gebruiker',
	'Class:URP_UserOrg/Name' => 'Link tussen %1$s en %2$s',
	'Class:URP_UserProfile' => 'Gebruiker / Profiel',
	'Class:URP_UserProfile+' => 'Koppeling tussen gebruikers en profielen',
	'Class:URP_UserProfile/Attribute:profile' => 'Profiel',
	'Class:URP_UserProfile/Attribute:profile+' => 'Naam van het profiel',
	'Class:URP_UserProfile/Attribute:profileid' => 'Profiel',
	'Class:URP_UserProfile/Attribute:profileid+' => 'Gebruiksprofiel',
	'Class:URP_UserProfile/Attribute:reason' => 'Reden',
	'Class:URP_UserProfile/Attribute:reason+' => 'Leg uit waarom deze persoon deze rol heeft',
	'Class:URP_UserProfile/Attribute:userid' => 'Gebruiker',
	'Class:URP_UserProfile/Attribute:userid+' => 'De gebruiker gekoppeld aan dit profiel',
	'Class:URP_UserProfile/Attribute:userlogin' => 'Login',
	'Class:URP_UserProfile/Attribute:userlogin+' => 'De login (gebruikersnaam) van de gebruiker',
	'Class:URP_UserProfile/Name' => 'Link tussen %1$s en %2$s',
	'Class:User' => 'Gebruiker',
	'Class:User+' => 'Login voor gebruiker',
	'Class:User/Attribute:allowed_org_list' => 'Toegestane organisaties',
	'Class:User/Attribute:allowed_org_list+' => 'De eindgebruiker heeft toestemming om data te bekijken van de gerelateerde organisaties. Als er geen organisatie is opgegeven, heeft de persoon toegang tot data van alle organisaties.',
	'Class:User/Attribute:contactid' => 'Contact',
	'Class:User/Attribute:contactid+' => 'Contactpersoon',
	'Class:User/Attribute:email' => 'E-mailadres',
	'Class:User/Attribute:email+' => 'E-mailadres van de overeenkomende persoon',
	'Class:User/Attribute:finalclass' => 'Accounttype',
	'Class:User/Attribute:finalclass+' => '',
	'Class:User/Attribute:first_name' => 'Voornaam',
	'Class:User/Attribute:first_name+' => 'Voornaam van de overeenkomende persoon',
	'Class:User/Attribute:language' => 'Taal',
	'Class:User/Attribute:language+' => 'Taal van de gebruiker',
	'Class:User/Attribute:language/Value:EN US' => 'Engels',
	'Class:User/Attribute:language/Value:EN US+' => 'Engels (V.S.)',
	'Class:User/Attribute:language/Value:FR FR' => 'Frans',
	'Class:User/Attribute:language/Value:FR FR+' => 'Frans (Frankrijk)',
	'Class:User/Attribute:last_name' => 'Achternaam',
	'Class:User/Attribute:last_name+' => 'Naam van de overeenkomende persoon',
	'Class:User/Attribute:login' => 'Login',
	'Class:User/Attribute:login+' => 'Login (gebruikersnaam) waarmee deze persoon zich kan aanmelden',
	'Class:User/Attribute:org_id' => 'Organisatie',
	'Class:User/Attribute:org_id+' => 'Organisatie van de gerelateerde persoon',
	'Class:User/Attribute:profile_list' => 'Profielen',
	'Class:User/Attribute:profile_list+' => 'Rollen waarmee rechten verleend zijn aan deze account.',
	'Class:User/Attribute:status' => 'Status',
	'Class:User/Attribute:status+' => 'De gebruikersaccount kan in- of uitgeschakeld zijn.',
	'Class:User/Attribute:status/Value:disabled' => 'Uitgeschakeld',
	'Class:User/Attribute:status/Value:enabled' => 'Ingeschakeld',
	'Class:User/Error:AllowedOrgsMustContainUserOrg' => 'De toegestande organisaties moeten minstens de organisatie bevatten waartoe de gebruikersaccount behoort.',
	'Class:User/Error:AtLeastOneOrganizationIsNeeded' => 'Minstens één organisatie moet toegewezen zijn aan deze gebruiker',
	'Class:User/Error:AtLeastOneProfileIsNeeded' => 'Minstens één profiel moet toegewezen zijn aan deze gebruiker',
	'Class:User/Error:CurrentProfilesHaveInsufficientRights' => 'De huidige lijst van profielen heeft niet voldoende toegangsrechten (gebruikersaccount zijn niet meer wijzigbaar).',
	'Class:User/Error:LoginMustBeUnique' => 'Login moet uniek zijn - "%1s" is al in gebruik',
	'Class:User/Error:OrganizationNotAllowed' => 'Organisatie is niet toegestaan.',
	'Class:User/Error:PersonIsMandatory' => 'De persoon moet ingevuld zijn.',
	'Class:User/Error:PortalPowerUserHasInsufficientRights' => 'The Portal power user profile does not give sufficient access rights (another profile must be added)~~',
	'Class:User/Error:ProfileNotAllowed' => 'Profiel "%1$s" kan niet toegevoegd worden omdat het de toegang tot de backoffice zou ontzeggen.',
	'Class:User/Error:StatusChangeIsNotAllowed' => 'Je kan de status voor je eigen gebruikersaccount niet wijzigen.',
	'Class:User/Error:UserOrganizationNotAllowed' => 'De gebruikersaccount behoort niet tot de organisaties waar je zelf rechten voor hebt.',
	'Class:User/Warning:NoContactHasImpact' => 'Cautious: there is no Person defined on this User, this prevents access to portals, news notifications and other side effects in back-office~~',
	'Class:User/Warning:NoOrganizationMeansFullAccess' => 'No "Allowed Organizations" defined for this user, this means they have access to all organizations~~',
	'Class:UserDashboard' => 'Gebruikerdashboard',
	'Class:UserDashboard+' => '',
	'Class:UserDashboard/Attribute:contents' => 'Inhoud',
	'Class:UserDashboard/Attribute:contents+' => '',
	'Class:UserDashboard/Attribute:menu_code' => 'Code menu',
	'Class:UserDashboard/Attribute:menu_code+' => '',
	'Class:UserDashboard/Attribute:user_id' => 'Gebruiker',
	'Class:UserDashboard/Attribute:user_id+' => '',
	'Class:UserInternal' => 'Interne gebruiker',
	'Class:UserInternal+' => 'Gebruiker gedefinieerd in '.ITOP_APPLICATION_SHORT,
	'Class:lnkAuditCategoryToAuditDomain' => 'Link AuditCategory / AuditDomain~~',
	'Class:lnkAuditCategoryToAuditDomain+' => '',
	'Class:lnkAuditCategoryToAuditDomain/Attribute:category_id' => 'Categorie',
	'Class:lnkAuditCategoryToAuditDomain/Attribute:category_id+' => 'Audit Categorie',
	'Class:lnkAuditCategoryToAuditDomain/Attribute:category_name' => 'Categorie naam',
	'Class:lnkAuditCategoryToAuditDomain/Attribute:category_name+' => 'Audit categorie naam',
	'Class:lnkAuditCategoryToAuditDomain/Attribute:domain_id' => 'Domein',
	'Class:lnkAuditCategoryToAuditDomain/Attribute:domain_id+' => 'Audit domein',
	'Class:lnkAuditCategoryToAuditDomain/Attribute:domain_name' => 'Domein naam',
	'Class:lnkAuditCategoryToAuditDomain/Attribute:domain_name+' => 'Audit domein naam',
	'DayOfWeek-Friday' => 'Vrijdag',
	'DayOfWeek-Friday-Min' => 'Vr',
	'DayOfWeek-Monday' => 'Maandag',
	'DayOfWeek-Monday-Min' => 'Ma',
	'DayOfWeek-Saturday' => 'Zaterdag',
	'DayOfWeek-Saturday-Min' => 'Za',
	'DayOfWeek-Sunday' => 'Zondag',
	'DayOfWeek-Sunday-Min' => 'Zo',
	'DayOfWeek-Thursday' => 'Donderdag',
	'DayOfWeek-Thursday-Min' => 'Do',
	'DayOfWeek-Tuesday' => 'Dinsdag',
	'DayOfWeek-Tuesday-Min' => 'Di',
	'DayOfWeek-Wednesday' => 'Woensdag',
	'DayOfWeek-Wednesday-Min' => 'Wo',
	'Enum:Undefined' => 'Ongedefinieerd',
	'ExcelExport:AutoDownload' => 'Start het downloaden automatisch als de export klaar is.',
	'ExcelExport:PreparingExport' => 'Export aan het voorbereiden...',
	'ExcelExport:Statistics' => 'Statistieken',
	'ExcelExporter:BuildingExcelFile' => 'Excel-bestand aan het maken...',
	'ExcelExporter:Done' => 'Klaar.',
	'ExcelExporter:DownloadButton' => 'Download %1$s',
	'ExcelExporter:ExportButton' => 'Exporteer',
	'ExcelExporter:ExportDialogTitle' => 'Exporteer als Excel-bestand',
	'ExcelExporter:ExportMenu' => 'Exporteer naar Excel',
	'ExcelExporter:RetrievingData' => 'Data aan het opvragen...',
	'Expression:Operator:=' => ': ',
	'Expression:Operator:AND' => ' EN ',
	'Expression:Operator:OR' => ' OF ',
	'Expression:Unit:Long:DAY' => 'dag(en)',
	'Expression:Unit:Long:HOUR' => 'ure(n)',
	'Expression:Unit:Long:MINUTE' => 'minute(n)',
	'Expression:Unit:Short:DAY' => 'd',
	'Expression:Unit:Short:MONTH' => 'm',
	'Expression:Unit:Short:WEEK' => 'w',
	'Expression:Unit:Short:YEAR' => 'j',
	'Expression:Verb:ISNULL' => ': ongedefinieerd (NULL)',
	'Expression:Verb:NOW' => 'nu',
	'Menu:AdminTools' => 'Admintools',
	'Menu:AdminTools+' => 'Beheertools',
	'Menu:AdminTools?' => 'Tools die enkel toegankelijk zijn voor gebruikers met een administratorprofiel.',
	'Menu:AuditCategories' => 'Auditcategorieën',
	'Menu:AuditCategories+' => 'Auditcategorieën',
	'Menu:AuditCategories:Title' => 'Audit configuratie',
	'Menu:CSVImportMenu' => 'CSV import',
	'Menu:CSVImportMenu+' => 'In bulk aanmaken of aanpassen van objecten',
	'Menu:ConfigurationTools' => 'Configuratie',
	'Menu:DataAdministration' => 'Databeheer',
	'Menu:DataAdministration+' => 'Databeheer',
	'Menu:DataModelMenu' => 'Datamodel',
	'Menu:DataModelMenu+' => 'Overzicht van het datamodel',
	'Menu:DataSources' => 'Synchronisatie-databronnen',
	'Menu:DataSources+' => 'Alle Synchronisatie-databronnen',
	'Menu:ExportMenu' => 'Export',
	'Menu:ExportMenu+' => 'Exporteer de resultaten van query\'s als HTML, CSV of XML',
	'Menu:MyShortcuts' => 'Mijn snelkoppelingen',
	'Menu:Notifications:Title' => 'Auditcategorieën',
	'Menu:NotificationsMenu' => 'Meldingen',
	'Menu:NotificationsMenu+' => 'Configuratie van de meldingen',
	'Menu:ProfilesMenu' => 'Profielen',
	'Menu:ProfilesMenu+' => 'Profielen',
	'Menu:ProfilesMenu:Title' => 'Profielen',
	'Menu:Queries' => 'Query\'s',
	'Menu:QueryMenu' => 'Voorgedefinieerde query\'s',
	'Menu:QueryMenu+' => 'Voorgedefinieerde query\'s',
	'Menu:RunQueriesMenu' => 'Query\'s uitvoeren',
	'Menu:RunQueriesMenu+' => 'Voer een query uit',
	'Menu:SystemTools' => 'Systeem',
	'Menu:TagAdminMenu' => 'Tags-configuratie',
	'Menu:TagAdminMenu+' => 'Beheer de tags',
	'Menu:UniversalSearchMenu' => 'Globale zoekopdracht',
	'Menu:UniversalSearchMenu+' => 'Zoek in alle data...',
	'Menu:UserAccountsMenu' => 'Gebruikersaccounts',
	'Menu:UserAccountsMenu+' => 'Gebruikersaccounts',
	'Menu:UserAccountsMenu:Title' => 'Gebruikersaccounts',
	'Menu:UserManagement' => 'Gebruikersbeheer',
	'Menu:UserManagementMenu' => 'Gebruikersbeheer',
	'Menu:UserManagementMenu+' => 'Gebruikersbeheer',
	'Menu:WelcomeMenu' => 'Welkom',
	'Menu:WelcomeMenu+' => 'Welkom in '.ITOP_APPLICATION_SHORT,
	'Menu:WelcomeMenuPage' => 'Welkom',
	'Menu:WelcomeMenuPage+' => 'Welkom in '.ITOP_APPLICATION_SHORT,
	'Month-01' => 'Januari',
	'Month-01-Short' => 'Jan',
	'Month-02' => 'Februari',
	'Month-02-Short' => 'Feb',
	'Month-03' => 'Maart',
	'Month-03-Short' => 'Maa',
	'Month-04' => 'April',
	'Month-04-Short' => 'Apr',
	'Month-05' => 'Mei',
	'Month-05-Short' => 'Mei',
	'Month-06' => 'Juni',
	'Month-06-Short' => 'Jun',
	'Month-07' => 'Juli',
	'Month-07-Short' => 'Jul',
	'Month-08' => 'Augustus',
	'Month-08-Short' => 'Aug',
	'Month-09' => 'September',
	'Month-09-Short' => 'Sep',
	'Month-10' => 'Oktober',
	'Month-10-Short' => 'Okt',
	'Month-11' => 'November',
	'Month-11-Short' => 'Nov',
	'Month-12' => 'December',
	'Month-12-Short' => 'Dec',
	'ObjectRef:Archived' => 'Gearchiveerd',
	'ObjectRef:Obsolete' => 'Buiten dienst',
	'Portal:AddAttachment' => ' Voeg bijlage toe ',
	'Portal:Attachment_No_To_Ticket_Name' => 'Bijlage #%1$d to %2$s (%3$s)',
	'Portal:Attachments' => 'Bijlagen',
	'Portal:Back' => 'Vorige',
	'Portal:Button:CloseTicket' => 'Sluit deze ticket',
	'Portal:Button:ReopenTicket' => 'Heropen deze ticket',
	'Portal:Button:UpdateRequest' => 'Update de aanvraag',
	'Portal:ChangeMyPassword' => 'Verander mijn wachtwoord',
	'Portal:ClosedRequests' => 'Mijn gesloten aanvragen',
	'Portal:CreateNewIncidentItil' => 'Maak een nieuw incidentrapport aan',
	'Portal:CreateNewRequest' => 'Maak een nieuwe aanvraag aan',
	'Portal:CreateNewRequestItil' => 'Maak een nieuwe aanvraag aan',
	'Portal:DescriptionOfTheRequest' => 'Voeg een beschrijving voor jouw aanvraag toe:',
	'Portal:Disconnect' => 'Disconnect',
	'Portal:EnterYourCommentsOnTicket' => 'Voeg opmerkingen over het oplossen van deze ticket toe:',
	'Portal:ErrorNoContactForThisUser' => 'Fout: de huidige gebruiker is niet gelinkt aan een persoon/contact. Neem contact op met jouw beheerder.',
	'Portal:NoClosedRequest' => 'Geen aanvragen in deze categorie',
	'Portal:NoOpenRequest' => 'Geen aanvragen in deze categorie',
	'Portal:NoRequestMgmt' => 'Beste %1$s, je bent naar deze pagina doorverwezen omdat jouw account is geconfigureerd met het profiel "Portal user". Helaas is '.ITOP_APPLICATION_SHORT.' niet geïnstalleerd met de optie "Request Management". Neem contact op met jouw beheerder.',
	'Portal:OpenRequests' => 'Mijn lopende aanvragen',
	'Portal:PleaseSelectAServiceSubCategory' => 'Selecteer een subcategorie',
	'Portal:PleaseSelectOneService' => 'Selecteer een service',
	'Portal:Refresh' => 'Herlaad',
	'Portal:RemoveAttachment' => ' Verwijder bijlage ',
	'Portal:ResolvedRequests' => 'Mijn opgeloste aanvragen',
	'Portal:SelectRequestTemplate' => 'Selecteer een sjabloon voor %1$s',
	'Portal:SelectService' => 'Selecteer een service uit de catalogus:',
	'Portal:SelectSubcategoryFrom_Service' => 'Selecteer een subcategorie voor de service %1$s:',
	'Portal:ShowClosed' => 'Laat gesloten aanvragen zien',
	'Portal:ShowOngoing' => 'Laat lopende aanvragen zien',
	'Portal:Title' => ITOP_APPLICATION_SHORT.' gebruikersportaal',
	'Portal:TitleDetailsFor_Request' => 'Details voor aanvraag',
	'Portal:TitleRequestDetailsFor_Request' => 'Details voor de aanvraag %1$s:',
	'Portal:WelcomeUserOrg' => 'Welkom %1$s, van %2$s',
	'Query:baseinfo' => 'Algemene informatie',
	'Query:exportInfo' => 'Export informatie',
	'Tag:Archived' => 'Gearchiveerd',
	'Tag:Archived+' => 'Kan enkel bekeken worden in Archief-mode',
	'Tag:Obsolete' => 'Buiten dienst',
	'Tag:Obsolete+' => 'Uitgesloten uit de impactanalyse en onzichtbaar in zoekresultaten',
	'Tag:Synchronized' => 'Gesynchroniseerd',
	'UI-ChangeManagementMenu-ChangesByStatus' => 'Changes aan de hand van soort status',
	'UI-ChangeManagementMenu-ChangesByType' => 'Changes aan de hand van soort',
	'UI-ChangeManagementMenu-ChangesNotYetAssigned' => 'Nog niet toegewezen Changes',
	'UI-ChangeManagementOverview-ChangeByType' => 'Changes aan de hand van soort',
	'UI-ChangeManagementOverview-ChangeUnassigned' => 'Nog niet toegewezen Changes',
	'UI-ChangeManagementOverview-ChangeWithOutage' => 'Outages door changes',
	'UI-ConfigMgmtMenuOverview-FunctionalCIByType' => 'Configuratie-items aan de hand van soort',
	'UI-ConfigMgmtMenuOverview-FunctionalCIbyStatus' => 'Configuratie-items aan de hand van status',
	'UI-ConfigurationManagementMenu-InfraByStatus' => 'Objecten van de infrastructuur aan de hand van status',
	'UI-ConfigurationManagementMenu-InfraByType' => 'Objecten van de infrastructuur aan de hand van soort',
	'UI-ContactsMenu-ContactsByLocation' => 'Contacten aan de hand van locatie',
	'UI-ContactsMenu-ContactsByStatus' => 'Contacten aan de hand van status',
	'UI-ContactsMenu-ContactsByType' => 'Contacten aan de hand van soort',
	'UI-IncidentManagementOverview-IncidentByPriority' => 'Incidenten aan de hand van prioriteit',
	'UI-IncidentManagementOverview-IncidentByService' => 'Incidenten aan de hand van service',
	'UI-IncidentManagementOverview-IncidentUnassigned' => 'Nog niet toegewezen incidenten',
	'UI-RequestManagementOverview-RequestByPriority' => 'Gebruikersaanvragen aan de hand van prioriteit',
	'UI-RequestManagementOverview-RequestByService' => 'Gebruikersaanvragen aan de hand van service',
	'UI-RequestManagementOverview-RequestUnassigned' => 'Nog niet toegewezen gebruikersaanvragen',
	'UI-ServiceManagementOverview-CustomerContractToRenew' => 'Klantencontracten die binnen 30 dagen vernieuwd moeten worden',
	'UI-ServiceManagementOverview-ProviderContractToRenew' => 'Providercontracten die binnen 30 dagen vernieuwd moeten worden',
	'UI:About:DataModel' => 'Datamodel',
	'UI:About:Extension_Version' => 'Versie: %1$s',
	'UI:About:InstallationOptions' => 'Installatie-opties',
	'UI:About:Licenses' => 'Licenties',
	'UI:About:ManualExtensionSource' => 'Extensie',
	'UI:About:RemoteExtensionSource' => 'Data',
	'UI:About:Support' => 'Support informatie',
	'UI:About:Title' => 'Over '.ITOP_APPLICATION_SHORT,
	'UI:AboutBox' => 'Over '.ITOP_APPLICATION_SHORT.'...',
	'UI:AccessRO-All' => ITOP_APPLICATION.' is alleen-lezen',
	'UI:AccessRO-Users' => ITOP_APPLICATION.' is alleen-lezen voor eindgebruikers',
	'UI:ActionNotAllowed' => 'Je hebt geen toestemming om deze actie op deze objecten uit te voeren.',
	'UI:AddAnExisting_Class' => 'Voeg objecten van type %1$s toe...',
	'UI:AddLinkedObjectsOf_Class' => 'Voeg %1$s toe',
	'UI:AddObjectsOf_Class_LinkedWith_Class' => 'Voeg %1$s objecten toe om te linken met de %2$s',
	'UI:AddObjectsOf_Class_LinkedWith_Class_Instance' => 'Voeg %1$s objecten gelinkt met %2$s: %3$s toe',
	'UI:AllOrganizations' => ' Alle Organisaties ',
	'UI:ApplicationEnvironment' => 'Omgeving van de applicatie: %1$s',
	'UI:Apply_Stimulus_On_Object_In_State_ToTarget_State' => 'Bezig met het toepassen van %1$s op object: %2$s in fase %3$s tot doelfase: %4$s.',
	'UI:ArchiveMode:Banner' => 'Archief-mode',
	'UI:ArchiveMode:Banner+' => 'Gearchiveerde objecten zijn zichtbaar, maar kunnen niet worden aangepast',
	'UI:ArchiveModeOff' => 'Schakel Archief-mode uit',
	'UI:ArchiveModeOn' => 'Schakel Archief-mode in',
	'UI:Archive_User_OnBehalfOf_User' => '%1$s vanwege %2$s',
	'UI:AttemptingToChangeASlaveAttribute_Name' => 'Het veld %1$s is niet aanpasbaar omdat het onderdeel is van een datasynchronisatie. Waarde blijft onveranderd',
	'UI:AttemptingToSetAReadOnlyAttribute_Name' => 'Bezig met het instellen van het alleen-lezen veld: %1$s',
	'UI:AttemptingToSetASlaveAttribute_Name' => 'Het veld %1$s is niet aanpasbaar omdat het onderdeel is van een datasynchronisatie. Waarde niet opgegeven',
	'UI:Audit:AuditCategory:Subtitle' => '%1$s fouten van de %2$s - %3$s%%',
	'UI:Audit:AuditErrors' => 'Audit fouten',
	'UI:Audit:Dashboard:ObjectsAudited' => 'Gecontroleerde objecten',
	'UI:Audit:Dashboard:ObjectsInError' => 'Foutieve objecten',
	'UI:Audit:Dashboard:ObjectsValidated' => 'Gevalideerde objecten',
	'UI:Audit:Error:ValueNA' => 'NB',
	'UI:Audit:ErrorIn_Category' => 'Fout in Categorie',
	'UI:Audit:ErrorIn_Category_Reason' => 'OQL-fout in de categorie %1$s: %2$s.',
	'UI:Audit:ErrorIn_Rule' => 'Fout in regel',
	'UI:Audit:ErrorIn_Rule_Reason' => 'OQL-fout in de regel %1$s: %2$s.',
	'UI:Audit:HeaderAuditRule' => 'Auditregel',
	'UI:Audit:HeaderNbErrors' => '# fouten',
	'UI:Audit:HeaderNbObjects' => '# objecten',
	'UI:Audit:Interactive:All:BreadCrumb' => 'Volledige audit',
	'UI:Audit:Interactive:All:BreadCrumb+' => 'Audit resultaten voor alle regels',
	'UI:Audit:Interactive:All:SubTitle' => 'Volledige audit: omvat alle regels, alle categorieën en alle domeinen',
	'UI:Audit:Interactive:All:Title' => 'Audit resultaten',
	'UI:Audit:Interactive:Button:Back' => 'Terug naar de audit',
	'UI:Audit:Interactive:Button:Configuration' => 'Audit configuratie',
	'UI:Audit:Interactive:Categories:BreadCrumb' => 'Categorieën',
	'UI:Audit:Interactive:Categories:BreadCrumb+' => 'Audit categorieën: %1$s',
	'UI:Audit:Interactive:Categories:SubTitle' => 'Audit resultaten voor alle regels behorend bij een van deze %1$s categorieën',
	'UI:Audit:Interactive:Categories:Title' => 'Audit resultaten voor categorie: %1$s',
	'UI:Audit:Interactive:Domain:BreadCrumb' => '%1$s',
	'UI:Audit:Interactive:Domain:BreadCrumb+' => 'Audit voor domein: %1$s',
	'UI:Audit:Interactive:Domain:SubTitle' => 'Audit resultaten voor alle regels behorend bij een categorie gerelateerd aan het domein: %1$s',
	'UI:Audit:Interactive:Domain:Title' => 'Audit resultaten voor domein: %1$s',
	'UI:Audit:Interactive:Selection:BadgeAll' => 'Alle categorieën',
	'UI:Audit:Interactive:Selection:BreadCrumb' => 'Selection~~',
	'UI:Audit:Interactive:Selection:BreadCrumb+' => 'Selection of an Audit to run~~',
	'UI:Audit:Interactive:Selection:SubTitle' => 'Select a domain to get the results limited to this domain or select "All categories" to get a full audit (can take time or even fail if too much data to audit)~~',
	'UI:Audit:Interactive:Selection:Title' => 'Selection of an audit~~',
	'UI:Audit:InteractiveAudit' => 'Interactieve Audit',
	'UI:Audit:OqlError' => 'OQL fout',
	'UI:Audit:PercentageOk' => '% Ok',
	'UI:Audit:Title' => ITOP_APPLICATION_SHORT.' - CMDB Audit',
	'UI:Audit:ViewRules' => 'Check the rules~~',
	'UI:AutoApplyConfirmationMessage' => 'Sommige veranderingen zijn nog niet doorgevoerd. Wil je dat '.ITOP_APPLICATION_SHORT.' deze meeneemt?',
	'UI:AvailableInlineImagesLegend' => 'Beschikbare afbeeldingen',
	'UI:BeforeAdding_Class_ObjectsSaveThisObject' => 'Sla dit object op voordat je meer %1$s objecten toevoegt.',
	'UI:BrowseInlineImages' => 'Afbeeldingen doorbladeren...',
	'UI:BulkAction:NoObjectSelected' => 'Selecteer tenminste een object om deze actie uit te voeren',
	'UI:BulkDeletePageTitle' => ITOP_APPLICATION_SHORT.' - Meerdere objecten verwijderen',
	'UI:BulkDeleteTitle' => 'Selecteer de objecten die je wilt verwijderen:',
	'UI:BulkModify:N_MoreValues' => '%1$d meer waarden...',
	'UI:BulkModify:Value_Exists_N_Times' => '%1$s, %2$d keer',
	'UI:BulkModifyErrors' => 'Fouten (indien van toepassing)',
	'UI:BulkModifyErrors+' => 'Fouten die de bewerking verhinderen',
	'UI:BulkModifyStatus' => 'Operatie',
	'UI:BulkModifyStatus+' => 'Status van de operatie',
	'UI:BulkModifyStatusError' => 'Fout',
	'UI:BulkModifyStatusModified' => 'Aangepast',
	'UI:BulkModifyStatusOk' => 'Ok',
	'UI:BulkModifyStatusSkipped' => 'Overgeslagen',
	'UI:BulkModify_Count_DistinctValues' => '%1$d unieke waarden:',
	'UI:Button:Add' => ' Voeg toe ',
	'UI:Button:AddObject' => ' Voeg toe... ',
	'UI:Button:AddToList' => ' << Voeg toe ',
	'UI:Button:Apply' => 'Pas toe',
	'UI:Button:Back' => ' << Vorige ',
	'UI:Button:BrowseObjects' => ' Bladeren... ',
	'UI:Button:Cancel' => 'Annuleer',
	'UI:Button:ChangePassword' => ' Verander wachtwoord ',
	'UI:Button:Clear' => ' Wis ',
	'UI:Button:Close' => 'Sluiten',
	'UI:Button:Confirm' => 'Bevestigen',
	'UI:Button:Create' => ' Maak aan ',
	'UI:Button:Delete' => ' Verwijder ',
	'UI:Button:DoImport' => ' Importeer!',
	'UI:Button:Done' => ' Klaar ',
	'UI:Button:Evaluate' => ' Evalueer ',
	'UI:Button:Evaluate:Title' => ' Evalueer (Ctrl+Enter)',
	'UI:Button:Export' => 'Exporteer',
	'UI:Button:FilterList' => ' Filter... ',
	'UI:Button:Finish' => ' Afronden ',
	'UI:Button:GlobalSearch' => 'Zoek',
	'UI:Button:GoPrint' => 'Afdrukken...',
	'UI:Button:Insert' => 'Invoegen',
	'UI:Button:Less' => 'Minder',
	'UI:Button:Login' => 'Ga naar '.ITOP_APPLICATION,
	'UI:Button:Logoff' => 'Log uit',
	'UI:Button:ModifyAll' => 'Bewerk alles',
	'UI:Button:More' => 'Meer',
	'UI:Button:MoveDown' => 'Ga omlaag',
	'UI:Button:MoveUp' => 'Ga omhoog',
	'UI:Button:Next' => ' Volgende >> ',
	'UI:Button:Ok' => 'Ok',
	'UI:Button:PreviewModifications' => 'Voorbeeld van de bewerkingen >>',
	'UI:Button:Query' => ' Query ',
	'UI:Button:Refresh' => 'Herlaad',
	'UI:Button:Remove' => 'Verwijder',
	'UI:Button:RemoveDocument' => 'Document verwijderen',
	'UI:Button:RemoveFromList' => ' Verwijder >> ',
	'UI:Button:RemoveImage' => 'Afbeelding verwijderen',
	'UI:Button:Rename' => ' Hernoem... ',
	'UI:Button:ResetImage' => 'Vorige afbeelding herstellen',
	'UI:Button:ResetPassword' => ' Stel wachtwoord opnieuw in ',
	'UI:Button:Restart' => ' |<< Herstarten ',
	'UI:Button:Save' => 'Opslaan',
	'UI:Button:SaveAnd' => 'Opslaan en %1$s',
	'UI:Button:Search' => ' Zoek ',
	'UI:Button:SearchInHierarchy' => ' Zoek in hiërarchie ',
	'UI:Button:Send' => 'Verzenden',
	'UI:Button:SendAnd' => 'Verzend en %1$s',
	'UI:Button:SimulateImport' => ' Simuleer de Import ',
	'UI:Button:Test' => 'Test!',
	'UI:Button:UploadImage' => 'Afbeelding uploaden',
	'UI:Button:Wait' => 'Even geduld terwijl de velden vernieuwd worden',
	'UI:CSVExport:AdvancedMode' => 'Geavanceerde mode',
	'UI:CSVExport:AdvancedMode+' => 'In geavanceerde mode worden verscheidene kolommen toegevoegd aan de export: id van het object, id van de externe codes en hun reconciliation-attributen.',
	'UI:CSVExport:LostChars' => 'Tekstcoderingsprobleem',
	'UI:CSVExport:LostChars+' => 'Het gedownloade bestand zal worden gecodeerd in %1$s. '.ITOP_APPLICATION_SHORT.' heeft een aantal karakters gedetecteerd die niet compatibel zijn met dit formaat. Deze karakters zullen worden vervangen door een ander karakter (bijvoorbeeld karakters met accent kunnen het accent verliezen), of ze zullen worden verwijderd. Je kan data kopiëren en plakken van jouw webbrowser. Ook kan je de beheerder contacteren om de codes te veranderen (Zie parameter \'csv_file_default_charset\').',
	'UI:CSVImport:AdvancedMode' => 'Geavanceerde mode',
	'UI:CSVImport:AdvancedMode+' => 'In geavanceerde mode kan de "id" (primaire sleutel (key)) van de objecten gebruikt worden om deze te updaten en te hernoemen. De kolom "id" (indien beschikbaar) kan alleen worden gebruikt als zoekcriterium en kan niet worden gecombineerd met andere zoekcriteria.',
	'UI:CSVImport:AlertIncompleteMapping' => 'Selecteer een mapping voor ieder veld',
	'UI:CSVImport:AlertMultipleMapping' => 'Zorg dat er voor elk veld slechts één mapping is',
	'UI:CSVImport:AlertNoSearchCriteria' => 'Selecteer tenminste een zoekcriterium.',
	'UI:CSVImport:CSVDataPreview' => 'CSV-voorbeeld',
	'UI:CSVImport:ClassesSelectOne' => '-- selecteer een --',
	'UI:CSVImport:Column' => 'Kolom %1$s',
	'UI:CSVImport:CommentsAndHeader' => 'Opmerkingen en kolomtitel',
	'UI:CSVImport:CustomDateTimeFormat' => 'Aangepast formaat: %1$s',
	'UI:CSVImport:CustomDateTimeFormatTooltip' => 'Beschikbare variabelen:<table>
	<tr><td>Y</td><td>jaar (4 cijfers, bv. 2016)</td></tr>
	<tr><td>y</td><td>jaar (2 cijfers, bv. 16 voor 2016)</td></tr>
	<tr><td>m</td><td>maand (2 cijfers, bv. 01..12)</td></tr>
	<tr><td>n</td><td>maand (1 of 2 cijfers zonder 0 ervoor, bv. 1..12)</td></tr>
	<tr><td>d</td><td>dag (2 cijfers, bv. 01..31)</td></tr>
	<tr><td>j</td><td>dag (1 of 2 cijfers zonder 0 ervoor, bv. 1..31)</td></tr>
	<tr><td>H</td><td>uur (24 uur, 2 cijfers, bv. 00..23)</td></tr>
	<tr><td>h</td><td>uur (12 uur, 2 cijfers, bv. 01..12)</td></tr>
	<tr><td>G</td><td>uur (24 uur, 1 or 2 cijfers zonder 0 ervoor, bv. 0..23)</td></tr>
	<tr><td>g</td><td>uur (12 uur, 1 or 2 cijfers zonder 0 ervoor, bv. 1..12)</td></tr>
	<tr><td>a</td><td>uur, am of pm (kleine letters)</td></tr>
	<tr><td>A</td><td>uur, AM of PM (grote letters)</td></tr>
	<tr><td>i</td><td>minuten (2 cijfers, bv. 00..59)</td></tr>
	<tr><td>s</td><td>secondn (2 cijfers, bv. 00..59)</td></tr>
	</table>',
	'UI:CSVImport:DataLine1' => 'Dataregel 1',
	'UI:CSVImport:DataLine2' => 'Dataregel 2',
	'UI:CSVImport:DateAndTimeFormats' => 'Datum- en tijdformaat',
	'UI:CSVImport:DefaultDateTimeFormat_Format_Example' => 'Standaardformaat: %1$s (bv. %2$s)',
	'UI:CSVImport:Encoding' => 'Tekstencodering',
	'UI:CSVImport:ErrorExtendedAttCode' => 'Interne fout: "%1$s" is een incorrecte code omdat "%2$s" geen externe sleutel (key) van klasse "%3$s" is',
	'UI:CSVImport:ErrorOnlyOneColumn' => 'Fout: De data bevat slechts één kolom. Is het juiste scheidingsteken geselecteerd?',
	'UI:CSVImport:FieldName' => 'Veld %1$d',
	'UI:CSVImport:HeaderFields' => 'Velden',
	'UI:CSVImport:HeaderMappings' => 'Mappings',
	'UI:CSVImport:HeaderSearch' => 'Zoek?',
	'UI:CSVImport:LinesNotImported' => 'Regels die niet konden worden geladen:',
	'UI:CSVImport:LinesNotImported+' => 'De volgende regels zijn niet geïmporteerd omdat ze fouten bevatten',
	'UI:CSVImport:MappingNotApplicable' => '-- Negeer dit veld --',
	'UI:CSVImport:MappingSelectOne' => '-- Selecteer --',
	'UI:CSVImport:NoData' => 'Lege dataset..., voeg data toe',
	'UI:CSVImport:ObjectsHadErrors' => 'bij %1$d objecten(s) traden fouten op.',
	'UI:CSVImport:ObjectsRemainedUnchanged' => '%1$d objecten(s) zijn onveranderd gebleven.',
	'UI:CSVImport:ObjectsWereAdded' => '%1$d objecten(s) zijn toegevoegd.',
	'UI:CSVImport:ObjectsWereModified' => '%1$d objecten(s) zijn aangepast.',
	'UI:CSVImport:ObjectsWillBeAdded' => '%1$d objecten(s) zullen worden toegevoegd.',
	'UI:CSVImport:ObjectsWillBeModified' => '%1$d objecten(s) zullen worden aangepast.',
	'UI:CSVImport:ObjectsWillHaveErrors' => '%1$d objecten(s) zullen fouten bevatten.',
	'UI:CSVImport:ObjectsWillStayUnchanged' => '%1$d objecten(s) zullen onveranderd blijven.',
	'UI:CSVImport:PasteData' => 'Plak data om te importeren:',
	'UI:CSVImport:PickClassForTemplate' => 'Kies sjabloon om te downloaden: ',
	'UI:CSVImport:QualifierDoubleQuote+' => '" (dubbele quote)',
	'UI:CSVImport:QualifierOther' => 'anders:',
	'UI:CSVImport:QualifierSimpleQuote+' => '\' (enkele quote)',
	'UI:CSVImport:SelectAClassFirst' => 'Om de mapping te configureren, moet je eerst een klasse selecteren.',
	'UI:CSVImport:SelectClass' => 'Selecteer de klasse om te importeren:',
	'UI:CSVImport:SelectFile' => 'Selecteer het bestand om te importeren:',
	'UI:CSVImport:SeparatorCharacter' => 'Scheidingsteken:',
	'UI:CSVImport:SeparatorComma+' => ', (komma)',
	'UI:CSVImport:SeparatorOther' => 'ander:',
	'UI:CSVImport:SeparatorSemicolon+' => '; (puntkomma)',
	'UI:CSVImport:SeparatorTab+' => 'tab',
	'UI:CSVImport:Skip_N_LinesAtTheBeginning' => 'Sla %1$s regels aan het begin van het bestand over',
	'UI:CSVImport:Tab:CopyPaste' => 'Kopieer en plak data',
	'UI:CSVImport:Tab:LoadFromFile' => 'Vanuit bestand importeren',
	'UI:CSVImport:Tab:Templates' => 'Sjablonen',
	'UI:CSVImport:TextQualifierCharacter' => 'Teken dat rond tekst staat:',
	'UI:CSVImport:TreatFirstLineAsHeader' => 'Eerste regel bevat kolomtitels (kolomkop)',
	'UI:CSVImport:ViewAllAmbiguousValues' => 'Bekijk alle dubbelzinnige waarden',
	'UI:CSVImport:ViewAllPossibleValues' => 'Bekijk alle mogelijke waarden',
	'UI:CSVImport:idField' => 'id (Primaire sleutel (key))',
	'UI:CSVImportConfirmMessage' => 'Weet je zeker dat je dit wilt doen?',
	'UI:CSVImportConfirmTitle' => 'Bevestig de actie',
	'UI:CSVImportCreated_items' => 'Aangemaakt: %1$d',
	'UI:CSVImportError_items' => 'Fouten: %1$d',
	'UI:CSVImportModified_items' => 'Bewerkt: %1$d',
	'UI:CSVImportUnchanged_items' => 'Onveranderd: %1$d',
	'UI:CSVReport-Icon-Created' => 'Aangemaakt',
	'UI:CSVReport-Icon-Error' => 'Fout',
	'UI:CSVReport-Icon-Missing' => 'Ontbrekend',
	'UI:CSVReport-Icon-Modified' => 'Aangepast',
	'UI:CSVReport-Icon-Unchanged' => 'Onveranderd',
	'UI:CSVReport-Object-Ambiguous' => 'Onduidelijk: %1$s',
	'UI:CSVReport-Object-Created' => 'Object aangemaakt',
	'UI:CSVReport-Object-Error' => 'Fout: %1$s',
	'UI:CSVReport-Object-MissingToUpdate' => 'Ontbrekend object: zal worden aangepast',
	'UI:CSVReport-Object-MissingUpdated' => 'Ontbrekend object: werd aangepast',
	'UI:CSVReport-Object-ToCreate' => 'Object zal worden aangemaakt',
	'UI:CSVReport-Row-Created' => 'gemaakt',
	'UI:CSVReport-Row-Disappeared' => 'verdwenen, %1$d rijen aangepast',
	'UI:CSVReport-Row-Issue' => 'Probleem: %1$s',
	'UI:CSVReport-Row-Issue-Ambiguous' => 'Onduidelijke verbetering',
	'UI:CSVReport-Row-Issue-Attribute' => 'Onverwachte attribuutwaarden',
	'UI:CSVReport-Row-Issue-DateFormat' => 'Verkeerde datumformaat',
	'UI:CSVReport-Row-Issue-ExpectedDateFormat' => 'Verwacht formaat: %1$s',
	'UI:CSVReport-Row-Issue-Inconsistent' => 'Attributen komen niet met elkaar overeeen: %1$s',
	'UI:CSVReport-Row-Issue-Internal' => 'Interne fout: %1$s, %2$s',
	'UI:CSVReport-Row-Issue-MissingExtKey' => 'Kon niet worden aangemaakt door het ontbreken van externe code(s): %1$s',
	'UI:CSVReport-Row-Issue-Reconciliation' => 'Verbeteren mislukt',
	'UI:CSVReport-Row-Unchanged' => 'onveranderd',
	'UI:CSVReport-Row-Updated' => ' %1$d rijen aangepast',
	'UI:CSVReport-Stats-Created' => '%1$.0f %% van de geladen objecten zullen worden gemaakt',
	'UI:CSVReport-Stats-Errors' => '%1$.0f %% van de geladen objecten bevatten fouten en zullen worden genegeerd',
	'UI:CSVReport-Stats-Modified' => '%1$.0f %% zullen worden aangepast.',
	'UI:CSVReport-Value-Ambiguous' => 'Onduidelijk: gevonden %1$s objecten',
	'UI:CSVReport-Value-ChangeIssue' => '\'%1$s\' is een ongeldige waarde',
	'UI:CSVReport-Value-Issue-AllowedValues' => 'Toegestane waarde(n) voor \'%1$s\': %2$s',
	'UI:CSVReport-Value-Issue-Format' => 'Input %1$s verwerken mislukt',
	'UI:CSVReport-Value-Issue-FoundMany' => ' %1$d Matches gevonden',
	'UI:CSVReport-Value-Issue-NoMatch' => 'Onverwachte waarde voor attribuut \'%1$s\': geen match gevonden, controleer spelling',
	'UI:CSVReport-Value-Issue-NotFound' => 'Object niet gevonden',
	'UI:CSVReport-Value-Issue-Null' => 'Null niet toegestaan',
	'UI:CSVReport-Value-Issue-Readonly' => 'Het attribuut \'%1$s\' is alleen-lezen en kan niet worden aangepast (huidige waarde: %2$s,voorgestelde waarde: %3$s)',
	'UI:CSVReport-Value-Issue-Unknown' => 'Onverwachte waarde voor attribuut \'%1$s\': %2$s',
	'UI:CSVReport-Value-Missing' => 'Ontbrekende verplichte waarde',
	'UI:CSVReport-Value-Modified' => 'Aangepast',
	'UI:CSVReport-Value-NoMatch' => 'Geen match voor waarde \'%1$s\'',
	'UI:CSVReport-Value-NoMatch-NoObject' => 'Er zijn geen \'%1$s\' objecten',
	'UI:CSVReport-Value-NoMatch-NoObject-ForCurrentUser' => 'Er zijn geen \'%1$s\' objecten gevonden met je huidige profiel',
	'UI:CSVReport-Value-NoMatch-PossibleValues' => 'Some possible \'%1$s\' value(s): %2$s~~',
	'UI:CSVReport-Value-NoMatch-SomeObjectNotVisibleForCurrentUser' => 'There are some \'%1$s\' objects not visible with your current profile~~',
	'UI:CSVReport-Value-SetIssue' => 'Ongeldige waarde voor attribuut',
	'UI:CancelConfirmationMessage' => 'Je zult jouw aanpassingen verliezen. Wil je toch doorgaan?',
	'UI:CaseLog:Header_Date_UserName' => '%1$s - %2$s:',
	'UI:CaseLog:InitialValue' => 'Beginwaarde:',
	'UI:CaseLogTypeYourTextHere' => 'Typ jouw tekst hier:',
	'UI:ChangeManagementMenu' => 'Change Management',
	'UI:ChangeManagementMenu+' => 'Change Management',
	'UI:ChangeManagementMenu:Title' => 'Overzicht changes',
	'UI:ChangeMgmtMenuOverview:Title' => 'Dashboard voor Change Management',
	'UI:ChangePwdMenu' => 'Verander wachtwoord',
	'UI:ChangesLogTitle' => 'Changes log (%1$d):',
	'UI:Class_Object_NotUpdated' => 'Geen verandering waargenomen, %1$s (%2$s) is <strong>niet</strong> aangepast.',
	'UI:Class_Object_Updated' => '%1$s (%2$s) aangepast.',
	'UI:ClickToCreateNew' => 'Maak een %1$s aan',
	'UI:ClonePageTitle_Object_Class' => ITOP_APPLICATION_SHORT.' - Kloon %1$s - %2$s aanpassing',
	'UI:CloneTitle_Class_Object' => 'Klonen van %1$s: <span class="hilite">%2$s</span>',
	'UI:CollapseList' => 'Inklappen',
	'UI:ColumnsAndSortOrder' => 'Kolommen en sorteervolgorde:',
	'UI:Combo:SelectValue' => '--- selecteer een waarde ---',
	'UI:ConcurrentLockKilled' => 'De vergrendeling voor gelijktijdige gebruikers is opgeheven.',
	'UI:ConfigMgmtMenuOverview:Title' => 'Dashboard voor Configuratie Management',
	'UI:ConfigurationManagementMenu' => 'Configuratie Management',
	'UI:ConfigurationManagementMenu+' => 'Configuratie Management',
	'UI:ConfigurationManagementMenu:Title' => 'Infrastructuuroverzicht',
	'UI:ConfigureThisList' => 'Configureer deze lijst...',
	'UI:ContactsMenu' => 'Contacten',
	'UI:ContactsMenu+' => 'Contacten',
	'UI:ContactsMenu:Title' => 'Overzicht van contacten',
	'UI:CountOfObjects' => '%1$d objecten voldoen aan de criteria.',
	'UI:CountOfResults' => '%1$d object(en)',
	'UI:Create_Class_InState' => 'Maak %1$s aan in deze fase: ',
	'UI:CreationPageTitle_Class' => ITOP_APPLICATION_SHORT.' - %1$s aanmaken',
	'UI:CreationTitle_Class' => '%1$s aanmaken',
	'UI:CurrentObjectIsLockedBy_User' => 'Het object is vergrendeld omdat het momenteel aangepast wordt door %1$s.',
	'UI:CurrentObjectIsLockedBy_User_Explanation' => 'Het object wordt aangepast door %1$s. Jouw wijzigingen kunnen niet opgeslagen worden omdat ze een conflict kunnen veroorzaken.',
	'UI:CurrentObjectIsSoftLockedBy_User' => 'Het object wordt aangepast door %1$s. Je kan je wijzigingen doorvoeren wanneer men klaar is.',
	'UI:CurrentObjectLockExpired' => 'De vergrendeling om gelijktijdige wijzigingen te voorkomen, is opgeheven.',
	'UI:CurrentObjectLockExpired_Explanation' => 'De vergrendeling om gelijktijdige wijzigingen te voorkomen, is opgeheven. Je kan je wijzigingen niet meer opslaan aangezien andere gebruikers ondertussen dit object kunnen aanpassen.',
	'UI:Dashboard:Actions' => 'Dashboard acties',
	'UI:Dashboard:CreateCustom' => 'Maak aangepaste versie...',
	'UI:Dashboard:DeleteCustom' => 'Verwijder aangepaste versie...',
	'UI:Dashboard:Edit' => 'Bewerk deze pagina...',
	'UI:Dashboard:EditCustom' => 'Bewerk aangepaste versie...',
	'UI:Dashboard:NotUpToDateUntilContainerSaved' => 'Dit dashboard toont informatie die nog geen rekening houdt met de wijzigingen die nu gemaakt worden.',
	'UI:Dashboard:Revert' => 'Herstel de originele versie...',
	'UI:Dashboard:RevertConfirm' => 'Alle bewerkingen die zijn gemaakt aan de originele versie zullen verloren gaan. Bevestig dat je wilt doorgaan.',
	'UI:DashboardEdit:Apply' => 'Opslaan',
	'UI:DashboardEdit:AutoReload' => 'Automatisch vernieuwen',
	'UI:DashboardEdit:AutoReloadSec' => 'Interval voor het automatisch vernieuwen (seconden)',
	'UI:DashboardEdit:AutoReloadSec+' => 'Het toegestane minimum is 5 seconden',
	'UI:DashboardEdit:DashboardTitle' => 'Titel',
	'UI:DashboardEdit:DashletProperties' => 'Eigenschappen van dashlet',
	'UI:DashboardEdit:Dashlets' => 'Beschikbare Dashlets',
	'UI:DashboardEdit:Layout' => 'Layout',
	'UI:DashboardEdit:Properties' => 'Eigenschappen van dashboard',
	'UI:DashboardEdit:Revert' => 'Herstel',
	'UI:DashboardEdit:Title' => 'Dashboard editor',
	'UI:DashletBadge:Description' => 'Object Icoon met nieuw/zoek naar',
	'UI:DashletBadge:Label' => 'Badge',
	'UI:DashletBadge:Prop-Class' => 'Klasse',
	'UI:DashletCreation:Dashboard' => 'Dashboard',
	'UI:DashletCreation:DashletType' => 'Soort dashlet',
	'UI:DashletCreation:EditNow' => 'Bewerk het dashboard',
	'UI:DashletCreation:Title' => 'Maak een nieuwe Dashlet aan',
	'UI:DashletGroupBy:MissingGroupBy' => 'Selecteer het veld waarop de objecten gegroepeerd moeten worden',
	'UI:DashletGroupBy:Order:asc' => 'Oplopend',
	'UI:DashletGroupBy:Order:desc' => 'Aflopend',
	'UI:DashletGroupBy:Prop-Function' => 'Groepeerfunctie',
	'UI:DashletGroupBy:Prop-FunctionAttribute' => 'Functie-attribuut',
	'UI:DashletGroupBy:Prop-GroupBy' => 'Groepeer aan de hand van...',
	'UI:DashletGroupBy:Prop-GroupBy:DayOfMonth' => 'Dag van de maand voor %1$s',
	'UI:DashletGroupBy:Prop-GroupBy:DayOfWeek' => 'Dag van de week voor %1$s',
	'UI:DashletGroupBy:Prop-GroupBy:Hour' => 'Uur %1$s (0-23)',
	'UI:DashletGroupBy:Prop-GroupBy:Month' => 'Maand %1$s (1 - 12)',
	'UI:DashletGroupBy:Prop-GroupBy:Select-DayOfMonth' => '%1$s (dag van de maand)',
	'UI:DashletGroupBy:Prop-GroupBy:Select-DayOfWeek' => '%1$s (dag van de week)',
	'UI:DashletGroupBy:Prop-GroupBy:Select-Hour' => '%1$s (uur)',
	'UI:DashletGroupBy:Prop-GroupBy:Select-Month' => '%1$s (maand)',
	'UI:DashletGroupBy:Prop-Limit' => 'Limiet',
	'UI:DashletGroupBy:Prop-OrderDirection' => 'Volgorde',
	'UI:DashletGroupBy:Prop-OrderField' => 'Sorteren op',
	'UI:DashletGroupBy:Prop-Query' => 'Query',
	'UI:DashletGroupBy:Prop-Style' => 'Stijl',
	'UI:DashletGroupBy:Prop-Title' => 'Titel',
	'UI:DashletGroupByBars:Description' => 'Staafdiagram',
	'UI:DashletGroupByBars:Label' => 'Staafdiagram',
	'UI:DashletGroupByPie:Description' => 'Cirkeldiagram',
	'UI:DashletGroupByPie:Label' => 'Cirkeldiagram',
	'UI:DashletGroupByTable:Description' => 'Lijst (Gegroepeerd aan de hand van een veld)',
	'UI:DashletGroupByTable:Label' => 'Groepeer aan de hand van (tabel)',
	'UI:DashletHeaderDynamic:Description' => 'Kolom met statistieken (gegroepeerd aan de hand van...)',
	'UI:DashletHeaderDynamic:Label' => 'Kolom met gegevens',
	'UI:DashletHeaderDynamic:Prop-GroupBy' => 'Gegroepeerd aan de hand van',
	'UI:DashletHeaderDynamic:Prop-Icon' => 'Icoon',
	'UI:DashletHeaderDynamic:Prop-Query' => 'Query',
	'UI:DashletHeaderDynamic:Prop-Subtitle' => 'Subtitel',
	'UI:DashletHeaderDynamic:Prop-Subtitle:Default' => 'Contacten',
	'UI:DashletHeaderDynamic:Prop-Title' => 'Titel',
	'UI:DashletHeaderDynamic:Prop-Title:Default' => 'Contacten',
	'UI:DashletHeaderDynamic:Prop-Values' => 'Waarden',
	'UI:DashletHeaderStatic:Description' => 'Geeft een horizontale separator weer',
	'UI:DashletHeaderStatic:Label' => 'Kolom',
	'UI:DashletHeaderStatic:Prop-Icon' => 'Icoon',
	'UI:DashletHeaderStatic:Prop-Title' => 'Titel',
	'UI:DashletHeaderStatic:Prop-Title:Default' => 'Contacten',
	'UI:DashletObjectList:Description' => 'Objectlijst dashlet',
	'UI:DashletObjectList:Label' => 'Objectlijst',
	'UI:DashletObjectList:Prop-Menu' => 'Menu',
	'UI:DashletObjectList:Prop-Query' => 'Query',
	'UI:DashletObjectList:Prop-Title' => 'Titel',
	'UI:DashletPlainText:Description' => 'Gewone tekst (niet geformatteerd)',
	'UI:DashletPlainText:Label' => 'Tekst',
	'UI:DashletPlainText:Prop-Text' => 'Tekst',
	'UI:DashletPlainText:Prop-Text:Default' => 'Voeg hier wat tekst toe...',
	'UI:DashletProxy:Description' => 'Proxy dashlet',
	'UI:DashletProxy:Label' => 'Proxy',
	'UI:DashletProxy:Prop-XMLConfiguration' => 'Configuratie (getoond als ruwe XML)',
	'UI:DashletProxy:RenderNoDataText:Edit' => 'Geen voorbeeld mogelijk van deze dashlet van een derde partij (klasse "%1$s").',
	'UI:DashletUnknown:Description' => 'Onbekende dashlet (mogelijk verwijderd)',
	'UI:DashletUnknown:Label' => 'Onbekend',
	'UI:DashletUnknown:Prop-XMLConfiguration' => 'Configuratie (getoond als ruwe XML)',
	'UI:DashletUnknown:RenderNoDataText:Edit' => 'Geen voorbeeld mogelijk van deze dashlet (klasse "%1$s").',
	'UI:DashletUnknown:RenderText:Edit' => 'Kan deze dashlet niet weergeven (klasse "%1$s"). Controleer bij je '.ITOP_APPLICATION_SHORT.'-beheerder of dit nog beschikbaar is.',
	'UI:DashletUnknown:RenderText:View' => 'Kan deze dashlet niet weergeven.',
	'UI:DeadlineMissedBy_duration' => 'Gemist op %1$s',
	'UI:Deadline_Days_Hours_Minutes' => '%1$dd %2$dh %3$dmin',
	'UI:Deadline_Hours_Minutes' => '%1$dh %2$dmin',
	'UI:Deadline_LessThan1Min' => '< 1 min',
	'UI:Deadline_Minutes' => '%1$d min',
	'UI:Delect:Confirm_Count_ObjectsOf_Class' => 'Bevestig dat je de volgende %1$d objecten van klasse %2$s wilt verwijderen.',
	'UI:Delect:Confirm_Object' => 'Bevestig dat je  %1$s wil verwijderen.',
	'UI:Delete:AutomaticResetOf_Fields' => 'automatische reset van veld(en): %1$s',
	'UI:Delete:AutomaticallyDeleted' => 'automatisch verwijderd',
	'UI:Delete:CannotDeleteBecause' => 'Kon niet worden verwijderd: %1$s',
	'UI:Delete:CannotUpdateBecause_Issue' => 'Zou automatisch moeten geüpdatet worden, maar: %1$s',
	'UI:Delete:CleaningUpRefencesTo_Object' => 'Bezig met het opschonen van alle verwijzingen naar %1$s...',
	'UI:Delete:CleaningUpRefencesTo_Several_ObjectsOf_Class' => 'Bezig met het opschonen van %1$d objecten van klasse "%2$s"...',
	'UI:Delete:ConfirmDeletionOf_Count_ObjectsOf_Class' => 'Verwijderen van %1$d objecten van klasse "%2$s"',
	'UI:Delete:ConfirmDeletionOf_Name' => 'Verwijderen van %1$s',
	'UI:Delete:Consequence+' => 'Wat er zal gebeuren',
	'UI:Delete:Count_Objects/LinksReferencingTheObjects' => '%1$d objecten/links verwijzen naar sommige objecten die verwijderd worden',
	'UI:Delete:Count_Objects/LinksReferencing_Object' => '%1$d objecten/links verwijzen naar %2$s',
	'UI:Delete:Deleted' => 'verwijderd',
	'UI:Delete:Done+' => 'Wat er is gebeurd...',
	'UI:Delete:MustBeDeletedManually' => 'Moet handmatig verwijderd worden',
	'UI:Delete:MustBeDeletedManuallyButNotPossible' => 'Moet handmatig verwijderd worden, maar dat is niet mogelijk: %1$s',
	'UI:Delete:NotAllowedToDelete' => 'Je bent niet gemachtigd om dit object te verwijderen',
	'UI:Delete:NotAllowedToUpdate_Fields' => 'Je bent niet gemachtigd om het/de volgende veld(en) aan te passen: %1$s',
	'UI:Delete:PleaseDoTheManualOperations' => 'Verricht eerst de handmatige handelingen die hierboven staan voordat je dit object verwijdert',
	'UI:Delete:ReferencesMustBeDeletedToEnsureIntegrity' => 'Elke verdere verwijzing moet verwijderd worden om de integriteit van de database te verzekeren',
	'UI:Delete:ShouldBeDeletedAtomaticallyButNotPossible' => 'Zou automatisch moeten verwijderd worden, maar dat is niet mogelijk: %1$s',
	'UI:Delete:SorryDeletionNotAllowed' => 'Sorry, je bent niet gemachtigd om dit object te verwijderen. Voor uitgebreide uitleg, zie hierboven',
	'UI:Delete:WillAutomaticallyUpdate_Fields' => 'Zal automatisch aangepast worden (reset: %1$s)',
	'UI:Delete:WillBeDeletedAutomatically' => 'Zal automatisch verwijderd worden',
	'UI:Delete:_Name_Class_Deleted' => '%1$s - %2$s verwijderd',
	'UI:Details+' => 'Details',
	'UI:DetailsPageTitle' => ITOP_APPLICATION_SHORT.' - %1$s - %2$s details',
	'UI:DisconnectedDlgMessage' => 'Je bent afgemeld. Je moet je opnieuw aanmelden om de toepassing verder te gebruiken.',
	'UI:DisconnectedDlgTitle' => 'Waarschuwing!',
	'UI:DisplayAll' => 'Toon alles',
	'UI:DisplayThisMessageAtStartup' => 'Geef dit bericht weer bij het opstarten',
	'UI:Display_X_ItemsPerPage_prefix' => 'Geef',
	'UI:Display_X_ItemsPerPage_suffix' => 'items per pagina weer',
	'UI:Document:NoPreview' => 'Er is geen voorbeeld beschikbaar voor dit soort document',
	'UI:Document:OpenInNewWindow:Download' => 'Open in nieuw venster: %1$s, Download: %2$s',
	'UI:Download-CSV' => 'Download %1$s',
	'UI:DownloadDocument_' => 'Download',
	'UI:DurationForm_Days_Hours_Minutes_Seconds' => '%1$s dagen %2$s uren %3$s minuten %4$s seconden',
	'UI:Edit:SearchQuery' => 'Kies een vooraf gedefinieerde query',
	'UI:Edit:TestQuery' => 'Test query',
	'UI:ElementsDisplayed' => 'Filtering',
	'UI:EmptyChangesLogTitle' => 'Changes log is leeg',
	'UI:Error:1ParametersMissing' => 'Fout: de volgende parameter moet worden opgegeven voor deze actie: %1$s.',
	'UI:Error:2ParametersMissing' => 'Fout: de volgende parameters moeten worden opgegeven voor deze actie: %1$s and %2$s.',
	'UI:Error:3ParametersMissing' => 'Fout: de volgende parameters moeten worden opgegeven voor deze actie: %1$s, %2$s and %3$s.',
	'UI:Error:4ParametersMissing' => 'Fout: de volgende parameters moeten worden opgegeven voor deze actie: %1$s, %2$s, %3$s and %4$s.',
	'UI:Error:ActionNotAllowed' => 'Je bent niet gemachtigd om deze actie uit te voeren.',
	'UI:Error:AnErrorOccuredWhileRunningTheQuery_Message' => 'Er trad een fout op tijdens het uitvoeren van deze query: %1$s',
	'UI:Error:BulkDeleteNotAllowedOn_Class' => 'Je bent niet gemachtigd om meerdere objecten in klasse "%1$s") in één keer te verwijderen.',
	'UI:Error:BulkModifyNotAllowedOn_Class' => 'Je bent niet gemachtigd om meerdere objecten (klasse %1$s) in één keer aan te passen',
	'UI:Error:CannotDeleteBecause' => 'Dit object kon niet worden verwijderd. Reden: %1$s',
	'UI:Error:CannotDeleteBecauseManualOpNeeded' => 'Dit object kon niet worden verwijderd omdat er eerst enkele handmatige handelingen moeten worden verricht',
	'UI:Error:CannotDeleteBecauseOfDepencies' => 'Dit object kon niet worden verwijderd omdat er eerst enkele handmatige handelingen moeten worden verricht',
	'UI:Error:CannotWriteToTmp_Dir' => 'Niet mogelijk om het tijdelijke bestand naar een tijdelijke map weg te schrijven. upload_tmp_dir = "%1$s".',
	'UI:Error:DeleteNotAllowedOn_Class' => 'Je bent niet gemachtigd om objecten van de klasse "%1$s" te verwijderen',
	'UI:Error:IncorrectLinkDefinition_LinkedClass_Class' => 'Incorrecte linkdefinitie: de klasse %1$s om objecten te beheren werd niet gevonden als externe sleutel (key) in de klasse %2$s',
	'UI:Error:IncorrectOQLQuery_Message' => 'Fout: incorrecte OQL-query: %1$s',
	'UI:Error:InvalidDashboard' => 'Fout: ongeldig dashboard',
	'UI:Error:InvalidDashboardFile' => 'Fout: ongeldig dashboard-bestand',
	'UI:Error:InvalidGroupByFields' => 'Ongeldige lijst van velden waarop gegroepeerd moet worden: "%1$s".',
	'UI:Error:InvalidToken' => 'Fout: de gevraagde bewerking werd al uitgevoerd (CSRF token niet gevonden)',
	'UI:Error:Invalid_Stimulus_On_Object_In_State' => 'Fout: ongeldige stimulus "%1$s" op object %2$s in fase "%3$s".',
	'UI:Error:MaintenanceMode' => 'Toepassing is momenteel in onderhoud',
	'UI:Error:MaintenanceTitle' => 'Onderhoud',
	'UI:Error:MandatoryTemplateParameter_group_by' => 'Parameter "group_by" is verplicht. Controleer de definitie van het weergavesjabloon.',
	'UI:Error:MandatoryTemplateParameter_object_id' => 'Parameter "object_id" is verplicht als "link_attr" is opgegeven. Controleer de definitie van het weergavesjabloon.',
	'UI:Error:MandatoryTemplateParameter_target_attr' => 'Parameter "target_attr" is verplicht als "link_attr" is opgegeven. Controleer de definitie van het weergavesjabloon.',
	'UI:Error:NoTmpDir' => 'De tijdelijke opslagruimte is niet gedefinieerd.',
	'UI:Error:NotEnoughRightsToDelete' => 'Dit object kon niet worden verwijderd omdat de huidige gebruiker niet de juiste rechten heeft',
	'UI:Error:ObjectAlreadyCloned' => 'Fout: het object is al gekloond!',
	'UI:Error:ObjectAlreadyCreated' => 'Fout: het object is al aangemaakt!',
	'UI:Error:ObjectAlreadyUpdated' => 'Fout: het object is al aangepast.',
	'UI:Error:ObjectCannotBeUpdated' => 'Fout: het object kan niet worden aangepast.',
	'UI:Error:Object_Class_Id_NotFound' => 'Object: %1$s:%2$d niet gevonden',
	'UI:Error:ObjectsAlreadyDeleted' => 'Fout: objecten zijn al verwijderd',
	'UI:Error:ReadNotAllowedOn_Class' => 'Je bent niet gemachtigd om objecten van de klasse "%1$s" te bekijken',
	'UI:Error:SMTP:UnknownVendor' => 'OAuth SMTP provider %1$s bestaat niet (email_transport_smtp.oauth.provider)',
	'UI:Error:SaveFailed' => 'Het object kan niet bewaard worden:',
	'UI:Error:UnsupportedStyleOfBlock' => 'Fout: de stijl "%1$s" wordt niet ondersteund voor dit blok.',
	'UI:Error:UploadFailedUnknownCause_Code' => 'Uploaden van bestand mislukt, oorzaak onbekend. (Foutcode = "%1$s").',
	'UI:Error:UploadStoppedByExtension_FileName' => 'Upload gestopt door bestandsextensie. (Oorspronkelijke bestandsnaam = "%1$s").',
	'UI:Error:UploadedFileTooBig' => 'Het geüploade bestand is te groot. De maximale grootte is %1$s. Contacteer jouw '.ITOP_APPLICATION_SHORT.'-beheerder om deze limiet aan te passen. (Controleer de PHP-configuratie voor "upload_max_filesize" en "post_max_size" op de server).',
	'UI:Error:UploadedFileTruncated.' => 'Het geüploade bestand is ingekort!',
	'UI:Error:WizardCircularReferenceInDependencies' => 'Fout: cirkelverwijzing in de afhankelijke variabelen tussen de velden. Controleer het datamodel.',
	'UI:ErrorPageTitle' => ITOP_APPLICATION_SHORT.' - Fout',
	'UI:Error_Details' => 'Fout: %1$s.',
	'UI:ExplainPrintable' => 'Klik op het %1$s-icoon om items te verbergen op de afdruk.<br/>Gebruik de "Afdrukvoorbeeld"-functie van je browser indien nodig.<br/>Opmerking: deze hoofding en andere weergave-opties zullen niet worden afgedrukt.',
	'UI:ExportDashBoard' => 'Exporteer naar een bestand',
	'UI:ExtField_AsRemoteField' => '%1$s (%2$s)',
	'UI:ExtKey_AsFriendlyName' => '%1$s (Herkenbare naam)',
	'UI:ExtKey_AsLink' => '%1$s (Link)',
	'UI:FailedToApplyStimuli' => 'De actie is mislukt.',
	'UI:FatalErrorMessage' => 'Fatale fout, '.ITOP_APPLICATION_SHORT.' kan niet doorgaan.',
	'UI:FavoriteLanguage' => 'Taal van de gebruikersinterface',
	'UI:FavoriteOrganizations' => 'Favoriete organisaties',
	'UI:FavoriteOrganizations+' => 'Duid in onderstaande lijst de organisaties aan die je wilt zien in de keuzelijst voor een snelle toegang. Dit is geen beveiligingsinstelling; objecten van elke organisatie zijn nog steed zichtbaar en toegankelijk door "Alle Organisaties" te selecteren in de keuzelijst.',
	'UI:FavoriteOtherSettings' => 'Overige instellingen',
	'UI:Favorites:Default_X_ItemsPerPage' => 'Standaardlengte: %1$s items per pagina',
	'UI:Favorites:SelectYourLanguage' => 'Selecteer jouw taal',
	'UI:Favorites:ShowObsoleteData' => 'Toon "Buiten dienst"-data',
	'UI:Favorites:ShowObsoleteData+' => 'Toon "Buiten dienst"-data in zoekresultaten en in keuzelijsten.',
	'UI:FillAllMandatoryFields' => 'Vul de verplichte velden in.',
	'UI:ForAllLists' => 'Standaard voor alle lijsten',
	'UI:Form:Property' => 'Eigenschap',
	'UI:Form:Value' => 'Waarde',
	'UI:FullTextSearchTitle_Text' => 'Resultaten voor "%1$s":',
	'UI:GroupBy:Count' => 'Aantal',
	'UI:GroupBy:Count+' => 'Aantal objecten',
	'UI:GroupBy:avg' => 'Gemiddelde',
	'UI:GroupBy:avg+' => 'Gemiddelde van %1$s',
	'UI:GroupBy:count' => 'Aantal',
	'UI:GroupBy:count+' => 'Aantal items',
	'UI:GroupBy:max' => 'Maximum',
	'UI:GroupBy:max+' => 'Maximum van %1$s',
	'UI:GroupBy:min' => 'Minimum',
	'UI:GroupBy:min+' => 'Minimum van %1$s',
	'UI:GroupBy:sum' => 'Som',
	'UI:GroupBy:sum+' => 'Som van %1$s',
	'UI:Help' => 'Help',
	'UI:HierarchyOf_Class' => 'Hierarchie van %1$s',
	'UI:History:BulkImportDetails' => 'Veranderingen volgend op CSV-import uitgevoerd op %1$s (door %2$s)',
	'UI:History:BulkImports' => 'Geschiedenis',
	'UI:History:BulkImports+' => 'Lijst van CSV-imports (nieuwste import eerst)',
	'UI:History:Changes' => 'Verandering',
	'UI:History:Changes+' => 'Veranderingen gemaakt aan object',
	'UI:History:Date' => 'Datum',
	'UI:History:Date+' => 'Datum van verandering',
	'UI:History:LastModified_On_By' => 'Laatst bewerkt op %1$s door %2$s.',
	'UI:History:StatsCreations' => 'Aangemaakt',
	'UI:History:StatsCreations+' => 'Aantal aangemaakte objecten',
	'UI:History:StatsDeletes' => 'Verwijderd',
	'UI:History:StatsDeletes+' => 'Aantal verwijderde objecten',
	'UI:History:StatsModifs' => 'Aangepast',
	'UI:History:StatsModifs+' => 'Aantal aangepaste objecten',
	'UI:History:User' => 'Gebruiker',
	'UI:History:User+' => 'Gebruiker die de verandering doorvoerde',
	'UI:HistoryTab' => 'Geschiedenis',
	'UI:ImportDashBoard' => 'Importeer vanuit een bestand',
	'UI:ImportDashboardText' => 'Selecteer een bestand van het dashboard om te importeren:',
	'UI:ImportDashboardTitle' => 'Importeer vanuit een bestand',
	'UI:IncidentMgmtMenuOverview:Title' => 'Dashboard voor Incident Management',
	'UI:InputFile:NoFileSelected' => 'Geen bestand geselecteerd',
	'UI:InputFile:SelectFile' => 'Selecteer een bestand',
	'UI:Label:AvailableObjects' => 'Beschikbare objecten: ',
	'UI:Label:SelectedObjects' => 'Geselecteerde objecten: ',
	'UI:Link_Class_Attributes' => '%1$s attributen',
	'UI:LinksWidget:Autocomplete+' => 'Typ de eerste 3 karakters...',
	'UI:ListConfigurationTitle' => 'Configuratie van lijst',
	'UI:Loading' => 'Laden...',
	'UI:LogOff:ClickHereToLoginAgain' => 'Klik hier om in te loggen',
	'UI:LogOff:ThankYou' => 'Bedankt voor het gebruiken van '.ITOP_APPLICATION,
	'UI:LogOffMenu' => 'Log uit',
	'UI:LoggedAsMessage' => 'Ingelogd als %1$s (%2$s)',
	'UI:LoggedAsMessage+Admin' => 'Ingelogd als %1$s (%2$s, Beheerder)',
	'UI:Login:About' => ITOP_APPLICATION,
	'UI:Login:ChangeYourPassword' => 'Verander jouw wachtwoord',
	'UI:Login:Error:AccessAdmin' => 'Alleen toegankelijk voor mensen met beheerdersrechten. Neem contact op met een '.ITOP_APPLICATION_SHORT.'-beheerder',
	'UI:Login:Error:AccessRestricted' => 'Geen toegang tot '.ITOP_APPLICATION_SHORT.'.Neem contact op met een '.ITOP_APPLICATION_SHORT.'-beheerder.',
	'UI:Login:Error:MultipleContactsHaveSameEmail' => 'Meerdere contacten hebben hetzelfde e-mailadres',
	'UI:Login:Error:NoValidProfiles' => 'Geen geldig profiel opgegeven',
	'UI:Login:Error:WrongOrganizationName' => 'Onbekende organisatie',
	'UI:Login:ForgotPwd' => 'Wachtwoord vergeten?',
	'UI:Login:ForgotPwdForm' => 'Wachtwoord vergeten',
	'UI:Login:ForgotPwdForm+' => ITOP_APPLICATION_SHORT.' kan je een e-mail sturen waarin de instructies voor het resetten van jouw account staan.',
	'UI:Login:IdentifyYourself' => 'Identificeer jezelf voordat je verder gaat',
	'UI:Login:IncorrectLoginPassword' => 'Ongeldige gebruikersnaam of wachtwoord, probeer opnieuw.',
	'UI:Login:IncorrectOldPassword' => 'Fout: het oude wachtwoord is incorrect',
	'UI:Login:NewPasswordPrompt' => 'Nieuw wachtwoord',
	'UI:Login:OldPasswordPrompt' => 'Oud wachtwoord',
	'UI:Login:PasswordChanged' => 'Wachtwoord met succes aangepast',
	'UI:Login:PasswordNotChanged' => 'Fout: Wachtwoord is hetzelfde!',
	'UI:Login:PasswordPrompt' => 'Wachtwoord',
	'UI:Login:ResetPassword' => 'Stuur nu!',
	'UI:Login:ResetPwdFailed' => 'E-mail sturen mislukt: %1$s',
	'UI:Login:RetypeNewPasswordPrompt' => 'Herhaal nieuwe wachtwoord',
	'UI:Login:RetypePwdDoesNotMatch' => 'Het nieuwe wachtwoord en de herhaling van het nieuwe wachtwoord komen niet overeen',
	'UI:Login:SeparatorOr' => 'Of',
	'UI:Login:Title' => 'Aanmelden in '.ITOP_APPLICATION_SHORT,
	'UI:Login:UserNamePrompt' => 'Gebruikersnaam',
	'UI:Login:Welcome' => 'Welkom in '.ITOP_APPLICATION_SHORT.'!',
	'UI:LoginAgain' => 'Opnieuw aanmelden',
	'UI:ManageObjectsOf_Class_LinkedWith_Class_Instance' => 'Manage %1$s objecten gelinkt met %2$s: %3$s',
	'UI:Menu:Actions' => 'Acties',
	'UI:Menu:Add' => 'Voeg toe...',
	'UI:Menu:AddToDashboard' => 'Voeg toe aan dashboard...',
	'UI:Menu:BulkDelete' => 'Verwijder...',
	'UI:Menu:BulkDelete_Class' => 'Verwijder %1$s objecten...',
	'UI:Menu:BulkDelete_Link' => 'Verwijder %1$s...',
	'UI:Menu:BulkDelete_Remote' => 'Verwijder %1$s...',
	'UI:Menu:CSVExport' => 'CSV Export...',
	'UI:Menu:Delete' => 'Verwijder...',
	'UI:Menu:EMail' => 'E-mail',
	'UI:Menu:ExportPDF' => 'Exporteer als PDF...',
	'UI:Menu:FilterList' => 'Display list with search criteria~~',
	'UI:Menu:KillConcurrentLock' => 'Verwijder de vergrendeling voor gelijktijdige gebruikers!',
	'UI:Menu:Manage' => 'Beheer...',
	'UI:Menu:Modify' => 'Bewerk...',
	'UI:Menu:ModifyAll' => 'Bewerk...',
	'UI:Menu:ModifyAll_Class' => 'Bewerk %1$s objecten...',
	'UI:Menu:ModifyAll_Link' => 'Bewerk %1$s...',
	'UI:Menu:ModifyAll_Remote' => 'Bewerk %1$s...',
	'UI:Menu:New' => 'Nieuw...',
	'UI:Menu:OtherActions' => 'Andere acties',
	'UI:Menu:OtherTransitions' => 'Andere overgangen',
	'UI:Menu:PrintableVersion' => 'Printvriendelijke versie',
	'UI:Menu:ShortcutList' => 'Maak een snelkoppeling aan...',
	'UI:Menu:Transitions' => 'Overgangen',
	'UI:Menu:View' => 'Bekijk dit object',
	'UI:Message:EmptyList:UseAdd' => 'De lijst is leeg, gebruik de "Voeg toe..." knop om elementen toe te voegen.',
	'UI:Message:EmptyList:UseSearchForm' => 'Gebruik het bovenstaande zoekveld om te zoeker naar objecten die je wilt toevoegen.',
	'UI:ModificationPageTitle_Object_Class' => ITOP_APPLICATION_SHORT.' - %1$s - %2$s aanpassing',
	'UI:ModificationTitle_Class_Object' => 'Aanpassen van %1$s: <span class="hilite">%2$s</span>',
	'UI:ModifiedObject' => 'Object is aangepast',
	'UI:ModifyAllPageTitle' => 'Bewerk alles',
	'UI:Modify_M_ObjectsOf_Class_OutOf_N' => 'Bezig met het aanpassen van %1$d objecten van klasse %2$s van de %3$d',
	'UI:Modify_N_ObjectsOf_Class' => 'Bezig met het aanpassen van %1$d objecten van klasse %2$s',
	'UI:Modify_ObjectsOf_Class' => 'Bewerken objectem van klasse %1$s',
	'UI:NavigateAwayConfirmationMessage' => 'Bewerkingen zullen worden genegeerd.',
	'UI:Newsroom:ConfigurationLink' => 'Configuratie',
	'UI:Newsroom:DisplayAtMost_X_Messages' => 'Toon maximaal %1$s berichten in het %2$s menu.',
	'UI:Newsroom:DisplayMessagesFor_Provider' => 'Bekijk berichten van %1$s',
	'UI:Newsroom:MarkAllAsRead' => 'Markeer alle berichten als gelezen',
	'UI:Newsroom:NoNewMessage' => 'Geen nieuw bericht',
	'UI:Newsroom:Preferences' => 'Voorkeuren voor Newsroom',
	'UI:Newsroom:Priority:1:Tooltip' => 'Critical~~',
	'UI:Newsroom:Priority:2:Tooltip' => 'Urgent~~',
	'UI:Newsroom:Priority:3:Tooltip' => 'Important~~',
	'UI:Newsroom:Priority:4:Tooltip' => 'Normal~~',
	'UI:Newsroom:ResetCache' => 'Maak cache leeg',
	'UI:Newsroom:ResetCache:Success:Message' => 'Your newsroom cache has been successfully reset~~',
	'UI:Newsroom:ViewAllMessages' => 'Bekijk alle berichten',
	'UI:Newsroom:XNewMessage' => '%1$s nieuw(e) bericht(en)',
	'UI:NoInlineImage' => 'Er is geen afbeelding beschikbaar op de server. Gebruik de "Afbeeldingen doorbladeren..." knop hierboven om een afbeelding te kiezen op je toestel.',
	'UI:NoObjectToDisplay' => 'Geen object om weer te geven.',
	'UI:NoObject_Class_ToDisplay' => 'Geen %1$s om weer te geven',
	'UI:NotificationsMenu:Actions' => 'Acties',
	'UI:NotificationsMenu:Actions:Action' => 'Andere acties',
	'UI:NotificationsMenu:Actions:ActionEmail' => 'Email acties',
	'UI:NotificationsMenu:Actions:ActionWebhook' => 'Webhook acties (uitgaande integraties)',
	'UI:NotificationsMenu:AvailableActions' => 'Beschikbare acties',
	'UI:NotificationsMenu:AvailableTriggers' => 'Beschikbare triggers',
	'UI:NotificationsMenu:Help' => 'Help',
	'UI:NotificationsMenu:HelpContent' => '<p>In '.ITOP_APPLICATION_SHORT.' zijn de meldingen volledig aan te passen. Ze zijn gebaseerd op twee sets van objecten: <i>triggers and actions</i>.</p>
<p><i><b>Triggers</b></i> bepalen wanneer er een melding is. Er zijn verschillende triggers als onderdeel van '.ITOP_APPLICATION_SHORT.' core, maar andere kunnen door middel van uitbreidingen worden toegevoegd.

<p>Sommige triggers worden uitgevoerd:</p>

<ol>
	<li>wanneer een object van de opgegeven klasse wordt <b>aangemaakt</b>, <b>bijgewerkt</b> of <b>verwijderd</b>.</li>
	<li>wanneer een object van een bepaalde klasse een opgegeven <b>fase</b> <b>intreedt</b> of <b>uittreedt</b>.</li>
	<li>wanneer een <b>drempelwaarde</b> op <b>TTO</b> of <b>TTR</b> is <b>bereikt</b>.</li>
</ol>
</p>
<p>
<i><b>Acties</b></i> definieer de acties die uitgevoerd moeten worden als de triggers geactiveerd worden. Er zijn momenteel 2 soorten standaardacties:
<ol>
	<li>Stuur een e-mail: Bij deze acties definieer je een sjabloon voor het bericht en ook parameters zoals ontvanger(s), prioriteit, enz.<br />
	Een <a href="../setup/email.test.php" target="_blank">speciale testpagina (email.test.php)</a> is beschikbaar voor het testen en oplossen van eventuele problemen met jouw PHP e-mailconfiguratie.</li>
	<li>Sending a newsroom message: Display a news to user directly in the application through the newsroom (bell icon on the left menu)</li>
	<li>Webhooks: Staat toe om te integreren met toepassingen van derde partijen, door gestructureerde data te sturen naar een URL.</li>
</ol>
</p>
<p>Acties moeten gekoppeld zijn aan triggers.
Bij die koppeling wordt aan elke actie een volgorde-nummer gegeven. Dit bepaalt in welke volgorde de acties moeten worden uitgevoerd.</p>',
	'UI:NotificationsMenu:OnCreate' => 'Wanneer een object is aangemaakt',
	'UI:NotificationsMenu:OnStateEnter' => 'Wanneer een object een bepaalde fase intreedt',
	'UI:NotificationsMenu:OnStateLeave' => 'Wanneer een object een bepaalde fase uittreedt',
	'UI:NotificationsMenu:Title' => 'Configuratie van Meldingen',
	'UI:NotificationsMenu:Triggers' => 'Triggers',
	'UI:NotificationsTab' => 'Meldingen',
	'UI:OQL:UnknownClassAndFix' => 'Onbekende klasse "%1$s". Je zou "%2$s" kunnen proberen.',
	'UI:OQL:UnknownClassNoFix' => 'Onbekende klasse "%1$s"',
	'UI:OQLQueryBuilderTitle' => 'OQL-query Builder',
	'UI:OQLQueryTab' => 'OQL-query',
	'UI:ObjectArchived' => 'Dit object werd gearchiveerd. Gelieve de Archief-mode in te schakelen of je beheerder te contacteren.',
	'UI:ObjectCouldNotBeWritten' => 'Het object kon niet geschreven worden: %1$s',
	'UI:ObjectDoesNotExist' => 'Sorry, dit object bestaat niet (of je bent niet gemachtigd het te bekijken).',
	'UI:ObjectShortcutInsert' => 'Insert Object Shortcut~~',
	'UI:OnlyForThisList' => 'Alleen voor deze lijst',
	'UI:OpenDocumentInNewWindow_' => 'Open',
	'UI:OperationCancelled' => 'Operatie afgebroken',
	'UI:OrderByHint_Values' => 'Sorteervolgorde: %1$s',
	'UI:PageFormat_A3' => 'A3',
	'UI:PageFormat_A4' => 'A4',
	'UI:PageFormat_Letter' => 'Letter (Amerikaans)',
	'UI:PageOrientation_Landscape' => 'Landschap',
	'UI:PageOrientation_Portrait' => 'Portret',
	'UI:PageTitle:FatalError' => ITOP_APPLICATION_SHORT.' - Fatale Fout',
	'UI:PageTitle:ObjectCreated' => 'Object Aangemaakt.',
	'UI:PageTitle:ProfileProjections' => ITOP_APPLICATION_SHORT.' gebruikersbeheer - profiel-projecties',
	'UI:Pagination:All' => 'Alles',
	'UI:Pagination:HeaderNoSelection' => 'Totaal: %1$s objecten.',
	'UI:Pagination:HeaderSelection' => 'Totaal: %1$s objecten (%2$s objecten geselecteerd).',
	'UI:Pagination:PageSize' => '%1$s objecten per pagina',
	'UI:Pagination:PagesLabel' => 'Paginas:',
	'UI:PasswordConfirm' => 'Bevestig',
	'UI:Preferences' => 'Voorkeuren...',
	'UI:PrintResolution:A4Landscape' => 'A4 Landschap',
	'UI:PrintResolution:A4Portrait' => 'A4 Portret',
	'UI:PrintResolution:FullSize' => 'Volledig formaat',
	'UI:PrintResolution:LetterLandscape' => 'Letter Landschap',
	'UI:PrintResolution:LetterPortrait' => 'Letter Portret',
	'UI:PropertiesTab' => 'Eigenschappen',
	'UI:Query:UrlForExcel' => 'URL om te gebruiken voor MS Excel-webquery\'s',
	'UI:Query:UrlV1' => 'De lijst van velden is leeg gelaten. De pagina <em>export-V2.php</em> kan niet aangeroepen worden zonder deze informatie.Daarom verwijst de onderstaande link naar de oude export-pagina: <em>export.php</em>. Deze verouderde versie heeft enkele beperkingen: de lijst van geëxporteerde velden kan verschillen afhankelijk van het gekozen export-formaat en het datamodel van '.ITOP_APPLICATION_SHORT.'.Als je wil dat de lijst van geëxporteerde kolommen hetzelfde blijft over lange tijd, dan moet je een waarde opgeven voor het attribuut "Velden" en de pagina <em>export-V2.php</em> gebruiken.',
	'UI:Relation:AdditionalContextInfo' => 'Extra contextinfo',
	'UI:Relation:AttachmentExportOptions_Name' => 'Opties voor bijlage naar %1$s',
	'UI:Relation:Comments' => 'Opmerkingen',
	'UI:Relation:DrillDown' => 'Details...',
	'UI:Relation:ExportAsAttachment' => 'Exporteer als bijlage',
	'UI:Relation:ExportAsPDF' => 'Exporteer als PDF...',
	'UI:Relation:Key' => 'Sleutel (key)',
	'UI:Relation:NoneSelected' => 'Geen',
	'UI:Relation:PDFExportOptions' => 'Opties voor PDF-export',
	'UI:Relation:PDFExportPageFormat' => 'Paginaformaat',
	'UI:Relation:PDFExportPageOrientation' => 'Pagina-oriëntatie',
	'UI:Relation:Zoom' => 'Zoom',
	'UI:RelationGroupNumber_N' => 'Groep #%1$d',
	'UI:RelationGroups' => 'Groepen',
	'UI:RelationOption:Comments' => 'Opmerkingen',
	'UI:RelationOption:GroupingThreshold' => 'Drempelwaarde voor groeperen',
	'UI:RelationOption:IncludeList' => 'Voeg lijst van objecten toe',
	'UI:RelationOption:Title' => 'Titel',
	'UI:RelationOption:Untitled' => 'Naamloos',
	'UI:RelationTooltip:CriticalThreshold_N_of_M' => 'Kritieke drempelwaarde: %1$d / %2$d',
	'UI:RelationTooltip:ImpactedItems_N_of_M' => '# geïmpacteerde items: %1$d / %2$d',
	'UI:RelationTooltip:Redundancy' => 'Redundantie',
	'UI:RelationshipGraph' => 'Grafische weergave',
	'UI:RelationshipList' => 'Lijst',
	'UI:RemoveLinkedObjectsOf_Class' => 'Verwijder geselecteerde objecten',
	'UI:RequestMgmtMenuOverview:Title' => 'Dashboard voor Request Management',
	'UI:ResetPwd-EmailBody' => '<body><p>Je hebt een reset van jouw '.ITOP_APPLICATION_SHORT.'-wachtwoord aangevraagd.</p><p>Klik op deze link (eenmalig te gebruiken) om <a href="%1$s">een nieuw wachtwoord in te voeren</a></p>.',
	'UI:ResetPwd-EmailSent' => 'Kijk in jouw mailbox (eventueel bij ongewenste mail) en volg de instructies...',
	'UI:ResetPwd-EmailSubject' => 'Reset jouw '.ITOP_APPLICATION_SHORT.'-wachtwoord',
	'UI:ResetPwd-Error-EnterPassword' => 'Voer het nieuwe wachtwoord voor de account "%1$s" in.',
	'UI:ResetPwd-Error-FixedPwd' => 'Deze account staat het resetten van het wachtwoord niet toe.',
	'UI:ResetPwd-Error-InvalidToken' => 'Sorry. Jouw wachtwoord is al gereset, of je hebt al meerdere e-mails ontvangen. Zorg ervoor dat je de link in de laatst ontvangen e-mail gebruikt.',
	'UI:ResetPwd-Error-NoContact' => 'Deze account is niet gelinkt aan een persoon.',
	'UI:ResetPwd-Error-NoEmail' => 'Er ontbreekt een e-mailadres. Neem contact op met jouw beheerder.',
	'UI:ResetPwd-Error-NoEmailAtt' => 'Deze account is niet gelinkt aan een persoon waarvan een e-mailadres gekend is. Neem contact op met jouw beheerder.',
	'UI:ResetPwd-Error-NotPossible' => 'Het wachtwoord van externe accounts kan niet gereset worden.',
	'UI:ResetPwd-Error-Send' => 'Er is een technisch probleem bij het verzenden van de e-mail. Neem contact op met jouw beheerder.',
	'UI:ResetPwd-Error-WrongLogin' => '"%1$s" is geen geldige login',
	'UI:ResetPwd-Login' => 'Klik hier om in te loggen',
	'UI:ResetPwd-Ready' => 'Het wachtwoord is veranderd',
	'UI:ResetPwd-Title' => 'Reset wachtwoord',
	'UI:RunQuery:DevelopedOQL' => 'Ontwikkelde OQL',
	'UI:RunQuery:DevelopedOQLCount' => 'Ontwikkelde OQL voor aantal',
	'UI:RunQuery:DevelopedQuery' => 'Herschreven query-expressie: ',
	'UI:RunQuery:Error' => 'Er trad een fout op tijdens het uitvoeren van deze query',
	'UI:RunQuery:ExpressionToEvaluate' => 'Expressie om te evalueren: ',
	'UI:RunQuery:HeaderOQLExpression' => 'OQL-expressie',
	'UI:RunQuery:HeaderOQLExpression+' => 'De query in OQL syntax',
	'UI:RunQuery:HeaderPurpose' => 'Doel',
	'UI:RunQuery:HeaderPurpose+' => 'Uitleg over de query',
	'UI:RunQuery:MoreInfo' => 'Meer informatie over de query: ',
	'UI:RunQuery:QueryArguments' => 'Query-argumenten',
	'UI:RunQuery:QueryExamples' => 'Voorbeelden van query\'s',
	'UI:RunQuery:QueryResults' => 'Query-resultaten',
	'UI:RunQuery:ResultSQL' => 'Resulterende SQL',
	'UI:RunQuery:ResultSQLCount' => 'Resulterende SQL voor aantal',
	'UI:RunQuery:SerializedFilter' => 'Geserialiseerde filter: ',
	'UI:RunQuery:Title' => ITOP_APPLICATION_SHORT.' - Evaluatie van OQL-query',
	'UI:Schema:AbstractClass' => 'Abstracte klasse: objecten van deze klasse kunnen niet worden geïnstantieerd.',
	'UI:Schema:AllClasses' => 'Alle klasses',
	'UI:Schema:AllowedValues' => 'Toegelaten waarden',
	'UI:Schema:AllowedValues+' => 'Regels voor de mogelijke waarden van dit attribuut',
	'UI:Schema:Attribute/Filter' => 'Filter',
	'UI:Schema:AttributeCode' => 'Attribuutcode',
	'UI:Schema:AttributeCode+' => 'Interne code van het attribuut',
	'UI:Schema:Attributes' => 'Attributen',
	'UI:Schema:AvailOperators' => 'Beschikbare medewerkers',
	'UI:Schema:AvailOperators+' => 'Mogelijke medewerkers voor deze zoekcriteria',
	'UI:Schema:CategoryMenuItem' => 'Categorie <b>%1$s</b>',
	'UI:Schema:ChildClasses' => 'Subklassen',
	'UI:Schema:ClassFilter' => 'Klasse:',
	'UI:Schema:ClassHierarchyTitle' => 'Hiërarchie van de klasses',
	'UI:Schema:Class_IsLinkedTo_Class_Via_ClassAndAttribute' => '%1$s is gelinkt met %2$s via %3$s::<em>%4$s</em>',
	'UI:Schema:Class_ReferencingClasses_From_By' => 'Verwijzing naar %1$s door de klasse "%2$s" via het veld "%3$s"',
	'UI:Schema:Columns_Description' => 'Kolommen: <em>%1$s</em>',
	'UI:Schema:DefaultNullValue' => 'Standaardwaarde null : "%1$s"',
	'UI:Schema:Default_Description' => 'Standaard: "%1$s"',
	'UI:Schema:Description' => 'Beschrijving',
	'UI:Schema:Description+' => 'Beschrijving van het attribuut',
	'UI:Schema:DisplayLabel' => 'Weergavelabel:',
	'UI:Schema:DisplaySelector/Code' => 'Code',
	'UI:Schema:DisplaySelector/Label' => 'Label',
	'UI:Schema:DisplaySelector/LabelAndCode' => 'Label en code',
	'UI:Schema:Events' => 'Events~~',
	'UI:Schema:Events:Defined' => 'Defined events~~',
	'UI:Schema:Events:Description' => 'Beschrijving',
	'UI:Schema:Events:Event' => 'Event~~',
	'UI:Schema:Events:Listener' => 'Listener~~',
	'UI:Schema:Events:Listeners' => 'Event listeners~~',
	'UI:Schema:Events:Module' => 'Module',
	'UI:Schema:Events:NoEvent' => 'No event defined~~',
	'UI:Schema:Events:NoListener' => 'No event listener~~',
	'UI:Schema:Events:Rank' => 'Rank~~',
	'UI:Schema:ExternalKey_To' => 'Externe sleutel (key) voor %1$s',
	'UI:Schema:FilterCode' => 'Filtercode',
	'UI:Schema:FilterCode+' => 'Code van deze zoekcriteria',
	'UI:Schema:FilterDescription' => 'Beschrijving',
	'UI:Schema:FilterDescription+' => 'Beschrijving van deze zoekcriteria',
	'UI:Schema:Label' => 'Label',
	'UI:Schema:Label+' => 'Label van het attribuut',
	'UI:Schema:LifeCycle' => 'Levenscyclus',
	'UI:Schema:LifeCycleAttributeMustChange' => 'Moet worden aangepast',
	'UI:Schema:LifeCycleAttributeMustPrompt' => 'Gebruiker zal gevraagd worden om de waarde aan te passen',
	'UI:Schema:LifeCycleEmptyList' => 'lege lijst',
	'UI:Schema:LifeCycleHiddenAttribute' => 'Verborgen',
	'UI:Schema:LifeCycleMandatoryAttribute' => 'Verplicht',
	'UI:Schema:LifeCycleReadOnlyAttribute' => 'Alleen lezen',
	'UI:Schema:LifeCycleTransitions' => 'Overgangen',
	'UI:Schema:LifeCyleAttributeOptions' => 'Opties van attribuut',
	'UI:Schema:Links:1-n' => 'Klasses verwijzend naar %1$s (1:n links):',
	'UI:Schema:Links:All' => 'Weergave van alle gerelateerde klasses',
	'UI:Schema:Links:n-n' => 'Klasses gelinkt aan %1$s (n:n links):',
	'UI:Schema:MoreInfo' => 'Meer informatie',
	'UI:Schema:MoreInfo+' => 'Meer informatie over het veld gedefinieerd in de database',
	'UI:Schema:NoLifeCyle' => 'Er is geen levenscyclus gedefinieerd voor deze klasse.',
	'UI:Schema:NonAbstractClass' => 'Niet abstracte klasse: objecten van deze klasse kunnen worden geïnstantieerd.',
	'UI:Schema:NullAllowed' => 'Null toegestaan',
	'UI:Schema:NullNotAllowed' => 'Null niet toegestaan',
	'UI:Schema:Origin' => 'Oorsprong',
	'UI:Schema:Origin+' => 'De basisklasse waarin dit attribuut is gedefinieerd',
	'UI:Schema:ReferencingClasses' => 'Verwijzende klasses',
	'UI:Schema:RelatedClasses' => 'Gerelateerde klasses',
	'UI:Schema:RelationDoesNotPropagate' => '%1$s: propageert niet (%2$d levels), query: %3$s',
	'UI:Schema:RelationDown_Description' => 'Omlaag: %1$s',
	'UI:Schema:RelationPropagates' => '%1$s: propageert naar %2$d levels, query: %3$s',
	'UI:Schema:RelationUp_Description' => 'Omhoog: %1$s',
	'UI:Schema:Relation_Code_Description' => 'Relatie <em>%1$s</em> (%2$s)',
	'UI:Schema:Relationships' => 'Relaties',
	'UI:Schema:SearchCriteria' => 'Zoekcriteria',
	'UI:Schema:Title' => ITOP_APPLICATION_SHORT.' objecten-schema',
	'UI:Schema:TitleForClass' => '%1$s schema',
	'UI:Schema:Triggers' => 'Triggers',
	'UI:Schema:Type' => 'Type',
	'UI:Schema:Type+' => 'Datatype van het attribuut',
	'UI:Search:AddCriteria:List:MostPopular:Title' => 'Meest populair',
	'UI:Search:AddCriteria:List:Others:Title' => 'Andere',
	'UI:Search:AddCriteria:List:RecentlyUsed:Placeholder' => 'Nog geen.',
	'UI:Search:AddCriteria:List:RecentlyUsed:Title' => 'Recent gebruikt',
	'UI:Search:AutoSubmit:DisabledHint' => 'Direct zoeken werd uitgeschakeld voor deze klasse.',
	'UI:Search:Count_ObjectsOf_Class_Found' => '%1$d object(en) van klasse %2$s gevonden.',
	'UI:Search:Criteria:DateTime:From' => 'Vanaf',
	'UI:Search:Criteria:DateTime:FromTime' => 'Vanaf',
	'UI:Search:Criteria:DateTime:PlaceholderFrom' => 'Elk tijdstip',
	'UI:Search:Criteria:DateTime:PlaceholderFromTime' => 'Elk tijdstip',
	'UI:Search:Criteria:DateTime:PlaceholderUntil' => 'Elk tijdstip',
	'UI:Search:Criteria:DateTime:PlaceholderUntilTime' => 'Elk tijdstip',
	'UI:Search:Criteria:DateTime:Until' => 'tot',
	'UI:Search:Criteria:DateTime:UntilTime' => 'tot',
	'UI:Search:Criteria:HierarchicalKey:ChildrenIncluded:Hint' => 'Sub-objecten van geselecteerde objecten zullen mee opgenomen worden.',
	'UI:Search:Criteria:Locked' => 'Vergrendeld',
	'UI:Search:Criteria:Numeric:From' => 'Vanaf',
	'UI:Search:Criteria:Numeric:PlaceholderFrom' => 'Alle',
	'UI:Search:Criteria:Numeric:PlaceholderUntil' => 'Alle',
	'UI:Search:Criteria:Numeric:Until' => 'Tot',
	'UI:Search:Criteria:Operator:Default:Between' => 'Tussen',
	'UI:Search:Criteria:Operator:Default:Empty' => 'Is leeg',
	'UI:Search:Criteria:Operator:Default:Equals' => 'Gelijk aan',
	'UI:Search:Criteria:Operator:Default:NotEmpty' => 'Is niet leeg',
	'UI:Search:Criteria:Operator:Numeric:Different' => 'Verschillend van',
	'UI:Search:Criteria:Operator:Numeric:Equals' => 'Gelijk aan',
	'UI:Search:Criteria:Operator:Numeric:GreaterThan' => 'Groter',
	'UI:Search:Criteria:Operator:Numeric:GreaterThanOrEquals' => 'Groter of gelijk aan',
	'UI:Search:Criteria:Operator:Numeric:LessThan' => 'Kleiner',
	'UI:Search:Criteria:Operator:Numeric:LessThanOrEquals' => 'Kleiner of gelijk aan',
	'UI:Search:Criteria:Operator:String:Contains' => 'Bevat',
	'UI:Search:Criteria:Operator:String:EndsWith' => 'Eindigt in',
	'UI:Search:Criteria:Operator:String:RegExp' => 'Regex ',
	'UI:Search:Criteria:Operator:String:StartsWith' => 'Begint met',
	'UI:Search:Criteria:Operator:TagSet:Matches' => 'Bevat',
	'UI:Search:Criteria:Raw:Filtered' => 'Gefilterd',
	'UI:Search:Criteria:Raw:FilteredOn' => 'Gefiltered op %1$s',
	'UI:Search:Criteria:Remove' => 'Verwijder',
	'UI:Search:Criteria:Title:DateTime:Between' => '%2$s <= 1$s <= %3$s',
	'UI:Search:Criteria:Title:Default:Any' => '%1$s: alle',
	'UI:Search:Criteria:Title:Default:Between' => '%1$s tussen [%2$s]',
	'UI:Search:Criteria:Title:Default:Between:All' => '%1$s: Any',
	'UI:Search:Criteria:Title:Default:Between:From' => '%1$s from %2$s',
	'UI:Search:Criteria:Title:Default:Between:Until' => '%1$s up to %2$s',
	'UI:Search:Criteria:Title:Default:BetweenDates' => '%1$s [%2$s]',
	'UI:Search:Criteria:Title:Default:BetweenDates:All' => '%1$s: Alles',
	'UI:Search:Criteria:Title:Default:BetweenDates:From' => '%1$s vanaf %2$s',
	'UI:Search:Criteria:Title:Default:BetweenDates:Until' => '%1$s tot %2$s',
	'UI:Search:Criteria:Title:Default:Contains' => '%1$s bevat %2$s',
	'UI:Search:Criteria:Title:Default:Different' => '%1$s ≠ %2$s',
	'UI:Search:Criteria:Title:Default:Empty' => '%1$s is leeg',
	'UI:Search:Criteria:Title:Default:EndsWith' => '%1$s eindigt op %2$s',
	'UI:Search:Criteria:Title:Default:Equals' => '%1$s gelijk aan %2$s',
	'UI:Search:Criteria:Title:Default:GreaterThan' => '%1$s > %2$s',
	'UI:Search:Criteria:Title:Default:GreaterThanOrEquals' => '%1$s >= %2$s',
	'UI:Search:Criteria:Title:Default:LessThan' => '%1$s < %2$s',
	'UI:Search:Criteria:Title:Default:LessThanOrEquals' => '%1$s <= %2$s',
	'UI:Search:Criteria:Title:Default:NotEmpty' => '%1$s is niet leeg',
	'UI:Search:Criteria:Title:Default:RegExp' => '%1$s bevat %2$s',
	'UI:Search:Criteria:Title:Default:StartsWith' => '%1$s begint met %2$s',
	'UI:Search:Criteria:Title:Enum:In' => '%1$s: %2$s',
	'UI:Search:Criteria:Title:Enum:In:All' => '%1$s: Alle',
	'UI:Search:Criteria:Title:Enum:In:Many' => '%1$s: %2$s en %3$s andere',
	'UI:Search:Criteria:Title:ExternalKey:Empty' => '%1$s is gedefinieerd',
	'UI:Search:Criteria:Title:ExternalKey:Equals' => '%1$s %2$s',
	'UI:Search:Criteria:Title:ExternalKey:In' => '%1$s: %2$s',
	'UI:Search:Criteria:Title:ExternalKey:In:All' => '%1$s: Alle',
	'UI:Search:Criteria:Title:ExternalKey:In:Many' => '%1$s: %2$s en %3$s andere',
	'UI:Search:Criteria:Title:ExternalKey:NotEmpty' => '%1$s is niet gedefinieerd',
	'UI:Search:Criteria:Title:HierarchicalKey:Empty' => '%1$s is gedefinieerd',
	'UI:Search:Criteria:Title:HierarchicalKey:Equals' => '%1$s %2$s',
	'UI:Search:Criteria:Title:HierarchicalKey:In' => '%1$s: %2$s',
	'UI:Search:Criteria:Title:HierarchicalKey:In:All' => '%1$s: Alle',
	'UI:Search:Criteria:Title:HierarchicalKey:In:Many' => '%1$s: %2$s en %3$s andere',
	'UI:Search:Criteria:Title:HierarchicalKey:NotEmpty' => '%1$s is niet gedefinieerd',
	'UI:Search:Criteria:Title:TagSet:Matches' => '%1$s: %2$s',
	'UI:Search:Criteria:Toggle' => 'Klap in / uit',
	'UI:Search:Criterion:MoreMenu:AddCriteria' => 'Voeg nieuw criterium toe',
	'UI:Search:Enlarge' => 'Vergroot de zoekopdracht',
	'UI:Search:NeedleTooShort' => 'De zoekopdracht "%1$s" is te kort. Typ minstens %2$d karakters.',
	'UI:Search:NoAutoSubmit:ExplainText' => 'Voeg enkele criteria toe in het zoekveld of klik op de zoekknop om objecten te zien.',
	'UI:Search:NoObjectFound' => 'Geen object gevonden.',
	'UI:Search:NoSearch' => 'Geen zoekopdracht',
	'UI:Search:Obsolescence:DisabledHint' => 'Door jouw voorkeuren worden objecten met status "buiten dienst" verborgen',
	'UI:Search:Ongoing' => 'Zoeken naar "%1$s"',
	'UI:Search:Toggle' => 'Inklappen / uitklappen',
	'UI:Search:Value:Autocomplete:NoResult' => 'Geen resultaten.',
	'UI:Search:Value:Autocomplete:StartTyping' => 'Begin te typen om mogelijke waarden te zien.',
	'UI:Search:Value:Autocomplete:Wait' => 'Even geduld...',
	'UI:Search:Value:Filter:Placeholder' => 'Filter...',
	'UI:Search:Value:Search:Placeholder' => 'Zoek...',
	'UI:Search:Value:Toggler:CheckAllNone' => 'Alles aan-/uitvinken',
	'UI:Search:Value:Toggler:CheckAllNoneFiltered' => 'Alle zichtbare aan-/uitvinken',
	'UI:SearchFor_Class' => 'Zoek naar %1$s objecten',
	'UI:SearchFor_Class_Objects' => 'Zoek naar %1$s Objecten',
	'UI:SearchResultsPageTitle' => ITOP_APPLICATION_SHORT.' - Zoekresultaten',
	'UI:SearchResultsTitle' => 'Zoekresultaten',
	'UI:SearchResultsTitle+' => 'Volledige tekst - zoekresultaten',
	'UI:SearchToggle' => 'Zoek',
	'UI:SearchValue:Any' => '* Ieder *',
	'UI:SearchValue:CheckAll' => 'Vink alles aan',
	'UI:SearchValue:Mixed' => '* gemengd *',
	'UI:SearchValue:NbSelected' => '# geselecteerd',
	'UI:SearchValue:UncheckAll' => 'Vink alles uit',
	'UI:SelectAllToggle+' => '(De)selecteer alles',
	'UI:SelectInlineImageToUpload' => 'Selecteer een afbeelding om te uploaden',
	'UI:SelectOne' => '-- selecteer --',
	'UI:SelectTheTypeOf_Class_ToCreate' => 'Selecteer het type %1$s dat moet worden aangemaakt:',
	'UI:SelectionOf_Class' => 'Selectie van objecten van type %1$s',
	'UI:ServiceMgmtMenuOverview:Title' => 'Dashboard voor Service Management',
	'UI:ShortcutDelete:Confirm' => 'Bevestig dat je de snelkoppeling(en) wil verwijderen.',
	'UI:ShortcutListDlg:Title' => 'Maak een snelkoppeling voor de lijst aan',
	'UI:ShortcutRenameDlg:Title' => 'Hernoem de snelkoppeling',
	'UI:SimpleSearchTab' => 'Eenvoudig zoeken',
	'UI:SplitDateTime-Date' => 'datum',
	'UI:SplitDateTime-Time' => 'tijd',
	'UI:StateChanged' => 'Status veranderd',
	'UI:StayOnThePage' => 'Blijf op deze pagina',
	'UI:StimulusModify_N_ObjectsOf_Class' => '%1$s: Bezig met het bewerken van %2$d objecten van klasse %3$s',
	'UI:SystemIntrusion' => 'Toegang geweigerd. Je hebt een actie aangevraagd waarvoor je niet gemachtigd bent.',
	'UI:TagAdminMenu:NoTags' => 'Geen tags geconfigureerd',
	'UI:TagAdminMenu:Title' => 'Tags-configuratie',
	'UI:TagSetFieldData:Error' => 'Fout: %1$s',
	'UI:Title:BulkDeletionOf_Count_ObjectsOf_Class' => 'Verwijderen van %1$d objecten van klasse "%2$s"',
	'UI:Title:BulkImport' => ITOP_APPLICATION_SHORT.' - Bulk import',
	'UI:Title:BulkImport+' => 'CSV Import Wizard',
	'UI:Title:BulkSynchro_nbItem_ofClass_class' => 'Synchronisatie van %1$d objecten van klasse "%2$s"',
	'UI:Title:CSVImportStep2' => 'Stap 2 van 5: Opties voor CSV-gegevens',
	'UI:Title:CSVImportStep3' => 'Stap 3 van 5: Data mapping',
	'UI:Title:CSVImportStep4' => 'Stap 4 van 5: Import simulatie',
	'UI:Title:CSVImportStep5' => 'Stap 5 van 5: Import compleet',
	'UI:Title:DataPreview' => 'Datavoorbeeld',
	'UI:Title:DeletionOf_Object' => 'Verwijderen van %1$s',
	'UI:Title:Object_Of_Class_Created' => '%1$s - %2$s aangemaakt.',
	'UI:Toggle:CustomDashboard' => 'Aangepast',
	'UI:Toggle:StandardDashboard' => 'Standaard',
	'UI:Toggle:SwitchToCustomDashboard' => 'Schakel over naar aangepast dashboard',
	'UI:Toggle:SwitchToStandardDashboard' => 'Schakel over naar het standaard dashboard',
	'UI:ToggleFullScreen' => 'Minimaliseren / Maximaliseren',
	'UI:Treeview:CollapseAll' => 'Alles inklappen',
	'UI:Treeview:ExpandAll' => 'Alles uitklappen',
	'UI:TruncatedResults' => '%1$d objecten weergegeven buiten %2$d',
	'UI:UndefinedObject' => 'Ongedefinieerd',
	'UI:UniversalSearch:Error' => 'Fout: %1$s',
	'UI:UniversalSearch:LabelSelectTheClass' => 'Selecteer de klasse om te zoeken: ',
	'UI:UniversalSearchTitle' => ITOP_APPLICATION_SHORT.' - Universele zoekopdracht',
	'UI:UploadInlineImageLegend' => 'Voeg een afbeelding toe',
	'UI:UploadNotSupportedInThisMode' => 'Het aanpassen van afbeeldingen of bestanden wordt niet ondersteund in deze mode.',
	'UI:UseDefaultSettings' => 'Gebruik de standaard instellingen',
	'UI:UseSavetheSettings' => 'Sla de instellingen op',
	'UI:UseSpecificSettings' => 'Gebruik de volgende instellingen:',
	'UI:UserManagement:Action' => 'Actie',
	'UI:UserManagement:Action+' => 'Actie uitgevoerd door de gebruiker',
	'UI:UserManagement:Action:BulkDelete' => 'Meerdere objecten verwijderen',
	'UI:UserManagement:Action:BulkDelete+' => 'Verwijderen van meerdere objecten in één keer',
	'UI:UserManagement:Action:BulkModify' => 'Meerdere objecten aanpassen',
	'UI:UserManagement:Action:BulkModify+' => 'Aanpassen van meerdere objecten in één keer',
	'UI:UserManagement:Action:BulkRead' => 'Meerdere objecten lezen',
	'UI:UserManagement:Action:BulkRead+' => 'Lezen/weergevan van meerdere objecten',
	'UI:UserManagement:Action:Delete' => 'Verwijderen',
	'UI:UserManagement:Action:Delete+' => 'Verwijder van objecten',
	'UI:UserManagement:Action:Modify' => 'Aanpassen',
	'UI:UserManagement:Action:Modify+' => 'Maken/aanpassen van objecten',
	'UI:UserManagement:Action:Read' => 'Lezen',
	'UI:UserManagement:Action:Read+' => 'Lezen/weergeven van objecten',
	'UI:UserManagement:Action:Stimuli' => 'Stimuli',
	'UI:UserManagement:Action:Stimuli+' => 'Toegestane acties',
	'UI:UserManagement:ActionAllowed:No' => 'Nee',
	'UI:UserManagement:ActionAllowed:Yes' => 'Ja',
	'UI:UserManagement:AdminProfile+' => 'Beheerders hebben volledige lees- en schrijfrechten nodig in de database.',
	'UI:UserManagement:AnyObject' => '* elk *',
	'UI:UserManagement:Attributes' => 'Attributen',
	'UI:UserManagement:Class' => 'Klasse',
	'UI:UserManagement:Class+' => 'Klasse van objecten',
	'UI:UserManagement:GrantMatrix' => 'Rechtenmatrix',
	'UI:UserManagement:NoLifeCycleApplicable' => 'Niet beschikbaar',
	'UI:UserManagement:NoLifeCycleApplicable+' => 'Er is geen levenscyclus gedefinieerd voor deze klasse',
	'UI:UserManagement:Permission' => 'Toestemming',
	'UI:UserManagement:Permission+' => 'De autorisaties van de gebruiker',
	'UI:UserManagement:ProjectedObject' => 'Object',
	'UI:UserManagement:ProjectedObject+' => 'Beschermd object',
	'UI:UserManagement:TitleActions' => 'Acties',
	'UI:UserManagement:User' => 'Gebruiker',
	'UI:UserManagement:User+' => 'Gebruiker bezig met de projectie',
	'UI:UserPref:DoNotShowAgain' => 'Niet meer opnieuw tonen',
	'UI:ValueInvalidFormat' => 'Ongeldig formaat',
	'UI:ValueMustBeChanged' => 'Gelieve de waarde te veranderen',
	'UI:ValueMustBeSet' => 'Gelieve een waarde op te geven',
	'UI:WelcomeMenu:AllConfigItems' => 'Configuratie-items: %1$d',
	'UI:WelcomeMenu:AllOpenRequests' => 'Open aanvragen: %1$d',
	'UI:WelcomeMenu:MyCalls' => 'Mijn aanvragen',
	'UI:WelcomeMenu:MyIncidents' => 'Aan mij toegewezen incidenten',
	'UI:WelcomeMenu:OpenIncidents' => 'Open incidenten: %1$d',
	'UI:WelcomeMenu:Title' => 'Welkom in '.ITOP_APPLICATION_SHORT,
	'UI:WelcomeToITop' => 'Welkom in '.ITOP_APPLICATION,
	'UI:Wizard:FinalStepTitle' => 'Laatste stap: bevestiging',
	'UI:YourSearch' => 'Jouw zoekopdracht',
	'UI:iTopVersion:Long' => '%1$s versie %2$s-%3$s uitgegeven op %4$s',
	'UI:iTopVersion:Short' => '%1$s versie %2$s',
	'UI_CountOfObjectsShort' => '%1$d objecten.',
	'portal:backoffice' => ITOP_APPLICATION_SHORT.' Back-Office User Interface',
	'portal:legacy_portal' => 'Portaal voor eindgebruikers',
	'Menu:ConfigEditor' => 'Algemene configuratie',
	'Menu:ConfigEditor+' => 'Configuratiebestand-editor',
	'Menu:Integrations' => 'Integraties',
	'Menu:Integrations+' => '',
]);
