--
-- PostgreSQL database dump
--

SET client_encoding = 'SQL_ASCII';
SET check_function_bodies = false;
SET client_min_messages = warning;

--
-- TOC entry 1403 (class 0 OID 0)
-- Name: DUMP TIMESTAMP; Type: DUMP TIMESTAMP; Schema: -; Owner: 
--

-- Started on 2005-03-07 02:41:09 Hora estndar de Sudamrica O.


--
-- TOC entry 1406 (class 0 OID 0)
-- Dependencies: 3
-- Name: SCHEMA public; Type: COMMENT; Schema: -; Owner: postgres
--

COMMENT ON SCHEMA public IS 'Standard public namespace';


SET search_path = public, pg_catalog;

--
-- TOC entry 5 (class 1255 OID 1072673)
-- Dependencies: 3
-- Name: plpgsql_call_handler(); Type: FUNCTION; Schema: public; Owner: root
--

CREATE FUNCTION plpgsql_call_handler() RETURNS language_handler
    AS '$libdir/plpgsql', 'plpgsql_call_handler'
    LANGUAGE c;


--
-- TOC entry 202 (class 16402 OID 1072674)
-- Dependencies: 5
-- Name: plpgsql; Type: PROCEDURAL LANGUAGE; Schema: public; Owner: 
--

CREATE TRUSTED PROCEDURAL LANGUAGE plpgsql HANDLER plpgsql_call_handler;


SET default_tablespace = '';

SET default_with_oids = true;

--
-- TOC entry 1065 (class 1259 OID 1689459)
-- Dependencies: 1289 3
-- Name: alumno; Type: TABLE; Schema: public; Owner: infocid; Tablespace: 
--

CREATE TABLE alumno (
    numcarnet character varying(6) NOT NULL,
    nombre character varying(20) NOT NULL,
    apepat character varying(20) NOT NULL,
    apemat character varying(20) NOT NULL,
    especialidad character varying(50) NOT NULL,
    ciclo character varying(2) NOT NULL,
    direccion character varying(100) NOT NULL,
    telefono character varying(8) NOT NULL,
    sexo character(1) NOT NULL,
    ie character(1) NOT NULL,
    codlector bigint NOT NULL,
    activo character(2) DEFAULT 'SI' NOT NULL
);


--
-- TOC entry 1066 (class 1259 OID 1689465)
-- Dependencies: 3
-- Name: detdev; Type: TABLE; Schema: public; Owner: infocid; Tablespace: 
--

CREATE TABLE detdev (
    numdet bigint NOT NULL,
    coddev bigint NOT NULL,
    registro character varying(6) NOT NULL
);


--
-- TOC entry 1067 (class 1259 OID 1689470)
-- Dependencies: 3
-- Name: detprest; Type: TABLE; Schema: public; Owner: infocid; Tablespace: 
--

CREATE TABLE detprest (
    numdetalle bigint NOT NULL,
    codprest bigint NOT NULL,
    registro character varying(6) NOT NULL,
    devuelto character(2) NOT NULL,
    fechorprest timestamp without time zone NOT NULL
);


--
-- TOC entry 1068 (class 1259 OID 1689475)
-- Dependencies: 3
-- Name: devolucion; Type: TABLE; Schema: public; Owner: infocid; Tablespace: 
--

CREATE TABLE devolucion (
    coddev bigint NOT NULL,
    codprest bigint NOT NULL,
    codusuario bigint NOT NULL,
    fechordev timestamp without time zone NOT NULL
);


--
-- TOC entry 1069 (class 1259 OID 1689480)
-- Dependencies: 1290 1291 3
-- Name: documento; Type: TABLE; Schema: public; Owner: infocid; Tablespace: 
--

CREATE TABLE documento (
    codigo character varying(20) NOT NULL,
    titulo character varying(1000) NOT NULL,
    autor character varying(800) NOT NULL,
    descriptor character varying(1000) NOT NULL,
    idioma character varying(50) NOT NULL,
    ubicacion character varying(3) DEFAULT 'LTX' NOT NULL,
    paginacion character varying(5) NOT NULL,
    pieimprenta character varying(1000),
    ingreso character varying(100),
    resumen character varying(30000) DEFAULT '-',
    observaciones character varying(3500),
    orden integer
);


--
-- TOC entry 1064 (class 1259 OID 1689457)
-- Dependencies: 3
-- Name: documento_pieimprenta_seq; Type: SEQUENCE; Schema: public; Owner: infocid
--

CREATE SEQUENCE documento_pieimprenta_seq
    START WITH 1
    INCREMENT BY 1
    MAXVALUE 2147483647
    NO MINVALUE
    CACHE 1;


--
-- TOC entry 1408 (class 0 OID 0)
-- Dependencies: 1064
-- Name: documento_pieimprenta_seq; Type: SEQUENCE SET; Schema: public; Owner: infocid
--

SELECT pg_catalog.setval('documento_pieimprenta_seq', 1, false);


--
-- TOC entry 1070 (class 1259 OID 1689488)
-- Dependencies: 1292 1293 3
-- Name: estadistica; Type: TABLE; Schema: public; Owner: infocid; Tablespace: 
--

CREATE TABLE estadistica (
    numero bigint NOT NULL,
    item character varying(200) NOT NULL,
    encont bigint NOT NULL,
    fecha timestamp without time zone NOT NULL,
    lector character varying(10) DEFAULT '-',
    criterio character varying(25) DEFAULT '-'
);


--
-- TOC entry 1071 (class 1259 OID 1689495)
-- Dependencies: 1294 3
-- Name: externo; Type: TABLE; Schema: public; Owner: infocid; Tablespace: 
--

CREATE TABLE externo (
    dni character(8) NOT NULL,
    nombre character varying(20) NOT NULL,
    apemat character varying(20) NOT NULL,
    apepat character varying(20) NOT NULL,
    direccion character varying(100) NOT NULL,
    telefono character varying(8) NOT NULL,
    sexo character(1) NOT NULL,
    procedencia character varying(50) NOT NULL,
    codlector bigint NOT NULL,
    activo character(2) DEFAULT 'SI' NOT NULL
);


--
-- TOC entry 1084 (class 1259 OID 1985528)
-- Dependencies: 1317 1318 3
-- Name: gestion; Type: TABLE; Schema: public; Owner: infocid; Tablespace: 
--

CREATE TABLE gestion (
    id bigserial NOT NULL,
    usuario character varying(30) NOT NULL,
    pass character varying(60) NOT NULL,
    nivel_acceso integer DEFAULT 1 NOT NULL
);


--
-- TOC entry 1409 (class 0 OID 0)
-- Dependencies: 1083
-- Name: gestion_id_seq; Type: SEQUENCE SET; Schema: public; Owner: infocid
--

SELECT pg_catalog.setval(pg_catalog.pg_get_serial_sequence('gestion', 'id'), 3, true);


--
-- TOC entry 1072 (class 1259 OID 1689501)
-- Dependencies: 1295 3
-- Name: interno; Type: TABLE; Schema: public; Owner: infocid; Tablespace: 
--

CREATE TABLE interno (
    numcarnet character varying(8) NOT NULL,
    nombre character varying(20) NOT NULL,
    apemat character varying(20) NOT NULL,
    apepat character varying(20) NOT NULL,
    dependencia character varying(20) NOT NULL,
    anexo character varying(3) NOT NULL,
    sexo character(1) NOT NULL,
    codlector bigint NOT NULL,
    activo character(2) DEFAULT 'SI' NOT NULL
);


--
-- TOC entry 1073 (class 1259 OID 1689507)
-- Dependencies: 1296 3
-- Name: lector; Type: TABLE; Schema: public; Owner: infocid; Tablespace: 
--

CREATE TABLE lector (
    codlector bigint NOT NULL,
    tipo character(1) DEFAULT 'A' NOT NULL
);


--
-- TOC entry 1074 (class 1259 OID 1689513)
-- Dependencies: 1297 1298 1299 1300 1301 1302 1303 1304 1305 1306 1307 1308 1309 1310 1311 3
-- Name: libro; Type: TABLE; Schema: public; Owner: infocid; Tablespace: 
--

CREATE TABLE libro (
    registro character varying(6) NOT NULL,
    codigo character varying(20) NOT NULL,
    autor character varying(200) NOT NULL,
    titulo character varying(600) NOT NULL,
    descriptor character varying(5000) NOT NULL,
    resumen character varying(20000) NOT NULL,
    idioma character varying(2) DEFAULT 'ES' NOT NULL,
    prestado character varying(2) DEFAULT 'NO' NOT NULL,
    piedeimprenta character varying(500) DEFAULT '-' NOT NULL,
    isbn character varying(30) DEFAULT '-' NOT NULL,
    numpag character varying(10) DEFAULT '0' NOT NULL,
    precio character varying(20) DEFAULT '0000.00' NOT NULL,
    edicion character varying(50) DEFAULT '-' NOT NULL,
    fechaingreso character varying(20) DEFAULT '00/00/00' NOT NULL,
    numbc character varying(20) DEFAULT '-' NOT NULL,
    numingreso character varying(20) DEFAULT '-' NOT NULL,
    baja character varying(2) DEFAULT 'NO' NOT NULL,
    obs character varying(500) DEFAULT '-' NOT NULL,
    reservado character varying(2) DEFAULT 'NO',
    dilog character varying(20),
    pieedito character varying(500) DEFAULT '-',
    pieano character varying(4) DEFAULT '-'
);


--
-- TOC entry 1082 (class 1259 OID 1689596)
-- Dependencies: 3
-- Name: libroinv; Type: TABLE; Schema: public; Owner: infocid; Tablespace: 
--

CREATE TABLE libroinv (
    registro character varying(6) NOT NULL,
    codigo character varying(12) NOT NULL,
    autor character varying(150) NOT NULL,
    titulo character varying(255) NOT NULL,
    numbc character varying(14) NOT NULL,
    numingreso character varying(17) NOT NULL,
    fechaingreso character varying(10) NOT NULL,
    piedeimprenta character varying(100) NOT NULL,
    precio character varying(10) NOT NULL,
    prestado character varying(2) NOT NULL,
    operador character varying(3) NOT NULL,
    fechoringreso timestamp without time zone NOT NULL,
    dilog character varying(20)
);


--
-- TOC entry 1075 (class 1259 OID 1689536)
-- Dependencies: 3
-- Name: parametro; Type: TABLE; Schema: public; Owner: infocid; Tablespace: 
--

CREATE TABLE parametro (
    numreg bigint NOT NULL,
    codlector bigint NOT NULL,
    nlibros bigint NOT NULL
);


--
-- TOC entry 1076 (class 1259 OID 1689543)
-- Dependencies: 3
-- Name: regprest; Type: TABLE; Schema: public; Owner: infocid; Tablespace: 
--

CREATE TABLE regprest (
    codprest bigint NOT NULL,
    codlector bigint NOT NULL,
    codusuario bigint NOT NULL
);


--
-- TOC entry 1077 (class 1259 OID 1689548)
-- Dependencies: 3
-- Name: usuario; Type: TABLE; Schema: public; Owner: infocid; Tablespace: 
--

CREATE TABLE usuario (
    codusuario bigint NOT NULL,
    login character varying(30) NOT NULL,
    identificacion character varying(60) NOT NULL,
    cargo character varying(100) NOT NULL,
    "password" character varying(8) NOT NULL,
    nseguridad integer NOT NULL
);


--
-- TOC entry 1078 (class 1259 OID 1689553)
-- Dependencies: 1312 1313 1314 1315 1316 3
-- Name: video; Type: TABLE; Schema: public; Owner: infocid; Tablespace: 
--

CREATE TABLE video (
    registro character varying(6) NOT NULL,
    titulo character varying(400) NOT NULL,
    autor character varying(200) NOT NULL,
    fecha character varying(20) DEFAULT '00/00/00' NOT NULL,
    mesa character varying(400) NOT NULL,
    debate character varying(400) NOT NULL,
    entrevista character varying(400) NOT NULL,
    curso1 character varying(400) NOT NULL,
    curso2 character varying(400) NOT NULL,
    magazine character varying(400) NOT NULL,
    documental character varying(400) NOT NULL,
    duracion character varying(400) NOT NULL,
    resumen character varying(3000) NOT NULL,
    prestado character varying(2) DEFAULT 'NO' NOT NULL,
    obs character varying(400) DEFAULT '-' NOT NULL,
    activo character(2) DEFAULT 'SI' NOT NULL,
    operador character varying(200) DEFAULT '-'
);


--
-- TOC entry 1079 (class 1259 OID 1689566)
-- Dependencies: 1112 3
-- Name: vpresta; Type: VIEW; Schema: public; Owner: infocid
--

CREATE VIEW vpresta AS
    SELECT detprest.numdetalle, detprest.codprest, detprest.registro, detprest.devuelto, detprest.fechorprest, regprest.codlector, regprest.codusuario FROM detprest, regprest WHERE (regprest.codprest = detprest.codprest);


--
-- TOC entry 1080 (class 1259 OID 1689569)
-- Dependencies: 1113 3
-- Name: vprestalum; Type: VIEW; Schema: public; Owner: infocid
--

CREATE VIEW vprestalum AS
    SELECT alumno.nombre, alumno.apepat, alumno.apemat, alumno.sexo, vpresta.codlector FROM alumno, vpresta WHERE (vpresta.codlector = alumno.codlector);


--
-- TOC entry 1081 (class 1259 OID 1689572)
-- Dependencies: 1114 3
-- Name: vprestint; Type: VIEW; Schema: public; Owner: infocid
--

CREATE VIEW vprestint AS
    SELECT interno.nombre, interno.apemat, interno.apepat, interno.sexo, libro.autor, libro.titulo, vpresta.registro, vpresta.devuelto, vpresta.fechorprest, vpresta.codlector FROM interno, libro, vpresta WHERE ((vpresta.codlector = interno.codlector) AND (vpresta.registro = libro.registro));


--
-- TOC entry 1387 (class 0 OID 1689459)
-- Dependencies: 1065
-- Data for Name: alumno; Type: TABLE DATA; Schema: public; Owner: infocid
--

COPY alumno (numcarnet, nombre, apepat, apemat, especialidad, ciclo, direccion, telefono, sexo, ie, codlector, activo) FROM stdin;
\.


--
-- TOC entry 1388 (class 0 OID 1689465)
-- Dependencies: 1066
-- Data for Name: detdev; Type: TABLE DATA; Schema: public; Owner: infocid
--

COPY detdev (numdet, coddev, registro) FROM stdin;
\.


--
-- TOC entry 1389 (class 0 OID 1689470)
-- Dependencies: 1067
-- Data for Name: detprest; Type: TABLE DATA; Schema: public; Owner: infocid
--

COPY detprest (numdetalle, codprest, registro, devuelto, fechorprest) FROM stdin;
\.


--
-- TOC entry 1390 (class 0 OID 1689475)
-- Dependencies: 1068
-- Data for Name: devolucion; Type: TABLE DATA; Schema: public; Owner: infocid
--

COPY devolucion (coddev, codprest, codusuario, fechordev) FROM stdin;
\.


--
-- TOC entry 1391 (class 0 OID 1689480)
-- Dependencies: 1069
-- Data for Name: documento; Type: TABLE DATA; Schema: public; Owner: infocid
--

COPY documento (codigo, titulo, autor, descriptor, idioma, ubicacion, paginacion, pieimprenta, ingreso, resumen, observaciones, orden) FROM stdin;
\.


--
-- TOC entry 1392 (class 0 OID 1689488)
-- Dependencies: 1070
-- Data for Name: estadistica; Type: TABLE DATA; Schema: public; Owner: infocid
--

COPY estadistica (numero, item, encont, fecha, lector, criterio) FROM stdin;
1	CARAOTAS	0	2004-11-04 09:23:48.854864	INVITADO	TEMA
\.


--
-- TOC entry 1393 (class 0 OID 1689495)
-- Dependencies: 1071
-- Data for Name: externo; Type: TABLE DATA; Schema: public; Owner: infocid
--

COPY externo (dni, nombre, apemat, apepat, direccion, telefono, sexo, procedencia, codlector, activo) FROM stdin;
\.


--
-- TOC entry 1402 (class 0 OID 1985528)
-- Dependencies: 1084
-- Data for Name: gestion; Type: TABLE DATA; Schema: public; Owner: infocid
--

COPY gestion (id, usuario, pass, nivel_acceso) FROM stdin;
1	Admin	21232f297a57a5a743894a0e4a801fc3	0
3	cedinee	b41a5141498207612216c477748288e5	0
\.


--
-- TOC entry 1394 (class 0 OID 1689501)
-- Dependencies: 1072
-- Data for Name: interno; Type: TABLE DATA; Schema: public; Owner: infocid
--

COPY interno (numcarnet, nombre, apemat, apepat, dependencia, anexo, sexo, codlector, activo) FROM stdin;
\.


--
-- TOC entry 1395 (class 0 OID 1689507)
-- Dependencies: 1073
-- Data for Name: lector; Type: TABLE DATA; Schema: public; Owner: infocid
--

COPY lector (codlector, tipo) FROM stdin;
1	A
2	A
3	A
4	A
\.


--
-- TOC entry 1396 (class 0 OID 1689513)
-- Dependencies: 1074
-- Data for Name: libro; Type: TABLE DATA; Schema: public; Owner: infocid
--

COPY libro (registro, codigo, autor, titulo, descriptor, resumen, idioma, prestado, piedeimprenta, isbn, numpag, precio, edicion, fechaingreso, numbc, numingreso, baja, obs, reservado, dilog, pieedito, pieano) FROM stdin;
\.


--
-- TOC entry 1401 (class 0 OID 1689596)
-- Dependencies: 1082
-- Data for Name: libroinv; Type: TABLE DATA; Schema: public; Owner: infocid
--

COPY libroinv (registro, codigo, autor, titulo, numbc, numingreso, fechaingreso, piedeimprenta, precio, prestado, operador, fechoringreso, dilog) FROM stdin;
\.


--
-- TOC entry 1397 (class 0 OID 1689536)
-- Dependencies: 1075
-- Data for Name: parametro; Type: TABLE DATA; Schema: public; Owner: infocid
--

COPY parametro (numreg, codlector, nlibros) FROM stdin;
\.


--
-- TOC entry 1398 (class 0 OID 1689543)
-- Dependencies: 1076
-- Data for Name: regprest; Type: TABLE DATA; Schema: public; Owner: infocid
--

COPY regprest (codprest, codlector, codusuario) FROM stdin;
\.


--
-- TOC entry 1399 (class 0 OID 1689548)
-- Dependencies: 1077
-- Data for Name: usuario; Type: TABLE DATA; Schema: public; Owner: infocid
--

COPY usuario (codusuario, login, identificacion, cargo, "password", nseguridad) FROM stdin;
\.


--
-- TOC entry 1400 (class 0 OID 1689553)
-- Dependencies: 1078
-- Data for Name: video; Type: TABLE DATA; Schema: public; Owner: infocid
--

COPY video (registro, titulo, autor, fecha, mesa, debate, entrevista, curso1, curso2, magazine, documental, duracion, resumen, prestado, obs, activo, operador) FROM stdin;
\.


--
-- TOC entry 1321 (class 16386 OID 1689463)
-- Dependencies: 1065 1065
-- Name: alumno_pkey; Type: CONSTRAINT; Schema: public; Owner: infocid; Tablespace: 
--

ALTER TABLE ONLY alumno
    ADD CONSTRAINT alumno_pkey PRIMARY KEY (numcarnet);


--
-- TOC entry 1324 (class 16386 OID 1689468)
-- Dependencies: 1066 1066
-- Name: detdev_pkey; Type: CONSTRAINT; Schema: public; Owner: infocid; Tablespace: 
--

ALTER TABLE ONLY detdev
    ADD CONSTRAINT detdev_pkey PRIMARY KEY (numdet);


--
-- TOC entry 1327 (class 16386 OID 1689473)
-- Dependencies: 1067 1067
-- Name: detprest_pkey; Type: CONSTRAINT; Schema: public; Owner: infocid; Tablespace: 
--

ALTER TABLE ONLY detprest
    ADD CONSTRAINT detprest_pkey PRIMARY KEY (numdetalle);


--
-- TOC entry 1330 (class 16386 OID 1689478)
-- Dependencies: 1068 1068
-- Name: devolucion_pkey; Type: CONSTRAINT; Schema: public; Owner: infocid; Tablespace: 
--

ALTER TABLE ONLY devolucion
    ADD CONSTRAINT devolucion_pkey PRIMARY KEY (coddev);


--
-- TOC entry 1334 (class 16386 OID 1689493)
-- Dependencies: 1070 1070
-- Name: estadistica_pkey; Type: CONSTRAINT; Schema: public; Owner: infocid; Tablespace: 
--

ALTER TABLE ONLY estadistica
    ADD CONSTRAINT estadistica_pkey PRIMARY KEY (numero);


--
-- TOC entry 1337 (class 16386 OID 1689499)
-- Dependencies: 1071 1071
-- Name: externo_pkey; Type: CONSTRAINT; Schema: public; Owner: infocid; Tablespace: 
--

ALTER TABLE ONLY externo
    ADD CONSTRAINT externo_pkey PRIMARY KEY (dni);


--
-- TOC entry 1365 (class 16386 OID 1985533)
-- Dependencies: 1084 1084
-- Name: id_pkey; Type: CONSTRAINT; Schema: public; Owner: infocid; Tablespace: 
--

ALTER TABLE ONLY gestion
    ADD CONSTRAINT id_pkey PRIMARY KEY (id);


--
-- TOC entry 1340 (class 16386 OID 1689505)
-- Dependencies: 1072 1072
-- Name: interno_pkey; Type: CONSTRAINT; Schema: public; Owner: infocid; Tablespace: 
--

ALTER TABLE ONLY interno
    ADD CONSTRAINT interno_pkey PRIMARY KEY (numcarnet);


--
-- TOC entry 1343 (class 16386 OID 1689511)
-- Dependencies: 1073 1073
-- Name: lector_pkey; Type: CONSTRAINT; Schema: public; Owner: infocid; Tablespace: 
--

ALTER TABLE ONLY lector
    ADD CONSTRAINT lector_pkey PRIMARY KEY (codlector);


--
-- TOC entry 1345 (class 16386 OID 1689534)
-- Dependencies: 1074 1074
-- Name: libro_pkey; Type: CONSTRAINT; Schema: public; Owner: infocid; Tablespace: 
--

ALTER TABLE ONLY libro
    ADD CONSTRAINT libro_pkey PRIMARY KEY (registro);


--
-- TOC entry 1362 (class 16386 OID 1689599)
-- Dependencies: 1082 1082
-- Name: libroinv_pkey; Type: CONSTRAINT; Schema: public; Owner: infocid; Tablespace: 
--

ALTER TABLE ONLY libroinv
    ADD CONSTRAINT libroinv_pkey PRIMARY KEY (registro);


--
-- TOC entry 1351 (class 16386 OID 1689539)
-- Dependencies: 1075 1075
-- Name: parametro_pkey; Type: CONSTRAINT; Schema: public; Owner: infocid; Tablespace: 
--

ALTER TABLE ONLY parametro
    ADD CONSTRAINT parametro_pkey PRIMARY KEY (numreg);


--
-- TOC entry 1354 (class 16386 OID 1689546)
-- Dependencies: 1076 1076
-- Name: regprest_pkey; Type: CONSTRAINT; Schema: public; Owner: infocid; Tablespace: 
--

ALTER TABLE ONLY regprest
    ADD CONSTRAINT regprest_pkey PRIMARY KEY (codprest);


--
-- TOC entry 1357 (class 16386 OID 1689551)
-- Dependencies: 1077 1077
-- Name: usuario_pkey; Type: CONSTRAINT; Schema: public; Owner: infocid; Tablespace: 
--

ALTER TABLE ONLY usuario
    ADD CONSTRAINT usuario_pkey PRIMARY KEY (codusuario);


--
-- TOC entry 1359 (class 16386 OID 1689564)
-- Dependencies: 1078 1078
-- Name: video_pkey; Type: CONSTRAINT; Schema: public; Owner: infocid; Tablespace: 
--

ALTER TABLE ONLY video
    ADD CONSTRAINT video_pkey PRIMARY KEY (registro);


--
-- TOC entry 1319 (class 1259 OID 1689464)
-- Dependencies: 1065
-- Name: alumno_numcarnet_key; Type: INDEX; Schema: public; Owner: infocid; Tablespace: 
--

CREATE INDEX alumno_numcarnet_key ON alumno USING btree (numcarnet);


--
-- TOC entry 1322 (class 1259 OID 1689469)
-- Dependencies: 1066
-- Name: detdev_numdet_key; Type: INDEX; Schema: public; Owner: infocid; Tablespace: 
--

CREATE INDEX detdev_numdet_key ON detdev USING btree (numdet);


--
-- TOC entry 1325 (class 1259 OID 1689474)
-- Dependencies: 1067
-- Name: detprest_numdetalle_key; Type: INDEX; Schema: public; Owner: infocid; Tablespace: 
--

CREATE INDEX detprest_numdetalle_key ON detprest USING btree (numdetalle);


--
-- TOC entry 1328 (class 1259 OID 1689479)
-- Dependencies: 1068
-- Name: devolucion_coddev_key; Type: INDEX; Schema: public; Owner: infocid; Tablespace: 
--

CREATE INDEX devolucion_coddev_key ON devolucion USING btree (coddev);


--
-- TOC entry 1332 (class 1259 OID 1689494)
-- Dependencies: 1070
-- Name: estadistica_numero_key; Type: INDEX; Schema: public; Owner: infocid; Tablespace: 
--

CREATE INDEX estadistica_numero_key ON estadistica USING btree (numero);


--
-- TOC entry 1335 (class 1259 OID 1689500)
-- Dependencies: 1071
-- Name: externo_dni_key; Type: INDEX; Schema: public; Owner: infocid; Tablespace: 
--

CREATE INDEX externo_dni_key ON externo USING btree (dni);


--
-- TOC entry 1338 (class 1259 OID 1689506)
-- Dependencies: 1072
-- Name: interno_numcarnet_key; Type: INDEX; Schema: public; Owner: infocid; Tablespace: 
--

CREATE INDEX interno_numcarnet_key ON interno USING btree (numcarnet);


--
-- TOC entry 1341 (class 1259 OID 1689512)
-- Dependencies: 1073
-- Name: lector_codlector_key; Type: INDEX; Schema: public; Owner: infocid; Tablespace: 
--

CREATE INDEX lector_codlector_key ON lector USING btree (codlector);


--
-- TOC entry 1346 (class 1259 OID 1689535)
-- Dependencies: 1074
-- Name: libro_registro_key; Type: INDEX; Schema: public; Owner: infocid; Tablespace: 
--

CREATE INDEX libro_registro_key ON libro USING btree (registro);


--
-- TOC entry 1363 (class 1259 OID 1689600)
-- Dependencies: 1082
-- Name: libroinv_registro_key; Type: INDEX; Schema: public; Owner: infocid; Tablespace: 
--

CREATE INDEX libroinv_registro_key ON libroinv USING btree (registro);


--
-- TOC entry 1331 (class 1259 OID 1689487)
-- Dependencies: 1069
-- Name: orden_documento_key; Type: INDEX; Schema: public; Owner: infocid; Tablespace: 
--

CREATE INDEX orden_documento_key ON documento USING btree (orden);


--
-- TOC entry 1347 (class 1259 OID 1689540)
-- Dependencies: 1075
-- Name: parametro_codlector_key; Type: INDEX; Schema: public; Owner: infocid; Tablespace: 
--

CREATE INDEX parametro_codlector_key ON parametro USING btree (codlector);


--
-- TOC entry 1348 (class 1259 OID 1689541)
-- Dependencies: 1075
-- Name: parametro_numreg1_key; Type: INDEX; Schema: public; Owner: infocid; Tablespace: 
--

CREATE INDEX parametro_numreg1_key ON parametro USING btree (numreg);


--
-- TOC entry 1349 (class 1259 OID 1689542)
-- Dependencies: 1075 1075
-- Name: parametro_numreg_key; Type: INDEX; Schema: public; Owner: infocid; Tablespace: 
--

CREATE UNIQUE INDEX parametro_numreg_key ON parametro USING btree (codlector, numreg);


--
-- TOC entry 1352 (class 1259 OID 1689547)
-- Dependencies: 1076
-- Name: regprest_codprest_key; Type: INDEX; Schema: public; Owner: infocid; Tablespace: 
--

CREATE INDEX regprest_codprest_key ON regprest USING btree (codprest);


--
-- TOC entry 1355 (class 1259 OID 1689552)
-- Dependencies: 1077
-- Name: usuario_codusuario_key; Type: INDEX; Schema: public; Owner: infocid; Tablespace: 
--

CREATE INDEX usuario_codusuario_key ON usuario USING btree (codusuario);


--
-- TOC entry 1360 (class 1259 OID 1689565)
-- Dependencies: 1078
-- Name: video_registro_key; Type: INDEX; Schema: public; Owner: infocid; Tablespace: 
--

CREATE INDEX video_registro_key ON video USING btree (registro);


--
-- TOC entry 1366 (class 16412 OID 1689575)
-- Dependencies: 1065 1073
-- Name: RI_ConstraintTrigger_1689575; Type: TRIGGER; Schema: public; Owner: infocid
--

CREATE CONSTRAINT TRIGGER "RI_ConstraintTrigger_22404"
    AFTER INSERT OR UPDATE ON alumno
    FROM lector
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_check_ins"('<unnamed>', 'alumno', 'lector', 'UNSPECIFIED', 'codlector', 'codlector');


--
-- TOC entry 1372 (class 16412 OID 1689576)
-- Dependencies: 1073 1065
-- Name: RI_ConstraintTrigger_1689576; Type: TRIGGER; Schema: public; Owner: infocid
--

CREATE CONSTRAINT TRIGGER "RI_ConstraintTrigger_22406"
    AFTER DELETE ON lector
    FROM alumno
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_del"('<unnamed>', 'alumno', 'lector', 'UNSPECIFIED', 'codlector', 'codlector');


--
-- TOC entry 1373 (class 16412 OID 1689577)
-- Dependencies: 1073 1065
-- Name: RI_ConstraintTrigger_1689577; Type: TRIGGER; Schema: public; Owner: infocid
--

CREATE CONSTRAINT TRIGGER "RI_ConstraintTrigger_22408"
    AFTER UPDATE ON lector
    FROM alumno
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_upd"('<unnamed>', 'alumno', 'lector', 'UNSPECIFIED', 'codlector', 'codlector');


--
-- TOC entry 1370 (class 16412 OID 1689578)
-- Dependencies: 1071 1073
-- Name: RI_ConstraintTrigger_1689578; Type: TRIGGER; Schema: public; Owner: infocid
--

CREATE CONSTRAINT TRIGGER "RI_ConstraintTrigger_22436"
    AFTER INSERT OR UPDATE ON externo
    FROM lector
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_check_ins"('<unnamed>', 'externo', 'lector', 'UNSPECIFIED', 'codlector', 'codlector');


--
-- TOC entry 1374 (class 16412 OID 1689579)
-- Dependencies: 1073 1071
-- Name: RI_ConstraintTrigger_1689579; Type: TRIGGER; Schema: public; Owner: infocid
--

CREATE CONSTRAINT TRIGGER "RI_ConstraintTrigger_22438"
    AFTER DELETE ON lector
    FROM externo
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_del"('<unnamed>', 'externo', 'lector', 'UNSPECIFIED', 'codlector', 'codlector');


--
-- TOC entry 1375 (class 16412 OID 1689580)
-- Dependencies: 1073 1071
-- Name: RI_ConstraintTrigger_1689580; Type: TRIGGER; Schema: public; Owner: infocid
--

CREATE CONSTRAINT TRIGGER "RI_ConstraintTrigger_22440"
    AFTER UPDATE ON lector
    FROM externo
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_upd"('<unnamed>', 'externo', 'lector', 'UNSPECIFIED', 'codlector', 'codlector');


--
-- TOC entry 1371 (class 16412 OID 1689581)
-- Dependencies: 1072 1073
-- Name: RI_ConstraintTrigger_1689581; Type: TRIGGER; Schema: public; Owner: infocid
--

CREATE CONSTRAINT TRIGGER "RI_ConstraintTrigger_22467"
    AFTER INSERT OR UPDATE ON interno
    FROM lector
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_check_ins"('<unnamed>', 'interno', 'lector', 'UNSPECIFIED', 'codlector', 'codlector');


--
-- TOC entry 1376 (class 16412 OID 1689582)
-- Dependencies: 1073 1072
-- Name: RI_ConstraintTrigger_1689582; Type: TRIGGER; Schema: public; Owner: infocid
--

CREATE CONSTRAINT TRIGGER "RI_ConstraintTrigger_22469"
    AFTER DELETE ON lector
    FROM interno
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_del"('<unnamed>', 'interno', 'lector', 'UNSPECIFIED', 'codlector', 'codlector');


--
-- TOC entry 1377 (class 16412 OID 1689583)
-- Dependencies: 1073 1072
-- Name: RI_ConstraintTrigger_1689583; Type: TRIGGER; Schema: public; Owner: infocid
--

CREATE CONSTRAINT TRIGGER "RI_ConstraintTrigger_22471"
    AFTER UPDATE ON lector
    FROM interno
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_upd"('<unnamed>', 'interno', 'lector', 'UNSPECIFIED', 'codlector', 'codlector');


--
-- TOC entry 1380 (class 16412 OID 1689584)
-- Dependencies: 1075 1073
-- Name: RI_ConstraintTrigger_1689584; Type: TRIGGER; Schema: public; Owner: infocid
--

CREATE CONSTRAINT TRIGGER "RI_ConstraintTrigger_22515"
    AFTER INSERT OR UPDATE ON parametro
    FROM lector
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_check_ins"('<unnamed>', 'parametro', 'lector', 'UNSPECIFIED', 'codlector', 'codlector');


--
-- TOC entry 1378 (class 16412 OID 1689585)
-- Dependencies: 1073 1075
-- Name: RI_ConstraintTrigger_1689585; Type: TRIGGER; Schema: public; Owner: infocid
--

CREATE CONSTRAINT TRIGGER "RI_ConstraintTrigger_22517"
    AFTER DELETE ON lector
    FROM parametro
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_del"('<unnamed>', 'parametro', 'lector', 'UNSPECIFIED', 'codlector', 'codlector');


--
-- TOC entry 1379 (class 16412 OID 1689586)
-- Dependencies: 1073 1075
-- Name: RI_ConstraintTrigger_1689586; Type: TRIGGER; Schema: public; Owner: infocid
--

CREATE CONSTRAINT TRIGGER "RI_ConstraintTrigger_22519"
    AFTER UPDATE ON lector
    FROM parametro
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_upd"('<unnamed>', 'parametro', 'lector', 'UNSPECIFIED', 'codlector', 'codlector');


--
-- TOC entry 1367 (class 16412 OID 1689587)
-- Dependencies: 1067 1076
-- Name: RI_ConstraintTrigger_1689587; Type: TRIGGER; Schema: public; Owner: infocid
--

CREATE CONSTRAINT TRIGGER "RI_ConstraintTrigger_22562"
    AFTER INSERT OR UPDATE ON detprest
    FROM regprest
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_check_ins"('<unnamed>', 'detprest', 'regprest', 'UNSPECIFIED', 'codprest', 'codprest');


--
-- TOC entry 1381 (class 16412 OID 1689588)
-- Dependencies: 1076 1067
-- Name: RI_ConstraintTrigger_1689588; Type: TRIGGER; Schema: public; Owner: infocid
--

CREATE CONSTRAINT TRIGGER "RI_ConstraintTrigger_22564"
    AFTER DELETE ON regprest
    FROM detprest
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_del"('<unnamed>', 'detprest', 'regprest', 'UNSPECIFIED', 'codprest', 'codprest');


--
-- TOC entry 1382 (class 16412 OID 1689589)
-- Dependencies: 1076 1067
-- Name: RI_ConstraintTrigger_1689589; Type: TRIGGER; Schema: public; Owner: infocid
--

CREATE CONSTRAINT TRIGGER "RI_ConstraintTrigger_22566"
    AFTER UPDATE ON regprest
    FROM detprest
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_upd"('<unnamed>', 'detprest', 'regprest', 'UNSPECIFIED', 'codprest', 'codprest');


--
-- TOC entry 1368 (class 16412 OID 1689590)
-- Dependencies: 1068 1076
-- Name: RI_ConstraintTrigger_1689590; Type: TRIGGER; Schema: public; Owner: infocid
--

CREATE CONSTRAINT TRIGGER "RI_ConstraintTrigger_22587"
    AFTER INSERT OR UPDATE ON devolucion
    FROM regprest
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_check_ins"('<unnamed>', 'devolucion', 'regprest', 'UNSPECIFIED', 'codprest', 'codprest');


--
-- TOC entry 1383 (class 16412 OID 1689591)
-- Dependencies: 1076 1068
-- Name: RI_ConstraintTrigger_1689591; Type: TRIGGER; Schema: public; Owner: infocid
--

CREATE CONSTRAINT TRIGGER "RI_ConstraintTrigger_22589"
    AFTER DELETE ON regprest
    FROM devolucion
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_del"('<unnamed>', 'devolucion', 'regprest', 'UNSPECIFIED', 'codprest', 'codprest');


--
-- TOC entry 1384 (class 16412 OID 1689592)
-- Dependencies: 1076 1068
-- Name: RI_ConstraintTrigger_1689592; Type: TRIGGER; Schema: public; Owner: infocid
--

CREATE CONSTRAINT TRIGGER "RI_ConstraintTrigger_22591"
    AFTER UPDATE ON regprest
    FROM devolucion
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_upd"('<unnamed>', 'devolucion', 'regprest', 'UNSPECIFIED', 'codprest', 'codprest');


--
-- TOC entry 1369 (class 16412 OID 1689593)
-- Dependencies: 1068 1077
-- Name: RI_ConstraintTrigger_1689593; Type: TRIGGER; Schema: public; Owner: infocid
--

CREATE CONSTRAINT TRIGGER "RI_ConstraintTrigger_22593"
    AFTER INSERT OR UPDATE ON devolucion
    FROM usuario
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_check_ins"('<unnamed>', 'devolucion', 'usuario', 'UNSPECIFIED', 'codusuario', 'codusuario');


--
-- TOC entry 1385 (class 16412 OID 1689594)
-- Dependencies: 1077 1068
-- Name: RI_ConstraintTrigger_1689594; Type: TRIGGER; Schema: public; Owner: infocid
--

CREATE CONSTRAINT TRIGGER "RI_ConstraintTrigger_22595"
    AFTER DELETE ON usuario
    FROM devolucion
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_del"('<unnamed>', 'devolucion', 'usuario', 'UNSPECIFIED', 'codusuario', 'codusuario');


--
-- TOC entry 1386 (class 16412 OID 1689595)
-- Dependencies: 1077 1068
-- Name: RI_ConstraintTrigger_1689595; Type: TRIGGER; Schema: public; Owner: infocid
--

CREATE CONSTRAINT TRIGGER "RI_ConstraintTrigger_22597"
    AFTER UPDATE ON usuario
    FROM devolucion
    NOT DEFERRABLE INITIALLY IMMEDIATE
    FOR EACH ROW
    EXECUTE PROCEDURE "RI_FKey_noaction_upd"('<unnamed>', 'devolucion', 'usuario', 'UNSPECIFIED', 'codusuario', 'codusuario');


--
-- TOC entry 1411 (class 0 OID 0)
-- Name: DUMP TIMESTAMP; Type: DUMP TIMESTAMP; Schema: -; Owner: 
--

-- Completed on 2005-03-07 02:41:33 Hora estndar de Sudamrica O.


--
-- TOC entry 1407 (class 0 OID 0)
-- Dependencies: 3
-- Name: public; Type: ACL; Schema: -; Owner: postgres
--

REVOKE ALL ON SCHEMA public FROM PUBLIC;
REVOKE ALL ON SCHEMA public FROM postgres;
GRANT ALL ON SCHEMA public TO PUBLIC;


--
-- TOC entry 1410 (class 0 OID 0)
-- Dependencies: 1074
-- Name: libro; Type: ACL; Schema: public; Owner: infocid
--

REVOKE ALL ON TABLE libro FROM PUBLIC;
GRANT ALL ON TABLE libro TO postgres;


