/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.taglib;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.BodyContent;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.util.MessageResources;
import org.apache.struts.util.ResponseUtils;

public class TagUtils {
    private static TagUtils instance = new TagUtils();
    private static final Log log = LogFactory.getLog(TagUtils.class);
    private static final MessageResources messages = MessageResources.getMessageResources((String)"org.apache.struts.taglib.LocalStrings");
    private static final Map scopes = new HashMap();

    protected TagUtils() {
    }

    public static TagUtils getInstance() {
        return instance;
    }

    public static void setInstance(TagUtils instance) {
        TagUtils.instance = instance;
    }

    public Map computeParameters(PageContext pageContext, String paramId, String paramName, String paramProperty, String paramScope, String name, String property, String scope, boolean transaction) throws JspException {
        if (paramId == null && name == null && !transaction) {
            return null;
        }
        Map map = null;
        try {
            if (name != null) {
                map = (Map)TagUtils.getInstance().lookup(pageContext, name, property, scope);
            }
        }
        catch (JspException e) {
            this.saveException(pageContext, e);
            throw e;
        }
        HashMap<String, Object> results = null;
        results = map != null ? new HashMap(map) : new HashMap<String, Object>();
        if (paramId != null && paramName != null) {
            Object paramValue = null;
            try {
                paramValue = TagUtils.getInstance().lookup(pageContext, paramName, paramProperty, paramScope);
            }
            catch (JspException e) {
                this.saveException(pageContext, e);
                throw e;
            }
            if (paramValue != null) {
                String paramString = null;
                paramString = paramValue instanceof String ? (String)paramValue : paramValue.toString();
                Object mapValue = results.get(paramId);
                if (mapValue == null) {
                    results.put(paramId, paramString);
                } else if (mapValue instanceof String[]) {
                    String[] oldValues = (String[])mapValue;
                    String[] newValues = new String[oldValues.length + 1];
                    System.arraycopy(oldValues, 0, newValues, 0, oldValues.length);
                    newValues[oldValues.length] = paramString;
                    results.put(paramId, newValues);
                } else {
                    String[] newValues = new String[]{mapValue.toString(), paramString};
                    results.put(paramId, newValues);
                }
            }
        }
        if (transaction) {
            HttpSession session = pageContext.getSession();
            String token = null;
            if (session != null) {
                token = (String)session.getAttribute("org.apache.struts.action.TOKEN");
            }
            if (token != null) {
                results.put("org.apache.struts.taglib.html.TOKEN", token);
            }
        }
        return results;
    }

    public String computeURL(PageContext pageContext, String forward, String href, String page, String action, String module, Map params, String anchor, boolean redirect) throws MalformedURLException {
        return this.computeURLWithCharEncoding(pageContext, forward, href, page, action, module, params, anchor, redirect, false);
    }

    public String computeURLWithCharEncoding(PageContext pageContext, String forward, String href, String page, String action, String module, Map params, String anchor, boolean redirect, boolean useLocalEncoding) throws MalformedURLException {
        return this.computeURLWithCharEncoding(pageContext, forward, href, page, action, module, params, anchor, redirect, true, useLocalEncoding);
    }

    public String computeURL(PageContext pageContext, String forward, String href, String page, String action, String module, Map params, String anchor, boolean redirect, boolean encodeSeparator) throws MalformedURLException {
        return this.computeURLWithCharEncoding(pageContext, forward, href, page, action, module, params, anchor, redirect, encodeSeparator, false);
    }

    public String computeURLWithCharEncoding(PageContext pageContext, String forward, String href, String page, String action, String module, Map params, String anchor, boolean redirect, boolean encodeSeparator, boolean useLocalEncoding) throws MalformedURLException {
        String charEncoding = "UTF-8";
        return null;
    }

    public String filter(String value) {
        return ResponseUtils.filter((String)value);
    }

    public int getScope(String scopeName) throws JspException {
        Integer scope = (Integer)scopes.get(scopeName.toLowerCase());
        if (scope == null) {
            throw new JspException(messages.getMessage("lookup.scope", (Object)scope));
        }
        return scope;
    }

    public Locale getUserLocale(PageContext pageContext, String locale) {
        return null;
    }

    public boolean isXhtml(PageContext pageContext) {
        String xhtml = (String)pageContext.getAttribute("org.apache.struts.globals.XHTML", 1);
        return "true".equalsIgnoreCase(xhtml);
    }

    public Object lookup(PageContext pageContext, String name, String scopeName) throws JspException {
        if (scopeName == null) {
            return pageContext.findAttribute(name);
        }
        try {
            return pageContext.getAttribute(name, instance.getScope(scopeName));
        }
        catch (JspException e) {
            this.saveException(pageContext, e);
            throw e;
        }
    }

    public Object lookup(PageContext pageContext, String name, String property, String scope) throws JspException {
        Object bean = this.lookup(pageContext, name, scope);
        if (bean == null) {
            JspException e = null;
            e = scope == null ? new JspException(messages.getMessage("lookup.bean.any", (Object)name)) : new JspException(messages.getMessage("lookup.bean", (Object)name, (Object)scope));
            this.saveException(pageContext, e);
            throw e;
        }
        if (property == null) {
            return bean;
        }
        try {
            return PropertyUtils.getProperty((Object)bean, (String)property);
        }
        catch (IllegalAccessException e) {
            this.saveException(pageContext, e);
            throw new JspException(messages.getMessage("lookup.access", (Object)property, (Object)name));
        }
        catch (IllegalArgumentException e) {
            this.saveException(pageContext, e);
            throw new JspException(messages.getMessage("lookup.argument", (Object)property, (Object)name));
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t == null) {
                t = e;
            }
            this.saveException(pageContext, t);
            throw new JspException(messages.getMessage("lookup.target", (Object)property, (Object)name));
        }
        catch (NoSuchMethodException e) {
            Object obj;
            this.saveException(pageContext, e);
            String beanName = name;
            if ("org.apache.struts.taglib.html.BEAN".equals(name) && (obj = pageContext.findAttribute("org.apache.struts.taglib.html.BEAN")) != null) {
                beanName = obj.getClass().getName();
            }
            throw new JspException(messages.getMessage("lookup.method", (Object)property, (Object)beanName));
        }
    }

    public String message(PageContext pageContext, String bundle, String locale, String key) throws JspException {
        return this.message(pageContext, bundle, locale, key, null);
    }

    public String message(PageContext pageContext, String bundle, String locale, String key, Object[] args) throws JspException {
        MessageResources resources = this.retrieveMessageResources(pageContext, bundle, false);
        Locale userLocale = this.getUserLocale(pageContext, locale);
        String message = null;
        message = args == null ? resources.getMessage(userLocale, key) : resources.getMessage(userLocale, key, args);
        if (message == null && log.isDebugEnabled()) {
            log.debug((Object)resources.getMessage("message.resources", (Object)key, (Object)bundle, (Object)locale));
        }
        return message;
    }

    public boolean present(PageContext pageContext, String bundle, String locale, String key) throws JspException {
        MessageResources resources = this.retrieveMessageResources(pageContext, bundle, true);
        Locale userLocale = this.getUserLocale(pageContext, locale);
        return resources.isPresent(userLocale, key);
    }

    public MessageResources retrieveMessageResources(PageContext pageContext, String bundle, boolean checkPageScope) throws JspException {
        MessageResources resources = null;
        if (bundle == null) {
            bundle = "org.apache.struts.action.MESSAGE";
        }
        if (checkPageScope) {
            resources = (MessageResources)pageContext.getAttribute(bundle, 1);
        }
        if (resources == null) {
            resources = (MessageResources)pageContext.getAttribute(bundle, 2);
        }
        if (resources == null) {
            resources = (MessageResources)pageContext.getAttribute(bundle, 4);
        }
        if (resources == null) {
            JspException e = new JspException(messages.getMessage("message.bundle", (Object)bundle));
            this.saveException(pageContext, e);
            throw e;
        }
        return resources;
    }

    public void saveException(PageContext pageContext, Throwable exception) {
        pageContext.setAttribute("org.apache.struts.action.EXCEPTION", (Object)exception, 2);
    }

    public void write(PageContext pageContext, String text) throws JspException {
        JspWriter writer = pageContext.getOut();
        try {
            writer.print(text);
        }
        catch (IOException e) {
            this.saveException(pageContext, e);
            throw new JspException(messages.getMessage("write.io", (Object)e.toString()));
        }
    }

    public void writePrevious(PageContext pageContext, String text) throws JspException {
        JspWriter writer = pageContext.getOut();
        if (writer instanceof BodyContent) {
            writer = ((BodyContent)writer).getEnclosingWriter();
        }
        try {
            writer.print(text);
        }
        catch (IOException e) {
            this.saveException(pageContext, e);
            throw new JspException(messages.getMessage("write.io", (Object)e.toString()));
        }
    }

    static {
        scopes.put("page", new Integer(1));
        scopes.put("request", new Integer(2));
        scopes.put("session", new Integer(3));
        scopes.put("application", new Integer(4));
    }
}

