/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.schema;

import com.kwoksys.schema.SchemaProperties;
import com.kwoksys.schema.versions.Schema;
import java.util.LinkedHashMap;
import java.util.Map;

public class SchemaFactory {
    static Map<String, Schema> versionMap = new LinkedHashMap<String, Schema>();
    static Map<String, String> previousVersionMap = new LinkedHashMap<String, String>();

    public static Schema getSchema(String version) {
        return versionMap.get(version);
    }

    public static Schema getLatestSchema() {
        return SchemaFactory.getSchema(SchemaProperties.getInstance().getLatestVersion());
    }

    public static Schema getPreviousSchema(String version) {
        return SchemaFactory.getSchema(previousVersionMap.get(version));
    }

    static {
        String[] versions = SchemaProperties.getInstance().getAllVersions();
        String version = null;
        for (String prevVersion : versions) {
            versionMap.put(prevVersion, new Schema(prevVersion));
            if (version != null) {
                previousVersionMap.put(version, prevVersion);
            }
            version = prevVersion;
        }
    }
}

