/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.schema;

import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SchemaProperties {
    private static final Logger logger = Logger.getLogger(SchemaProperties.class.getName());
    private static final SchemaProperties INSTANCE = new SchemaProperties();
    public static final String SCHEMA_VERSION = "schema.version";
    public static final String SCHEMA_PREVIOUS_VERSIONS = "schema.previousVersions";
    private Properties props;
    private String latestVersion;
    private String[] allVersions;

    private void init() {
        logger.info("Loading schemasetup properties...");
        try {
            this.props = new Properties();
            this.props.load(SchemaProperties.class.getResourceAsStream("Schema.properties"));
            this.latestVersion = this.props.getProperty(SCHEMA_VERSION);
            this.allVersions = (this.latestVersion + "," + this.props.getProperty(SCHEMA_PREVIOUS_VERSIONS)).replace(" ", "").split(",");
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Problem loading property file.", e);
        }
    }

    public static SchemaProperties getInstance() {
        return INSTANCE;
    }

    public String getLatestVersion() {
        return this.latestVersion;
    }

    public String[] getAllVersions() {
        return this.allVersions;
    }

    static {
        INSTANCE.init();
    }
}

