/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.schema;

import com.kwoksys.biz.system.license.LicenseValidator;
import com.kwoksys.schema.SchemaSetupParams;
import com.kwoksys.schema.commands.SchemaSetupCommand;
import com.kwoksys.schema.commands.SchemaStatsCommand;
import com.kwoksys.schema.exceptions.DatabaseDriverException;
import com.kwoksys.schema.output.BaseOutput;
import com.kwoksys.schema.output.SystemOutput;

public class SchemaSetup {
    public static void main(String[] args) {
        SystemOutput out = SystemOutput.getInstance();
        SchemaSetupParams params = new SchemaSetupParams();
        if (!params.validateInputs(args)) {
            return;
        }
        try {
            if (params.getInstallType().equals("encrypt")) {
                ((BaseOutput)out).println(LicenseValidator.hash(params.getPassword()));
                return;
            }
            ((BaseOutput)out).print("Loading database driver " + params.getDriverName() + "... ");
            try {
                Class.forName(params.getDriverName());
            }
            catch (ClassNotFoundException e) {
                throw new DatabaseDriverException("Problem loading driver: " + e.getMessage());
            }
            ((BaseOutput)out).println("done");
            if (params.getInstallType().equals("stats")) {
                new SchemaStatsCommand().execute(out, params);
            } else {
                new SchemaSetupCommand().execute(out, params);
            }
        }
        catch (Exception e) {
            ((BaseOutput)out).println("failed. " + e.getMessage() + ". Cause: " + e.getCause());
            ((BaseOutput)out).println("Schema setup encountered errors");
        }
    }
}

