/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.schema;

import com.kwoksys.biz.system.license.LicenseValidator;
import com.kwoksys.schema.output.BaseOutput;
import com.kwoksys.schema.output.SystemOutput;
import java.util.Arrays;
import java.util.List;

public class SchemaSetupParams {
    public static final String CREATE = "install";
    public static final String UPGRADE = "upgrade";
    public static final String ENCRYPT = "encrypt";
    public static final String STATS = "stats";
    public static final List<String> VALID_COMMANDS = Arrays.asList("install", "upgrade", "encrypt", "stats");
    public static final String DATABASE_PARAM = "database";
    public static final String USERNAME_PARAM = "username";
    public static final String PASSWORD_PARAM = "password";
    public static final String HOST_PARAM = "host";
    public static final String PORT_PARAM = "port";
    public static final String DEBUG_PARAM = "debug";
    public static final String LICENSE_PARAM = "license";
    private String installType = "";
    private String database = "";
    private String username = "";
    private String password = "";
    private String host = "localhost";
    private String port = "5432";
    private String license = "";
    private String installedVersion = "";
    private String driverName = "org.postgresql.Driver";
    private boolean isDebug = false;

    public boolean validateInputs(String[] args) {
        boolean valid = true;
        for (String arg : args) {
            String[] keyValue = arg.split("=");
            try {
                if (VALID_COMMANDS.contains(keyValue[0])) {
                    this.setInstallType(keyValue[0]);
                    continue;
                }
                if (keyValue[0].equals(DATABASE_PARAM)) {
                    this.setDatabase(keyValue[1]);
                    continue;
                }
                if (keyValue[0].equals(USERNAME_PARAM)) {
                    this.setUsername(keyValue[1]);
                    continue;
                }
                if (keyValue[0].equals(PASSWORD_PARAM)) {
                    this.setPassword(keyValue[1]);
                    continue;
                }
                if (keyValue[0].equals(HOST_PARAM)) {
                    this.setHost(keyValue[1]);
                    continue;
                }
                if (keyValue[0].equals(PORT_PARAM)) {
                    this.setPort(keyValue[1]);
                    continue;
                }
                if (keyValue[0].equals(LICENSE_PARAM)) {
                    this.setLicense(keyValue[1]);
                    continue;
                }
                if (!keyValue[0].equals(DEBUG_PARAM)) continue;
                this.setDebug(keyValue[1].equals("true"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        SystemOutput out = SystemOutput.getInstance();
        if (this.getInstallType().isEmpty()) {
            valid = false;
            ((BaseOutput)out).println("You must specify either install or upgrade option");
        } else if (this.getInstallType().equals(CREATE) || this.getInstallType().equals(UPGRADE) || this.getInstallType().equals(STATS)) {
            if (this.getDatabase().isEmpty()) {
                valid = false;
                ((BaseOutput)out).println("\"database\" option is missing");
            }
            if (this.getDatabase().equals("postgres")) {
                valid = false;
                ((BaseOutput)out).println("postgres is default database, we don't support installing on it");
            }
            if (this.getUsername().isEmpty()) {
                valid = false;
                ((BaseOutput)out).println("\"username\" option is missing");
            }
        }
        if (this.getInstallType().equals(STATS) || this.getInstallType().equals(ENCRYPT)) {
            boolean validLicense;
            if (this.getLicense().isEmpty()) {
                valid = false;
                ((BaseOutput)out).println("\"license\" option is missing or empty");
            }
            if (!(validLicense = LicenseValidator.isValid(this.getLicense()))) {
                valid = false;
                ((BaseOutput)out).println("Invalid license key " + this.getLicense());
            }
        }
        if (this.getPassword().isEmpty()) {
            valid = false;
            ((BaseOutput)out).println("\"password\" option is missing");
        }
        return valid;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public String getDatabase() {
        return this.database;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public String getInstalledVersion() {
        return this.installedVersion;
    }

    public void setInstalledVersion(String installedVersion) {
        this.installedVersion = installedVersion;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getDriverName() {
        return this.driverName;
    }

    public void setDriverName(String driverName) {
        this.driverName = driverName;
    }

    public String getInstallType() {
        return this.installType;
    }

    public void setInstallType(String installType) {
        this.installType = installType;
    }

    public boolean isDebug() {
        return this.isDebug;
    }

    public void setDebug(boolean debug) {
        this.isDebug = debug;
    }

    public String getLicense() {
        return this.license;
    }

    public void setLicense(String license) {
        this.license = license;
    }
}

