/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.schema;

import com.kwoksys.schema.SchemaSetupParams;
import com.kwoksys.schema.output.BaseOutput;
import com.kwoksys.schema.output.SystemOutput;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;

public class SchemaUtil {
    public static Connection createConnection(SchemaSetupParams params, String database) throws SQLException {
        Connection conn;
        DatabaseMetaData meta;
        SystemOutput output = SystemOutput.getInstance();
        Properties prop = new Properties();
        prop.put("user", params.getUsername());
        prop.put("password", params.getPassword());
        ((BaseOutput)output).print("Connecting to PostgreSQL Server...");
        if (!database.isEmpty()) {
            ((BaseOutput)output).print(", database: " + database + ",...");
        }
        if ((meta = (conn = DriverManager.getConnection("jdbc:postgresql://" + params.getHost() + ":" + params.getPort() + "/" + database, prop)).getMetaData()).getDatabaseProductVersion().startsWith("8.1.") || meta.getDatabaseProductVersion().startsWith("8.2.") || meta.getDatabaseProductVersion().startsWith("8.3.")) {
            try {
                SchemaUtil.close(conn);
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new SQLException("Postgres version " + meta.getDatabaseProductVersion() + " is not supported. Supports 8.4.x and above.");
        }
        ((BaseOutput)output).println(" Postgres version " + meta.getDatabaseProductVersion() + " (supports 8.4.x and above)... done");
        return conn;
    }

    public static String loadSqlfile(String filename) throws IOException {
        InputStream in = SchemaUtil.class.getResourceAsStream(filename);
        BufferedInputStream stream = new BufferedInputStream(in);
        byte[] b = new byte[stream.available()];
        stream.read(b);
        stream.close();
        return new String(b);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String checkDatabaseVersion(SchemaSetupParams params) throws SQLException {
        Connection conn = SchemaUtil.createConnection(params, params.getDatabase());
        String schemaVersion = "";
        Statement stmt = conn.createStatement();
        stmt.execute("select config_value from system_config where config_key='schema.version'");
        ResultSet rs = stmt.getResultSet();
        try {
            if (rs.next()) {
                schemaVersion = rs.getString("config_value");
            }
        }
        finally {
            SchemaUtil.close(rs);
            SchemaUtil.close(stmt);
            SchemaUtil.close(conn);
        }
        return schemaVersion;
    }

    public static void close(ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void close(Statement stmt) {
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void close(Connection conn) {
        if (conn != null) {
            try {
                conn.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

