/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.schema.commands;

import com.kwoksys.schema.SchemaFactory;
import com.kwoksys.schema.SchemaSetupParams;
import com.kwoksys.schema.SchemaUtil;
import com.kwoksys.schema.output.BaseOutput;
import com.kwoksys.schema.versions.Schema;

public class SchemaSetupCommand {
    public void execute(BaseOutput out, SchemaSetupParams params) throws Exception {
        Schema schema = SchemaFactory.getLatestSchema();
        if (params.getInstallType().equals("install")) {
            out.println("Preparing to install version " + schema.getVersion() + "... ");
            schema.createDatabase(params);
            schema.prepDatabase(params);
            schema.create(params);
        } else if (params.getInstallType().equals("upgrade")) {
            params.setInstalledVersion(SchemaUtil.checkDatabaseVersion(params));
            if (params.getInstalledVersion().equals(schema.getVersion())) {
                out.println("Schema has the lastest version " + params.getInstalledVersion() + ", no upgrade required");
                return;
            }
            if (SchemaFactory.getSchema(params.getInstalledVersion()) == null) {
                throw new Exception("Upgrade from your installed version " + params.getInstalledVersion() + " is not supported");
            }
            out.println("Preparing to upgrade from version " + params.getInstalledVersion() + " to version " + schema.getVersion() + "... ");
            schema.prepDatabase(params);
            schema.upgrade(params);
        }
        out.println("Schema setup completed successfully");
    }
}

