/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.schema.commands;

import com.kwoksys.schema.SchemaSetupParams;
import com.kwoksys.schema.SchemaUtil;
import com.kwoksys.schema.output.BaseOutput;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public class SchemaStatsCommand {
    public void execute(BaseOutput out, SchemaSetupParams params) throws Exception {
        out.println("\n=== Schema Stats ===");
        out.println("Host: " + params.getHost());
        out.println("Port: " + params.getPort());
        out.println("Database: " + params.getDatabase());
        out.println("Username: " + params.getUsername());
        String schemaName = "public";
        out.println("Schema: " + schemaName);
        out.println("App version: " + SchemaUtil.checkDatabaseVersion(params));
        Connection conn = SchemaUtil.createConnection(params, params.getDatabase());
        PreparedStatement stmt = conn.prepareStatement("select count(1) as table_count from pg_stat_user_tables where schemaname = '" + schemaName + "'");
        stmt.execute();
        ResultSet rs = stmt.getResultSet();
        rs.next();
        out.println("\nTables: " + rs.getString("table_count"));
        stmt = conn.prepareStatement("select relname as table_name, n_tup_ins as row_count from pg_stat_user_tables where schemaname = '" + schemaName + "' order by relname");
        stmt.execute();
        rs = stmt.getResultSet();
        while (rs.next()) {
            out.println("- " + rs.getString("table_name") + ": " + rs.getString("row_count"));
        }
        stmt = conn.prepareStatement("select count(1) function_count FROM pg_proc p LEFT JOIN pg_namespace n ON n.oid = p.pronamespace where n.nspname='" + schemaName + "'");
        stmt.execute();
        rs = stmt.getResultSet();
        rs.next();
        out.println("\nFunctions: " + rs.getString("function_count"));
        stmt = conn.prepareStatement("select count(1) as seq_count from pg_statio_all_sequences where schemaname = '" + schemaName + "'");
        stmt.execute();
        rs = stmt.getResultSet();
        rs.next();
        out.println("Sequences: " + rs.getString("seq_count"));
        stmt = conn.prepareStatement("select count(1) as view_count from pg_views where schemaname = '" + schemaName + "'");
        stmt.execute();
        rs = stmt.getResultSet();
        rs.next();
        out.println("Views: " + rs.getString("view_count"));
        try {
            rs.close();
            conn.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        out.println("\n=== End ===");
    }
}

