/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.schema.versions;

import com.kwoksys.schema.SchemaFactory;
import com.kwoksys.schema.SchemaSetupParams;
import com.kwoksys.schema.SchemaUtil;
import com.kwoksys.schema.output.BaseOutput;
import com.kwoksys.schema.output.SystemOutput;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;

public class Schema {
    protected static BaseOutput output = SystemOutput.getInstance();
    protected String version;
    private String createSql;
    private String upgradeSql;
    private String refreshSql;

    public Schema(String version) {
        this.version = version;
        this.createSql = "versions/postgres/v" + version + "/create-schema-base-v" + version + ".sql";
        this.upgradeSql = "versions/postgres/v" + version + "/upgrade-to-v" + version + ".sql";
        this.refreshSql = "versions/postgres/v" + version + "/refresh-views-and-procedures-v" + version + ".sql";
    }

    public void createDatabase(SchemaSetupParams params) throws SQLException {
        Connection conn = SchemaUtil.createConnection(params, "");
        Statement stmt = conn.createStatement();
        output.print("Creating database " + params.getDatabase() + "... ");
        stmt.executeUpdate("CREATE DATABASE " + params.getDatabase() + " WITH ENCODING 'UTF8'");
        output.println("done");
        SchemaUtil.close(stmt);
        SchemaUtil.close(conn);
    }

    public void prepDatabase(SchemaSetupParams params) throws SQLException {
        Connection conn = SchemaUtil.createConnection(params, params.getDatabase());
        Statement stmt = conn.createStatement();
        output.print("Updating database timezone to GMT...");
        stmt.executeUpdate("ALTER DATABASE " + params.getDatabase() + " SET TimeZone='GMT'");
        output.println("done");
        try {
            output.print("Creating language 'plpgsql'... ");
            stmt.executeUpdate("CREATE TRUSTED PROCEDURAL LANGUAGE 'plpgsql' HANDLER plpgsql_call_handler VALIDATOR plpgsql_validator");
            output.println("done");
        }
        catch (Exception e) {
            if (params.isDebug()) {
                output.println(e);
            }
            output.println("Language 'plpgsql' already exists... done");
        }
        SchemaUtil.close(stmt);
        SchemaUtil.close(conn);
    }

    public void create(SchemaSetupParams params) throws SQLException, IOException {
        Connection conn = SchemaUtil.createConnection(params, params.getDatabase());
        Statement stmt = conn.createStatement();
        this.createSchema(stmt);
        this.upgradeSchema(stmt);
        this.createViewsProcedures(stmt);
        stmt.close();
        SchemaUtil.close(conn);
    }

    public void upgrade(SchemaSetupParams params) throws SQLException, IOException {
        Schema previousSchema = SchemaFactory.getPreviousSchema(this.version);
        if (!params.getInstalledVersion().equals(previousSchema.getVersion())) {
            previousSchema.upgrade(params);
        }
        Connection conn = SchemaUtil.createConnection(params, params.getDatabase());
        Statement stmt = conn.createStatement();
        this.upgradeSchema(stmt);
        if (SchemaFactory.getPreviousSchema(SchemaFactory.getLatestSchema().getVersion()).equals(previousSchema)) {
            this.createViewsProcedures(stmt);
        }
        stmt.close();
        SchemaUtil.close(conn);
    }

    private void createSchema(Statement stmt) throws SQLException, IOException {
        output.print("Creating schema base... ");
        stmt.execute(SchemaUtil.loadSqlfile(this.createSql));
        output.println("done");
    }

    private void createViewsProcedures(Statement stmt) throws SQLException, IOException {
        output.print("Creating views and stored procedures... ");
        stmt.execute(SchemaUtil.loadSqlfile(this.refreshSql));
        output.println("done");
    }

    private void upgradeSchema(Statement stmt) throws SQLException, IOException {
        output.print("Upgrading schema to version " + this.getVersion() + "... ");
        stmt.execute(SchemaUtil.loadSqlfile(this.upgradeSql));
        output.println("done");
    }

    public String getVersion() {
        return this.version;
    }
}

