/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.interceptor.csp;

import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.config.ConfigurationException;
import com.opensymphony.xwork2.interceptor.AbstractInterceptor;
import com.opensymphony.xwork2.util.ClassLoaderUtil;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.net.URI;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts2.action.CspSettingsAware;
import org.apache.struts2.interceptor.csp.CspSettings;
import org.apache.struts2.interceptor.csp.DefaultCspSettings;

public final class CspInterceptor
extends AbstractInterceptor {
    private static final Logger LOG = LogManager.getLogger(CspInterceptor.class);
    private boolean prependServletContext = true;
    private boolean enforcingMode;
    private String reportUri;
    private String reportTo;
    private String cspSettingsClassName = DefaultCspSettings.class.getName();

    @Override
    public String intercept(ActionInvocation invocation) throws Exception {
        Object action = invocation.getAction();
        if (action instanceof CspSettingsAware) {
            LOG.trace("Using CspSettings provided by the action: {}", action);
            this.applySettings(invocation, ((CspSettingsAware)action).getCspSettings());
        } else {
            LOG.trace("Using {} with action: {}", (Object)this.cspSettingsClassName, action);
            CspSettings cspSettings = this.createCspSettings(invocation);
            this.applySettings(invocation, cspSettings);
        }
        return invocation.invoke();
    }

    private CspSettings createCspSettings(ActionInvocation invocation) throws ClassNotFoundException {
        Class cspSettingsClass;
        try {
            cspSettingsClass = ClassLoaderUtil.loadClass(this.cspSettingsClassName, this.getClass());
        }
        catch (ClassNotFoundException e) {
            throw new ConfigurationException(String.format("The class %s doesn't exist!", this.cspSettingsClassName));
        }
        if (!CspSettings.class.isAssignableFrom(cspSettingsClass)) {
            throw new ConfigurationException(String.format("The class %s doesn't implement %s!", this.cspSettingsClassName, CspSettings.class.getName()));
        }
        return (CspSettings)invocation.getInvocationContext().getContainer().inject(cspSettingsClass);
    }

    private void applySettings(ActionInvocation invocation, CspSettings cspSettings) {
        HttpServletRequest request = invocation.getInvocationContext().getServletRequest();
        HttpServletResponse response = invocation.getInvocationContext().getServletResponse();
        LOG.trace("Applying: {} to enforcingMode", (Object)this.enforcingMode);
        cspSettings.setEnforcingMode(this.enforcingMode);
        if (this.reportUri != null) {
            LOG.trace("Applying: {} to reportUri", (Object)this.reportUri);
            String finalReportUri = this.reportUri;
            if (this.prependServletContext && request.getContextPath() != null && !request.getContextPath().isEmpty()) {
                finalReportUri = request.getContextPath() + finalReportUri;
            }
            cspSettings.setReportUri(finalReportUri);
            if (this.reportTo != null) {
                LOG.trace("Applying: {} to reportTo", (Object)this.reportTo);
                cspSettings.setReportTo(this.reportTo);
            }
        }
        invocation.addPreResultListener((actionInvocation, resultCode) -> {
            LOG.trace("Applying CSP header: {} to the request", (Object)cspSettings);
            cspSettings.addCspHeaders(request, response);
        });
    }

    public void setReportUri(String reportUri) {
        Optional<URI> uri = this.buildUri(reportUri);
        if (!uri.isPresent()) {
            throw new IllegalArgumentException("Could not parse configured report URI for CSP interceptor: " + reportUri);
        }
        if (!uri.get().isAbsolute() && !reportUri.startsWith("/")) {
            throw new IllegalArgumentException("Illegal configuration: report URI is not relative to the root. Please set a report URI that starts with /");
        }
        this.reportUri = reportUri;
    }

    public void setReportTo(String reportTo) {
        this.reportTo = reportTo;
    }

    private Optional<URI> buildUri(String reportUri) {
        try {
            return Optional.of(URI.create(reportUri));
        }
        catch (IllegalArgumentException ignored) {
            return Optional.empty();
        }
    }

    public void setEnforcingMode(boolean enforcingMode) {
        this.enforcingMode = enforcingMode;
    }

    public void setPrependServletContext(boolean prependServletContext) {
        this.prependServletContext = prependServletContext;
    }

    public void setCspSettingsClassName(String cspSettingsClassName) {
        this.cspSettingsClassName = cspSettingsClassName;
    }
}

