/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.views.freemarker;

import com.opensymphony.xwork2.util.ValueStack;
import freemarker.template.ObjectWrapper;
import freemarker.template.SimpleHash;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ScopesHashModel
extends SimpleHash
implements TemplateModel {
    private static final long serialVersionUID = 5551686380141886764L;
    private static final Logger LOG = LogManager.getLogger(ScopesHashModel.class);
    private static final String TAG_ATTRIBUTES = "attributes";
    @Deprecated
    private static final String TAG_PARAMETERS = "parameters";
    private HttpServletRequest request;
    private ServletContext servletContext;
    private ValueStack stack;
    private final Map<String, TemplateModel> unlistedModels = new HashMap<String, TemplateModel>();
    private volatile Object attributesCache;

    public ScopesHashModel(ObjectWrapper objectWrapper, ServletContext context, HttpServletRequest request, ValueStack stack) {
        super(objectWrapper);
        this.servletContext = context;
        this.request = request;
        this.stack = stack;
    }

    public ScopesHashModel(ObjectWrapper objectWrapper, ServletContext context, HttpServletRequest request) {
        super(objectWrapper);
        this.servletContext = context;
        this.request = request;
    }

    public void putUnlistedModel(String key, TemplateModel model) {
        this.unlistedModels.put(key, model);
    }

    public TemplateModel get(String key) throws TemplateModelException {
        Object obj;
        TemplateModel model = super.get(key);
        if (model != null) {
            return model;
        }
        if (this.stack != null) {
            obj = this.findValueOnStack(key);
            if (obj != null) {
                return this.wrap(obj);
            }
            if (TAG_ATTRIBUTES.equals(key) || TAG_PARAMETERS.equals(key)) {
                LOG.warn("[{}] cannot be resolved against stack, short-circuiting!", (Object)key);
                return null;
            }
            obj = this.stack.getContext().get(key);
            if (obj != null) {
                return this.wrap(obj);
            }
        }
        if (this.request != null) {
            obj = this.request.getAttribute(key);
            if (obj != null) {
                return this.wrap(obj);
            }
            HttpSession session = this.request.getSession(false);
            if (session != null && (obj = session.getAttribute(key)) != null) {
                return this.wrap(obj);
            }
        }
        if (this.servletContext != null && (obj = this.servletContext.getAttribute(key)) != null) {
            return this.wrap(obj);
        }
        model = this.unlistedModels.get(key);
        if (model != null) {
            return this.wrap(model);
        }
        return null;
    }

    private Object findValueOnStack(String key) {
        if (TAG_ATTRIBUTES.equals(key) || TAG_PARAMETERS.equals(key)) {
            Object attributesLocal;
            if (this.attributesCache != null) {
                return this.attributesCache;
            }
            this.attributesCache = attributesLocal = this.stack.findValue(key);
            return attributesLocal;
        }
        return this.stack.findValue(key);
    }

    public void put(String string, boolean b) {
        super.put(string, b);
    }

    public void put(String string, Object object) {
        super.put(string, object);
    }
}

