/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.action.admin.attribute;

import com.kwoksys.action.common.template.HeaderTemplate;
import com.kwoksys.action.common.template.StandardTemplate;
import com.kwoksys.biz.ServiceProvider;
import com.kwoksys.biz.admin.AdminService;
import com.kwoksys.biz.admin.core.AttributeSearch;
import com.kwoksys.biz.admin.dao.AdminQueries;
import com.kwoksys.biz.admin.dto.AccessUser;
import com.kwoksys.biz.admin.dto.Attribute;
import com.kwoksys.biz.admin.dto.AttributeField;
import com.kwoksys.biz.system.core.AppPaths;
import com.kwoksys.biz.system.core.AttributeManager;
import com.kwoksys.biz.system.core.Attributes;
import com.kwoksys.biz.system.core.Image;
import com.kwoksys.biz.system.core.Links;
import com.kwoksys.framework.connections.database.QueryCriteria;
import com.kwoksys.framework.struts2.Action2;
import com.kwoksys.framework.ui.Link;
import com.kwoksys.framework.util.HtmlUtils;
import java.util.ArrayList;
import java.util.HashMap;

public class AttributeDetailAction
extends Action2 {
    public String execute() throws Exception {
        AccessUser user = this.requestContext.getUser();
        AdminService adminService = ServiceProvider.getAdminService(this.requestContext);
        Attribute attr = adminService.getSystemAttribute(this.requestContext.getParameter("attributeId"));
        AttributeManager attributeManager = new AttributeManager(this.requestContext);
        boolean canEditAttrField = user.hasPermission(AppPaths.ADMIN_ATTR_FIELD_EDIT);
        AttributeSearch attributeSearch = new AttributeSearch();
        attributeSearch.put("attributeIdEquals", attr.getId());
        attributeSearch.put("isEditable", true);
        QueryCriteria queryCriteria = new QueryCriteria(attributeSearch);
        queryCriteria.addSortColumn(AdminQueries.getOrderByColumn("attribute_field_name"));
        ArrayList attrFields = new ArrayList();
        ArrayList attrFieldsDisabled = new ArrayList();
        for (AttributeField attrField : adminService.getEditAttributeFields(queryCriteria).values()) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("attrFieldId", attrField.getId());
            map.put("attrFieldName", Links.getAttrFieldIcon(this.requestContext, attrField));
            map.put("attrFieldDescription", HtmlUtils.formatMultiLineDisplay(attrField.getDescription()));
            map.put("attrFieldDefault", attr.getDefaultAttrFieldId().equals(attrField.getId()));
            if (canEditAttrField && attrField.getId() > 0) {
                map.put("attributeEditPath", new Link(this.requestContext).setAjaxPath(AppPaths.ADMIN_ATTR_FIELD_EDIT + "?attrFieldId=" + attrField.getId()).setInlineImage(Image.getInstance().getActionEdit(this.requestContext, "common.action.Edit")).getString());
            }
            if (attrField.isDisabled()) {
                attrFieldsDisabled.add(map);
                continue;
            }
            attrFields.add(map);
        }
        StandardTemplate standardTemplate = new StandardTemplate(this.requestContext);
        standardTemplate.setAttribute("attribute", attr);
        standardTemplate.setAttribute("attrFieldList", attrFields);
        standardTemplate.setAttribute("attrFieldDisabledList", attrFieldsDisabled);
        if (attr.isRequiredFieldEditable()) {
            this.request.setAttribute("attributeIsRequired", (Object)("common.boolean.yes_no." + attr.isRequired()));
        }
        if (attr.isDefaultAttrFieldEditable()) {
            this.request.setAttribute("defaultAttrField", (Object)attributeManager.getAttrFieldMapCache(attr.getId()).get(attr.getDefaultAttrFieldId()));
        }
        this.request.setAttribute("canAddAttrField", (Object)(!attr.getId().equals(Attributes.ISSUE_ASSIGNEE) ? 1 : 0));
        if (user.hasPermission(AppPaths.ADMIN_ATTR_FIELD_ADD)) {
            this.request.setAttribute("attributeFieldAddPath", (Object)("[" + new Link(this.requestContext).setAjaxPath(AppPaths.ADMIN_ATTR_FIELD_ADD + "?attributeId=" + attr.getId()).setTitleKey("common.action.Add") + "]"));
        }
        HeaderTemplate header = standardTemplate.getHeaderTemplate();
        if (user.hasPermission(AppPaths.ADMIN_ATTRIBUTE_EDIT) && (attr.isRequiredFieldEditable() || attr.isDefaultAttrFieldEditable())) {
            header.addHeaderCmds(new Link(this.requestContext).setAjaxPath(AppPaths.ADMIN_ATTRIBUTE_EDIT + "?attributeId=" + attr.getId()).setTitleKey("admin.attributeEdit.header"));
        }
        header.addNavLink(Links.getAdminHomeLink(this.requestContext));
        if (user.hasPermission(AppPaths.ADMIN_ATTRIBUTE_LIST)) {
            header.addNavLink(new Link(this.requestContext).setAjaxPath(AppPaths.ADMIN_ATTRIBUTE_LIST).setTitleKey("admin.attributeList"));
        }
        return standardTemplate.findTemplate("standard_template");
    }
}

