/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.action.admin.attribute;

import com.kwoksys.action.admin.attribute.AttributeForm;
import com.kwoksys.action.common.template.ActionErrorsTemplate;
import com.kwoksys.action.common.template.StandardTemplate;
import com.kwoksys.biz.ServiceProvider;
import com.kwoksys.biz.admin.AdminService;
import com.kwoksys.biz.admin.core.AdminUtils;
import com.kwoksys.biz.admin.dto.Attribute;
import com.kwoksys.biz.admin.dto.AttributeField;
import com.kwoksys.biz.admin.dto.Icon;
import com.kwoksys.biz.system.core.AppPaths;
import com.kwoksys.biz.system.core.AttributeManager;
import com.kwoksys.biz.system.core.Links;
import com.kwoksys.framework.session.CacheManager;
import com.kwoksys.framework.struts2.Action2;
import com.kwoksys.framework.struts2.ActionMessages;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class AttributeFieldAddAction
extends Action2 {
    public String add() throws Exception {
        AttributeForm actionForm = this.getBaseForm(AttributeForm.class);
        actionForm.setId("attributeFieldAddForm");
        AdminService adminService = ServiceProvider.getAdminService(this.requestContext);
        Attribute attr = adminService.getSystemAttribute(actionForm.getAttributeId());
        AttributeField attrField = new AttributeField();
        if (!actionForm.isResubmit()) {
            actionForm.setAttributeField(attrField);
            actionForm.setCustomAttrs(adminService.getSavedAttributeFieldTypes(attrField.getId()));
        }
        List<Icon> icons = adminService.getIcons(attr.getId());
        if (AdminUtils.isAttributeTypeMappingEnabled(attr.getId())) {
            ArrayList customAttrs = new ArrayList();
            for (Attribute custAttr : new AttributeManager(this.requestContext).getCustomFieldMap(attr.getObjectTypeId()).values()) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("attr", custAttr);
                map.put("checked", actionForm.getCustomAttrs().contains(custAttr.getId()) ? "checked" : "");
                customAttrs.add(map);
            }
            this.request.setAttribute("customAttrs", customAttrs);
        }
        StandardTemplate standardTemplate = new StandardTemplate(this.requestContext);
        standardTemplate.setPathAttribute("formAction", AppPaths.ADMIN_ATTR_FIELD_ADD_2);
        standardTemplate.setAttribute("formCancelLink", Links.getCancelLink(this.requestContext, AppPaths.ADMIN_ATTRIBUTE_DETAIL + "?attributeId=" + attr.getId()).getString());
        standardTemplate.setAttribute("attribute", attr);
        standardTemplate.setAttribute("iconList", icons);
        standardTemplate.setAttribute("statusList", AdminUtils.getAttributeStatusList(this.requestContext));
        ActionErrorsTemplate errorsTemplate = standardTemplate.addTemplate(new ActionErrorsTemplate());
        errorsTemplate.setShowRequiredFieldMsg(true);
        return standardTemplate.findTemplate("standard_template");
    }

    public String add2() throws Exception {
        AttributeForm actionForm = this.saveActionForm(new AttributeForm());
        AdminService adminService = ServiceProvider.getAdminService(this.requestContext);
        Attribute attr = adminService.getSystemAttribute(actionForm.getAttributeId());
        AttributeField attrField = new AttributeField();
        attrField.setAttributeId(actionForm.getAttributeId());
        attrField.setName(actionForm.getAttributeFieldName());
        attrField.setDescription(actionForm.getAttributeFieldDescription());
        attrField.setIconId(actionForm.getIconId());
        attrField.setDisabled(actionForm.getDisabled());
        attrField.setLinkedAttrIds(actionForm.getCustomAttrs());
        ActionMessages errors = adminService.addAttributeField(attrField);
        if (!errors.isEmpty()) {
            this.saveActionErrors(errors);
            return this.ajaxUpdateView(AppPaths.ADMIN_ATTR_FIELD_ADD + "?attributeId=" + attr.getId() + "&" + "_error=true");
        }
        new CacheManager(this.requestContext).removeAttributeFieldsCache(attr.getId());
        return this.ajaxUpdateView(AppPaths.ADMIN_ATTRIBUTE_DETAIL + "?attributeId=" + attr.getId());
    }
}

