/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.action.admin.attribute;

import com.kwoksys.action.admin.attribute.CustomAttributeForm;
import com.kwoksys.action.common.template.ActionErrorsTemplate;
import com.kwoksys.action.common.template.HeaderTemplate;
import com.kwoksys.action.common.template.StandardTemplate;
import com.kwoksys.action.common.template.ThisTemplate;
import com.kwoksys.biz.ServiceProvider;
import com.kwoksys.biz.admin.AdminService;
import com.kwoksys.biz.admin.dto.AttributeGroup;
import com.kwoksys.biz.system.core.AppPaths;
import com.kwoksys.biz.system.core.AttributeManager;
import com.kwoksys.biz.system.core.Links;
import com.kwoksys.framework.exceptions.ObjectNotFoundException;
import com.kwoksys.framework.properties.Localizer;
import com.kwoksys.framework.session.CacheManager;
import com.kwoksys.framework.struts2.Action2;
import com.kwoksys.framework.struts2.ActionMessages;

public class AttributeGroupAddAction
extends Action2 {
    public String add() throws Exception {
        CustomAttributeForm actionForm = this.getBaseForm(CustomAttributeForm.class);
        actionForm.setId("attrGroupAddForm");
        Integer objectTypeId = actionForm.getObjectTypeId();
        if (!AttributeManager.getCustomFieldObjectTypes().contains(objectTypeId)) {
            throw new ObjectNotFoundException();
        }
        if (!actionForm.isResubmit()) {
            AttributeGroup group = new AttributeGroup();
            actionForm.setAttrGroupName(group.getName());
        }
        StandardTemplate standardTemplate = new StandardTemplate(this.requestContext);
        standardTemplate.setPathAttribute("formAction", AppPaths.ADMIN_ATTRIBUTE_GROUP_ADD_2);
        standardTemplate.setAttribute("formCancelLink", Links.getCancelLink(this.requestContext, AppPaths.ADMIN_CUSTOM_ATTR_LIST).getString());
        standardTemplate.setAttribute("objectTypeId", objectTypeId);
        HeaderTemplate headerTemplate = standardTemplate.getHeaderTemplate();
        headerTemplate.setTitleText(Localizer.getText(this.requestContext, "admin.attributeGroupAdd.header") + " - " + Localizer.getText(this.requestContext, "common.objectType." + objectTypeId));
        ActionErrorsTemplate errorsTemplate = standardTemplate.addTemplate(new ActionErrorsTemplate());
        errorsTemplate.setShowRequiredFieldMsg(true);
        standardTemplate.addTemplate(new ThisTemplate());
        return standardTemplate.findTemplate("standard_template");
    }

    public String add2() throws Exception {
        CustomAttributeForm actionForm = this.saveActionForm(new CustomAttributeForm());
        Integer objectTypeId = actionForm.getObjectTypeId();
        if (!AttributeManager.getCustomFieldObjectTypes().contains(objectTypeId)) {
            throw new ObjectNotFoundException();
        }
        AttributeGroup attributeGroup = new AttributeGroup();
        attributeGroup.setObjectTypeId(actionForm.getObjectTypeId());
        attributeGroup.setName(actionForm.getAttrGroupName());
        AdminService adminService = ServiceProvider.getAdminService(this.requestContext);
        ActionMessages errors = adminService.addAttributeGroup(attributeGroup);
        if (!errors.isEmpty()) {
            this.saveActionErrors(errors);
            return this.ajaxUpdateView(AppPaths.ADMIN_ATTRIBUTE_GROUP_ADD + "?" + "_error=true" + "&objectTypeId=" + attributeGroup.getObjectTypeId());
        }
        new CacheManager(this.requestContext).removeCustomAttrGroupsCache(attributeGroup.getObjectTypeId());
        return this.ajaxUpdateView(AppPaths.ADMIN_CUSTOM_ATTR_LIST);
    }
}

