/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.action.admin.attribute;

import com.kwoksys.action.common.template.HeaderTemplate;
import com.kwoksys.action.common.template.StandardTemplate;
import com.kwoksys.biz.ServiceProvider;
import com.kwoksys.biz.admin.AdminService;
import com.kwoksys.biz.admin.core.AttributeSearch;
import com.kwoksys.biz.admin.dao.AdminQueries;
import com.kwoksys.biz.admin.dto.Attribute;
import com.kwoksys.biz.system.core.AppPaths;
import com.kwoksys.biz.system.core.Links;
import com.kwoksys.framework.connections.database.QueryCriteria;
import com.kwoksys.framework.properties.Localizer;
import com.kwoksys.framework.struts2.Action2;
import com.kwoksys.framework.ui.Link;
import java.util.ArrayList;
import java.util.HashMap;

public class AttributeListAction
extends Action2 {
    public String execute() throws Exception {
        AttributeSearch attributeSearch = new AttributeSearch();
        attributeSearch.put("isEditable", true);
        attributeSearch.put("isCustomAttr", false);
        QueryCriteria queryCriteria = new QueryCriteria(attributeSearch);
        queryCriteria.addSortColumn(AdminQueries.getOrderByColumn("attribute_name"));
        AdminService adminService = ServiceProvider.getAdminService(this.requestContext);
        ArrayList attributeList = new ArrayList();
        for (Attribute attr : adminService.getAttributes(queryCriteria).values()) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("attributeName", new Link(this.requestContext).setAjaxPath(AppPaths.ADMIN_ATTRIBUTE_DETAIL + "?attributeId=" + attr.getId()).setEscapeTitle(Localizer.getText(this.requestContext, "common.objectType." + attr.getObjectTypeId()) + " &raquo; " + Localizer.getText(this.requestContext, "common.column." + attr.getName())).getString());
            attributeList.add(map);
        }
        StandardTemplate standardTemplate = new StandardTemplate(this.requestContext);
        this.request.setAttribute("attributeList", attributeList);
        HeaderTemplate header = standardTemplate.getHeaderTemplate();
        header.setTitleKey("admin.attributeList");
        header.addNavLink(Links.getAdminHomeLink(this.requestContext));
        header.addNavLink(new Link(this.requestContext).setTitleKey("admin.attributeList"));
        return standardTemplate.findTemplate("standard_template");
    }
}

