/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.action.admin.attribute;

import com.kwoksys.action.common.template.HeaderTemplate;
import com.kwoksys.action.common.template.StandardTemplate;
import com.kwoksys.biz.ServiceProvider;
import com.kwoksys.biz.admin.AdminService;
import com.kwoksys.biz.admin.core.AdminUtils;
import com.kwoksys.biz.admin.core.AttributeSearch;
import com.kwoksys.biz.admin.dao.AdminQueries;
import com.kwoksys.biz.admin.dto.AccessUser;
import com.kwoksys.biz.admin.dto.Attribute;
import com.kwoksys.biz.admin.dto.AttributeGroup;
import com.kwoksys.biz.system.core.AppPaths;
import com.kwoksys.biz.system.core.AttributeManager;
import com.kwoksys.biz.system.core.Links;
import com.kwoksys.framework.connections.database.QueryCriteria;
import com.kwoksys.framework.struts2.Action2;
import com.kwoksys.framework.ui.Link;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;

public class CustomAttributeAction
extends Action2 {
    public String execute() throws Exception {
        AccessUser user = this.requestContext.getUser();
        AttributeSearch attributeSearch = new AttributeSearch();
        attributeSearch.put("isEditable", true);
        attributeSearch.put("isCustomAttr", true);
        QueryCriteria queryCriteria = new QueryCriteria(attributeSearch);
        queryCriteria.addSortColumn(AdminQueries.getOrderByColumn("attribute_name"));
        AdminService adminService = ServiceProvider.getAdminService(this.requestContext);
        LinkedHashMap objectTypesMap = new LinkedHashMap();
        HashMap<Integer, AttributeGroup> groupMap = new HashMap<Integer, AttributeGroup>();
        boolean canEditAttrGroup = user.hasPermission(AppPaths.ADMIN_ATTRIBUTE_GROUP_EDIT);
        boolean canDeleteAttrGroup = user.hasPermission(AppPaths.ADMIN_ATTRIBUTE_GROUP_DELETE);
        for (Integer objectTypeId : AttributeManager.getCustomFieldObjectTypes()) {
            Map<Integer, AttributeGroup> tempGroupMap = adminService.getAttributeGroups(objectTypeId);
            groupMap.putAll(tempGroupMap);
            TreeMap typeGroupMap = new TreeMap();
            for (AttributeGroup group : tempGroupMap.values()) {
                String key = AdminUtils.getAttributeGroupKey(group);
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("group", group);
                if (canEditAttrGroup) {
                    map.put("attrGroupEditLink", new Link(this.requestContext).setTitleKey("common.action.Edit").setAjaxPath(AppPaths.ADMIN_ATTRIBUTE_GROUP_EDIT + "?objectTypeId=" + objectTypeId + "&attrGroupId=" + group.getId()).getString());
                }
                if (canDeleteAttrGroup) {
                    map.put("attrGroupDeleteLink", new Link(this.requestContext).setTitleKey("common.action.Delete").setAjaxPath(AppPaths.ADMIN_ATTRIBUTE_GROUP_DELETE + "?objectTypeId=" + objectTypeId + "&attrGroupId=" + group.getId()));
                }
                map.put("customFields", new ArrayList());
                typeGroupMap.put(key, map);
            }
            objectTypesMap.put(objectTypeId, typeGroupMap);
        }
        for (Attribute attr : adminService.getAttributes(queryCriteria).values()) {
            ArrayList list;
            AttributeGroup group;
            String key;
            Map typeGroupMap = (Map)objectTypesMap.get(attr.getObjectTypeId());
            if (typeGroupMap.get(key = AdminUtils.getAttributeGroupKey(group = (AttributeGroup)groupMap.get(attr.getAttributeGroupId()))) == null) {
                typeGroupMap.put(key, new HashMap());
            }
            if ((list = (ArrayList)((Map)typeGroupMap.get(key)).get("customFields")) == null) {
                list = new ArrayList();
                ((Map)typeGroupMap.get(key)).put("customFields", list);
            }
            HashMap<String, String> attrMap = new HashMap<String, String>();
            attrMap.put("attrName", new Link(this.requestContext).setAjaxPath(AppPaths.ADMIN_CUSTOM_ATTR_DETAIL + "?attrId=" + attr.getId()).setTitle(attr.getName()).getString());
            list.add(attrMap);
        }
        StandardTemplate standardTemplate = new StandardTemplate(this.requestContext);
        this.request.setAttribute("objectTypesMap", objectTypesMap);
        if (user.hasPermission(AppPaths.ADMIN_CUSTOM_ATTR_ADD)) {
            this.request.setAttribute("attrAddPath", (Object)(AppPaths.ROOT + AppPaths.ADMIN_CUSTOM_ATTR_ADD + "?objectTypeId="));
        }
        if (user.hasPermission(AppPaths.ADMIN_ATTRIBUTE_GROUP_ADD)) {
            this.request.setAttribute("attrGroupAddPath", (Object)(AppPaths.ROOT + AppPaths.ADMIN_ATTRIBUTE_GROUP_ADD + "?objectTypeId="));
        }
        HeaderTemplate header = standardTemplate.getHeaderTemplate();
        header.setTitleKey("admin.customAttrList");
        header.addNavLink(Links.getAdminHomeLink(this.requestContext));
        header.addNavLink(new Link(this.requestContext).setTitleKey("admin.customAttrList"));
        return standardTemplate.findTemplate("standard_template");
    }
}

