/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.action.admin.attribute;

import com.kwoksys.action.admin.attribute.CustomAttributeForm;
import com.kwoksys.action.common.template.ActionErrorsTemplate;
import com.kwoksys.action.common.template.HeaderTemplate;
import com.kwoksys.action.common.template.StandardTemplate;
import com.kwoksys.biz.ServiceProvider;
import com.kwoksys.biz.admin.AdminService;
import com.kwoksys.biz.admin.core.AdminUtils;
import com.kwoksys.biz.admin.dto.Attribute;
import com.kwoksys.biz.admin.dto.AttributeField;
import com.kwoksys.biz.system.core.AppPaths;
import com.kwoksys.biz.system.core.AttributeManager;
import com.kwoksys.biz.system.core.Links;
import com.kwoksys.framework.exceptions.ObjectNotFoundException;
import com.kwoksys.framework.session.CacheManager;
import com.kwoksys.framework.struts2.Action2;
import com.kwoksys.framework.struts2.ActionMessages;
import com.kwoksys.framework.struts2.LabelValueBean;
import com.kwoksys.framework.ui.WidgetUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class CustomAttributeAddAction
extends Action2 {
    public String add() throws Exception {
        CustomAttributeForm actionForm = this.getBaseForm(CustomAttributeForm.class);
        actionForm.setId("customAttributeAddForm");
        Integer objectTypeId = actionForm.getObjectTypeId();
        if (!AttributeManager.getCustomFieldObjectTypes().contains(objectTypeId)) {
            throw new ObjectNotFoundException();
        }
        if (!actionForm.isResubmit()) {
            actionForm.setAttribute(new Attribute());
        }
        List<LabelValueBean> attrTypeOptions = AttributeManager.getAttrDataTypeOptions(this.requestContext);
        Integer objectAttrType = AdminUtils.getObjectTypeMap().get(objectTypeId);
        if (AdminUtils.isAttributeTypeMappingEnabled(objectAttrType)) {
            ArrayList systemFields = new ArrayList();
            for (AttributeField attrField : new CacheManager(this.requestContext).getAttributeFieldsCache(objectAttrType).values()) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("fieldName", attrField.getName());
                map.put("fieldId", attrField.getId().toString());
                map.put("checked", actionForm.getSystemFieldIds().contains(attrField.getId()) ? "checked" : "");
                systemFields.add(map);
            }
            this.request.setAttribute("systemFields", systemFields);
        }
        StandardTemplate standardTemplate = new StandardTemplate(this.requestContext);
        standardTemplate.setPathAttribute("formAction", AppPaths.ADMIN_CUSTOM_ATTR_ADD_2);
        standardTemplate.setAttribute("formCancelLink", Links.getCancelLink(this.requestContext, AppPaths.ADMIN_CUSTOM_ATTR_LIST).getString());
        this.request.setAttribute("objectTypeId", (Object)objectTypeId);
        this.request.setAttribute("attrTypeId", (Object)actionForm.getAttrType());
        this.request.setAttribute("attrTypeOptions", attrTypeOptions);
        this.request.setAttribute("attrConvertUrlOptions", WidgetUtils.getYesNoOptions(this.requestContext));
        this.request.setAttribute("attrGroupOptions", AdminUtils.getAttributeGroupOptions(this.requestContext, objectTypeId));
        this.request.setAttribute("attrUrlExample", (Object)"http://www.kwoksys.com/${CUSTOM_FIELD_VALUE}");
        HeaderTemplate headerTemplate = standardTemplate.getHeaderTemplate();
        headerTemplate.setOnloadJavascript("App.updateAttrOptions(" + actionForm.getAttrType() + ");");
        ActionErrorsTemplate errorsTemplate = standardTemplate.addTemplate(new ActionErrorsTemplate());
        errorsTemplate.setShowRequiredFieldMsg(true);
        return standardTemplate.findTemplate("standard_template");
    }

    public String add2() throws Exception {
        Integer objectTypeId = this.requestContext.getParameter("objectTypeId");
        List<Integer> systemFieldIds = this.requestContext.getParameters("systemFields");
        if (!AttributeManager.getCustomFieldObjectTypes().contains(objectTypeId)) {
            throw new ObjectNotFoundException();
        }
        CustomAttributeForm actionForm = this.saveActionForm(new CustomAttributeForm());
        Attribute attr = new Attribute();
        attr.setObjectTypeId(actionForm.getObjectTypeId());
        attr.setName(actionForm.getAttrName());
        attr.setDescription(actionForm.getDescription());
        attr.setType(actionForm.getAttrType());
        attr.setAttributeOption(actionForm.getAttrOption());
        attr.setConvertUrl(actionForm.getAttrConvertUrl());
        attr.setUrl(actionForm.getAttrUrl());
        attr.setAttributeGroupId(actionForm.getAttrGroupId());
        attr.setInputMask(actionForm.getInputMask());
        attr.setAttrFieldIds(systemFieldIds);
        attr.setTypeCurrencySymbol(actionForm.getCurrencySymbol());
        AdminService adminService = ServiceProvider.getAdminService(this.requestContext);
        ActionMessages errors = adminService.addAttribute(attr);
        if (!errors.isEmpty()) {
            this.saveActionErrors(errors);
            return this.ajaxUpdateView(AppPaths.ADMIN_CUSTOM_ATTR_ADD + "?objectTypeId=" + attr.getObjectTypeId() + "&" + "_error=true");
        }
        return this.ajaxUpdateView(AppPaths.ADMIN_CUSTOM_ATTR_LIST);
    }
}

