/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.action.admin.attribute;

import com.kwoksys.action.common.template.HeaderTemplate;
import com.kwoksys.action.common.template.StandardTemplate;
import com.kwoksys.biz.ServiceProvider;
import com.kwoksys.biz.admin.AdminService;
import com.kwoksys.biz.admin.core.AdminUtils;
import com.kwoksys.biz.admin.dto.AccessUser;
import com.kwoksys.biz.admin.dto.Attribute;
import com.kwoksys.biz.admin.dto.AttributeField;
import com.kwoksys.biz.admin.dto.AttributeGroup;
import com.kwoksys.biz.system.core.AppPaths;
import com.kwoksys.biz.system.core.Links;
import com.kwoksys.framework.session.CacheManager;
import com.kwoksys.framework.struts2.Action2;
import com.kwoksys.framework.ui.Link;
import com.kwoksys.framework.util.StringUtils;
import java.util.ArrayList;
import java.util.Set;

public class CustomAttributeDetailAction
extends Action2 {
    public String execute() throws Exception {
        Integer attributeId = this.requestContext.getParameter("attrId");
        AccessUser user = this.requestContext.getUser();
        AdminService adminService = ServiceProvider.getAdminService(this.requestContext);
        Attribute attr = adminService.getCustomAttribute(attributeId);
        Integer objectAttrType = AdminUtils.getObjectTypeMap().get(attr.getObjectTypeId());
        if (AdminUtils.isAttributeTypeMappingEnabled(objectAttrType)) {
            Set<Integer> mappedAttrIds = adminService.getAttributeFieldTypesByField(attr.getId());
            ArrayList<String> systemFields = new ArrayList<String>();
            for (AttributeField attrField : new CacheManager(this.requestContext).getAttributeFieldsCache(objectAttrType).values()) {
                if (!mappedAttrIds.contains(attrField.getId())) continue;
                systemFields.add(new Link(this.requestContext).setAjaxPath(AppPaths.ADMIN_ATTRIBUTE_DETAIL + "?attributeId=" + attrField.getAttributeId()).setTitle(attrField.getName()).getString());
            }
            this.request.setAttribute("systemFields", systemFields);
        }
        StandardTemplate standardTemplate = new StandardTemplate(this.requestContext);
        standardTemplate.setAttribute("attr", attr);
        standardTemplate.setAttribute("attrOption", StringUtils.join(attr.getAttributeOptions(), ", "));
        standardTemplate.setAttribute("attrConvertUrl", "common.boolean.yes_no." + attr.isConvertUrl());
        standardTemplate.setAttribute("attributeIsRequired", "common.boolean.yes_no." + attr.isRequired());
        if (attr.getAttributeGroupId() != 0) {
            AttributeGroup attributeGroup = adminService.getAttributeGroup(attr.getAttributeGroupId(), attr.getObjectTypeId());
            this.request.setAttribute("attrGroup", (Object)attributeGroup);
        }
        HeaderTemplate header = standardTemplate.getHeaderTemplate();
        header.setTitleKey("admin.customAttrDetail.header");
        if (user.hasPermission(AppPaths.ADMIN_CUSTOM_ATTR_EDIT)) {
            header.addHeaderCmds(new Link(this.requestContext).setTitleKey("common.action.Edit").setAjaxPath(AppPaths.ADMIN_CUSTOM_ATTR_EDIT + "?attrId=" + attr.getId()));
        }
        if (user.hasPermission(AppPaths.ADMIN_CUSTOM_ATTR_DELETE)) {
            header.addHeaderCmds(new Link(this.requestContext).setTitleKey("common.action.Delete").setAjaxPath(AppPaths.ADMIN_CUSTOM_ATTR_DELETE + "?attrId=" + attr.getId()));
        }
        header.addNavLink(Links.getAdminHomeLink(this.requestContext));
        if (user.hasPermission(AppPaths.ADMIN_CUSTOM_ATTR_LIST)) {
            header.addNavLink(new Link(this.requestContext).setTitleKey("admin.customAttrList").setAjaxPath(AppPaths.ADMIN_CUSTOM_ATTR_LIST));
        }
        return standardTemplate.findTemplate("standard_template");
    }
}

