/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.action.admin.config;

import com.kwoksys.action.admin.config.ConfigForm;
import com.kwoksys.action.common.template.ActionErrorsTemplate;
import com.kwoksys.action.common.template.HeaderTemplate;
import com.kwoksys.action.common.template.StandardTemplate;
import com.kwoksys.biz.ServiceProvider;
import com.kwoksys.biz.admin.AdminService;
import com.kwoksys.biz.admin.core.AdminUtils;
import com.kwoksys.biz.admin.dto.AccessUser;
import com.kwoksys.biz.admin.dto.SystemConfig;
import com.kwoksys.biz.contracts.core.ContractUtils;
import com.kwoksys.biz.hardware.core.HardwareUtils;
import com.kwoksys.biz.issues.core.IssueUtils;
import com.kwoksys.biz.kb.KbUtils;
import com.kwoksys.biz.software.SoftwareUtils;
import com.kwoksys.biz.system.core.AppPaths;
import com.kwoksys.biz.system.core.Image;
import com.kwoksys.biz.system.core.Links;
import com.kwoksys.biz.system.core.configs.ConfigManager;
import com.kwoksys.framework.license.LicenseManager;
import com.kwoksys.framework.properties.Localizer;
import com.kwoksys.framework.properties.PropertiesManager;
import com.kwoksys.framework.struts2.Action2;
import com.kwoksys.framework.struts2.ActionMessage;
import com.kwoksys.framework.struts2.ActionMessages;
import com.kwoksys.framework.struts2.LabelValueBean;
import com.kwoksys.framework.ui.Link;
import com.kwoksys.framework.ui.WidgetUtils;
import com.kwoksys.framework.util.DatetimeUtils;
import com.kwoksys.framework.util.NumberUtils;
import com.kwoksys.framework.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;

public class ConfigAppAction
extends Action2 {
    public String index() throws Exception {
        AccessUser user = this.requestContext.getUser();
        StandardTemplate standardTemplate = new StandardTemplate(this.requestContext, "app");
        standardTemplate.setAttribute("appVersion", PropertiesManager.getPatchVersion());
        Link link = new Link(this.requestContext);
        link.setTitleKey(LicenseManager.getContentKey());
        if (!LicenseManager.isCommercialEdition()) {
            link.setExternalPath("http://www.kwoksys.com/pages/compare-editions.php");
            link.setInlineImage(Image.getInstance().getExternalPopupIcon(this.requestContext)).setImgAlignRight();
        }
        this.request.setAttribute("appEdition", (Object)link);
        this.request.setAttribute("licenseKey", (Object)ConfigManager.system.getLicenseKey());
        this.request.setAttribute("applicationUrl", (Object)ConfigManager.system.getAppUrl());
        this.request.setAttribute("timezoneLocal", (Object)Localizer.getText(this.requestContext, "admin.config.timezone." + ConfigManager.system.getTimezoneLocalString()));
        this.request.setAttribute("timezoneOffset", (Object)Localizer.getText(this.requestContext, "common.calendar.time.hours_x", (Object[])new String[]{String.valueOf(DatetimeUtils.getTimeOffsetHours(this.requestContext.getSysdate()))}));
        this.request.setAttribute("serverTime", (Object)DatetimeUtils.toLocalDatetime(this.requestContext.getSysdate()));
        this.request.setAttribute("shortDateFormat", (Object)ConfigManager.system.getDateFormat());
        this.request.setAttribute("locale", (Object)ConfigManager.system.getLocaleString());
        this.request.setAttribute("timeFormat", (Object)ConfigManager.system.getTimeFormat());
        this.request.setAttribute("currencyOptions", (Object)ConfigManager.system.getCurrencySymbol());
        this.request.setAttribute("numberOfPastYearsToShow", (Object)ConfigManager.app.getNumPastYears());
        this.request.setAttribute("numberOfFutureYearsToShow", (Object)ConfigManager.app.getNumFutureYears());
        this.request.setAttribute("usernameDisplay", (Object)ConfigManager.system.getUsernameDisplay());
        this.request.setAttribute("usersRowsToShow", (Object)ConfigManager.app.getUserRows());
        this.request.setAttribute("companiesRowsToShow", (Object)ConfigManager.app.getCompanyRows());
        this.request.setAttribute("contactsRowsToShow", (Object)ConfigManager.app.getContactRows());
        this.request.setAttribute("contractsRowsToShow", (Object)ConfigManager.app.getContractsRowsToShow());
        this.request.setAttribute("issuesRowsToShow", (Object)ConfigManager.app.getIssueRows());
        this.request.setAttribute("issuesMultipleDeleteEnabled", (Object)ConfigManager.app.isIssuesMultipleDeleteEnabled());
        String defaultDueDate = ConfigManager.app.getIssueDueDateDiff() != 0 ? Localizer.getText(this.requestContext, "common.calendar.days", (Object[])new String[]{String.valueOf(ConfigManager.app.getIssueDueDateDiff())}) : "";
        this.request.setAttribute("issuesDefaultDueDate", (Object)defaultDueDate);
        this.request.setAttribute("issuesDefaultDisplayHtmlEmail", (Object)ConfigManager.app.isIssuesDefaultDisplayHtmlEmail());
        this.request.setAttribute("hardwareRowsToShow", (Object)ConfigManager.app.getHardwareRowsToShow());
        this.request.setAttribute("softwareRowsToShow", (Object)ConfigManager.app.getSoftwareRowsToShow());
        this.request.setAttribute("softwareLicenseNotesNumChars", (Object)ConfigManager.app.getSoftwareLicenseNotesNumChars());
        ArrayList<String> licenseColumns = new ArrayList<String>();
        licenseColumns.add(Localizer.getText(this.requestContext, "common.column.hardware_name"));
        if (ConfigManager.app.getSoftwareLicenseColumns().contains("hardware_owner_name")) {
            licenseColumns.add(Localizer.getText(this.requestContext, "common.column.hardware_owner_name"));
        }
        this.request.setAttribute("softwareLicenseColumns", (Object)StringUtils.join(licenseColumns, ", "));
        ArrayList<String> hardwareColumns = new ArrayList<String>();
        for (String string : ConfigManager.app.getHardwareColumns()) {
            hardwareColumns.add(Localizer.getText(this.requestContext, "common.column." + string));
        }
        this.request.setAttribute("hardwareColumns", (Object)StringUtils.join(hardwareColumns, ", "));
        ArrayList<String> softwareColumns = new ArrayList<String>();
        for (String string : ConfigManager.app.getSoftwareColumns()) {
            softwareColumns.add(Localizer.getText(this.requestContext, "common.column." + string));
        }
        this.request.setAttribute("softwareColumns", (Object)StringUtils.join(softwareColumns, ", "));
        this.request.setAttribute("hardwareExpirationCountdown", (Object)Localizer.getText(this.requestContext, "common.calendar.days", (Object[])new String[]{String.valueOf(ConfigManager.app.getHardwareWarrantyExpireCountdown())}));
        this.request.setAttribute("checkUniqueHardwareName", (Object)ConfigManager.app.isCheckUniqueHardwareName());
        this.request.setAttribute("checkUniqueSerialNumber", (Object)ConfigManager.app.isCheckUniqueSerialNumber());
        this.request.setAttribute("bulkHardwareDelete", (Object)ConfigManager.app.isHardwareBulkDeleteEnabled());
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : ConfigManager.app.getIssuesColumns()) {
            arrayList.add(Localizer.getText(this.requestContext, "common.column." + string));
        }
        this.request.setAttribute("issuesColumns", (Object)StringUtils.join(arrayList, ", "));
        this.request.setAttribute("issuesGuestSubmitModuleEnabled", (Object)ConfigManager.app.isIssuesGuestSubmitModuleEnabled());
        this.request.setAttribute("issuesGuestSubmitEnabled", (Object)ConfigManager.app.isIssuesGuestSubmitFooterEnabled());
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (String column : ConfigManager.app.getContractsColumns()) {
            arrayList2.add(Localizer.getText(this.requestContext, "common.column." + column));
        }
        this.request.setAttribute("contractsColumns", (Object)StringUtils.join(arrayList2, ", "));
        this.request.setAttribute("contractsExpirationCountdown", (Object)Localizer.getText(this.requestContext, "common.calendar.days", (Object[])new String[]{String.valueOf(ConfigManager.app.getContractsExpireCountdown())}));
        ArrayList<String> arrayList3 = new ArrayList<String>();
        for (String column : ConfigManager.app.getKbArticleColumns()) {
            arrayList3.add(Localizer.getText(this.requestContext, "common.column." + column));
        }
        this.request.setAttribute("kbColumns", (Object)StringUtils.join(arrayList3, ", "));
        this.request.setAttribute("isMediaWikiSyntaxEnabled", (Object)ConfigManager.app.isKbArticleMediaWikiSyntaxEnabled());
        this.request.setAttribute("kbArticleCharLimit", (Object)Localizer.getText(this.requestContext, "admin.config.kb.articleCharLimit", (Object[])new Integer[]{ConfigManager.app.getKbArticleCharLimit()}));
        this.request.setAttribute("portal_numberOfBlogPostsToShowOnList", (Object)ConfigManager.app.getBlogsNumPosts());
        this.request.setAttribute("portal_numberOfBlogPostCharactersOnList", (Object)ConfigManager.app.getBlogsNumberOfPostCharacters());
        this.request.setAttribute("hardwareReportFilenameHeader", (Object)Localizer.getText(this.requestContext, "reports.workflow.type.hardware_report"));
        this.request.setAttribute("hardwareLicensesReportFilenameHeader", (Object)Localizer.getText(this.requestContext, "reports.workflow.type.hardware_license_report"));
        this.request.setAttribute("hardwareMembersReportFilenameHeader", (Object)Localizer.getText(this.requestContext, "reports.workflow.type.hardware_member_report"));
        this.request.setAttribute("softwareReportFilenameHeader", (Object)Localizer.getText(this.requestContext, "reports.workflow.type.software_report"));
        this.request.setAttribute("softwareUsageReportFilenameHeader", (Object)Localizer.getText(this.requestContext, "reports.workflow.type.software_usage_report"));
        this.request.setAttribute("issuesReportFilenameHeader", (Object)Localizer.getText(this.requestContext, "reports.workflow.type.issue_report"));
        this.request.setAttribute("contractsReportFilenameHeader", (Object)Localizer.getText(this.requestContext, "reports.workflow.type.contract_report"));
        String filename = ConfigManager.reports.getHardwareReportFilename();
        if (StringUtils.isEmpty(filename)) {
            filename = Localizer.getText(this.requestContext, "admin.config.reports.defaultName", (Object[])new String[]{Localizer.getText(this.requestContext, "reports.workflow.type.hardware_report")});
        }
        this.request.setAttribute("hardwareReportFilename", (Object)filename);
        filename = ConfigManager.reports.getHardwareLicensesReportFilename();
        if (StringUtils.isEmpty(filename)) {
            filename = Localizer.getText(this.requestContext, "admin.config.reports.defaultName", (Object[])new String[]{Localizer.getText(this.requestContext, "reports.workflow.type.hardware_license_report")});
        }
        this.request.setAttribute("hardwareLicensesReportFilename", (Object)filename);
        filename = ConfigManager.reports.getHardwareMembersReportFilename();
        if (StringUtils.isEmpty(filename)) {
            filename = Localizer.getText(this.requestContext, "admin.config.reports.defaultName", (Object[])new String[]{Localizer.getText(this.requestContext, "reports.workflow.type.hardware_member_report")});
        }
        this.request.setAttribute("hardwareMembersReportFilename", (Object)filename);
        filename = ConfigManager.reports.getSoftwareReportFilename();
        if (StringUtils.isEmpty(filename)) {
            filename = Localizer.getText(this.requestContext, "admin.config.reports.defaultName", (Object[])new String[]{Localizer.getText(this.requestContext, "reports.workflow.type.software_report")});
        }
        this.request.setAttribute("softwareReportFilename", (Object)filename);
        filename = ConfigManager.reports.getSoftwareUsageReportFilename();
        if (StringUtils.isEmpty(filename)) {
            filename = Localizer.getText(this.requestContext, "admin.config.reports.defaultName", (Object[])new String[]{Localizer.getText(this.requestContext, "reports.workflow.type.software_usage_report")});
        }
        this.request.setAttribute("softwareUsageReportFilename", (Object)filename);
        filename = ConfigManager.reports.getIssuesReportFilename();
        if (StringUtils.isEmpty(filename)) {
            filename = Localizer.getText(this.requestContext, "admin.config.reports.defaultName", (Object[])new String[]{Localizer.getText(this.requestContext, "reports.workflow.type.issue_report")});
        }
        this.request.setAttribute("issuesReportFilename", (Object)filename);
        filename = ConfigManager.reports.getContractsReportFilename();
        if (StringUtils.isEmpty(filename)) {
            filename = Localizer.getText(this.requestContext, "admin.config.reports.defaultName", (Object[])new String[]{Localizer.getText(this.requestContext, "reports.workflow.type.contract_report")});
        }
        this.request.setAttribute("contractsReportFilename", (Object)filename);
        this.request.setAttribute("rssProxyServerAddress", (Object)ConfigManager.app.getRssProxyServerAddress());
        this.request.setAttribute("rssProxyServerPort", (Object)ConfigManager.app.getRssProxyServerPort());
        if (user.hasPermission(AppPaths.ADMIN_CONFIG_WRITE)) {
            standardTemplate.setAttribute("rssEditLink", new Link(this.requestContext).setJavascript("App.updateView('rssConfigs', '" + AppPaths.ROOT + AppPaths.ADMIN_CONFIG_WRITE + "?cmd=" + "rssEdit" + "')").setInlineImage(Image.getInstance().getActionEdit(this.requestContext, "common.action.Edit")).getString());
            standardTemplate.setAttribute("reportEditLink", new Link(this.requestContext).setJavascript("App.updateView('reports', '" + AppPaths.ROOT + AppPaths.ADMIN_CONFIG_WRITE + "?cmd=" + "reportsEdit" + "')").setInlineImage(Image.getInstance().getActionEdit(this.requestContext, "common.action.Edit")).getString());
        }
        standardTemplate.setAttribute("loadCustomFields", Localizer.getText(this.requestContext, "common.boolean.true_false." + ConfigManager.app.isLoadCustomFields()));
        HeaderTemplate header = standardTemplate.getHeaderTemplate();
        header.setTitleKey("admin.config.app");
        if (user.hasPermission(AppPaths.ADMIN_CONFIG_WRITE)) {
            link = new Link(this.requestContext);
            link.setAjaxPath(AppPaths.ADMIN_CONFIG_WRITE + "?cmd=" + "appEdit");
            link.setTitleKey("common.action.Edit");
            header.addHeaderCmds(link);
        }
        header.addNavLink(Links.getAdminHomeLink(this.requestContext));
        header.addNavLink(new Link(this.requestContext).setTitleKey("admin.config.app"));
        return standardTemplate.findTemplate("standard_template");
    }

    public String edit() throws Exception {
        ConfigForm actionForm = this.getBaseForm(ConfigForm.class);
        actionForm.setId("configAppForm");
        if (!actionForm.isResubmit()) {
            actionForm.setLicenseKey(ConfigManager.system.getLicenseKey());
            actionForm.setApplicationUrl(ConfigManager.system.getAppUrl());
            actionForm.setTimezone(ConfigManager.system.getTimezoneLocalString());
            actionForm.setLocale(ConfigManager.system.getLocaleString());
            actionForm.setShortDateFormat(ConfigManager.system.getDateFormat());
            actionForm.setTimeFormat(ConfigManager.system.getTimeFormat());
            actionForm.setTheme(ConfigManager.system.getTheme());
            actionForm.setCurrency(ConfigManager.system.getCurrencySymbol());
            actionForm.setNumberOfPastYears(String.valueOf(ConfigManager.app.getNumPastYears()));
            actionForm.setNumberOfFutureYears(String.valueOf(ConfigManager.app.getNumFutureYears()));
            actionForm.setUserNameDisplay(ConfigManager.system.getUsernameDisplay());
            actionForm.setUsersNumRows(ConfigManager.app.getUserRows());
            actionForm.setHardwareNumRows(ConfigManager.app.getHardwareRowsToShow());
            actionForm.setCheckUniqueHardwareName(ConfigManager.app.isCheckUniqueHardwareName());
            actionForm.setCheckUniqueSerialNumber(ConfigManager.app.isCheckUniqueSerialNumber());
            actionForm.setHardwareExpireCountdown(ConfigManager.app.getHardwareWarrantyExpireCountdown());
            actionForm.setBulkHardwareDeleteEnabled(ConfigManager.app.isHardwareBulkDeleteEnabled());
            actionForm.setCompaniesNumRows(ConfigManager.app.getCompanyRows());
            actionForm.setContactsNumRows(ConfigManager.app.getContactRows());
            actionForm.setContractsNumRows(ConfigManager.app.getContractsRowsToShow());
            actionForm.setContractsExpireCountdown(ConfigManager.app.getContractsExpireCountdown());
            actionForm.setIssuesNumRows(ConfigManager.app.getIssueRows());
            actionForm.setIssuesMultipleDeleteEnabled(String.valueOf(ConfigManager.app.isIssuesMultipleDeleteEnabled()));
            actionForm.setSoftwareNumRows(ConfigManager.app.getSoftwareRowsToShow());
            actionForm.setSoftwareLicenseNotesNumChars(String.valueOf(ConfigManager.app.getSoftwareLicenseNotesNumChars()));
            actionForm.setBlogPostsListNumRows(ConfigManager.app.getBlogsNumPosts());
            actionForm.setBlogPostCharactersList(ConfigManager.app.getBlogsNumberOfPostCharacters());
            actionForm.setIssuesGuestSubmitModuleEnabled(String.valueOf(ConfigManager.app.isIssuesGuestSubmitModuleEnabled()));
            actionForm.setIssuesGuestSubmitEnabled(String.valueOf(ConfigManager.app.isIssuesGuestSubmitFooterEnabled()));
            actionForm.setIssuesDefaultDueDateDiff(String.valueOf(ConfigManager.app.getIssueDueDateDiff()));
            actionForm.setIssuesDefaultDisplayHtmlEmail(String.valueOf(ConfigManager.app.isIssuesDefaultDisplayHtmlEmail()));
            actionForm.setLoadCustomFields(ConfigManager.app.isLoadCustomFields());
            actionForm.setIssuesColumns(IssueUtils.getIssueColumnHeaders());
            actionForm.setHardwareColumns(HardwareUtils.getColumnHeaderList());
            actionForm.setSoftwareColumns(SoftwareUtils.getColumnHeaderList());
            actionForm.setSoftwareLicenseColumns(ConfigManager.app.getSoftwareLicenseColumns());
            actionForm.setContractColumns(ContractUtils.getColumnHeaderList());
            actionForm.setKbColumns(KbUtils.getArticleColumnHeaderList());
            actionForm.setKbMediaWikiSyntaxEnabled(ConfigManager.app.isKbArticleMediaWikiSyntaxEnabled());
        }
        ArrayList<LabelValueBean> timezoneOptions = new ArrayList<LabelValueBean>();
        for (String timezone : ConfigManager.system.getTimezoneLocalOptions()) {
            timezoneOptions.add(new LabelValueBean(Localizer.getText(this.requestContext, "admin.config.timezone." + timezone), timezone));
        }
        ArrayList<LabelValueBean> dateFormatOptions = new ArrayList<LabelValueBean>();
        for (String option : ConfigManager.system.getDateFormatOptions()) {
            dateFormatOptions.add(new LabelValueBean(option, option));
        }
        ArrayList<LabelValueBean> timeFormatOptions = new ArrayList<LabelValueBean>();
        for (String option : ConfigManager.system.getTimeFormatOptions()) {
            timeFormatOptions.add(new LabelValueBean(option, option));
        }
        ArrayList<LabelValueBean> numrowOptions = new ArrayList<LabelValueBean>();
        for (String option : ConfigManager.admin.getNumberOfRowsToShowOptions()) {
            numrowOptions.add(new LabelValueBean(option, option));
        }
        ArrayList<LabelValueBean> numBlogPostsOptions = new ArrayList<LabelValueBean>();
        for (String option : ConfigManager.app.getBlogsNumberOfPostsOptions()) {
            numBlogPostsOptions.add(new LabelValueBean(option, option));
        }
        ArrayList<LabelValueBean> blogPostCharOptions = new ArrayList<LabelValueBean>();
        for (String option : ConfigManager.app.getBlogsNumberOfPostCharactersOptions()) {
            blogPostCharOptions.add(new LabelValueBean(option, option));
        }
        ArrayList issuesColumnOptions = new ArrayList();
        for (String column : IssueUtils.getIssuesDefaultColumns()) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("name", column);
            if (column.equals("issue_name")) {
                map.put("disabled", "disabled");
            }
            if (actionForm.getIssuesColumns().contains(column)) {
                map.put("checked", "checked=\"checked\" ");
            }
            issuesColumnOptions.add(map);
        }
        ArrayList hwColumnOptions = new ArrayList();
        for (String column : HardwareUtils.HARDWARE_DEFAULT_COLUMNS) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("name", column);
            if (column.equals("hardware_name")) {
                map.put("disabled", "disabled");
            }
            if (actionForm.getHardwareColumns().contains(column)) {
                map.put("checked", "checked=\"checked\" ");
            }
            hwColumnOptions.add(map);
        }
        ArrayList<String[]> swColumnOptions = new ArrayList<String[]>();
        for (String column : SoftwareUtils.SOFTWARE_DEFAULT_COLUMNS) {
            String[] map = new HashMap();
            map.put("name", column);
            if (column.equals("software_name")) {
                map.put("disabled", "disabled");
            }
            if (actionForm.getSoftwareColumns().contains(column)) {
                map.put("checked", "checked=\"checked\" ");
            }
            swColumnOptions.add(map);
        }
        ArrayList licenseColumnsOptions = new ArrayList();
        HashMap<String, String> sfLicColumnMap = new HashMap<String, String>();
        String sfLicColumn = "hardware_owner_name";
        sfLicColumnMap.put("name", sfLicColumn);
        if (actionForm.getSoftwareLicenseColumns().contains(sfLicColumn)) {
            sfLicColumnMap.put("checked", "checked=\"checked\" ");
        }
        licenseColumnsOptions.add(sfLicColumnMap);
        ArrayList contractColumns = new ArrayList();
        for (String column : ContractUtils.CONTRACT_COLUMNS_DEFAULT) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("name", column);
            if (column.equals("contract_name")) {
                map.put("disabled", "disabled");
            }
            if (actionForm.getContractColumns().contains(column)) {
                map.put("checked", "checked=\"checked\" ");
            }
            contractColumns.add(map);
        }
        ArrayList kbColumnOptions = new ArrayList();
        for (String column : KbUtils.getArticleColumnsDefault()) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("name", column);
            if (column.equals("article_name")) {
                map.put("disabled", "disabled");
            }
            if (actionForm.getKbColumns().contains(column)) {
                map.put("checked", "checked=\"checked\" ");
            }
            kbColumnOptions.add(map);
        }
        ArrayList<LabelValueBean> expireCountdownOptions = new ArrayList<LabelValueBean>();
        for (String option : ConfigManager.app.getExpireCountdownOptions()) {
            expireCountdownOptions.add(new LabelValueBean(option, option));
        }
        ArrayList<LabelValueBean> userNameDisplayOptions = new ArrayList<LabelValueBean>();
        for (String option : ConfigManager.admin.getUsernameDisplayOptions()) {
            userNameDisplayOptions.add(new LabelValueBean(Localizer.getText(this.requestContext, "common.column." + option), option));
        }
        StandardTemplate standardTemplate = new StandardTemplate(this.requestContext, "appEdit");
        standardTemplate.setPathAttribute("formAction", AppPaths.ADMIN_CONFIG_WRITE);
        standardTemplate.setAttribute("formCancelLink", Links.getCancelLink(this.requestContext, AppPaths.ADMIN_CONFIG + "?cmd=" + "app").getString());
        this.request.setAttribute("cmd", (Object)"appEdit2");
        this.request.setAttribute("licenseKeyExample", (Object)Localizer.getText(this.requestContext, "common.example", (Object[])new String[]{"KEY:************;EXPIRE:****-**-**"}));
        this.request.setAttribute("shortDateFormatOptions", dateFormatOptions);
        this.request.setAttribute("timeFormatOptions", timeFormatOptions);
        this.request.setAttribute("timezoneOptions", timezoneOptions);
        this.request.setAttribute("localeOptions", WidgetUtils.getLocaleOptions(this.requestContext));
        this.request.setAttribute("numrowOptions", numrowOptions);
        this.request.setAttribute("numBlogPostsOptions", numBlogPostsOptions);
        this.request.setAttribute("numBlogPostCharactersOptions", blogPostCharOptions);
        this.request.setAttribute("contractsColumnOptions", contractColumns);
        this.request.setAttribute("expireCountdownOptions", expireCountdownOptions);
        this.request.setAttribute("issuesColumnOptions", issuesColumnOptions);
        this.request.setAttribute("kbColumnOptions", kbColumnOptions);
        this.request.setAttribute("hardwareColumnOptions", hwColumnOptions);
        this.request.setAttribute("softwareColumnOptions", swColumnOptions);
        this.request.setAttribute("licenseColumnsOptions", licenseColumnsOptions);
        this.request.setAttribute("userNameDisplayOptions", userNameDisplayOptions);
        standardTemplate.setAttribute("booleanOptions", WidgetUtils.getBooleanOptions(this.requestContext));
        HeaderTemplate header = standardTemplate.getHeaderTemplate();
        header.setEditTitleKey("admin.config.app");
        standardTemplate.addTemplate(new ActionErrorsTemplate());
        return standardTemplate.findTemplate("standard_template");
    }

    public String edit2() throws Exception {
        ConfigForm actionForm = this.saveActionForm(new ConfigForm());
        ActionMessages errors = new ActionMessages();
        if (!AdminUtils.validCurrencySymbol(actionForm.getCurrency())) {
            errors.add("currency", new ActionMessage("admin.config.error.invalidCurrency"));
        }
        if (!NumberUtils.isInteger(actionForm.getIssuesDefaultDueDateDiff())) {
            errors.add("issuesDefaultDueDateDiff", new ActionMessage("common.form.fieldNumberInvalid", Localizer.getText(this.requestContext, "admin.config.issues.defaultDueDate")));
        }
        if (!NumberUtils.isInteger(actionForm.getNumberOfPastYears())) {
            errors.add("numberOfPastYears", new ActionMessage("common.form.fieldNumberInvalid", Localizer.getText(this.requestContext, "admin.config.numberOfPastYears")));
        }
        if (!NumberUtils.isInteger(actionForm.getNumberOfFutureYears())) {
            errors.add("numberOfFutureYears", new ActionMessage("common.form.fieldNumberInvalid", Localizer.getText(this.requestContext, "admin.config.numberOfFutureYears")));
        }
        if (!NumberUtils.isInteger(actionForm.getSoftwareLicenseNotesNumChars())) {
            errors.add("softwareLicenseNotesNumChars", new ActionMessage("common.form.fieldNumberInvalid", Localizer.getText(this.requestContext, "admin.config.software.licenseNotesCharacters")));
        }
        if (errors.isEmpty()) {
            String licenseKeyPrefix;
            String issuesColumns = StringUtils.join(actionForm.getIssuesColumns(), ",");
            String hardwareColumns = StringUtils.join(actionForm.getHardwareColumns(), ",");
            String softwareColumns = StringUtils.join(actionForm.getSoftwareColumns(), ",");
            String softwareLicenseColumns = StringUtils.join(actionForm.getSoftwareLicenseColumns(), ",");
            String contractColumns = StringUtils.join(actionForm.getContractColumns(), ",");
            String kbColumns = StringUtils.join(actionForm.getKbColumns(), ",");
            String licenseKey = actionForm.getLicenseKey();
            if (!licenseKey.startsWith(licenseKeyPrefix = "KEY:")) {
                licenseKey = licenseKeyPrefix + licenseKey;
            }
            ArrayList<SystemConfig> list = new ArrayList<SystemConfig>();
            list.add(new SystemConfig("system.licenseKey", licenseKey));
            list.add(new SystemConfig("url.application", actionForm.getApplicationUrl()));
            list.add(new SystemConfig("currency.options", actionForm.getCurrency()));
            list.add(new SystemConfig("timezone.local", actionForm.getTimezone()));
            list.add(new SystemConfig("locale", actionForm.getLocale()));
            list.add(new SystemConfig("datetime.shortDateFormat", actionForm.getShortDateFormat()));
            list.add(new SystemConfig("datetime.timeFormat", actionForm.getTimeFormat()));
            list.add(new SystemConfig("users.numberOfRowsToShow", String.valueOf(actionForm.getUsersNumRows())));
            list.add(new SystemConfig("Users.NameDisplay", actionForm.getUserNameDisplay()));
            list.add(new SystemConfig("hardware.numberOfRowsToShow", String.valueOf(actionForm.getHardwareNumRows())));
            list.add(new SystemConfig("hardware.columnList", hardwareColumns));
            list.add(new SystemConfig("hardware.warrantyExpireCountdown", String.valueOf(actionForm.getHardwareExpireCountdown())));
            list.add(new SystemConfig("Hardware.CheckUniqueHardwareName", actionForm.getCheckUniqueHardwareName()));
            list.add(new SystemConfig("Hardware.CheckUniqueSerialNumber", actionForm.isCheckUniqueSerialNumber()));
            list.add(new SystemConfig("Hardware.BulkDeleteEnabled", actionForm.isBulkHardwareDeleteEnabled()));
            list.add(new SystemConfig("companies.numberOfRowsToShow", String.valueOf(actionForm.getCompaniesNumRows())));
            list.add(new SystemConfig("contacts.numberOfRowsToShow", String.valueOf(actionForm.getContactsNumRows())));
            list.add(new SystemConfig("contracts.columnList", contractColumns));
            list.add(new SystemConfig("contracts.numberOfRowsToShow", String.valueOf(actionForm.getContractsNumRows())));
            list.add(new SystemConfig("contracts.expirationCountdown", String.valueOf(actionForm.getContractsExpireCountdown())));
            list.add(new SystemConfig("issues.numberOfRowsToShow", String.valueOf(actionForm.getIssuesNumRows())));
            list.add(new SystemConfig("issues.columnList", issuesColumns));
            list.add(new SystemConfig("Issues.ReportIssueModuleEnabled", actionForm.getIssuesGuestSubmitModuleEnabled()));
            list.add(new SystemConfig("Issues.ReportIssueFooterEnabled", actionForm.getIssuesGuestSubmitEnabled()));
            list.add(new SystemConfig("Issues.multipleDeleteEnabled", actionForm.getIssuesMultipleDeleteEnabled()));
            list.add(new SystemConfig("Issues.DueDateDiff", actionForm.getIssuesDefaultDueDateDiff()));
            list.add(new SystemConfig("_SpareConfigKey4", actionForm.getIssuesDefaultDisplayHtmlEmail()));
            list.add(new SystemConfig("kb.article.columns", kbColumns));
            list.add(new SystemConfig("blogs.numberOfPostsToShow", String.valueOf(actionForm.getBlogPostsListNumRows())));
            list.add(new SystemConfig("blogs.numberOfPostCharsToShow", String.valueOf(actionForm.getBlogPostCharactersList())));
            list.add(new SystemConfig("datetime.numberOfPastYears", actionForm.getNumberOfPastYears()));
            list.add(new SystemConfig("datetime.numberOfUpcomingYears", actionForm.getNumberOfFutureYears()));
            list.add(new SystemConfig("software.columnList", softwareColumns));
            list.add(new SystemConfig("software.numberOfRowsToShow", String.valueOf(actionForm.getSoftwareNumRows())));
            list.add(new SystemConfig("software.numberLicenseNotesChars", String.valueOf(actionForm.getSoftwareLicenseNotesNumChars())));
            list.add(new SystemConfig("Software.Licenses.Columns", softwareLicenseColumns));
            list.add(new SystemConfig("CustomFields.Expand", actionForm.isLoadCustomFields()));
            list.add(new SystemConfig("KB.Article.MediaWikiSyntaxEnabled", actionForm.isKbMediaWikiSyntaxEnabled()));
            AdminService adminService = ServiceProvider.getAdminService(this.requestContext);
            errors = adminService.updateConfig(list);
        }
        if (!errors.isEmpty()) {
            this.saveActionErrors(errors);
            return this.ajaxUpdateView(AppPaths.ADMIN_CONFIG_WRITE + "?cmd=" + "appEdit" + "&" + "_error=true");
        }
        Localizer.setSessionLocale(this.request.getSession(), actionForm.getLocale());
        return this.ajaxUpdateView(AppPaths.ADMIN_CONFIG + "?cmd=" + "app");
    }
}

