/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.action.admin.config;

import com.kwoksys.action.admin.config.ConfigForm;
import com.kwoksys.action.common.template.ActionErrorsTemplate;
import com.kwoksys.action.common.template.HeaderTemplate;
import com.kwoksys.action.common.template.StandardTemplate;
import com.kwoksys.biz.ServiceProvider;
import com.kwoksys.biz.admin.AdminService;
import com.kwoksys.biz.admin.dto.AccessUser;
import com.kwoksys.biz.admin.dto.SystemConfig;
import com.kwoksys.biz.system.core.AppPaths;
import com.kwoksys.biz.system.core.Links;
import com.kwoksys.biz.system.core.configs.ConfigManager;
import com.kwoksys.framework.properties.Localizer;
import com.kwoksys.framework.struts2.Action2;
import com.kwoksys.framework.struts2.ActionMessage;
import com.kwoksys.framework.struts2.ActionMessages;
import com.kwoksys.framework.struts2.LabelValueBean;
import com.kwoksys.framework.ui.Link;
import com.kwoksys.framework.ui.WidgetUtils;
import com.kwoksys.framework.util.NumberUtils;
import java.util.ArrayList;

public class ConfigAuthAction
extends Action2 {
    public String index() throws Exception {
        Link link;
        AccessUser user = this.requestContext.getUser();
        StandardTemplate standardTemplate = new StandardTemplate(this.requestContext, "auth");
        this.request.setAttribute("authType", (Object)Localizer.getText(this.requestContext, "admin.config.auth.type." + ConfigManager.auth.getAuthType()));
        this.request.setAttribute("authenticationMethod", (Object)Localizer.getText(this.requestContext, "admin.config.auth.authenticationMethod." + ConfigManager.auth.getAuthMethod()));
        this.request.setAttribute("authLdapUrl", (Object)(ConfigManager.auth.getLdapUrlScheme() + ConfigManager.auth.getAuthLdapUrl()));
        this.request.setAttribute("authLdapSecurityPrincipal", (Object)ConfigManager.auth.getAuthLdapSecurityPrincipal());
        this.request.setAttribute("authDomain", (Object)ConfigManager.auth.getAuthDomain());
        this.request.setAttribute("authSessionTimeout", (Object)Localizer.getText(this.requestContext, "common.calendar.time.hours_x", new Object[]{ConfigManager.auth.getSessionTimeoutHours()}));
        this.request.setAttribute("allowBlankUserPassword", (Object)Localizer.getText(this.requestContext, "common.boolean.yes_no." + ConfigManager.admin.isAllowBlankUserPassword()));
        this.request.setAttribute("minimumPasswordLength", (Object)ConfigManager.auth.getSecurityMinPasswordLength());
        this.request.setAttribute("passwordComplexity", (Object)Localizer.getText(this.requestContext, "common.boolean.true_false." + ConfigManager.admin.isSecurityPasswordComplexityEnabled()));
        this.request.setAttribute("accountLockoutThreshold", (Object)ConfigManager.admin.getAccountLockoutThreshold());
        this.request.setAttribute("accountLockoutDuration", (Object)ConfigManager.admin.getAccountLockoutDurationMinutes());
        this.request.setAttribute("accountLockoutDescription", (Object)(ConfigManager.admin.isValidateAcctLockout() ? Localizer.getText(this.requestContext, "admin.config.security.accountLockoutOn.description", new Object[]{ConfigManager.admin.getAccountLockoutDurationMinutes(), ConfigManager.admin.getAccountLockoutThreshold()}) : Localizer.getText(this.requestContext, "admin.config.security.accountLockoutOff.description")));
        HeaderTemplate header = standardTemplate.getHeaderTemplate();
        header.setTitleKey("admin.config.auth");
        if (user.hasPermission(AppPaths.ADMIN_CONFIG_WRITE)) {
            link = new Link(this.requestContext);
            link.setAjaxPath(AppPaths.ADMIN_CONFIG_WRITE + "?cmd=" + "authEdit");
            link.setTitleKey("common.action.Edit");
            header.addHeaderCmds(link);
        }
        if (user.hasPermission(AppPaths.ADMIN_CONFIG)) {
            link = new Link(this.requestContext);
            link.setAjaxPath(AppPaths.ADMIN_CONFIG + "?cmd=" + "ldapTest");
            link.setTitleKey("admin.cmd.ldapTest");
            header.addHeaderCmds(link);
        }
        header.addNavLink(Links.getAdminHomeLink(this.requestContext));
        header.addNavLink(new Link(this.requestContext).setTitleKey("admin.config.auth"));
        return standardTemplate.findTemplate("standard_template");
    }

    public String edit() throws Exception {
        ConfigForm actionForm = this.getBaseForm(ConfigForm.class);
        actionForm.setId("configAuthEditForm");
        if (!actionForm.isResubmit()) {
            actionForm.setAuthType(ConfigManager.auth.getAuthType());
            actionForm.setAuthMethod(ConfigManager.auth.getAuthMethod());
            actionForm.setAuthTimeout(ConfigManager.auth.getSessionTimeoutSeconds());
            actionForm.setLdapSecurityPrincipal(ConfigManager.auth.getAuthLdapSecurityPrincipal());
            actionForm.setLdapUrlScheme(ConfigManager.auth.getLdapUrlScheme());
            actionForm.setLdapUrl(ConfigManager.auth.getAuthLdapUrl());
            actionForm.setDomain(ConfigManager.auth.getAuthDomain());
            actionForm.setMinimumPasswordLength(ConfigManager.auth.getSecurityMinPasswordLength());
            actionForm.setPasswordComplexityEnabled(ConfigManager.admin.isSecurityPasswordComplexityEnabled());
            actionForm.setAllowBlankUserPassword(ConfigManager.admin.isAllowBlankUserPassword() ? 1 : 0);
            actionForm.setAccountLockoutThreshold(String.valueOf(ConfigManager.admin.getAccountLockoutThreshold()));
            actionForm.setAccountLockoutDurationMinutes(String.valueOf(ConfigManager.admin.getAccountLockoutDurationMinutes()));
        }
        ArrayList<LabelValueBean> authTypeOptions = new ArrayList<LabelValueBean>();
        for (String option : ConfigManager.auth.getAuthTypeOptions()) {
            authTypeOptions.add(new LabelValueBean(Localizer.getText(this.requestContext, "admin.config.auth.type." + option), option));
        }
        ArrayList<LabelValueBean> authMethodOptions = new ArrayList<LabelValueBean>();
        for (String option : ConfigManager.auth.getAuthMethodOptions()) {
            authMethodOptions.add(new LabelValueBean(Localizer.getText(this.requestContext, "admin.config.auth.authenticationMethod." + option), option));
        }
        ArrayList<LabelValueBean> sessionTimeoutOptions = new ArrayList<LabelValueBean>();
        for (String option : ConfigManager.auth.getSessionTimeoutSecondsOptions()) {
            sessionTimeoutOptions.add(new LabelValueBean(String.valueOf(Integer.parseInt(option) / 3600), option));
        }
        ArrayList<LabelValueBean> ldapUrlSchemeOptions = new ArrayList<LabelValueBean>();
        for (String option : ConfigManager.auth.getLdapUrlSchemeOptions()) {
            ldapUrlSchemeOptions.add(new LabelValueBean(option, option));
        }
        ArrayList<LabelValueBean> passwordLenOptions = new ArrayList<LabelValueBean>();
        for (int i = 1; i <= 14; ++i) {
            passwordLenOptions.add(new LabelValueBean(String.valueOf(i), String.valueOf(i)));
        }
        StandardTemplate standardTemplate = new StandardTemplate(this.requestContext, "authEdit");
        standardTemplate.setPathAttribute("formAction", AppPaths.ADMIN_CONFIG_WRITE);
        standardTemplate.setAttribute("formCancelLink", Links.getCancelLink(this.requestContext, AppPaths.ADMIN_CONFIG + "?cmd=" + "auth").getString());
        this.request.setAttribute("cmd", (Object)"authEdit2");
        this.request.setAttribute("authTypeOptions", authTypeOptions);
        this.request.setAttribute("authMethodOptions", authMethodOptions);
        this.request.setAttribute("sessionTimeoutOptions", sessionTimeoutOptions);
        this.request.setAttribute("allowBlankUserPasswordOptions", WidgetUtils.getYesNoOptions(this.requestContext));
        this.request.setAttribute("passwordLenOptions", passwordLenOptions);
        this.request.setAttribute("passwordComplexityOptions", WidgetUtils.getBooleanOptions(this.requestContext));
        this.request.setAttribute("ldapUrlSchemeOptions", ldapUrlSchemeOptions);
        HeaderTemplate header = standardTemplate.getHeaderTemplate();
        header.setEditTitleKey("admin.config.auth");
        header.setSectionKey("admin.config.sectionHeader");
        standardTemplate.addTemplate(new ActionErrorsTemplate());
        return standardTemplate.findTemplate("standard_template");
    }

    public String edit2() throws Exception {
        ConfigForm actionForm = this.saveActionForm(new ConfigForm());
        String authType = actionForm.getAuthType();
        String authMethod = actionForm.getAuthMethod();
        String ldapUrl = actionForm.getLdapUrl();
        ActionMessages errors = new ActionMessages();
        if (!authMethod.equals("app") && ldapUrl.isEmpty()) {
            errors.add("ldapUrl", new ActionMessage("admin.config.error.emptyLdapUrl"));
        }
        if (!NumberUtils.isInteger(actionForm.getAccountLockoutThreshold())) {
            errors.add("accountLockoutThreshold", new ActionMessage("common.form.fieldNumberInvalid", Localizer.getText(this.requestContext, "admin.config.security.accountLockoutThreshold")));
        }
        if (!NumberUtils.isInteger(actionForm.getAccountLockoutDurationMinutes())) {
            errors.add("accountLockoutDurationMinutes", new ActionMessage("common.form.fieldNumberInvalid", Localizer.getText(this.requestContext, "admin.config.security.accountLockoutDuration")));
        }
        if (errors.isEmpty()) {
            ArrayList<SystemConfig> list = new ArrayList<SystemConfig>();
            list.add(new SystemConfig("auth.type", authType));
            list.add(new SystemConfig("auth.authenticationMethod", authMethod));
            list.add(new SystemConfig("auth.ldap.url.scheme", actionForm.getLdapUrlScheme()));
            list.add(new SystemConfig("auth.ldapUrl", ldapUrl));
            list.add(new SystemConfig("auth.ldap.securityPrincipal", actionForm.getLdapSecurityPrincipal()));
            list.add(new SystemConfig("auth.domain", actionForm.getDomain()));
            list.add(new SystemConfig("auth.sessionTimeoutSeconds", String.valueOf(actionForm.getAuthTimeout())));
            list.add(new SystemConfig("admin.allowBlankUserPassword", String.valueOf(actionForm.getAllowBlankUserPassword())));
            list.add(new SystemConfig("System.Security.UserPasswordLength", String.valueOf(actionForm.getMinimumPasswordLength())));
            list.add(new SystemConfig("System.Security.UserPasswordComplexityEnabled", actionForm.isPasswordComplexityEnabled()));
            list.add(new SystemConfig("System.Security.AccountLockoutThreshold", actionForm.getAccountLockoutThreshold()));
            list.add(new SystemConfig("System.Security.AccountLockoutDurationMinutes", actionForm.getAccountLockoutDurationMinutes()));
            AdminService adminService = ServiceProvider.getAdminService(this.requestContext);
            errors = adminService.updateConfig(list);
        }
        if (!errors.isEmpty()) {
            this.saveActionErrors(errors);
            return this.ajaxUpdateView(AppPaths.ADMIN_CONFIG_WRITE + "?cmd=" + "authEdit" + "&" + "_error=true");
        }
        return this.ajaxUpdateView(AppPaths.ADMIN_CONFIG + "?cmd=" + "auth");
    }
}

