/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.action.admin.config;

import com.kwoksys.action.admin.config.ConfigForm;
import com.kwoksys.action.common.template.ActionErrorsTemplate;
import com.kwoksys.action.common.template.HeaderTemplate;
import com.kwoksys.action.common.template.StandardTemplate;
import com.kwoksys.biz.ServiceProvider;
import com.kwoksys.biz.admin.AdminService;
import com.kwoksys.biz.admin.core.AdminUtils;
import com.kwoksys.biz.admin.dto.AccessUser;
import com.kwoksys.biz.admin.dto.SystemConfig;
import com.kwoksys.biz.files.FileService;
import com.kwoksys.biz.files.core.FileUtils;
import com.kwoksys.biz.system.core.AppPaths;
import com.kwoksys.biz.system.core.FeatureManager;
import com.kwoksys.biz.system.core.Links;
import com.kwoksys.biz.system.core.configs.ConfigManager;
import com.kwoksys.framework.properties.PropertiesManager;
import com.kwoksys.framework.struts2.Action2;
import com.kwoksys.framework.struts2.ActionMessages;
import com.kwoksys.framework.ui.Link;
import com.kwoksys.framework.util.DatetimeUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ConfigBackupAction
extends Action2 {
    private static final Logger LOGGER = Logger.getLogger(ConfigBackupAction.class.getName());

    public String index() throws Exception {
        Link link;
        File directory;
        AccessUser user = this.requestContext.getUser();
        FileService fileService = ServiceProvider.getFileService(this.requestContext);
        boolean validBackupCmdPath = fileService.isFileExist(ConfigManager.file.getDbPostgresProgramPath());
        boolean validBackupRepoPath = fileService.isDirectoryExist(ConfigManager.file.getDbBackupRepositoryPath());
        StandardTemplate standardTemplate = new StandardTemplate(this.requestContext, "backup");
        this.request.setAttribute("backupCmdPath", (Object)ConfigManager.file.getDbPostgresProgramPath());
        this.request.setAttribute("validBackupCmdPath", (Object)validBackupCmdPath);
        this.request.setAttribute("backupCmd", (Object)AdminUtils.getBackupCommandDisplay());
        this.request.setAttribute("backupRepoPath", (Object)ConfigManager.file.getDbBackupRepositoryPath());
        this.request.setAttribute("validBackupRepoPath", (Object)validBackupRepoPath);
        this.request.setAttribute("backupExecutePath", (Object)new Link(this.requestContext).setJavascript("App.updateView({loadElemId:'backExecLoading', targetElemId:CONTENT_ELEM_ID}, '" + AppPaths.ROOT + AppPaths.ADMIN_CONFIG_WRITE + "?cmd=" + "backupExecute" + "')").setTitleKey("admin.config.db.backup.execute.cmd"));
        if (user.hasPermission(AppPaths.ADMIN_CONFIG_WRITE)) {
            this.request.setAttribute("backupCmdEnabled", (Object)(validBackupCmdPath && validBackupRepoPath ? 1 : 0));
        }
        if ((directory = new File(ConfigManager.file.getDbBackupRepositoryPath())).isDirectory()) {
            File[] files = directory.listFiles();
            ArrayList fileMaps = new ArrayList();
            for (File file : files) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("filename", file.getName());
                map.put("fileModifiedDate", DatetimeUtils.toLocalDatetime(file.lastModified()));
                map.put("filesize", FileUtils.formatFileSize(this.requestContext, file.length()));
                fileMaps.add(map);
            }
            this.request.setAttribute("backupFiles", fileMaps);
        }
        HeaderTemplate headerTemplate = standardTemplate.getHeaderTemplate();
        headerTemplate.setTitleKey("admin.config.db.backup.header");
        if (user.hasPermission(AppPaths.ADMIN_CONFIG_WRITE)) {
            link = new Link(this.requestContext);
            link.setAjaxPath(AppPaths.ADMIN_CONFIG_WRITE + "?cmd=" + "backupEdit");
            link.setTitleKey("common.action.Edit");
            headerTemplate.addHeaderCmds(link);
        }
        headerTemplate.addNavLink(Links.getAdminHomeLink(this.requestContext));
        if (user.hasPermission(AppPaths.ADMIN_CONFIG)) {
            link = new Link(this.requestContext);
            link.setAjaxPath(AppPaths.ADMIN_CONFIG + "?cmd=" + "system");
            link.setTitleKey("admin.configHeader.system_info");
            headerTemplate.addNavLink(link);
        }
        return standardTemplate.findTemplate("standard_template");
    }

    public String edit() throws Exception {
        ConfigForm actionForm = this.getBaseForm(ConfigForm.class);
        if (!actionForm.isResubmit()) {
            actionForm.setDbBackupProgramPath(ConfigManager.file.getDbPostgresProgramPath());
            actionForm.setDbBackupRepositoryPath(ConfigManager.file.getDbBackupRepositoryPath());
        }
        StandardTemplate standardTemplate = new StandardTemplate(this.requestContext, "backupEdit");
        standardTemplate.setPathAttribute("formAction", AppPaths.ADMIN_CONFIG_WRITE);
        standardTemplate.setAttribute("formCancelLink", Links.getCancelLink(this.requestContext, AppPaths.ADMIN_CONFIG + "?cmd=" + "backup").getString());
        standardTemplate.setAttribute("cmd", "backupEdit2");
        standardTemplate.setAttribute("disableFilePathUpdate", FeatureManager.isMultiAppsInstance());
        HeaderTemplate header = standardTemplate.getHeaderTemplate();
        header.setTitleKey("admin.config.db.backup.header");
        ActionErrorsTemplate errorsTemplate = standardTemplate.addTemplate(new ActionErrorsTemplate());
        errorsTemplate.setMessageKey("admin.config.sectionHeader");
        return standardTemplate.findTemplate("standard_template");
    }

    public String edit2() throws Exception {
        AdminService adminService;
        ActionMessages errors;
        ConfigForm actionForm = this.saveActionForm(new ConfigForm());
        ArrayList<SystemConfig> list = new ArrayList<SystemConfig>();
        if (!FeatureManager.isMultiAppsInstance()) {
            list.add(new SystemConfig("db.postgresProgramPath", actionForm.getDbBackupProgramPath()));
            list.add(new SystemConfig("file.db.backup.repositoryPath", actionForm.getDbBackupRepositoryPath()));
        }
        if (!(errors = (adminService = ServiceProvider.getAdminService(this.requestContext)).updateConfig(list)).isEmpty()) {
            this.saveActionErrors(errors);
            return this.ajaxUpdateView(AppPaths.ADMIN_CONFIG_WRITE + "?cmd=" + "backupEdit" + "&" + "_error=true");
        }
        return this.ajaxUpdateView(AppPaths.ADMIN_CONFIG + "?cmd=" + "backup");
    }

    public String execute() throws Exception {
        ProcessBuilder pb = new ProcessBuilder(AdminUtils.getBackupCommand());
        pb.environment().put("PGPASSWORD", PropertiesManager.get("db.password"));
        pb.redirectErrorStream(true);
        try {
            pb.start();
            this.saveNotifyMessageKey("admin.config.db.backup.success");
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Problem with PostgreSQL backup.", e);
        }
        pb.environment().remove("PGPASSWORD");
        return this.ajaxUpdateView(AppPaths.ADMIN_CONFIG + "?cmd=" + "backup" + "&" + "_notify=true");
    }
}

