/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.action.admin.config;

import com.kwoksys.action.admin.config.ConfigForm;
import com.kwoksys.action.common.template.ActionErrorsTemplate;
import com.kwoksys.action.common.template.DetailTableTemplate;
import com.kwoksys.action.common.template.HeaderTemplate;
import com.kwoksys.action.common.template.StandardTemplate;
import com.kwoksys.biz.ServiceProvider;
import com.kwoksys.biz.admin.AdminService;
import com.kwoksys.biz.admin.dto.AccessUser;
import com.kwoksys.biz.admin.dto.SystemConfig;
import com.kwoksys.biz.system.core.AppPaths;
import com.kwoksys.biz.system.core.Links;
import com.kwoksys.biz.system.core.configs.ConfigManager;
import com.kwoksys.framework.struts2.Action2;
import com.kwoksys.framework.struts2.ActionMessages;
import com.kwoksys.framework.ui.Link;
import com.kwoksys.framework.util.HtmlUtils;
import java.util.ArrayList;

public class ConfigCompanyAction
extends Action2 {
    public String index() throws Exception {
        AccessUser user = this.requestContext.getUser();
        StandardTemplate standardTemplate = new StandardTemplate(this.requestContext, "company");
        HeaderTemplate header = standardTemplate.getHeaderTemplate();
        header.setTitleKey("admin.configCompany.title");
        if (user.hasPermission(AppPaths.ADMIN_CONFIG_WRITE)) {
            Link link = new Link(this.requestContext).setAjaxPath(AppPaths.ADMIN_CONFIG_WRITE + "?cmd=" + "companyEdit").setTitleKey("common.action.Edit");
            header.addHeaderCmds(link);
        }
        header.addNavLink(Links.getAdminHomeLink(this.requestContext));
        header.addNavLink(new Link(this.requestContext).setTitleKey("admin.configCompany.title"));
        DetailTableTemplate detailTableTemplate = standardTemplate.addTemplate(new DetailTableTemplate());
        DetailTableTemplate.Td td = detailTableTemplate.newTd();
        td.setHeaderKey("admin.config.companyName");
        td.setValue(HtmlUtils.encode(ConfigManager.system.getCompanyName()));
        td = detailTableTemplate.newTd();
        td.setHeaderKey("admin.config.companyPath");
        td.setValue(HtmlUtils.encode(ConfigManager.system.getCompanyPath()));
        td = detailTableTemplate.newTd();
        td.setHeaderKey("admin.config.companyLogoPath");
        td.setValue(HtmlUtils.encode(ConfigManager.system.getCompanyLogoPath()));
        td = detailTableTemplate.newTd();
        td.setHeaderKey("admin.config.companyFooterNotes");
        td.setValue(ConfigManager.system.getCompanyFooterNotes());
        return standardTemplate.findTemplate("standard_autogen_template");
    }

    public String edit() throws Exception {
        ConfigForm actionForm = this.getBaseForm(ConfigForm.class);
        if (!actionForm.isResubmit()) {
            actionForm.setCompanyName(ConfigManager.system.getCompanyName());
            actionForm.setCompanyPath(ConfigManager.system.getCompanyPath());
            actionForm.setCompanyLogoPath(ConfigManager.system.getCompanyLogoPath());
            actionForm.setCompanyFooterNotes(ConfigManager.system.getCompanyFooterNotes());
        }
        StandardTemplate standardTemplate = new StandardTemplate(this.requestContext, "companyEdit");
        standardTemplate.setPathAttribute("formAction", AppPaths.ADMIN_CONFIG_WRITE);
        standardTemplate.setAttribute("formCancelLink", Links.getCancelLink(this.requestContext, AppPaths.ADMIN_CONFIG + "?cmd=" + "company").getString());
        standardTemplate.setAttribute("cmd", "companyEdit2");
        HeaderTemplate header = standardTemplate.getHeaderTemplate();
        header.setEditTitleKey("admin.configCompany.title");
        standardTemplate.addTemplate(new ActionErrorsTemplate());
        return standardTemplate.findTemplate("standard_template");
    }

    public String edit2() throws Exception {
        ConfigForm actionForm = this.saveActionForm(new ConfigForm());
        ArrayList<SystemConfig> list = new ArrayList<SystemConfig>();
        list.add(new SystemConfig("companyName", actionForm.getCompanyName()));
        list.add(new SystemConfig("companyPath", actionForm.getCompanyPath()));
        list.add(new SystemConfig("companyLogoPath", actionForm.getCompanyLogoPath()));
        list.add(new SystemConfig("company.footerNotes", actionForm.getCompanyFooterNotes()));
        AdminService adminService = ServiceProvider.getAdminService(this.requestContext);
        ActionMessages errors = adminService.updateConfig(list);
        if (!errors.isEmpty()) {
            this.saveActionErrors(errors);
            return this.ajaxUpdateView(AppPaths.ADMIN_CONFIG_WRITE + "?cmd=" + "companyEdit" + "&" + "_error=true");
        }
        return this.ajaxUpdateView(AppPaths.ADMIN_CONFIG + "?cmd=" + "company");
    }
}

