/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.action.admin.config;

import com.kwoksys.action.admin.config.ConfigForm;
import com.kwoksys.action.common.template.ActionErrorsTemplate;
import com.kwoksys.action.common.template.HeaderTemplate;
import com.kwoksys.action.common.template.StandardTemplate;
import com.kwoksys.biz.ServiceProvider;
import com.kwoksys.biz.admin.AdminService;
import com.kwoksys.biz.admin.dto.SystemConfig;
import com.kwoksys.biz.issues.IssueService;
import com.kwoksys.biz.system.core.AppPaths;
import com.kwoksys.biz.system.core.Links;
import com.kwoksys.biz.system.core.configs.ConfigManager;
import com.kwoksys.framework.connections.mail.PopConnection;
import com.kwoksys.framework.properties.Localizer;
import com.kwoksys.framework.struts2.Action2;
import com.kwoksys.framework.struts2.ActionMessage;
import com.kwoksys.framework.struts2.ActionMessages;
import com.kwoksys.framework.struts2.LabelValueBean;
import com.kwoksys.framework.util.NumberUtils;
import com.kwoksys.framework.util.StringUtils;
import java.util.ArrayList;

public class ConfigEmailPopAction
extends Action2 {
    private static final String EMAIL_INBOUND_PROTOCOL_PREFIX = "admin.config.email.inbound.protocol.";

    public String edit() throws Exception {
        ConfigForm actionForm = this.getBaseForm(ConfigForm.class);
        actionForm.setId("configPopEmailForm");
        if (!actionForm.isResubmit()) {
            actionForm.setInboundEmailProtocol(ConfigManager.email.getIncomingEmailProtocol());
            actionForm.setInboundEmailOauthEndpoint(ConfigManager.email.getInboundEmailOauthEndpoint());
            actionForm.setInboundEmailOauthParams(ConfigManager.email.getInboundEmailOauthParams());
            actionForm.setPopHost(ConfigManager.email.getPopHost());
            actionForm.setPopPort(ConfigManager.email.getPopPort());
            actionForm.setPopUsername(ConfigManager.email.getPopUsername());
            actionForm.setPopIgnoreSender(ConfigManager.email.getPopSenderIgnoreList());
            actionForm.setPopUseSSL(ConfigManager.email.isPopSslEnabled());
            actionForm.setPopPassword("");
            actionForm.setPopRetrievalFrequency(ConfigManager.email.getPopRepeatInterval());
            actionForm.setPopMessageBatchSize(ConfigManager.email.getPopMessagesLimit());
        }
        StandardTemplate standardTemplate = new StandardTemplate(this.requestContext, "popEmailEdit");
        standardTemplate.setPathAttribute("formAction", AppPaths.ADMIN_CONFIG_WRITE);
        standardTemplate.setAttribute("formCancelLink", Links.getCancelLink(this.requestContext, AppPaths.ADMIN_CONFIG + "?cmd=" + "email").getString());
        standardTemplate.setAttribute("cmd", "popEmailEdit2");
        ArrayList<LabelValueBean> inboundEmailProtocols = new ArrayList<LabelValueBean>();
        inboundEmailProtocols.add(new LabelValueBean(Localizer.getText(this.requestContext, "admin.config.email.inbound.protocol.pop3"), "pop3"));
        inboundEmailProtocols.add(new LabelValueBean(Localizer.getText(this.requestContext, "admin.config.email.inbound.protocol.imap"), "imap"));
        inboundEmailProtocols.add(new LabelValueBean(Localizer.getText(this.requestContext, "admin.config.email.inbound.protocol.office365Imap"), "office365Imap"));
        standardTemplate.setAttribute("inboundEmailProtocols", inboundEmailProtocols);
        ArrayList<LabelValueBean> retrievalOptions = new ArrayList<LabelValueBean>();
        for (Integer option : new Integer[]{1, 2, 3, 4, 5}) {
            retrievalOptions.add(new LabelValueBean(String.valueOf(option), String.valueOf((long)option.intValue() * 60000L)));
        }
        standardTemplate.setAttribute("popRetrievalFrequencyOptions", retrievalOptions);
        ArrayList<LabelValueBean> popMessageBatchSizeOptions = new ArrayList<LabelValueBean>();
        for (Integer option : new Integer[]{10, 20, 30, 40, 50, 60, 70, 80, 90, 100}) {
            popMessageBatchSizeOptions.add(new LabelValueBean(String.valueOf(option), String.valueOf(option)));
        }
        standardTemplate.setAttribute("popMessageBatchSizeOptions", popMessageBatchSizeOptions);
        HeaderTemplate headerTemplate = standardTemplate.getHeaderTemplate();
        headerTemplate.setTitleKey("admin.config.email.incomingServer.header");
        ActionErrorsTemplate errorsTemplate = standardTemplate.addTemplate(new ActionErrorsTemplate());
        errorsTemplate.setMessageKey("admin.config.email.incomingServer.sectionHeader");
        return standardTemplate.findTemplate("standard_template");
    }

    public String edit2() throws Exception {
        ConfigForm actionForm = this.saveActionForm(new ConfigForm());
        ActionMessages errors = new ActionMessages();
        PopConnection conn = new PopConnection();
        conn.setMessagesLimit(1);
        if (!NumberUtils.isInteger(actionForm.getPopPort())) {
            errors.add("popPort", new ActionMessage("common.form.fieldNumberInvalid", Localizer.getText(this.requestContext, "admin.config.email.port")));
        }
        if (errors.isEmpty()) {
            if (actionForm.isTest()) {
                conn.setProtocol(actionForm.getInboundEmailProtocol());
                conn.setOauthEndpoint(actionForm.getInboundEmailOauthEndpoint());
                conn.setOauthParams(actionForm.getInboundEmailOauthParams());
                conn.setHost(actionForm.getPopHost());
                conn.setPort(actionForm.getPopPort());
                conn.setUsername(actionForm.getPopUsername());
                conn.setSslEnabled(actionForm.getPopUseSSL());
                conn.setSenderIgnoreList(actionForm.getPopIgnoreSender());
                if (actionForm.getPopPassword().isEmpty()) {
                    conn.setPassword(StringUtils.decodeBase64Codec(ConfigManager.email.getPopPassword()));
                } else {
                    conn.setPassword(actionForm.getPopPassword());
                }
                IssueService issueService = ServiceProvider.getIssueService(this.requestContext);
                errors = issueService.retrieveIssueEmails(conn);
                if (errors.isEmpty()) {
                    errors.add("fetchSuccess", new ActionMessage("admin.config.email.pop.success", new Object[]{conn.getMessagesRetrieved()}));
                }
                this.saveActionMessages(errors);
                return this.ajaxUpdateView(AppPaths.ADMIN_CONFIG_WRITE + "?cmd=" + "popEmailEdit" + "&" + "_error=true");
            }
            ArrayList<SystemConfig> list = new ArrayList<SystemConfig>();
            list.add(new SystemConfig("_SpareConfigKey3", actionForm.getInboundEmailProtocol()));
            list.add(new SystemConfig("mail.pop.host", actionForm.getPopHost()));
            list.add(new SystemConfig("mail.pop.port", actionForm.getPopPort()));
            list.add(new SystemConfig("mail.pop.username", actionForm.getPopUsername()));
            list.add(new SystemConfig("mail.pop.ssl.enable", actionForm.getPopUseSSL()));
            list.add(new SystemConfig("mail.pop.senderIgnoreList", actionForm.getPopIgnoreSender()));
            list.add(new SystemConfig("mail.pop.repeatInterval", actionForm.getPopRetrievalFrequency()));
            list.add(new SystemConfig("mail.pop.messages.limit", actionForm.getPopMessageBatchSize()));
            list.add(new SystemConfig("_SpareConfigKey5", actionForm.getInboundEmailProtocol().equals("office365Imap") ? actionForm.getInboundEmailOauthEndpoint() : ""));
            list.add(new SystemConfig("_SpareConfigKey6", actionForm.getInboundEmailProtocol().equals("office365Imap") ? actionForm.getInboundEmailOauthParams() : ""));
            if (!actionForm.getPopPassword().isEmpty()) {
                list.add(new SystemConfig("mail.pop.password", StringUtils.encodeBase64Codec(actionForm.getPopPassword())));
            }
            AdminService adminService = ServiceProvider.getAdminService(this.requestContext);
            errors = adminService.updateConfig(list);
        }
        if (!errors.isEmpty()) {
            this.saveActionErrors(errors);
            return this.ajaxUpdateView(AppPaths.ADMIN_CONFIG_WRITE + "?cmd=" + "popEmailEdit" + "&" + "_error=true");
        }
        return this.ajaxUpdateView(AppPaths.ADMIN_CONFIG + "?cmd=" + "email");
    }
}

