/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.action.admin.config;

import com.kwoksys.action.admin.config.ConfigForm;
import com.kwoksys.action.common.template.ActionErrorsTemplate;
import com.kwoksys.action.common.template.HeaderTemplate;
import com.kwoksys.action.common.template.StandardTemplate;
import com.kwoksys.biz.ServiceProvider;
import com.kwoksys.biz.admin.AdminService;
import com.kwoksys.biz.admin.dto.SystemConfig;
import com.kwoksys.biz.system.core.AppPaths;
import com.kwoksys.biz.system.core.Links;
import com.kwoksys.biz.system.core.configs.ConfigManager;
import com.kwoksys.framework.connections.mail.EmailMessage;
import com.kwoksys.framework.connections.mail.SmtpConnection;
import com.kwoksys.framework.connections.mail.SmtpService;
import com.kwoksys.framework.properties.Localizer;
import com.kwoksys.framework.struts2.Action2;
import com.kwoksys.framework.struts2.ActionMessage;
import com.kwoksys.framework.struts2.ActionMessages;
import com.kwoksys.framework.ui.WidgetUtils;
import com.kwoksys.framework.util.NumberUtils;
import com.kwoksys.framework.util.StringUtils;
import com.kwoksys.framework.validations.ColumnField;
import com.kwoksys.framework.validations.InputValidator;
import java.util.ArrayList;

public class ConfigEmailSmtpAction
extends Action2 {
    public String edit() throws Exception {
        ConfigForm actionForm = this.getBaseForm(ConfigForm.class);
        actionForm.setId("configEmailForm");
        if (!actionForm.isResubmit()) {
            actionForm.setIssueNotificationFromUiOn(ConfigManager.email.isIssueNotificationFromUiEnabled());
            actionForm.setIssueNotificationFromEmailOn(ConfigManager.email.isIssueNotificationFromEmailEnabled());
            actionForm.setContractExpireNotificationOn(ConfigManager.email.isContractExpireNotificationEnabled());
            actionForm.setAllowedDomains(ConfigManager.email.getAllowedDomains());
            actionForm.setSmtpHost(ConfigManager.email.getSmtpHost());
            actionForm.setSmtpPort(ConfigManager.email.getSmtpPort());
            actionForm.setSmtpUsername(ConfigManager.email.getSmtpUsername());
            actionForm.setSmtpFrom(ConfigManager.email.getSmtpFrom());
            actionForm.setSmtpTo(ConfigManager.email.getSmtpTo());
            actionForm.setSmtpPassword("");
            actionForm.setSmtpStarttls(ConfigManager.email.getSmtpStartTls());
            actionForm.setReportIssueEmailTemplate(ConfigManager.email.getIssueReportEmailTemplate());
            actionForm.setIssueAddEmailTemplate(ConfigManager.email.getIssueAddEmailTemplate());
            actionForm.setIssueUpdateEmailTemplate(ConfigManager.email.getIssueUpdateEmailTemplate());
            actionForm.setContractExpireNotifyEmailTemplate(ConfigManager.email.getContractExpireNotificationEmailTemplate());
        }
        StandardTemplate standardTemplate = new StandardTemplate(this.requestContext, "emailEdit");
        standardTemplate.setPathAttribute("formAction", AppPaths.ADMIN_CONFIG_WRITE);
        standardTemplate.setAttribute("formCancelLink", Links.getCancelLink(this.requestContext, AppPaths.ADMIN_CONFIG + "?cmd=" + "email").getString());
        standardTemplate.setAttribute("cmd", "emailEdit2");
        standardTemplate.setAttribute("onOffOptions", WidgetUtils.getOnOffOptions(this.requestContext));
        HeaderTemplate headerTemplate = standardTemplate.getHeaderTemplate();
        headerTemplate.setTitleKey("admin.config.email.outgoingServer.header");
        standardTemplate.addTemplate(new ActionErrorsTemplate());
        return standardTemplate.findTemplate("standard_template");
    }

    public String edit2() throws Exception {
        ConfigForm actionForm = this.saveActionForm(new ConfigForm());
        String password = actionForm.getSmtpPassword();
        ActionMessages errors = new ActionMessages();
        if (!NumberUtils.isInteger(actionForm.getSmtpPort())) {
            errors.add("smtpPort", new ActionMessage("common.form.fieldNumberInvalid", Localizer.getText(this.requestContext, "admin.config.email.port")));
        }
        if (errors.isEmpty()) {
            if (actionForm.isTest()) {
                InputValidator validator = new InputValidator(this.requestContext, errors);
                validator.validate(new ColumnField().setName("toField").setTitleKey("admin.config.email.smtp.to").setNullable(false).calculateLength(actionForm.getSmtpTo()));
                if (errors.isEmpty()) {
                    EmailMessage message = new EmailMessage();
                    message.setFromField(actionForm.getSmtpFrom());
                    message.getToField().add(actionForm.getSmtpTo());
                    message.setSubjectField(Localizer.getText(this.requestContext, "admin.config.email.test.subject"));
                    message.setBodyField(Localizer.getText(this.requestContext, "admin.config.email.test.body"));
                    SmtpConnection conn = new SmtpConnection();
                    conn.setHost(actionForm.getSmtpHost());
                    conn.setPort(actionForm.getSmtpPort());
                    conn.setUsername(actionForm.getSmtpUsername());
                    conn.setStarttls(actionForm.getSmtpStarttls());
                    if (!password.isEmpty()) {
                        conn.setPassword(actionForm.getSmtpPassword());
                    }
                    if ((errors = new SmtpService(conn).send(message)).isEmpty()) {
                        errors.add("sendSuccess", new ActionMessage("admin.config.email.success", actionForm.getSmtpTo()));
                    }
                }
                this.saveActionMessages(errors);
                return this.ajaxUpdateView(AppPaths.ADMIN_CONFIG_WRITE + "?cmd=" + "emailEdit" + "&" + "_error=true");
            }
            ArrayList<SystemConfig> list = new ArrayList<SystemConfig>();
            list.add(new SystemConfig("Email.IssueNotificationFromUiEnabled", actionForm.isIssueNotificationFromUiOn()));
            list.add(new SystemConfig("Email.IssueNotificationFromEmailEnabled", actionForm.isIssueNotificationFromEmailOn()));
            list.add(new SystemConfig("Email.ContractExpirationNotificationEnabled", actionForm.isContractExpireNotificationOn()));
            list.add(new SystemConfig("email.allowedDomains", actionForm.getAllowedDomains()));
            list.add(new SystemConfig("mail.smtp.host", actionForm.getSmtpHost()));
            list.add(new SystemConfig("mail.smtp.port", actionForm.getSmtpPort()));
            list.add(new SystemConfig("mail.smtp.username", actionForm.getSmtpUsername()));
            list.add(new SystemConfig("mail.smtp.from", actionForm.getSmtpFrom()));
            list.add(new SystemConfig("mail.smtp.to", actionForm.getSmtpTo()));
            list.add(new SystemConfig("mail.smtp.starttls", actionForm.getSmtpStarttls()));
            list.add(new SystemConfig("Issues.IssueReportEmailTemplate", actionForm.getReportIssueEmailTemplate()));
            list.add(new SystemConfig("Issues.IssueAddEmailTemplate", actionForm.getIssueAddEmailTemplate()));
            list.add(new SystemConfig("Issues.IssueUpdateEmailTemplate", actionForm.getIssueUpdateEmailTemplate()));
            list.add(new SystemConfig("Issues.IssueUpdateEmailTemplate", actionForm.getIssueUpdateEmailTemplate()));
            list.add(new SystemConfig("Email.ContractExpireNotificationTemplate", actionForm.getContractExpireNotifyEmailTemplate()));
            if (!password.isEmpty()) {
                list.add(new SystemConfig("mail.smtp.password", StringUtils.encodeBase64Codec(password)));
            }
            AdminService adminService = ServiceProvider.getAdminService(this.requestContext);
            errors = adminService.updateConfig(list);
        }
        if (!errors.isEmpty()) {
            this.saveActionErrors(errors);
            return this.ajaxUpdateView(AppPaths.ADMIN_CONFIG_WRITE + "?cmd=" + "emailEdit" + "&" + "_error=true");
        }
        return this.ajaxUpdateView(AppPaths.ADMIN_CONFIG + "?cmd=" + "email");
    }
}

