/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.action.admin.config;

import com.kwoksys.action.admin.config.ConfigForm;
import com.kwoksys.action.common.template.ActionErrorsTemplate;
import com.kwoksys.action.common.template.HeaderTemplate;
import com.kwoksys.action.common.template.StandardTemplate;
import com.kwoksys.biz.ServiceProvider;
import com.kwoksys.biz.admin.AdminService;
import com.kwoksys.biz.admin.dto.AccessUser;
import com.kwoksys.biz.admin.dto.SystemConfig;
import com.kwoksys.biz.files.FileService;
import com.kwoksys.biz.files.core.FileUtils;
import com.kwoksys.biz.system.core.AppPaths;
import com.kwoksys.biz.system.core.FeatureManager;
import com.kwoksys.biz.system.core.Links;
import com.kwoksys.biz.system.core.configs.ConfigManager;
import com.kwoksys.framework.struts2.Action2;
import com.kwoksys.framework.struts2.ActionMessages;
import com.kwoksys.framework.struts2.LabelValueBean;
import com.kwoksys.framework.ui.Link;
import java.util.ArrayList;

public class ConfigFileAction
extends Action2 {
    public String index() throws Exception {
        Link link;
        AccessUser user = this.requestContext.getUser();
        FileService fileService = ServiceProvider.getFileService(this.requestContext);
        StandardTemplate standardTemplate = new StandardTemplate(this.requestContext, "file");
        standardTemplate.setAttribute("maxFileUploadSize", FileUtils.formatFileSize(this.requestContext, ConfigManager.file.getMaxFileUploadSize()));
        standardTemplate.setAttribute("kilobyteUnits", ConfigManager.file.getKilobyteUnits());
        standardTemplate.setAttribute("companyRepositoryPath", ConfigManager.file.getCompanyFileRepositoryLocation());
        standardTemplate.setAttribute("validCompanyRepositoryPath", fileService.isDirectoryExist(ConfigManager.file.getCompanyFileRepositoryLocation()));
        standardTemplate.setAttribute("issueRepositoryPath", ConfigManager.file.getIssueFileRepositoryLocation());
        standardTemplate.setAttribute("validIssueRepositoryPath", fileService.isDirectoryExist(ConfigManager.file.getIssueFileRepositoryLocation()));
        standardTemplate.setAttribute("hardwareRepositoryPath", ConfigManager.file.getHardwareFileRepositoryLocation());
        standardTemplate.setAttribute("validHardwareRepositoryPath", fileService.isDirectoryExist(ConfigManager.file.getHardwareFileRepositoryLocation()));
        standardTemplate.setAttribute("softwareRepositoryPath", ConfigManager.file.getSoftwareFileRepositoryLocation());
        standardTemplate.setAttribute("validSoftwareRepositoryPath", fileService.isDirectoryExist(ConfigManager.file.getSoftwareFileRepositoryLocation()));
        standardTemplate.setAttribute("contractRepositoryPath", ConfigManager.file.getContractFileRepositoryLocation());
        standardTemplate.setAttribute("validContractRepositoryPath", fileService.isDirectoryExist(ConfigManager.file.getContractFileRepositoryLocation()));
        standardTemplate.setAttribute("kbRepositoryPath", ConfigManager.file.getKbFileRepositoryLocation());
        standardTemplate.setAttribute("validKbRepositoryPath", fileService.isDirectoryExist(ConfigManager.file.getKbFileRepositoryLocation()));
        HeaderTemplate header = standardTemplate.getHeaderTemplate();
        header.setTitleKey("admin.config.file");
        if (user.hasPermission(AppPaths.ADMIN_CONFIG_WRITE)) {
            link = new Link(this.requestContext);
            link.setAjaxPath(AppPaths.ADMIN_CONFIG_WRITE + "?cmd=" + "fileEdit");
            link.setTitleKey("common.action.Edit");
            header.addHeaderCmds(link);
        }
        header.addNavLink(Links.getAdminHomeLink(this.requestContext));
        link = new Link(this.requestContext);
        link.setTitleKey("admin.config.file");
        header.addNavLink(link);
        return standardTemplate.findTemplate("standard_template");
    }

    public String edit() throws Exception {
        ConfigForm actionForm = this.getBaseForm(ConfigForm.class);
        if (!actionForm.isResubmit()) {
            actionForm.setKilobyteUnits(ConfigManager.file.getKilobyteUnits());
            actionForm.setFileRepositoryCompany(ConfigManager.file.getCompanyFileRepositoryLocation());
            actionForm.setFileRepositoryIssue(ConfigManager.file.getIssueFileRepositoryLocation());
            actionForm.setFileRepositoryHardware(ConfigManager.file.getHardwareFileRepositoryLocation());
            actionForm.setFileRepositorySoftware(ConfigManager.file.getSoftwareFileRepositoryLocation());
            actionForm.setFileRepositoryContract(ConfigManager.file.getContractFileRepositoryLocation());
            actionForm.setFileRepositoryKb(ConfigManager.file.getKbFileRepositoryLocation());
        }
        ArrayList<LabelValueBean> kbUnitOptions = new ArrayList<LabelValueBean>();
        for (Integer option : ConfigManager.file.getKilobyteUnitsList()) {
            kbUnitOptions.add(new LabelValueBean(String.valueOf(option), String.valueOf(option)));
        }
        StandardTemplate standardTemplate = new StandardTemplate(this.requestContext, "fileEdit");
        standardTemplate.setPathAttribute("formAction", AppPaths.ADMIN_CONFIG_WRITE);
        standardTemplate.setAttribute("formCancelLink", Links.getCancelLink(this.requestContext, AppPaths.ADMIN_CONFIG + "?cmd=" + "file").getString());
        standardTemplate.setAttribute("cmd", "fileEdit2");
        standardTemplate.setAttribute("disableFilePathUpdate", FeatureManager.isMultiAppsInstance());
        standardTemplate.setAttribute("kbUnitOptions", kbUnitOptions);
        HeaderTemplate headerTemplate = standardTemplate.getHeaderTemplate();
        headerTemplate.setEditTitleKey("admin.config.file");
        standardTemplate.addTemplate(new ActionErrorsTemplate());
        return standardTemplate.findTemplate("standard_template");
    }

    public String edit2() throws Exception {
        AdminService adminService;
        ActionMessages errors;
        ConfigForm actionForm = this.saveActionForm(new ConfigForm());
        ArrayList<SystemConfig> list = new ArrayList<SystemConfig>();
        list.add(new SystemConfig("Files.KilobyteUnits", String.valueOf(actionForm.getKilobyteUnits())));
        if (!FeatureManager.isMultiAppsInstance()) {
            list.add(new SystemConfig("file.company.repositoryPath", actionForm.getFileRepositoryCompany()));
            list.add(new SystemConfig("file.issue.repositoryPath", actionForm.getFileRepositoryIssue()));
            list.add(new SystemConfig("file.hardware.repositoryPath", actionForm.getFileRepositoryHardware()));
            list.add(new SystemConfig("file.software.repositoryPath", actionForm.getFileRepositorySoftware()));
            list.add(new SystemConfig("file.contract.repositoryPath", actionForm.getFileRepositoryContract()));
            list.add(new SystemConfig("file.kb.repositoryPath", actionForm.getFileRepositoryKb()));
        }
        if (!(errors = (adminService = ServiceProvider.getAdminService(this.requestContext)).updateConfig(list)).isEmpty()) {
            this.saveActionErrors(errors);
            return this.ajaxUpdateView(AppPaths.ADMIN_CONFIG_WRITE + "?cmd=" + "fileEdit" + "&" + "_error=true");
        }
        return this.ajaxUpdateView(AppPaths.ADMIN_CONFIG + "?cmd=" + "file");
    }
}

