/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.action.admin.config;

import com.kwoksys.action.admin.config.ConfigForm;
import com.kwoksys.action.common.template.ActionErrorsTemplate;
import com.kwoksys.action.common.template.AjaxTemplate;
import com.kwoksys.biz.ServiceProvider;
import com.kwoksys.biz.admin.AdminService;
import com.kwoksys.biz.admin.dto.SystemConfig;
import com.kwoksys.biz.system.core.AppPaths;
import com.kwoksys.biz.system.core.Links;
import com.kwoksys.biz.system.core.configs.LogConfigManager;
import com.kwoksys.framework.properties.Localizer;
import com.kwoksys.framework.struts2.Action2;
import com.kwoksys.framework.struts2.ActionMessages;
import com.kwoksys.framework.struts2.LabelValueBean;
import java.util.ArrayList;

public class ConfigLoggingAjax
extends Action2 {
    public String edit() throws Exception {
        ConfigForm actionForm = this.getBaseForm(ConfigForm.class);
        if (!actionForm.isResubmit()) {
            actionForm.setDatabaseAccessLogLevel(LogConfigManager.getLogLevel(LogConfigManager.DATABASE_ACCESS_PREFIX).getName());
            actionForm.setLdapLogLevel(LogConfigManager.getLogLevel(LogConfigManager.AUTHENTICATION_PREFIX).getName());
            actionForm.setSchedulerLogLevel(LogConfigManager.getLogLevel(LogConfigManager.SCHEDULER_PREFIX).getName());
            actionForm.setTemplateLogLevel(LogConfigManager.getLogLevel(LogConfigManager.TEMPLATE_PREFIX).getName());
        }
        ArrayList<LabelValueBean> logLevelOptions = new ArrayList<LabelValueBean>();
        logLevelOptions.add(new LabelValueBean(Localizer.getText(this.requestContext, "admin.config.logging.level.info"), "INFO"));
        logLevelOptions.add(new LabelValueBean(Localizer.getText(this.requestContext, "admin.config.logging.level.off"), "OFF"));
        AjaxTemplate standardTemplate = new AjaxTemplate(this.requestContext, "loggingEdit");
        standardTemplate.setPathAttribute("formAction", AppPaths.ADMIN_CONFIG_WRITE);
        standardTemplate.setAttribute("formCancelLink", Links.getCancelLink(this.requestContext, AppPaths.ADMIN_CONFIG + "?cmd=" + "system").getString());
        standardTemplate.setAttribute("cmd", "loggingEdit2");
        standardTemplate.setAttribute("logLevelOptions", logLevelOptions);
        standardTemplate.addTemplate(new ActionErrorsTemplate());
        return standardTemplate.findTemplate("ajax_template");
    }

    public String edit2() throws Exception {
        ConfigForm actionForm = this.saveActionForm(new ConfigForm());
        ArrayList<SystemConfig> list = new ArrayList<SystemConfig>();
        list.add(new SystemConfig("logging.database.level", actionForm.getDatabaseAccessLogLevel()));
        list.add(new SystemConfig("logging.ldap.level", actionForm.getLdapLogLevel()));
        list.add(new SystemConfig("Logging.Level.Scheduler", actionForm.getSchedulerLogLevel()));
        list.add(new SystemConfig("Logging.Level.Template", actionForm.getTemplateLogLevel()));
        AdminService adminService = ServiceProvider.getAdminService(this.requestContext);
        ActionMessages errors = adminService.updateConfig(list);
        if (!errors.isEmpty()) {
            this.saveActionErrors(errors);
            return this.ajaxUpdateView("configLogging", AppPaths.ADMIN_CONFIG_WRITE + "?cmd=" + "loggingEdit" + "&" + "_error=true");
        }
        return this.ajaxUpdateView(AppPaths.ADMIN_CONFIG + "?cmd=" + "system");
    }
}

