/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.action.admin.config;

import com.kwoksys.action.admin.config.ConfigForm;
import com.kwoksys.action.common.template.ActionErrorsTemplate;
import com.kwoksys.action.common.template.HeaderTemplate;
import com.kwoksys.action.common.template.StandardTemplate;
import com.kwoksys.biz.ServiceProvider;
import com.kwoksys.biz.admin.AdminService;
import com.kwoksys.biz.admin.dto.AccessUser;
import com.kwoksys.biz.admin.dto.SystemConfig;
import com.kwoksys.biz.system.core.AppPaths;
import com.kwoksys.biz.system.core.Links;
import com.kwoksys.biz.system.core.configs.ConfigManager;
import com.kwoksys.framework.properties.Localizer;
import com.kwoksys.framework.session.SessionManager;
import com.kwoksys.framework.struts2.Action2;
import com.kwoksys.framework.struts2.ActionMessages;
import com.kwoksys.framework.struts2.LabelValueBean;
import com.kwoksys.framework.ui.Link;
import com.kwoksys.framework.util.CkeditorHelper;
import com.kwoksys.framework.util.StringUtils;
import java.util.ArrayList;

public class ConfigLookAction
extends Action2 {
    public String index() throws Exception {
        AccessUser user = this.requestContext.getUser();
        StandardTemplate standardTemplate = new StandardTemplate(this.requestContext, "look");
        standardTemplate.setAttribute("theme", Localizer.getText(this.requestContext, "admin.config.theme." + ConfigManager.system.getTheme()));
        standardTemplate.setAttribute("stylesheet", ConfigManager.system.getSytlesheet());
        standardTemplate.setAttribute("homeCustomDescription", ConfigManager.system.getCustomHomeDescription());
        HeaderTemplate header = standardTemplate.getHeaderTemplate();
        header.setTitleKey("admin.index.lookAndFeel");
        if (user.hasPermission(AppPaths.ADMIN_CONFIG_WRITE)) {
            Link link = new Link(this.requestContext);
            link.setAjaxPath(AppPaths.ADMIN_CONFIG_WRITE + "?cmd=" + "lookEdit");
            link.setTitleKey("common.action.Edit");
            header.addHeaderCmds(link);
        }
        header.addNavLink(Links.getAdminHomeLink(this.requestContext));
        header.addNavLink(new Link(this.requestContext).setTitleKey("admin.index.lookAndFeel"));
        return standardTemplate.findTemplate("standard_template");
    }

    public String edit() throws Exception {
        ConfigForm actionForm = this.getBaseForm(ConfigForm.class);
        if (!actionForm.isResubmit()) {
            actionForm.setTheme(ConfigManager.system.getTheme());
            actionForm.setStylesheet(ConfigManager.system.getSytlesheet());
            actionForm.setHomeCustomDescription(ConfigManager.system.getCustomHomeDescription());
        }
        ArrayList<LabelValueBean> themeOptions = new ArrayList<LabelValueBean>();
        for (String option : ConfigManager.system.getThemeOptions()) {
            themeOptions.add(new LabelValueBean(Localizer.getText(this.requestContext, "admin.config.theme." + option), option));
        }
        StandardTemplate standardTemplate = new StandardTemplate(this.requestContext, "lookEdit");
        standardTemplate.setPathAttribute("formAction", AppPaths.ADMIN_CONFIG_WRITE);
        standardTemplate.setAttribute("formCancelLink", Links.getCancelLink(this.requestContext, AppPaths.ADMIN_CONFIG + "?cmd=" + "look").getString());
        standardTemplate.setAttribute("cmd", "lookEdit2");
        standardTemplate.setAttribute("themeOptions", themeOptions);
        standardTemplate.setAttribute("homepageContent", StringUtils.encodeCkeditorJs(actionForm.getHomeCustomDescription()));
        standardTemplate.setAttribute("language", CkeditorHelper.getLocaleKey(this.requestContext.getLocale()));
        HeaderTemplate header = standardTemplate.getHeaderTemplate();
        header.setEditTitleKey("admin.index.lookAndFeel");
        standardTemplate.addTemplate(new ActionErrorsTemplate());
        return standardTemplate.findTemplate("standard_template");
    }

    public String edit2() throws Exception {
        ConfigForm actionForm = this.saveActionForm(new ConfigForm());
        String theme = actionForm.getTheme();
        ArrayList<SystemConfig> list = new ArrayList<SystemConfig>();
        list.add(new SystemConfig("theme.default", theme));
        list.add(new SystemConfig("ui.stylesheet", actionForm.getStylesheet()));
        list.add(new SystemConfig("home.customDescription", actionForm.getHomeCustomDescription()));
        AdminService adminService = ServiceProvider.getAdminService(this.requestContext);
        ActionMessages errors = adminService.updateConfig(list);
        if (!errors.isEmpty()) {
            this.saveActionErrors(errors);
            return this.redirect(AppPaths.ADMIN_CONFIG_WRITE + "?cmd=" + "lookEdit" + "&" + "_error=true");
        }
        SessionManager.setAppSessionTheme(this.request.getSession(), theme);
        return this.redirect(AppPaths.ADMIN_CONFIG + "?cmd=" + "look");
    }
}

