/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.action.admin.config;

import com.kwoksys.action.common.template.HeaderTemplate;
import com.kwoksys.action.common.template.StandardTemplate;
import com.kwoksys.biz.ServiceProvider;
import com.kwoksys.biz.admin.AdminService;
import com.kwoksys.biz.admin.dto.AccessUser;
import com.kwoksys.biz.files.core.FileUtils;
import com.kwoksys.biz.system.SystemService;
import com.kwoksys.biz.system.core.AppPaths;
import com.kwoksys.biz.system.core.FeatureManager;
import com.kwoksys.biz.system.core.Image;
import com.kwoksys.biz.system.core.Links;
import com.kwoksys.biz.system.core.configs.ConfigManager;
import com.kwoksys.biz.system.core.configs.LogConfigManager;
import com.kwoksys.framework.connections.database.DatabaseManager;
import com.kwoksys.framework.properties.Localizer;
import com.kwoksys.framework.properties.PropertiesManager;
import com.kwoksys.framework.struts2.Action2;
import com.kwoksys.framework.ui.Link;
import com.kwoksys.framework.util.StringUtils;
import java.util.Map;

public class ConfigSystemAction
extends Action2 {
    public String execute() throws Exception {
        AccessUser user = this.requestContext.getUser();
        SystemService systemService = ServiceProvider.getSystemService(this.requestContext);
        AdminService adminService = ServiceProvider.getAdminService(this.requestContext);
        Map<String, String> dbmap = systemService.getDatabaseInfo();
        StandardTemplate standardTemplate = new StandardTemplate(this.requestContext, "system");
        standardTemplate.setAttribute("browserUserAgent", this.requestContext.getRequest().getHeader("user-agent"));
        standardTemplate.setAttribute("os", Localizer.getText(this.requestContext, "admin.configData.os.value", new Object[]{System.getProperty("os.name"), System.getProperty("os.version")}));
        standardTemplate.setAttribute("osArch", System.getProperty("os.arch"));
        standardTemplate.setAttribute("jvmName", System.getProperty("java.vm.name"));
        standardTemplate.setAttribute("jvmVersion", System.getProperty("java.version"));
        standardTemplate.setAttribute("jvmVendor", System.getProperty("java.vendor"));
        standardTemplate.setAttribute("jvmHome", System.getProperty("java.home"));
        standardTemplate.setAttribute("jvmFreeMemory", FileUtils.formatFileSize(this.requestContext, Runtime.getRuntime().freeMemory()));
        standardTemplate.setAttribute("jvmTotalMemory", FileUtils.formatFileSize(this.requestContext, Runtime.getRuntime().totalMemory()));
        standardTemplate.setAttribute("jvmMaxMemory", FileUtils.formatFileSize(this.requestContext, Runtime.getRuntime().maxMemory()));
        standardTemplate.setAttribute("userHome", System.getProperty("user.home"));
        standardTemplate.setAttribute("dbProductName", dbmap.get("DatabaseProductName"));
        standardTemplate.setAttribute("dbProductVersion", dbmap.get("DatabaseProductVersion"));
        if (!FeatureManager.isMultiAppsInstance()) {
            standardTemplate.setAttribute("databases", StringUtils.join(adminService.getDatabases(), "database_name", ", "));
        }
        standardTemplate.setAttribute("dbHost", PropertiesManager.get("db.serverHost"));
        standardTemplate.setAttribute("dbPort", PropertiesManager.get("db.serverPort"));
        standardTemplate.setAttribute("dbName", PropertiesManager.get("db.name"));
        standardTemplate.setAttribute("dbMaxPoolSize", ConfigManager.system.getDbMaxConnection());
        standardTemplate.setAttribute("dbPoolSizeCurrent", Localizer.getText(this.requestContext, "admin.config.db.poolSize", (Object[])new Integer[]{DatabaseManager.getInstance().getCheckedOutPoolSize(), DatabaseManager.getInstance().getAvailablePoolSize()}));
        standardTemplate.setAttribute("backupLink", new Link(this.requestContext).setAjaxPath(AppPaths.ADMIN_CONFIG + "?cmd=" + "backup").setTitleKey("admin.config.db.backup.cmd").getString());
        standardTemplate.setAttribute("loadDbSequencesLink", new Link(this.requestContext).setTitleKey("admin.config.system.loadDbSequences").setJavascript("App.updateViewToggle('dbSequences', '" + AppPaths.ROOT + AppPaths.ADMIN_CONFIG + "?cmd=" + "dbSequences" + "')").getString());
        if (user.hasPermission(AppPaths.ADMIN_CONFIG_WRITE)) {
            standardTemplate.setAttribute("loggingLink", new Link(this.requestContext).setJavascript("App.updateView('configLogging', '" + AppPaths.ROOT + AppPaths.ADMIN_CONFIG_WRITE + "?cmd=" + "loggingEdit" + "')").setInlineImage(Image.getInstance().getActionEdit(this.requestContext, "common.action.Edit")).getString());
        }
        standardTemplate.setAttribute("databaseAccessLogLevel", LogConfigManager.getLogLevel(LogConfigManager.DATABASE_ACCESS_PREFIX));
        standardTemplate.setAttribute("ldapLogLevel", LogConfigManager.getLogLevel(LogConfigManager.AUTHENTICATION_PREFIX));
        standardTemplate.setAttribute("schedulerLogLevel", LogConfigManager.getLogLevel(LogConfigManager.SCHEDULER_PREFIX));
        standardTemplate.setAttribute("templateLogLevel", LogConfigManager.getLogLevel(LogConfigManager.TEMPLATE_PREFIX));
        HeaderTemplate header = standardTemplate.getHeaderTemplate();
        header.setTitleClassNoLine();
        header.setTitleKey("admin.configHeader.system_info");
        header.addNavLink(Links.getAdminHomeLink(this.requestContext));
        header.addNavLink(new Link(this.requestContext).setTitleKey("admin.configHeader.system_info"));
        return standardTemplate.findTemplate("standard_template");
    }
}

