/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.action.admin.dataimport;

import com.kwoksys.action.files.FileUploadForm;
import com.kwoksys.framework.csv.CsvReader;
import com.kwoksys.framework.http.RequestContext;
import com.kwoksys.framework.properties.Localizer;
import com.kwoksys.framework.struts2.ActionMessage;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DataImportForm
extends FileUploadForm {
    private static final Logger LOGGER = Logger.getLogger(DataImportForm.class.getName());
    private CsvReader csvReader;
    private String importType;
    private boolean allowDuplicate;
    private ActionMessage error;

    @Override
    public void setRequest(RequestContext requestContext) {
        super.setRequest(requestContext);
        this.importType = requestContext.getParameterString("importType", this.importType);
        this.allowDuplicate = requestContext.getParameterBoolean("allowDuplicate", this.allowDuplicate);
        this.error = null;
        try {
            if (this.files == null) {
                this.error = new ActionMessage("common.form.fieldRequired", Localizer.getText(requestContext, "import.selectImportFile"));
                return;
            }
            this.csvReader = new CsvReader(new File(this.files[0].getAbsolutePath()));
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Problem with uploaded file", e);
            this.error = new ActionMessage("import.validate.message.unknown");
        }
    }

    public String getImportType() {
        return this.importType;
    }

    public CsvReader getCsvReader() {
        return this.csvReader;
    }

    public ActionMessage getError() {
        return this.error;
    }

    public boolean isAllowDuplicate() {
        return this.allowDuplicate;
    }
}

