/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.action.admin.dataimport;

import com.kwoksys.action.admin.dataimport.DataImportForm;
import com.kwoksys.action.common.template.ActionErrorsTemplate;
import com.kwoksys.action.common.template.HeaderTemplate;
import com.kwoksys.action.common.template.StandardTemplate;
import com.kwoksys.biz.admin.core.dataimport.ImportManager;
import com.kwoksys.biz.system.core.AppPaths;
import com.kwoksys.biz.system.core.Links;
import com.kwoksys.biz.system.core.configs.ConfigManager;
import com.kwoksys.framework.csv.CsvReader;
import com.kwoksys.framework.struts2.Action2;
import com.kwoksys.framework.struts2.ActionMessage;
import com.kwoksys.framework.struts2.ActionMessages;

public class ValidateAction
extends Action2 {
    public String execute() throws Exception {
        DataImportForm actionForm = this.getSessionBaseForm(DataImportForm.class);
        CsvReader csvReader = actionForm.getCsvReader();
        ActionMessages errors = new ActionMessages();
        if (actionForm.getError() != null) {
            errors.add("file0", actionForm.getError());
        } else if (csvReader.getData().size() - 1 > ConfigManager.app.getDataImportRowLimit()) {
            errors.add("file0", new ActionMessage("import.validate.message.exceededRowLimit", ConfigManager.app.getDataImportRowLimit(), csvReader.getData().size()));
        }
        if (!errors.isEmpty()) {
            this.saveActionErrors(errors);
            return this.redirect(AppPaths.ADMIN_DATA_IMPORT_INDEX + "?" + "_error=true");
        }
        ImportManager importManager = ImportManager.newInstance(this.requestContext, actionForm);
        importManager.validate(csvReader.getData());
        StandardTemplate standardTemplate = new StandardTemplate(this.requestContext);
        standardTemplate.setAttribute("dataList", importManager.getImportItems());
        if (actionForm.getImportType().equals("hardware_import")) {
            standardTemplate.setAttribute("nameHeader", "common.column.hardware_name");
        } else if (actionForm.getImportType().equals("user_import")) {
            standardTemplate.setAttribute("nameHeader", "common.column.username");
        }
        standardTemplate.setPathAttribute("formAction", AppPaths.ADMIN_DATA_IMPORT_EXECUTE);
        standardTemplate.setPathAttribute("formBackAction", AppPaths.ADMIN_DATA_IMPORT_INDEX);
        standardTemplate.setAttribute("formCancelLink", Links.getCancelLink(this.requestContext, AppPaths.ADMIN_INDEX).getString());
        HeaderTemplate headerTemplate = standardTemplate.getHeaderTemplate();
        headerTemplate.setTitleKey("import.validate.title");
        headerTemplate.setTitleClassNoLine();
        ActionErrorsTemplate errorsTemplate = standardTemplate.addTemplate(new ActionErrorsTemplate());
        errorsTemplate.setMessageKey("import.validate.description");
        return standardTemplate.findTemplate("standard_template");
    }
}

