/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.action.admin.manageusers;

import com.kwoksys.action.admin.manageusers.GroupDetailTemplate;
import com.kwoksys.action.common.template.HeaderTemplate;
import com.kwoksys.action.common.template.StandardTemplate;
import com.kwoksys.action.common.template.TabBodyTemplate;
import com.kwoksys.action.common.template.TabsTemplate;
import com.kwoksys.biz.ServiceProvider;
import com.kwoksys.biz.admin.AdminService;
import com.kwoksys.biz.admin.core.AdminTabs;
import com.kwoksys.biz.admin.core.AdminUtils;
import com.kwoksys.biz.admin.dto.AccessGroup;
import com.kwoksys.biz.admin.dto.AccessUser;
import com.kwoksys.biz.admin.dto.GroupPermissionMap;
import com.kwoksys.biz.system.core.AppPaths;
import com.kwoksys.biz.system.core.Links;
import com.kwoksys.framework.connections.database.QueryCriteria;
import com.kwoksys.framework.struts2.Action2;
import com.kwoksys.framework.ui.Link;

public class GroupAccessAction
extends Action2 {
    public String execute() throws Exception {
        Link link;
        Integer groupId = this.requestContext.getParameter("groupId");
        AccessUser user = this.requestContext.getUser();
        AdminService adminService = ServiceProvider.getAdminService(this.requestContext);
        AccessGroup group = adminService.getGroup(groupId);
        QueryCriteria queryCriteria = new QueryCriteria();
        queryCriteria.addSortColumn("order_num");
        StandardTemplate standardTemplate = new StandardTemplate(this.requestContext);
        HeaderTemplate header = standardTemplate.getHeaderTemplate();
        header.setTitleKey("admin.groupDetail.header");
        if (user.hasPermission(AppPaths.ADMIN_GROUP_ACCESS_EDIT)) {
            link = new Link(this.requestContext);
            link.setAjaxPath(AppPaths.ADMIN_GROUP_ACCESS_EDIT + "?groupId=" + group.getId());
            link.setTitleKey("admin.cmd.groupAccessEdit");
            header.addHeaderCmds(link);
        }
        header.addNavLink(Links.getAdminHomeLink(this.requestContext));
        if (user.hasPermission(AppPaths.ADMIN_GROUP_LIST)) {
            link = new Link(this.requestContext);
            link.setAjaxPath(AppPaths.ADMIN_GROUP_LIST);
            link.setTitleKey("admin.index.groupList");
            header.addNavLink(link);
        }
        standardTemplate.addTemplate(new GroupDetailTemplate(group));
        TabsTemplate tabs = standardTemplate.addTemplate(new TabsTemplate());
        tabs.setTabList(AdminTabs.createGroupTabs(this.requestContext, groupId));
        tabs.setTabActive("accessTab");
        TabBodyTemplate tabBodyTemplate = standardTemplate.addTemplate(new TabBodyTemplate());
        for (GroupPermissionMap groupPerm : adminService.getGroupAccess(queryCriteria, groupId)) {
            TabBodyTemplate.Tr tr = new TabBodyTemplate.Tr(tabBodyTemplate);
            TabBodyTemplate.Td td = new TabBodyTemplate.Td(tabBodyTemplate);
            td.setValue(AdminUtils.getPermissionLabel(this.requestContext, groupPerm.getPermName()));
            td.setStyle("white-space:nowrap");
            tr.add(td);
            td = new TabBodyTemplate.Td(tabBodyTemplate);
            td.setValue(AdminUtils.getUserAccessIcon(groupPerm.isHasPermission()));
            td.setStyle("width:100%");
            tr.add(td);
            tabBodyTemplate.add(tr);
        }
        return standardTemplate.findTemplate("standard_autogen_template");
    }
}

