/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.action.admin.manageusers;

import com.kwoksys.action.admin.manageusers.GroupAccessForm;
import com.kwoksys.action.admin.manageusers.GroupDetailTemplate;
import com.kwoksys.action.common.template.ActionErrorsTemplate;
import com.kwoksys.action.common.template.HeaderTemplate;
import com.kwoksys.action.common.template.StandardTemplate;
import com.kwoksys.action.common.template.TabsTemplate;
import com.kwoksys.action.common.template.ThisTemplate;
import com.kwoksys.biz.ServiceProvider;
import com.kwoksys.biz.admin.AdminService;
import com.kwoksys.biz.admin.core.AdminTabs;
import com.kwoksys.biz.admin.core.AdminUtils;
import com.kwoksys.biz.admin.dto.AccessGroup;
import com.kwoksys.biz.admin.dto.GroupPermissionMap;
import com.kwoksys.biz.system.core.AppPaths;
import com.kwoksys.biz.system.core.Links;
import com.kwoksys.framework.connections.database.QueryCriteria;
import com.kwoksys.framework.session.CacheManager;
import com.kwoksys.framework.struts2.Action2;
import com.kwoksys.framework.struts2.ActionMessages;
import com.kwoksys.framework.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;

public class GroupAccessEditAction
extends Action2 {
    public String edit() throws Exception {
        GroupAccessForm actionForm = this.getBaseForm(GroupAccessForm.class);
        AdminService adminService = ServiceProvider.getAdminService(this.requestContext);
        AccessGroup group = adminService.getGroup(actionForm.getGroupId());
        QueryCriteria queryCriteria = new QueryCriteria();
        queryCriteria.addSortColumn("order_num");
        ArrayList accessList = new ArrayList();
        ArrayList<Integer> permissions = new ArrayList<Integer>();
        for (GroupPermissionMap groupPerm : adminService.getGroupAccess(queryCriteria, actionForm.getGroupId())) {
            HashMap<String, Object> accessMap = new HashMap<String, Object>();
            accessMap.put("accessText", AdminUtils.getPermissionLabel(this.requestContext, groupPerm.getPermName()));
            String accessName = "formAccess_" + groupPerm.getPermId();
            accessMap.put(accessName, groupPerm.isHasPermission() ? 1 : 0);
            accessMap.put("accessName", accessName);
            accessList.add(accessMap);
            permissions.add(groupPerm.getPermId());
        }
        StandardTemplate standardTemplate = new StandardTemplate(this.requestContext);
        standardTemplate.setAttribute("accessList", accessList);
        standardTemplate.setAttribute("permissionList", StringUtils.joinIntegers(permissions, ","));
        standardTemplate.setAttribute("accessOptions", AdminUtils.getUserAccessOptionList());
        standardTemplate.setPathAttribute("formAction", AppPaths.ADMIN_GROUP_ACCESS_EDIT_2 + "?groupId=" + actionForm.getGroupId());
        standardTemplate.setAttribute("formCancelLink", Links.getCancelLink(this.requestContext, AppPaths.ADMIN_GROUP_ACCESS + "?groupId=" + actionForm.getGroupId()).getString());
        HeaderTemplate header = standardTemplate.getHeaderTemplate();
        header.setTitleKey("admin.groupDetail.header");
        standardTemplate.addTemplate(new GroupDetailTemplate(group));
        standardTemplate.addTemplate(new ActionErrorsTemplate());
        TabsTemplate tabs = standardTemplate.addTemplate(new TabsTemplate());
        tabs.setTabList(AdminTabs.createGroupTabs(this.requestContext, actionForm.getGroupId()));
        tabs.setTabActive("accessTab");
        standardTemplate.addTemplate(new ThisTemplate());
        return standardTemplate.findTemplate("standard_autogen_template");
    }

    public String edit2() throws Exception {
        GroupAccessForm actionForm = this.saveActionForm(new GroupAccessForm());
        AdminService adminService = ServiceProvider.getAdminService(this.requestContext);
        AccessGroup group = adminService.getGroup(actionForm.getGroupId());
        ActionMessages errors = new ActionMessages();
        for (GroupPermissionMap groupperm : adminService.getGroupAccess(new QueryCriteria(), group.getId())) {
            groupperm.setCmd(this.requestContext.getParameter("formAccess_" + groupperm.getPermId()));
            errors = adminService.updateGroupAccess(groupperm);
        }
        if (!errors.isEmpty()) {
            this.saveActionErrors(errors);
            return this.ajaxUpdateView(AppPaths.ADMIN_GROUP_ACCESS_EDIT + "?" + "_error=true" + "&groupId=" + actionForm.getGroupId());
        }
        new CacheManager(this.requestContext).removeGroupPermissionsCache(actionForm.getGroupId());
        return this.ajaxUpdateView(AppPaths.ADMIN_GROUP_ACCESS + "?groupId=" + actionForm.getGroupId());
    }
}

