/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.action.admin.manageusers;

import com.kwoksys.action.admin.manageusers.GroupDetailTemplate;
import com.kwoksys.action.common.template.HeaderTemplate;
import com.kwoksys.action.common.template.StandardTemplate;
import com.kwoksys.action.common.template.TableTemplate;
import com.kwoksys.action.common.template.TabsTemplate;
import com.kwoksys.biz.ServiceProvider;
import com.kwoksys.biz.admin.AdminService;
import com.kwoksys.biz.admin.core.AdminTabs;
import com.kwoksys.biz.admin.core.AdminUtils;
import com.kwoksys.biz.admin.dto.AccessGroup;
import com.kwoksys.biz.admin.dto.AccessUser;
import com.kwoksys.biz.system.core.AppPaths;
import com.kwoksys.biz.system.core.Image;
import com.kwoksys.biz.system.core.Links;
import com.kwoksys.framework.struts2.Action2;
import com.kwoksys.framework.ui.Link;
import java.util.ArrayList;
import java.util.List;

public class GroupDetailAction
extends Action2 {
    public String execute() throws Exception {
        AccessUser user = this.requestContext.getUser();
        Integer groupId = this.requestContext.getParameter("groupId");
        AdminService adminService = ServiceProvider.getAdminService(this.requestContext);
        AccessGroup group = adminService.getGroup(groupId);
        StandardTemplate standardTemplate = new StandardTemplate(this.requestContext);
        HeaderTemplate header = standardTemplate.getHeaderTemplate();
        header.setTitleKey("admin.groupDetail.header");
        if (user.hasPermission(AppPaths.ADMIN_GROUP_EDIT)) {
            header.addHeaderCmds(new Link(this.requestContext).setTitleKey("admin.groupEdit.title").setAjaxPath(AppPaths.ADMIN_GROUP_EDIT + "?groupId=" + group.getId()).setInlineImage(Image.getInstance().getUserGroupEditIcon()));
        }
        if (user.hasPermission(AppPaths.ADMIN_GROUP_DELETE)) {
            header.addHeaderCmds(new Link(this.requestContext).setTitleKey("admin.groupDelete.title").setAjaxPath(AppPaths.ADMIN_GROUP_DELETE + "?groupId=" + group.getId()).setInlineImage(Image.getInstance().getUserGroupDeleteIcon()));
        }
        header.addNavLink(Links.getAdminHomeLink(this.requestContext));
        if (user.hasPermission(AppPaths.ADMIN_GROUP_LIST)) {
            header.addNavLink(new Link(this.requestContext).setTitleKey("admin.index.groupList").setAjaxPath(AppPaths.ADMIN_GROUP_LIST));
        }
        standardTemplate.addTemplate(new GroupDetailTemplate(group));
        TabsTemplate tabs = standardTemplate.addTemplate(new TabsTemplate());
        tabs.setTabList(AdminTabs.createGroupTabs(this.requestContext, groupId));
        tabs.setTabActive("membersTab");
        TableTemplate tableTemplate = standardTemplate.addTemplate(new TableTemplate());
        tableTemplate.setColumnHeaders(AccessGroup.getGroupMembersColumnHeader());
        tableTemplate.setColumnTextKey("common.column.");
        tableTemplate.setStyle("tabBody");
        tableTemplate.setEmptyRowMsgKey("admin.groupMembers.emptyTableMessage");
        List<AccessUser> users = adminService.getGroupMembers(groupId);
        if (!users.isEmpty()) {
            for (AccessUser requestUser : users) {
                ArrayList<String> columns = new ArrayList<String>();
                columns.add(new Link(this.requestContext).setAjaxPath(AppPaths.ADMIN_USER_DETAIL + "?userId=" + requestUser.getId()).setTitle(AdminUtils.getSystemUsername(this.requestContext, requestUser)).getString());
                tableTemplate.addRow(columns);
            }
        }
        return standardTemplate.findTemplate("standard_autogen_template");
    }
}

