/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.action.admin.manageusers;

import com.kwoksys.action.common.template.DetailTableTemplate;
import com.kwoksys.biz.admin.dto.AccessGroup;
import com.kwoksys.biz.base.BaseTemplate;
import com.kwoksys.framework.ui.WidgetUtils;
import com.kwoksys.framework.util.HtmlUtils;

public class GroupDetailTemplate
extends BaseTemplate {
    private DetailTableTemplate detailTableTemplate = new DetailTableTemplate();
    private AccessGroup group;

    public GroupDetailTemplate(AccessGroup group) {
        super(GroupDetailTemplate.class);
        this.group = group;
    }

    @Override
    public void init() {
        this.addTemplate(this.detailTableTemplate);
    }

    @Override
    public void applyTemplate() {
        DetailTableTemplate.Td td = this.detailTableTemplate.newTd();
        td.setHeaderKey("common.column.group_id");
        td.setValue(String.valueOf(this.group.getId()));
        td = this.detailTableTemplate.newTd();
        td.setHeaderKey("common.column.group_name");
        td.setValue(HtmlUtils.encode(this.group.getName()));
        td = this.detailTableTemplate.newTd();
        td.setHeaderKey("common.column.group_description");
        td.setValue(HtmlUtils.formatMultiLineDisplay(this.group.getDescription()));
        td = this.detailTableTemplate.newTd();
        td.setHeaderKey("common.column.creator");
        td.setValue(WidgetUtils.formatCreatorInfo(this.requestContext, this.group.getCreationDate(), this.group.getCreator()));
        td = this.detailTableTemplate.newTd();
        td.setHeaderKey("common.column.modifier");
        td.setValue(WidgetUtils.formatCreatorInfo(this.requestContext, this.group.getModificationDate(), this.group.getModifier()));
    }

    @Override
    public String getJspPath() {
        return "/jsp/common/template/DetailTable.jsp";
    }
}

