/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.action.admin.manageusers;

import com.kwoksys.action.admin.manageusers.GroupForm;
import com.kwoksys.action.common.template.ActionErrorsTemplate;
import com.kwoksys.action.common.template.HeaderTemplate;
import com.kwoksys.action.common.template.StandardTemplate;
import com.kwoksys.biz.ServiceProvider;
import com.kwoksys.biz.admin.AdminService;
import com.kwoksys.biz.admin.core.AdminUtils;
import com.kwoksys.biz.admin.dto.AccessGroup;
import com.kwoksys.biz.admin.dto.AccessUser;
import com.kwoksys.biz.system.core.AppPaths;
import com.kwoksys.biz.system.core.Links;
import com.kwoksys.framework.struts2.Action2;
import com.kwoksys.framework.struts2.ActionMessages;
import com.kwoksys.framework.struts2.LabelValueBean;
import java.util.ArrayList;

public class GroupEditAction
extends Action2 {
    public String edit() throws Exception {
        GroupForm actionForm = this.getBaseForm(GroupForm.class);
        AdminService adminService = ServiceProvider.getAdminService(this.requestContext);
        AccessGroup group = adminService.getGroup(actionForm.getGroupId());
        if (!actionForm.isResubmit()) {
            actionForm.setGroup(group);
        }
        ArrayList<LabelValueBean> availableMembers = new ArrayList<LabelValueBean>();
        for (AccessUser accessUser : adminService.getAvailableMembers(group.getId())) {
            availableMembers.add(new LabelValueBean(AdminUtils.getSystemUsername(this.requestContext, accessUser), String.valueOf(accessUser.getId())));
        }
        ArrayList<LabelValueBean> selectedMembers = new ArrayList<LabelValueBean>();
        for (AccessUser selectedSubscriber : adminService.getGroupMembers(group.getId())) {
            selectedMembers.add(new LabelValueBean(AdminUtils.getSystemUsername(this.requestContext, selectedSubscriber), String.valueOf(selectedSubscriber.getId())));
        }
        StandardTemplate standardTemplate = new StandardTemplate(this.requestContext);
        standardTemplate.setPathAttribute("formAction", AppPaths.ADMIN_GROUP_EDIT_2);
        standardTemplate.setAttribute("formCancelLink", Links.getCancelLink(this.requestContext, AppPaths.ADMIN_GROUP_DETAIL + "?groupId=" + actionForm.getGroupId()).getString());
        this.request.setAttribute("availableMembersOptions", availableMembers);
        this.request.setAttribute("selectedMembersOptions", selectedMembers);
        HeaderTemplate header = standardTemplate.getHeaderTemplate();
        header.setTitleKey("admin.groupEdit.title");
        ActionErrorsTemplate errorsTemplate = standardTemplate.addTemplate(new ActionErrorsTemplate());
        errorsTemplate.setShowRequiredFieldMsg(true);
        errorsTemplate.setMessageKey("admin.groupEdit.sectionHeader");
        return standardTemplate.findTemplate("standard_template");
    }

    public String edit2() throws Exception {
        GroupForm actionForm = this.saveActionForm(new GroupForm());
        Integer groupId = this.requestContext.getParameter("groupId");
        AdminService adminService = ServiceProvider.getAdminService(this.requestContext);
        AccessGroup group = adminService.getGroup(groupId);
        group.setName(actionForm.getGroupName());
        group.setDescription(actionForm.getGroupDescription());
        group.setSelectedMembers(actionForm.getSelectedMembers());
        ActionMessages errors = adminService.updateGroup(group);
        if (!errors.isEmpty()) {
            this.saveActionErrors(errors);
            return this.ajaxUpdateView(AppPaths.ADMIN_GROUP_EDIT + "?groupId=" + group.getId() + "&" + "_error=true");
        }
        return this.ajaxUpdateView(AppPaths.ADMIN_GROUP_DETAIL + "?groupId=" + group.getId());
    }
}

