/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.action.admin.manageusers;

import com.kwoksys.action.common.template.HeaderTemplate;
import com.kwoksys.action.common.template.StandardTemplate;
import com.kwoksys.biz.ServiceProvider;
import com.kwoksys.biz.admin.AdminService;
import com.kwoksys.biz.admin.dto.AccessGroup;
import com.kwoksys.biz.admin.dto.AccessUser;
import com.kwoksys.biz.auth.core.Access;
import com.kwoksys.biz.system.core.AppPaths;
import com.kwoksys.biz.system.core.Image;
import com.kwoksys.biz.system.core.Links;
import com.kwoksys.framework.connections.database.QueryCriteria;
import com.kwoksys.framework.struts2.Action2;
import com.kwoksys.framework.ui.Link;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class GroupListAction
extends Action2 {
    public String execute() throws Exception {
        AccessUser user = this.requestContext.getUser();
        AdminService adminService = ServiceProvider.getAdminService(this.requestContext);
        QueryCriteria queryCriteria = new QueryCriteria();
        queryCriteria.addSortColumn("group_name");
        List<AccessGroup> groupDataset = adminService.getGroups(queryCriteria);
        ArrayList groups = new ArrayList();
        for (AccessGroup group : groupDataset) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("groupName", new Link(this.requestContext).setAjaxPath(AppPaths.ADMIN_GROUP_DETAIL + "?groupId=" + group.getId()).setTitle(group.getName()).getString());
            groups.add(map);
        }
        StandardTemplate standardTemplate = new StandardTemplate(this.requestContext);
        this.request.setAttribute("groups", groups);
        HeaderTemplate header = standardTemplate.getHeaderTemplate();
        header.setTitleKey("admin.groupList.title");
        if (Access.hasPermission(user, AppPaths.ADMIN_GROUP_ADD)) {
            Link link = new Link(this.requestContext);
            link.setAjaxPath(AppPaths.ADMIN_GROUP_ADD);
            link.setTitleKey("admin.groupAdd.title");
            link.setInlineImage(Image.getInstance().getUserGroupAddIcon());
            header.addHeaderCmds(link);
        }
        header.addNavLink(Links.getAdminHomeLink(this.requestContext));
        header.addNavLink(new Link(this.requestContext).setTitleKey("admin.index.groupList"));
        return standardTemplate.findTemplate("standard_template");
    }
}

