/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.action.admin.manageusers;

import com.kwoksys.action.admin.manageusers.UserSpecTemplate;
import com.kwoksys.action.common.template.ActionErrorsTemplate;
import com.kwoksys.action.common.template.HeaderTemplate;
import com.kwoksys.action.common.template.StandardTemplate;
import com.kwoksys.action.common.template.TabsTemplate;
import com.kwoksys.biz.ServiceProvider;
import com.kwoksys.biz.admin.AdminService;
import com.kwoksys.biz.admin.core.AdminTabs;
import com.kwoksys.biz.admin.core.AdminUtils;
import com.kwoksys.biz.admin.dao.AdminQueries;
import com.kwoksys.biz.admin.dto.AccessUser;
import com.kwoksys.biz.admin.dto.UserPermissionMap;
import com.kwoksys.biz.auth.core.Access;
import com.kwoksys.biz.system.core.AppPaths;
import com.kwoksys.biz.system.core.Links;
import com.kwoksys.framework.connections.database.QueryCriteria;
import com.kwoksys.framework.session.CacheManager;
import com.kwoksys.framework.struts2.Action2;
import com.kwoksys.framework.struts2.ActionMessages;
import com.kwoksys.framework.ui.Link;
import com.kwoksys.framework.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;

public class UserAccessAction
extends Action2 {
    public String execute() throws Exception {
        Link link;
        AccessUser user = this.requestContext.getUser();
        Integer reqUserId = this.requestContext.getParameter("userId");
        String cmd = this.requestContext.getParameterString("cmd");
        AdminService adminService = ServiceProvider.getAdminService(this.requestContext);
        AccessUser requestUser = ServiceProvider.getAdminService(this.requestContext).getUser(reqUserId);
        if (!cmd.equals("edit")) {
            cmd = "detail";
        }
        QueryCriteria queryCriteria = new QueryCriteria();
        queryCriteria.addSortColumn(AdminQueries.getOrderByColumn("order_num"));
        ArrayList accessList = new ArrayList();
        ArrayList<Integer> permissions = new ArrayList<Integer>();
        for (UserPermissionMap userperm : adminService.getUserAccess(queryCriteria, reqUserId)) {
            HashMap<String, Object> accessMap = new HashMap<String, Object>();
            accessMap.put("accessText", AdminUtils.getPermissionLabel(this.requestContext, userperm.getPermName()));
            if (cmd.equals("edit")) {
                String accessName = "formAccess_" + userperm.getPermId();
                accessMap.put(accessName, userperm.isHasPermission() ? 1 : 0);
                accessMap.put("accessName", accessName);
                accessMap.put("accessOptions", AdminUtils.getUserAccessOptionList());
                permissions.add(userperm.getPermId());
            } else {
                accessMap.put("accessValue", AdminUtils.getUserAccessIcon(userperm.isHasPermission()));
            }
            accessList.add(accessMap);
        }
        StandardTemplate standardTemplate = new StandardTemplate(this.requestContext);
        standardTemplate.setAttribute("cmd", cmd);
        standardTemplate.setAttribute("accessList", accessList);
        standardTemplate.setAttribute("permissionList", StringUtils.joinIntegers(permissions, ","));
        standardTemplate.setAttribute("accessOptions", AdminUtils.getUserAccessOptionList());
        standardTemplate.setPathAttribute("formAction", AppPaths.ADMIN_USER_ACCESS_EDIT_2 + "?userId=" + reqUserId);
        standardTemplate.setAttribute("formCancelLink", Links.getCancelLink(this.requestContext, AppPaths.ADMIN_USER_ACCESS + "?userId=" + reqUserId).getString());
        boolean formDisabled = AdminUtils.disableAccessEdit(requestUser);
        standardTemplate.setAttribute("formDisabled", formDisabled);
        standardTemplate.setAttribute("formButtonDisabled", formDisabled ? "disabled" : "");
        standardTemplate.addTemplate(new UserSpecTemplate(requestUser));
        TabsTemplate tabs = standardTemplate.addTemplate(new TabsTemplate());
        tabs.setTabList(AdminTabs.createUserTabs(this.requestContext, requestUser));
        tabs.setTabActive("accessTab");
        HeaderTemplate header = standardTemplate.getHeaderTemplate();
        if (Access.hasPermission(user, AppPaths.ADMIN_USER_ACCESS_EDIT)) {
            link = new Link(this.requestContext);
            link.setAjaxPath(AppPaths.ADMIN_USER_ACCESS + "?userId=" + reqUserId + "&cmd=edit");
            link.setTitleKey("admin.cmd.userAccessEdit");
            header.addHeaderCmds(link);
        }
        header.addNavLink(Links.getAdminHomeLink(this.requestContext));
        if (Access.hasPermission(user, AppPaths.ADMIN_USER_INDEX)) {
            link = new Link(this.requestContext);
            link.setAjaxPath(AppPaths.ADMIN_USER_INDEX);
            link.setTitleKey("admin.userIndex.userSearchTitle");
            header.addNavLink(link);
        }
        if (Access.hasPermission(user, AppPaths.ADMIN_USER_LIST)) {
            link = new Link(this.requestContext);
            link.setAjaxPath(AppPaths.ADMIN_USER_LIST);
            link.setTitleKey("admin.userList.title");
            header.addNavLink(link);
        }
        standardTemplate.addTemplate(new ActionErrorsTemplate());
        return standardTemplate.findTemplate("standard_template");
    }

    public String edit2() throws Exception {
        Integer reqUserId = this.requestContext.getParameter("userId");
        AdminService adminService = ServiceProvider.getAdminService(this.requestContext);
        AccessUser requestUser = adminService.getUser(reqUserId);
        ActionMessages errors = new ActionMessages();
        for (UserPermissionMap userperm : adminService.getUserAccess(new QueryCriteria(), requestUser.getId())) {
            userperm.setCmd(this.requestContext.getParameter("formAccess_" + userperm.getPermId()));
            errors = adminService.updateUserAccess(userperm);
        }
        if (!errors.isEmpty()) {
            this.saveActionErrors(errors);
            return this.ajaxUpdateView(AppPaths.ADMIN_USER_ACCESS + "?" + "_error=true" + "&userId=" + reqUserId + "&cmd=edit");
        }
        new CacheManager(this.requestContext).removeUserPermissionsCache(reqUserId);
        return this.ajaxUpdateView(AppPaths.ADMIN_USER_ACCESS + "?userId=" + reqUserId);
    }
}

