/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.action.admin.manageusers;

import com.kwoksys.action.admin.manageusers.UserSpecTemplate;
import com.kwoksys.action.common.template.CustomFieldsTemplate;
import com.kwoksys.action.common.template.DetailTableTemplate;
import com.kwoksys.action.common.template.HeaderTemplate;
import com.kwoksys.action.common.template.StandardTemplate;
import com.kwoksys.action.common.template.TabsTemplate;
import com.kwoksys.biz.ServiceProvider;
import com.kwoksys.biz.admin.core.AdminTabs;
import com.kwoksys.biz.admin.core.AdminUtils;
import com.kwoksys.biz.admin.dto.AccessUser;
import com.kwoksys.biz.auth.core.Access;
import com.kwoksys.biz.contacts.ContactService;
import com.kwoksys.biz.contacts.dto.Contact;
import com.kwoksys.biz.system.core.AppPaths;
import com.kwoksys.biz.system.core.Image;
import com.kwoksys.biz.system.core.Links;
import com.kwoksys.biz.system.core.ObjectTypes;
import com.kwoksys.framework.struts2.Action2;
import com.kwoksys.framework.ui.Link;

public class UserDetailAction
extends Action2 {
    public String execute() throws Exception {
        Link link;
        AccessUser accessUser = this.requestContext.getUser();
        Integer reqUserId = this.requestContext.getParameter("userId");
        AccessUser requestUser = ServiceProvider.getAdminService(this.requestContext).getUser(reqUserId);
        ContactService contactService = ServiceProvider.getContactService(this.requestContext);
        Contact contact = contactService.getOptionalContact(requestUser.getContactId());
        StandardTemplate standardTemplate = new StandardTemplate(this.requestContext);
        DetailTableTemplate detailTableTemplate = standardTemplate.addTemplate(AdminUtils.formatUserContact(contact, this.requestContext, true));
        detailTableTemplate.setPrefix("_contact");
        standardTemplate.addTemplate(new UserSpecTemplate(requestUser));
        TabsTemplate tabs = standardTemplate.addTemplate(new TabsTemplate());
        tabs.setTabList(AdminTabs.createUserTabs(this.requestContext, requestUser));
        tabs.setTabActive("contactTab");
        HeaderTemplate header = standardTemplate.getHeaderTemplate();
        header.setPageTitleKey("admin.userDetail.title", new Object[]{requestUser.getId()});
        if (Access.hasPermission(accessUser, AppPaths.ADMIN_USER_EDIT)) {
            link = new Link(this.requestContext);
            link.setAjaxPath(AppPaths.ADMIN_USER_EDIT + "?userId=" + requestUser.getId());
            link.setTitleKey("admin.cmd.userEdit");
            link.setInlineImage(Image.getInstance().getUserEditIcon());
            header.addHeaderCmds(link);
        }
        if (Access.hasPermission(accessUser, AppPaths.ADMIN_USER_PASSWORD_RESET)) {
            link = new Link(this.requestContext);
            link.setAjaxPath(AppPaths.ADMIN_USER_PASSWORD_RESET + "?userId=" + requestUser.getId());
            link.setTitleKey("admin.cmd.userPasswordReset");
            header.addHeaderCmds(link);
        }
        if (Access.hasPermission(accessUser, AppPaths.ADMIN_USER_LOGOUT)) {
            link = new Link(this.requestContext).setInlineImage(Image.getInstance().getUserLogoutIcon()).setTitleKey("admin.cmd.userLogout");
            if (accessUser.getId().equals(requestUser.getId())) {
                link.setImgAltKey("admin.user.selfLogout");
            } else if (!requestUser.isLoggedOn(this.requestContext)) {
                link.setImgAltKey("admin.user.notLoggedIn");
            } else {
                link.setAjaxPath(AppPaths.ADMIN_USER_LOGOUT + "?userId=" + requestUser.getId());
            }
            header.addHeaderCmds(link);
        }
        if (Access.hasPermission(accessUser, AppPaths.ADMIN_USER_DELETE)) {
            link = new Link(this.requestContext).setInlineImage(Image.getInstance().getUserDeleteIcon());
            if (requestUser.isDefaultUser() || accessUser.getId().equals(requestUser.getId())) {
                link.setImgAltKey("admin.userDelete.cmdWarning");
            } else {
                link.setAjaxPath(AppPaths.ADMIN_USER_DELETE + "?userId=" + requestUser.getId());
            }
            link.setTitleKey("admin.userDelete.title");
            header.addHeaderCmds(link);
        }
        header.addNavLink(Links.getAdminHomeLink(this.requestContext));
        if (Access.hasPermission(accessUser, AppPaths.ADMIN_USER_INDEX)) {
            link = new Link(this.requestContext);
            link.setAjaxPath(AppPaths.ADMIN_USER_INDEX);
            link.setTitleKey("admin.userIndex.userSearchTitle");
            header.addNavLink(link);
        }
        if (Access.hasPermission(accessUser, AppPaths.ADMIN_USER_LIST)) {
            link = new Link(this.requestContext);
            link.setAjaxPath(AppPaths.ADMIN_USER_LIST);
            link.setTitleKey("admin.userList.title");
            header.addNavLink(link);
        }
        CustomFieldsTemplate customFieldsTemplate = standardTemplate.addTemplate(new CustomFieldsTemplate());
        customFieldsTemplate.setObjectTypeId(ObjectTypes.USER);
        customFieldsTemplate.setObjectId(reqUserId);
        customFieldsTemplate.setShowDefaultHeader(false);
        return standardTemplate.findTemplate("standard_template");
    }
}

