/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.action.admin.manageusers;

import com.kwoksys.action.admin.manageusers.UserSpecTemplate;
import com.kwoksys.action.common.template.HeaderTemplate;
import com.kwoksys.action.common.template.StandardTemplate;
import com.kwoksys.action.common.template.TableTemplate;
import com.kwoksys.action.common.template.TabsTemplate;
import com.kwoksys.biz.ServiceProvider;
import com.kwoksys.biz.admin.core.AdminTabs;
import com.kwoksys.biz.admin.dto.AccessUser;
import com.kwoksys.biz.auth.core.Access;
import com.kwoksys.biz.hardware.HardwareService;
import com.kwoksys.biz.hardware.core.HardwareSearch;
import com.kwoksys.biz.hardware.core.HardwareUtils;
import com.kwoksys.biz.hardware.dao.HardwareQueries;
import com.kwoksys.biz.hardware.dto.Hardware;
import com.kwoksys.biz.system.core.AppPaths;
import com.kwoksys.biz.system.core.Links;
import com.kwoksys.framework.connections.database.QueryCriteria;
import com.kwoksys.framework.data.Counter;
import com.kwoksys.framework.data.DataRow;
import com.kwoksys.framework.session.SessionManager;
import com.kwoksys.framework.struts2.Action2;
import com.kwoksys.framework.ui.Link;
import java.util.ArrayList;
import java.util.List;

public class UserHardwareAction
extends Action2 {
    public String execute() throws Exception {
        Link link;
        AccessUser user = this.requestContext.getUser();
        Integer reqUserId = this.requestContext.getParameter("userId");
        String orderBy = SessionManager.getOrSetAttribute(this.requestContext, "orderBy", "HARDWARE_ORDER_BY", "hardware_name");
        String order = SessionManager.getOrSetAttribute(this.requestContext, "order", "HARDWARE_ORDER", "asc");
        AccessUser requestUser = ServiceProvider.getAdminService(this.requestContext).getUser(reqUserId);
        HardwareSearch hardwareSearch = new HardwareSearch();
        hardwareSearch.put("hardwareOwnerId", requestUser.getId());
        QueryCriteria queryCriteria = new QueryCriteria(hardwareSearch);
        if (HardwareUtils.isSortableColumn(orderBy)) {
            queryCriteria.addSortColumn(HardwareQueries.getOrderByColumn(orderBy), order);
        }
        HardwareService hardwareService = ServiceProvider.getHardwareService(this.requestContext);
        List<Hardware> hardwareList = hardwareService.getHardwareList(queryCriteria);
        ArrayList<String> columnHeaders = new ArrayList<String>(HardwareUtils.getColumnHeaderList());
        columnHeaders.remove("hardware_owner_name");
        List<DataRow> dataList = HardwareUtils.formatHardwareList(this.requestContext, hardwareList, columnHeaders, new Counter(), AppPaths.HARDWARE_DETAIL);
        StandardTemplate standardTemplate = new StandardTemplate(this.requestContext);
        standardTemplate.setPathAttribute("ajaxHardwareDetailPath", AppPaths.IT_MGMT_AJAX_GET_HARDWARE_DETAIL + "?hardwareId=");
        standardTemplate.addTemplate(new UserSpecTemplate(requestUser));
        TabsTemplate tabs = standardTemplate.addTemplate(new TabsTemplate());
        tabs.setTabList(AdminTabs.createUserTabs(this.requestContext, requestUser));
        tabs.setTabActive("hardwareTab");
        TableTemplate tableTemplate = standardTemplate.addTemplate(new TableTemplate());
        tableTemplate.setDataList(dataList);
        tableTemplate.setColumnHeaders(columnHeaders);
        tableTemplate.setSortableColumnHeaders(HardwareUtils.getSortableColumns());
        tableTemplate.setColumnPath(AppPaths.ADMIN_USER_HARDWARE + "?userId=" + reqUserId);
        tableTemplate.setColumnTextKey("common.column.");
        tableTemplate.setOrderBy(orderBy);
        tableTemplate.setOrder(order);
        tableTemplate.setEmptyRowMsgKey("itMgmt.hardwareList.emptyTableMessage");
        HeaderTemplate header = standardTemplate.getHeaderTemplate();
        header.addNavLink(Links.getAdminHomeLink(this.requestContext));
        if (Access.hasPermission(user, AppPaths.ADMIN_USER_INDEX)) {
            link = new Link(this.requestContext);
            link.setAjaxPath(AppPaths.ADMIN_USER_INDEX);
            link.setTitleKey("admin.userIndex.userSearchTitle");
            header.addNavLink(link);
        }
        if (Access.hasPermission(user, AppPaths.ADMIN_USER_LIST)) {
            link = new Link(this.requestContext);
            link.setAjaxPath(AppPaths.ADMIN_USER_LIST);
            link.setTitleKey("admin.userList.title");
            header.addNavLink(link);
        }
        return standardTemplate.findTemplate("standard_template");
    }
}

