/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.action.admin.manageusers;

import com.kwoksys.action.admin.manageusers.UserSearchForm;
import com.kwoksys.action.common.template.HeaderTemplate;
import com.kwoksys.action.common.template.RecordsNavigationTemplate;
import com.kwoksys.action.common.template.StandardTemplate;
import com.kwoksys.action.common.template.TableTemplate;
import com.kwoksys.biz.ServiceProvider;
import com.kwoksys.biz.admin.AdminService;
import com.kwoksys.biz.admin.core.AdminUtils;
import com.kwoksys.biz.admin.core.UserSearch;
import com.kwoksys.biz.admin.dao.AdminQueries;
import com.kwoksys.biz.admin.dto.AccessUser;
import com.kwoksys.biz.auth.core.Access;
import com.kwoksys.biz.system.core.AppPaths;
import com.kwoksys.biz.system.core.AttributeFieldIds;
import com.kwoksys.biz.system.core.AttributeManager;
import com.kwoksys.biz.system.core.Attributes;
import com.kwoksys.biz.system.core.Image;
import com.kwoksys.biz.system.core.Links;
import com.kwoksys.biz.system.core.configs.ConfigManager;
import com.kwoksys.framework.connections.database.QueryCriteria;
import com.kwoksys.framework.data.Counter;
import com.kwoksys.framework.properties.Localizer;
import com.kwoksys.framework.session.SessionManager;
import com.kwoksys.framework.struts2.Action2;
import com.kwoksys.framework.struts2.LabelValueBean;
import com.kwoksys.framework.ui.Link;
import com.kwoksys.framework.util.HtmlUtils;
import jakarta.servlet.http.HttpSession;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class UserListAction
extends Action2 {
    public String execute() throws Exception {
        Link link;
        UserSearchForm actionForm = this.getSessionBaseForm(UserSearchForm.class);
        AccessUser user = this.requestContext.getUser();
        String cmd = this.requestContext.getParameterString("cmd");
        String rowCmd = this.requestContext.getParameterString("rowCmd");
        String orderBy = SessionManager.getOrSetAttribute(this.requestContext, "orderBy", "USERS_ORDER_BY", "username");
        String order = SessionManager.getOrSetAttribute(this.requestContext, "order", "USERS_ORDER", "asc");
        int rowStart = 0;
        if (!cmd.isEmpty() || rowCmd.equals("showAll")) {
            this.request.getSession().setAttribute("USERS_ROW_START", (Object)rowStart);
        } else {
            rowStart = SessionManager.getOrSetAttribute(this.requestContext, "rowStart", "USERS_ROW_START", rowStart);
        }
        int rowLimit = this.requestContext.getParameter("rowLimit", ConfigManager.app.getUserRows());
        if (rowCmd.equals("showAll")) {
            rowLimit = 0;
        }
        HttpSession session = this.request.getSession();
        UserSearch userSearch = new UserSearch();
        if (!cmd.isEmpty()) {
            if (cmd.equals("search")) {
                userSearch.prepareMap(actionForm, this.requestContext);
            } else if (cmd.equals("showEnabled")) {
                userSearch.put("userStatus", AttributeFieldIds.USER_STATUS_ENABLED);
            } else if (cmd.equals("showDisabled")) {
                userSearch.put("userStatus", AttributeFieldIds.USER_STATUS_DISABLED);
            } else if (cmd.equals("showLoggedIn")) {
                userSearch.put("loggedInUsers", "");
            }
            userSearch.put("cmd", cmd);
            session.setAttribute("USER_SEARCH_CRITERIA_MAP", userSearch.getSearchCriteriaMap());
        } else if (session.getAttribute("USER_SEARCH_CRITERIA_MAP") != null) {
            userSearch.setSearchCriteriaMap((Map)session.getAttribute("USER_SEARCH_CRITERIA_MAP"));
        }
        QueryCriteria queryCriteria = new QueryCriteria(userSearch);
        queryCriteria.setLimit(rowLimit, rowStart);
        if (AdminUtils.isSortableUserColumn(orderBy)) {
            queryCriteria.addSortColumn(AdminQueries.getOrderByColumn(orderBy), order);
        }
        List<String> columnHeaders = AdminUtils.getUserColumnHeaders();
        AdminService adminService = ServiceProvider.getAdminService(this.requestContext);
        AttributeManager attributeManager = new AttributeManager(this.requestContext);
        ArrayList<LabelValueBean> filterOptions = new ArrayList<LabelValueBean>();
        filterOptions.add(new LabelValueBean(Localizer.getText(this.requestContext, "admin.config.users.all"), "showAll"));
        filterOptions.add(new LabelValueBean(Localizer.getText(this.requestContext, "admin.config.users.enabled"), "showEnabled"));
        filterOptions.add(new LabelValueBean(Localizer.getText(this.requestContext, "admin.config.users.disabled"), "showDisabled"));
        filterOptions.add(new LabelValueBean(Localizer.getText(this.requestContext, "admin.config.users.loggedIn"), "showLoggedIn"));
        StandardTemplate standardTemplate = new StandardTemplate(this.requestContext);
        standardTemplate.setPathAttribute("formAction", AppPaths.ADMIN_USER_LIST);
        standardTemplate.setAttribute("filterOptions", filterOptions);
        HeaderTemplate header = standardTemplate.getHeaderTemplate();
        header.setTitleKey("admin.userList.title");
        header.setTitleClassNoLine();
        if (Access.hasPermission(user, AppPaths.ADMIN_USER_ADD)) {
            link = new Link(this.requestContext);
            link.setAjaxPath(AppPaths.ADMIN_USER_ADD);
            link.setTitleKey("admin.userAdd.title");
            link.setInlineImage(Image.getInstance().getUserAddIcon());
            header.addHeaderCmds(link);
        }
        if (Access.hasPermission(user, AppPaths.ADMIN_USER_LIST_EXPORT)) {
            link = new Link(this.requestContext);
            link.setExportPath(AppPaths.ADMIN_USER_LIST_EXPORT + "?rowCmd=" + rowCmd + "&rowStart=" + rowStart + "&rowLimit" + rowLimit);
            link.setTitleKey("admin.cmd.userListExport");
            link.setInlineImage(Image.getInstance().getFileCsvIcon());
            header.addHeaderCmds(link);
        }
        header.addNavLink(Links.getAdminHomeLink(this.requestContext));
        if (Access.hasPermission(user, AppPaths.ADMIN_USER_INDEX)) {
            link = new Link(this.requestContext);
            link.setAjaxPath(AppPaths.ADMIN_USER_INDEX);
            link.setTitleKey("admin.userIndex.userSearchTitle");
            header.addNavLink(link);
        }
        TableTemplate tableTemplate = standardTemplate.addTemplate(new TableTemplate());
        tableTemplate.setColumnHeaders(columnHeaders);
        tableTemplate.setSortableColumnHeaders(AdminUtils.getSortableUserColumns());
        tableTemplate.setColumnPath(AppPaths.ADMIN_USER_LIST);
        tableTemplate.setColumnTextKey("common.column.");
        tableTemplate.setRowCmd(rowCmd);
        tableTemplate.setOrderBy(orderBy);
        tableTemplate.setOrder(order);
        tableTemplate.setEmptyRowMsgKey("admin.userList.emptyTableMessage");
        List<AccessUser> userDataset = adminService.getUsers(queryCriteria);
        if (!userDataset.isEmpty()) {
            Counter counter = new Counter(rowStart);
            for (AccessUser appUser : userDataset) {
                ArrayList<String> columns = new ArrayList<String>();
                for (String column : columnHeaders) {
                    if (column.equals("rownum")) {
                        columns.add(counter.incr() + ".");
                        continue;
                    }
                    if (column.equals("username")) {
                        columns.add(new Link(this.requestContext).setAjaxPath(AppPaths.ADMIN_USER_DETAIL + "?userId=" + appUser.getId()).setTitle(appUser.getUsername()).getString());
                        continue;
                    }
                    if (column.equals("user_status")) {
                        columns.add(attributeManager.getAttrFieldNameCache(Attributes.USER_STATUS_TYPE, appUser.getStatus()));
                        continue;
                    }
                    if (column.equals("user_first_name")) {
                        columns.add(HtmlUtils.encode(appUser.getFirstName()));
                        continue;
                    }
                    if (column.equals("user_last_name")) {
                        columns.add(HtmlUtils.encode(appUser.getLastName()));
                        continue;
                    }
                    if (column.equals("user_display_name")) {
                        columns.add(HtmlUtils.encode(appUser.getDisplayName()));
                        continue;
                    }
                    if (!column.equals("user_email")) continue;
                    columns.add(HtmlUtils.encode(appUser.getEmail()));
                }
                tableTemplate.addRow(columns);
            }
        }
        int rowCount = adminService.getUserCount(queryCriteria);
        Object[] args = new Object[]{rowCount};
        RecordsNavigationTemplate nav = standardTemplate.addTemplate(new RecordsNavigationTemplate());
        nav.setRowOffset(rowStart);
        nav.setRowLimit(rowLimit);
        nav.setRowCount(rowCount);
        nav.setRowCountMsgkey("core.template.recordsNav.rownum");
        nav.setShowAllRecordsText(Localizer.getText(this.requestContext, "admin.userList.rowCount", args));
        nav.setShowAllRecordsPath(AppPaths.ADMIN_USER_LIST + "?rowCmd=showAll");
        nav.setPath(AppPaths.ADMIN_USER_LIST + "?rowStart=");
        return standardTemplate.findTemplate("standard_template");
    }
}

