/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.action.admin.manageusers;

import com.kwoksys.biz.ServiceProvider;
import com.kwoksys.biz.admin.AdminService;
import com.kwoksys.biz.admin.core.AdminUtils;
import com.kwoksys.biz.admin.core.UserSearch;
import com.kwoksys.biz.admin.dao.AdminQueries;
import com.kwoksys.biz.admin.dto.AccessUser;
import com.kwoksys.biz.reports.writers.CsvReportWriter;
import com.kwoksys.biz.system.core.AttributeManager;
import com.kwoksys.biz.system.core.Attributes;
import com.kwoksys.biz.system.core.configs.ConfigManager;
import com.kwoksys.framework.connections.database.QueryCriteria;
import com.kwoksys.framework.http.ResponseContext;
import com.kwoksys.framework.properties.Localizer;
import com.kwoksys.framework.session.SessionManager;
import com.kwoksys.framework.struts2.Action2;
import jakarta.servlet.http.HttpSession;
import java.util.ArrayList;
import java.util.Map;

public class UserListExportAction
extends Action2 {
    public String execute() throws Exception {
        String rowCmd = this.requestContext.getParameterString("rowCmd");
        int rowStart = this.requestContext.getParameter("rowStart", 0);
        int rowLimit = this.requestContext.getParameter("rowLimit", ConfigManager.app.getUserRows());
        HttpSession session = this.request.getSession();
        ResponseContext responseContext = new ResponseContext(this.response);
        responseContext.setAttachementName(Localizer.getText(this.requestContext, "admin.userListExport.filename"));
        CsvReportWriter csvReportWriter = new CsvReportWriter();
        csvReportWriter.init(responseContext);
        String[] columnsKeys = new String[]{"username", "user_first_name", "user_last_name", "user_display_name", "user_email", "user_status", "user_last_logon", "user_last_visit"};
        ArrayList<String> columnHeaders = new ArrayList<String>();
        for (String column : columnsKeys) {
            columnHeaders.add(Localizer.getText(this.requestContext, "common.column." + column));
        }
        csvReportWriter.addHeaderRow(columnHeaders);
        UserSearch userSearch = new UserSearch();
        if (session.getAttribute("USER_SEARCH_CRITERIA_MAP") != null) {
            userSearch.setSearchCriteriaMap((Map)session.getAttribute("USER_SEARCH_CRITERIA_MAP"));
        }
        String orderBy = SessionManager.getAttribute(this.request, "USERS_ORDER_BY", "username");
        String order = SessionManager.getAttribute(this.request, "USERS_ORDER", "asc");
        QueryCriteria queryCriteria = new QueryCriteria(userSearch);
        if (AdminUtils.isSortableUserColumn(orderBy)) {
            queryCriteria.addSortColumn(AdminQueries.getOrderByColumn(orderBy), order);
        }
        if (!rowCmd.equals("showAll")) {
            queryCriteria.setLimit(rowLimit, rowStart);
        }
        AdminService adminService = ServiceProvider.getAdminService(this.requestContext);
        AttributeManager attributeManager = new AttributeManager(this.requestContext);
        for (AccessUser user : adminService.getExtendedUsers(queryCriteria)) {
            ArrayList<String> columns = new ArrayList<String>();
            for (String column : columnsKeys) {
                if (column.equals("username")) {
                    columns.add(user.getUsername());
                    continue;
                }
                if (column.equals("user_first_name")) {
                    columns.add(user.getFirstName());
                    continue;
                }
                if (column.equals("user_last_name")) {
                    columns.add(user.getLastName());
                    continue;
                }
                if (column.equals("user_display_name")) {
                    columns.add(user.getDisplayName());
                    continue;
                }
                if (column.equals("user_email")) {
                    columns.add(user.getEmail());
                    continue;
                }
                if (column.equals("user_status")) {
                    columns.add(attributeManager.getAttrFieldNameCache(Attributes.USER_STATUS_TYPE, user.getStatus()));
                    continue;
                }
                if (column.equals("user_last_logon")) {
                    columns.add(user.getLastLogonTime());
                    continue;
                }
                if (!column.equals("user_last_visit")) continue;
                columns.add(user.getFormattedLastVisitTime());
            }
            csvReportWriter.addRow(columns);
        }
        return csvReportWriter.close();
    }
}

