/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.action.admin.manageusers;

import com.kwoksys.action.common.template.DetailTableTemplate;
import com.kwoksys.biz.admin.dto.AccessUser;
import com.kwoksys.biz.auth.core.Access;
import com.kwoksys.biz.base.BaseTemplate;
import com.kwoksys.biz.system.core.AppPaths;
import com.kwoksys.biz.system.core.AttributeManager;
import com.kwoksys.biz.system.core.Attributes;
import com.kwoksys.biz.system.core.Image;
import com.kwoksys.framework.ui.Link;
import com.kwoksys.framework.ui.WidgetUtils;
import com.kwoksys.framework.util.HtmlUtils;

public class UserSpecTemplate
extends BaseTemplate {
    private AccessUser recordUser;
    private DetailTableTemplate detailTableTemplate = new DetailTableTemplate();

    public UserSpecTemplate(AccessUser recordUser) {
        super(UserSpecTemplate.class);
        this.recordUser = recordUser;
    }

    @Override
    public void init() {
        this.addTemplate(this.detailTableTemplate);
    }

    @Override
    public void applyTemplate() throws Exception {
        AccessUser accessUser = this.requestContext.getUser();
        AttributeManager attributeManager = new AttributeManager(this.requestContext);
        this.detailTableTemplate.setNumColumns(2);
        DetailTableTemplate.Td td = this.detailTableTemplate.newTd();
        td.setHeaderKey("common.column.user_id");
        td.setValue(String.valueOf(this.recordUser.getId()));
        td = this.detailTableTemplate.newTd();
        td.setHeaderKey("common.column.username");
        td.setValue(HtmlUtils.encode(this.recordUser.getUsername()));
        td = this.detailTableTemplate.newTd();
        td.setHeaderKey("common.column.user_first_name");
        td.setValue(HtmlUtils.encode(this.recordUser.getFirstName()));
        td = this.detailTableTemplate.newTd();
        td.setHeaderKey("common.column.user_last_name");
        td.setValue(HtmlUtils.encode(this.recordUser.getLastName()));
        td = this.detailTableTemplate.newTd();
        td.setHeaderKey("common.column.user_display_name");
        td.setValue(HtmlUtils.encode(this.recordUser.getDisplayName()));
        td = this.detailTableTemplate.newTd();
        td.setHeaderKey("common.column.user_email");
        td.setValue(HtmlUtils.formatMailtoLink(this.recordUser.getEmail()));
        td = this.detailTableTemplate.newTd();
        td.setHeaderKey("common.column.user_status");
        td.setValue(attributeManager.getAttrFieldNameCache(Attributes.USER_STATUS_TYPE, this.recordUser.getStatus()));
        td = this.detailTableTemplate.newTd();
        td.setHeaderKey("common.column.user_group");
        Link link = new Link(this.requestContext);
        if (this.recordUser.getGroupId() != 0) {
            link.setInlineImage(Image.getInstance().getUserGroupIcon());
            link.setTitle(this.recordUser.getGroupName());
            if (Access.hasPermission(accessUser, AppPaths.ADMIN_GROUP_DETAIL)) {
                link.setAjaxPath(AppPaths.ADMIN_GROUP_DETAIL + "?groupId=" + this.recordUser.getGroupId());
            }
        }
        td.setValue(link.getString());
        td = this.detailTableTemplate.newTd();
        td.setHeaderKey("common.column.user_last_logon");
        td.setValue(this.recordUser.getLastLogonTime());
        td = this.detailTableTemplate.newTd();
        td.setHeaderKey("common.column.user_last_visit");
        td.setValue(this.recordUser.getFormattedLastVisitTime());
        td = this.detailTableTemplate.newTd();
        td.setHeaderKey("common.column.creator");
        td.setValue(WidgetUtils.formatCreatorInfo(this.requestContext, this.recordUser.getCreationDate(), this.recordUser.getCreator()));
        td = this.detailTableTemplate.newTd();
        td.setHeaderKey("common.column.modifier");
        td.setValue(WidgetUtils.formatCreatorInfo(this.requestContext, this.recordUser.getModificationDate(), this.recordUser.getModifier()));
    }

    @Override
    public String getJspPath() {
        return "/jsp/admin/manageusers/UserSpecTemplate.jsp";
    }
}

