/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.action.blogs;

import com.kwoksys.action.blogs.CategoryForm;
import com.kwoksys.action.common.template.ActionErrorsTemplate;
import com.kwoksys.action.common.template.HeaderTemplate;
import com.kwoksys.action.common.template.StandardTemplate;
import com.kwoksys.action.common.template.TableTemplate;
import com.kwoksys.biz.ServiceProvider;
import com.kwoksys.biz.admin.dto.AccessUser;
import com.kwoksys.biz.blogs.BlogService;
import com.kwoksys.biz.blogs.core.BlogUtils;
import com.kwoksys.biz.blogs.dao.BlogQueries;
import com.kwoksys.biz.blogs.dto.BlogCategory;
import com.kwoksys.biz.system.core.AppPaths;
import com.kwoksys.biz.system.core.Links;
import com.kwoksys.biz.system.dto.Category;
import com.kwoksys.framework.connections.database.QueryCriteria;
import com.kwoksys.framework.data.Counter;
import com.kwoksys.framework.struts2.Action2;
import com.kwoksys.framework.struts2.ActionMessages;
import com.kwoksys.framework.ui.Link;
import com.kwoksys.framework.util.HtmlUtils;
import java.util.ArrayList;
import java.util.List;

public class CategoryAction
extends Action2 {
    public String list() throws Exception {
        AccessUser user = this.requestContext.getUser();
        List<String> columnHeaders = BlogUtils.getCategoryColumnHeaderList();
        QueryCriteria queryCriteria = new QueryCriteria();
        if (BlogUtils.isSortableCategoryColumn("category_name")) {
            queryCriteria.addSortColumn(BlogQueries.getOrderByColumn("category_name"));
        }
        BlogService blogService = ServiceProvider.getBlogService(this.requestContext);
        List<Category> categoryDataset = blogService.getCategories(queryCriteria);
        StandardTemplate standardTemplate = new StandardTemplate(this.requestContext);
        HeaderTemplate header = standardTemplate.getHeaderTemplate();
        header.setTitleKey("blogs.categoryList.header");
        header.setTitleClassNoLine();
        if (user.hasPermission(AppPaths.BLOG_CATEGORY_ADD)) {
            header.addHeaderCmds(new Link(this.requestContext).setAjaxPath(AppPaths.BLOG_CATEGORY_ADD).setTitleKey("blogs.categoryAdd.header"));
        }
        TableTemplate tableTemplate = standardTemplate.addTemplate(new TableTemplate());
        tableTemplate.setColumnHeaders(columnHeaders);
        tableTemplate.setColumnPath(AppPaths.BLOG_CATEGORY_LIST);
        tableTemplate.setColumnTextKey("common.column.");
        if (!categoryDataset.isEmpty()) {
            boolean canEditCategory = user.hasPermission(AppPaths.BLOG_CATEGORY_EDIT);
            Counter counter = new Counter();
            for (Category category : categoryDataset) {
                ArrayList<String> columns = new ArrayList<String>();
                for (String column : columnHeaders) {
                    if (column.equals("category_name")) {
                        columns.add(HtmlUtils.encode(category.getName()));
                        continue;
                    }
                    if (column.equals("category_description")) {
                        columns.add(HtmlUtils.formatMultiLineDisplay(category.getDescription()));
                        continue;
                    }
                    if (column.equals("post_object_count")) {
                        columns.add(String.valueOf(category.getCountObjects()));
                        continue;
                    }
                    if (column.equals("category_actions")) {
                        if (canEditCategory) {
                            columns.add(new Link(this.requestContext).setAjaxPath(AppPaths.BLOG_CATEGORY_EDIT + "?categoryId=" + category.getId()).setTitleKey("common.action.Edit").getString());
                            continue;
                        }
                        columns.add("");
                        continue;
                    }
                    if (!column.equals("rownum")) continue;
                    columns.add(counter.incr() + ".");
                }
                tableTemplate.addRow(columns);
            }
        }
        return standardTemplate.findTemplate("standard_autogen_template");
    }

    public String add() throws Exception {
        Category category = new Category();
        CategoryForm actionForm = this.getBaseForm(CategoryForm.class);
        actionForm.setId("blogCategoryAddForm");
        if (!actionForm.isResubmit()) {
            actionForm.setCategory(category);
        }
        StandardTemplate standardTemplate = new StandardTemplate(this.requestContext);
        standardTemplate.setPathAttribute("formAction", AppPaths.BLOG_CATEGORY_ADD_2);
        standardTemplate.setAttribute("formCancelLink", Links.getCancelLink(this.requestContext, AppPaths.BLOG_CATEGORY_LIST).getString());
        HeaderTemplate headerTemplate = standardTemplate.getHeaderTemplate();
        headerTemplate.setTitleKey("blogs.categoryAdd.header");
        ActionErrorsTemplate errorsTemplate = standardTemplate.addTemplate(new ActionErrorsTemplate());
        errorsTemplate.setShowRequiredFieldMsg(true);
        return standardTemplate.findTemplate("standard_template");
    }

    public String add2() throws Exception {
        CategoryForm actionForm = this.saveActionForm(new CategoryForm());
        BlogCategory category = new BlogCategory();
        category.setName(actionForm.getCategoryName());
        BlogService blogService = ServiceProvider.getBlogService(this.requestContext);
        ActionMessages errors = blogService.addCategory(category);
        if (!errors.isEmpty()) {
            this.saveActionErrors(errors);
            return this.ajaxUpdateView(AppPaths.BLOG_CATEGORY_ADD + "?" + "_error=true");
        }
        return this.ajaxUpdateView(AppPaths.BLOG_CATEGORY_LIST);
    }

    public String edit() throws Exception {
        CategoryForm actionForm = this.getBaseForm(CategoryForm.class);
        actionForm.setId("blogCategoryEditForm");
        BlogService blogService = ServiceProvider.getBlogService(this.requestContext);
        Category category = blogService.getCategory(actionForm.getCategoryId());
        if (!actionForm.isResubmit()) {
            actionForm.setCategory(category);
        }
        StandardTemplate standardTemplate = new StandardTemplate(this.requestContext);
        standardTemplate.setPathAttribute("formAction", AppPaths.BLOG_CATEGORY_EDIT_2);
        standardTemplate.setAttribute("formCancelLink", Links.getCancelLink(this.requestContext, AppPaths.BLOG_CATEGORY_LIST).getString());
        HeaderTemplate headerTemplate = standardTemplate.getHeaderTemplate();
        headerTemplate.setTitleKey("blogs.categoryEdit.header");
        ActionErrorsTemplate errorsTemplate = standardTemplate.addTemplate(new ActionErrorsTemplate());
        errorsTemplate.setShowRequiredFieldMsg(true);
        return standardTemplate.findTemplate("standard_template");
    }

    public String edit2() throws Exception {
        CategoryForm actionForm = this.saveActionForm(new CategoryForm());
        BlogService blogService = ServiceProvider.getBlogService(this.requestContext);
        Category category = blogService.getCategory(actionForm.getCategoryId());
        category.setName(actionForm.getCategoryName());
        ActionMessages errors = blogService.updateCategory(category);
        if (!errors.isEmpty()) {
            this.saveActionErrors(errors);
            return this.ajaxUpdateView(AppPaths.BLOG_CATEGORY_EDIT + "?categoryId=" + actionForm.getCategoryId() + "&" + "_error=true");
        }
        return this.ajaxUpdateView(AppPaths.BLOG_CATEGORY_LIST);
    }
}

