/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.action.blogs;

import com.kwoksys.action.blogs.PostSearchForm;
import com.kwoksys.action.common.template.HeaderTemplate;
import com.kwoksys.action.common.template.StandardTemplate;
import com.kwoksys.biz.ServiceProvider;
import com.kwoksys.biz.admin.dto.AccessUser;
import com.kwoksys.biz.blogs.BlogService;
import com.kwoksys.biz.blogs.dao.BlogQueries;
import com.kwoksys.biz.system.core.AppPaths;
import com.kwoksys.biz.system.dto.Category;
import com.kwoksys.framework.connections.database.QueryCriteria;
import com.kwoksys.framework.properties.Localizer;
import com.kwoksys.framework.struts2.Action2;
import com.kwoksys.framework.struts2.LabelValueBean;
import com.kwoksys.framework.ui.Link;
import com.kwoksys.framework.ui.SelectOneLabelValueBean;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public class IndexAction
extends Action2 {
    public String execute() throws Exception {
        this.getSessionBaseForm(PostSearchForm.class);
        AccessUser user = this.requestContext.getUser();
        List<LabelValueBean> commentOptions = Arrays.asList(new SelectOneLabelValueBean(this.requestContext, String.valueOf(-1)), new LabelValueBean(Localizer.getText(this.requestContext, "common.boolean.yes_no.true"), String.valueOf(1)), new LabelValueBean(Localizer.getText(this.requestContext, "common.boolean.yes_no.false"), String.valueOf(0)));
        QueryCriteria queryCriteria = new QueryCriteria();
        queryCriteria.addSortColumn(BlogQueries.getOrderByColumn("category_name"));
        ArrayList postCategoryLinks = new ArrayList();
        ArrayList<LabelValueBean> postCategoryIdLabel = new ArrayList<LabelValueBean>();
        postCategoryIdLabel.add(new SelectOneLabelValueBean(this.requestContext));
        BlogService blogService = ServiceProvider.getBlogService(this.requestContext);
        for (Category category : blogService.getCategories(queryCriteria)) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("link", new Link(this.requestContext).setAjaxPath(AppPaths.BLOG_POST_LIST + "?cmd=search&categoryId=" + category.getId()).setTitle(category.getName()).getString());
            map.put("postCount", String.valueOf(category.getCountObjects()));
            postCategoryLinks.add(map);
            postCategoryIdLabel.add(new LabelValueBean(category.getName(), String.valueOf(category.getId())));
        }
        ArrayList<String> linkList = new ArrayList<String>();
        if (user.hasPermission(AppPaths.BLOG_POST_LIST)) {
            linkList.add(new Link(this.requestContext).setTitleKey("portal.index.showAllPosts").setAjaxPath(AppPaths.BLOG_POST_LIST + "?cmd=showAll").getString());
        }
        StandardTemplate standardTemplate = new StandardTemplate(this.requestContext);
        standardTemplate.setAttribute("postAllowCommentOptions", commentOptions);
        standardTemplate.setPathAttribute("postListPath", AppPaths.BLOG_POST_LIST);
        standardTemplate.setAttribute("postCategoryLinks", postCategoryLinks);
        standardTemplate.setAttribute("postCategoryIdLabel", postCategoryIdLabel);
        standardTemplate.setAttribute("linkList", linkList);
        HeaderTemplate header = standardTemplate.getHeaderTemplate();
        header.setTitleKey("core.moduleName.6");
        header.setTitleClassNoLine();
        if (user.hasPermission(AppPaths.BLOG_CATEGORY_LIST)) {
            header.addHeaderCmds(new Link(this.requestContext).setTitleKey("blogs.categoryList.header").setAjaxPath(AppPaths.BLOG_CATEGORY_LIST));
        }
        if (user.hasPermission(AppPaths.BLOG_POST_ADD)) {
            header.addHeaderCmds(new Link(this.requestContext).setTitleKey("portal.cmd.blogPostAdd").setAjaxPath(AppPaths.BLOG_POST_ADD));
        }
        return standardTemplate.findTemplate("standard_template");
    }
}

