/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.action.blogs;

import com.kwoksys.action.blogs.PostForm;
import com.kwoksys.action.common.template.ActionErrorsTemplate;
import com.kwoksys.action.common.template.HeaderTemplate;
import com.kwoksys.action.common.template.StandardTemplate;
import com.kwoksys.biz.ServiceProvider;
import com.kwoksys.biz.admin.dto.AccessUser;
import com.kwoksys.biz.blogs.BlogService;
import com.kwoksys.biz.blogs.core.BlogUtils;
import com.kwoksys.biz.blogs.dao.BlogQueries;
import com.kwoksys.biz.blogs.dto.BlogPost;
import com.kwoksys.biz.system.core.AppPaths;
import com.kwoksys.biz.system.core.Links;
import com.kwoksys.biz.system.dto.Category;
import com.kwoksys.framework.connections.database.QueryCriteria;
import com.kwoksys.framework.properties.Localizer;
import com.kwoksys.framework.struts2.Action2;
import com.kwoksys.framework.struts2.ActionMessages;
import com.kwoksys.framework.struts2.LabelValueBean;
import com.kwoksys.framework.ui.Link;
import java.util.ArrayList;

public class PostAddAction
extends Action2 {
    public String add() throws Exception {
        AccessUser user = this.requestContext.getUser();
        BlogPost post = new BlogPost();
        PostForm actionForm = this.getBaseForm(PostForm.class);
        actionForm.setId("postAddForm");
        if (!actionForm.isResubmit()) {
            actionForm.setPost(post);
        }
        String postCreatorText = Localizer.getText(this.requestContext, "blogs.colName.creation_preview_info", new Object[]{user.getDisplayName()});
        QueryCriteria queryCriteria = new QueryCriteria();
        queryCriteria.addSortColumn(BlogQueries.getOrderByColumn("category_name"));
        ArrayList<LabelValueBean> categoryIdOptions = new ArrayList<LabelValueBean>();
        BlogService blogService = ServiceProvider.getBlogService(this.requestContext);
        for (Category category : blogService.getCategories(queryCriteria)) {
            categoryIdOptions.add(new LabelValueBean(category.getName(), String.valueOf(category.getId())));
        }
        StandardTemplate standardTemplate = new StandardTemplate(this.requestContext);
        standardTemplate.setPathAttribute("formAction", AppPaths.BLOG_POST_ADD_2);
        standardTemplate.setAttribute("formCancelLink", Links.getCancelLink(this.requestContext, AppPaths.BLOG_POST_LIST).getString());
        standardTemplate.setAttribute("previewLink", new Link(this.requestContext).setJavascript("Js.Display.toggle('previewPostDiv')").setTitleKey("blogs.postAdd.toggleDiv"));
        this.request.setAttribute("postAllowCommentOptions", BlogUtils.getCommentOptions(this.requestContext));
        this.request.setAttribute("postCategoryIdOptions", categoryIdOptions);
        this.request.setAttribute("postCreatorText", (Object)postCreatorText);
        HeaderTemplate header = standardTemplate.getHeaderTemplate();
        header.setTitleKey("portal.cmd.blogPostAdd");
        ActionErrorsTemplate errorsTemplate = standardTemplate.addTemplate(new ActionErrorsTemplate());
        errorsTemplate.setShowRequiredFieldMsg(true);
        errorsTemplate.setMessageKey("blogs.postAdd.sectionHeader");
        return standardTemplate.findTemplate("standard_template");
    }

    public String add2() throws Exception {
        BlogPost post = new BlogPost();
        PostForm actionForm = this.saveActionForm(new PostForm());
        post.setPostTitle(actionForm.getPostTitle());
        post.setPostBody(actionForm.getPostBody());
        post.setPostAllowComment(actionForm.getPostAllowComment());
        post.setCategoryId(actionForm.getCategoryId());
        BlogService blogService = ServiceProvider.getBlogService(this.requestContext);
        ActionMessages errors = blogService.addPost(post);
        if (!errors.isEmpty()) {
            this.saveActionErrors(errors);
            return this.ajaxUpdateView(AppPaths.BLOG_POST_ADD + "?" + "_error=true");
        }
        return this.ajaxUpdateView(AppPaths.BLOG_POST_DETAIL + "?postId=" + post.getId());
    }
}

