/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.action.blogs;

import com.kwoksys.action.blogs.PostForm;
import com.kwoksys.action.common.template.HeaderTemplate;
import com.kwoksys.action.common.template.ObjectDeleteTemplate;
import com.kwoksys.action.common.template.StandardTemplate;
import com.kwoksys.biz.ServiceProvider;
import com.kwoksys.biz.admin.core.AdminUtils;
import com.kwoksys.biz.admin.dto.AccessUser;
import com.kwoksys.biz.auth.core.BlogPostAccess;
import com.kwoksys.biz.blogs.BlogService;
import com.kwoksys.biz.blogs.dto.BlogPost;
import com.kwoksys.biz.system.core.AppPaths;
import com.kwoksys.framework.exceptions.AccessDeniedException;
import com.kwoksys.framework.properties.Localizer;
import com.kwoksys.framework.struts2.Action2;
import com.kwoksys.framework.struts2.ActionMessages;

public class PostDeleteAction
extends Action2 {
    public String delete() throws Exception {
        BlogService blogService = ServiceProvider.getBlogService(this.requestContext);
        BlogPost blogPost = blogService.getPost(this.requestContext.getParameter("postId"));
        StandardTemplate standardTemplate = new StandardTemplate(this.requestContext, "delete");
        standardTemplate.setAttribute("postId", blogPost.getId());
        standardTemplate.setAttribute("postTitle", blogPost.getPostTitle());
        Object[] args = new String[]{AdminUtils.getSystemUsername(this.requestContext, blogPost.getCreator()), blogPost.getCreationDate()};
        standardTemplate.setAttribute("postCreator", Localizer.getText(this.requestContext, "blogs.colName.creation_info", args));
        HeaderTemplate header = standardTemplate.getHeaderTemplate();
        header.setTitleKey("blogs.postDelete.header");
        ObjectDeleteTemplate delete = standardTemplate.addTemplate(new ObjectDeleteTemplate());
        delete.setFormAjaxAction(AppPaths.BLOG_POST_DELETE_2 + "?postId=" + blogPost.getId());
        delete.setFormCancelAction(AppPaths.BLOG_POST_DETAIL + "?postId=" + blogPost.getId());
        delete.setConfirmationMsgKey("blogs.postDelete.confirm");
        delete.setSubmitButtonKey("blogs.postDelete.buttonSubmit");
        return standardTemplate.findTemplate("standard_template");
    }

    public String delete2() throws Exception {
        AccessUser user = this.requestContext.getUser();
        PostForm actionForm = this.saveActionForm(new PostForm());
        BlogService blogService = ServiceProvider.getBlogService(this.requestContext);
        BlogPost post = blogService.getPost(actionForm.getPostId());
        if (!BlogPostAccess.hasDeletePermission(user, post)) {
            throw new AccessDeniedException();
        }
        ActionMessages errors = blogService.deletePost(post);
        if (!errors.isEmpty()) {
            this.saveActionErrors(errors);
            return this.ajaxUpdateView(AppPaths.BLOG_POST_DELETE + "?postId=" + post.getId() + "&" + "_error=true");
        }
        return this.ajaxUpdateView(AppPaths.BLOG_POST_LIST);
    }
}

